/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.AWSGlueAsyncClientBuilder;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.DeleteTableRequest;
import com.amazonaws.services.glue.model.TableInput;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.AbstractTestHiveClientLocal;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.glue.GlueHiveMetastore;
import com.facebook.presto.hive.metastore.glue.GlueHiveMetastoreConfig;
import com.facebook.presto.hive.metastore.glue.PartitionFilterBuilder;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestHiveClientGlueMetastore
extends AbstractTestHiveClientLocal {
    private ExecutorService executorService;
    private static final String PARTITION_KEY = "part_key_1";
    private static final String PARTITION_KEY2 = "part_key_2";
    private static final String TEST_DATABASE_NAME_PREFIX = "test_glue";
    private static final TypeTranslator HIVE_TYPE_TRANSLATOR = new HiveTypeTranslator();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS = ImmutableList.builder().add((Object)new ColumnMetadata("id", (Type)BigintType.BIGINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)VarcharType.VARCHAR)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_TWO_KEYS = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("part_key_2", (Type)BigintType.BIGINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_TINYINT = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)TinyintType.TINYINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_SMALLINT = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)SmallintType.SMALLINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_INTEGER = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)IntegerType.INTEGER)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_BIGINT = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)BigintType.BIGINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_DECIMAL = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)PartitionFilterBuilder.DECIMAL_TYPE)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_DATE = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)DateType.DATE)).build();
    private static final List<String> VARCHAR_PARTITION_VALUES = ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01");

    public TestHiveClientGlueMetastore() {
        super(TEST_DATABASE_NAME_PREFIX + UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", ""));
    }

    @BeforeClass
    public void setUp() {
        this.executorService = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-glue-%s"));
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Override
    protected ExtendedHiveMetastore createMetastore(File tempDir) {
        HiveClientConfig hiveClientConfig = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(hiveClientConfig, metastoreClientConfig), (Set)ImmutableSet.of(), hiveClientConfig);
        HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, metastoreClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        GlueHiveMetastoreConfig glueConfig = new GlueHiveMetastoreConfig();
        glueConfig.setDefaultWarehouseDir(tempDir.toURI().toString());
        return new GlueHiveMetastore(hdfsEnvironment, glueConfig, (Executor)this.executor);
    }

    @Override
    public void testRenameTable() {
    }

    @Override
    public void testPartitionStatisticsSampling() throws Exception {
    }

    @Override
    public void testUpdateTableColumnStatistics() {
    }

    @Override
    public void testUpdateTableColumnStatisticsEmptyOptionalFields() {
    }

    @Override
    public void testUpdatePartitionColumnStatistics() {
    }

    @Override
    public void testUpdatePartitionColumnStatisticsEmptyOptionalFields() {
    }

    @Override
    public void testTableConstraints() {
    }

    @Override
    public void testStorePartitionWithStatistics() throws Exception {
        this.testStorePartitionWithStatistics(STATISTICS_PARTITIONED_TABLE_COLUMNS, BASIC_STATISTICS_1, BASIC_STATISTICS_2, BASIC_STATISTICS_1, EMPTY_TABLE_STATISTICS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testGetPartitions() throws Exception {
        SchemaTableName tableName = this.temporaryTable("get_partitions");
        try {
            this.createDummyPartitionedTable(this.tablePartitionFormat, CREATE_TABLE_COLUMNS_PARTITIONED);
            Table table = (Table)this.getMetastoreClient().getTable(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName()).get();
            Optional partitionNames = this.getMetastoreClient().getPartitionNames(HiveQueryRunner.METASTORE_CONTEXT, table.getDatabaseName(), table.getTableName());
            Assert.assertTrue((boolean)partitionNames.isPresent());
            Assert.assertEquals((Collection)((Collection)partitionNames.get()), (Collection)ImmutableList.of((Object)"ds=2016-01-01", (Object)"ds=2016-01-02"));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableWithoutStorageDescriptor() {
        SchemaTableName table = this.temporaryTable("test_missing_storage_descriptor");
        DeleteTableRequest deleteTableRequest = new DeleteTableRequest().withDatabaseName(table.getSchemaName()).withName(table.getTableName());
        AWSGlueAsync glueClient = AWSGlueAsyncClientBuilder.defaultClient();
        try {
            ConnectorSession session = this.newSession();
            MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), MetastoreUtil.getMetastoreHeaders((ConnectorSession)session), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
            TableInput tableInput = new TableInput().withName(table.getTableName()).withTableType(TableType.EXTERNAL_TABLE.name());
            glueClient.createTable(new CreateTableRequest().withDatabaseName(this.database).withTableInput(tableInput));
            Assertions.assertThatThrownBy(() -> this.getMetastoreClient().getTable(metastoreContext, table.getSchemaName(), table.getTableName())).hasMessageStartingWith("Table StorageDescriptor is null for table");
            glueClient.deleteTable(deleteTableRequest);
            tableInput = tableInput.withParameters((Map)ImmutableMap.of((Object)"table_type", (Object)"iceberg"));
            glueClient.createTable(new CreateTableRequest().withDatabaseName(this.database).withTableInput(tableInput));
            Assert.assertTrue((boolean)MetastoreUtil.isIcebergTable((Table)((Table)this.getMetastoreClient().getTable(metastoreContext, table.getSchemaName(), table.getTableName()).orElseThrow(() -> new NoSuchElementException()))));
            glueClient.deleteTable(deleteTableRequest);
            tableInput = tableInput.withParameters((Map)ImmutableMap.of((Object)"spark.sql.sources.provider", (Object)"delta"));
            glueClient.createTable(new CreateTableRequest().withDatabaseName(this.database).withTableInput(tableInput));
            Assert.assertTrue((boolean)MetastoreUtil.isDeltaLakeTable((Table)((Table)this.getMetastoreClient().getTable(metastoreContext, table.getSchemaName(), table.getTableName()).orElseThrow(() -> new NoSuchElementException()))));
        }
        finally {
            glueClient.deleteTable(new DeleteTableRequest().withDatabaseName(table.getSchemaName()).withName(table.getTableName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetPartitionsWithFilterUsingReservedKeywordsAsColumnName() throws Exception {
        SchemaTableName tableName = this.temporaryTable("get_partitions_with_filter_using_reserved_keyword_column_name");
        try {
            String reservedKeywordPartitionColumnName = "key";
            String regularColumnPartitionName = "int_partition";
            ImmutableList columns = ImmutableList.builder().add((Object)new ColumnMetadata("t_string", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata(reservedKeywordPartitionColumnName, (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata(regularColumnPartitionName, (Type)BigintType.BIGINT)).build();
            ImmutableList partitionedBy = ImmutableList.of((Object)reservedKeywordPartitionColumnName, (Object)regularColumnPartitionName);
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, (List<ColumnMetadata>)columns, (List<String>)partitionedBy);
            ExtendedHiveMetastore metastoreClient = this.getMetastoreClient();
            Table table = (Table)metastoreClient.getTable(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
            String partitionName1 = FileUtils.makePartName((List)ImmutableList.of((Object)reservedKeywordPartitionColumnName, (Object)regularColumnPartitionName), (List)ImmutableList.of((Object)"value1", (Object)"1"));
            String partitionName2 = FileUtils.makePartName((List)ImmutableList.of((Object)reservedKeywordPartitionColumnName, (Object)regularColumnPartitionName), (List)ImmutableList.of((Object)"value2", (Object)"2"));
            List partitions = (List)ImmutableList.of((Object)partitionName1, (Object)partitionName2).stream().map(partitionName -> new PartitionWithStatistics(this.createDummyPartition(table, (String)partitionName), partitionName, PartitionStatistics.empty())).collect(ImmutableList.toImmutableList());
            metastoreClient.addPartitions(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), partitions);
            metastoreClient.updatePartitionStatistics(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), partitionName1, currentStatistics -> EMPTY_TABLE_STATISTICS);
            metastoreClient.updatePartitionStatistics(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), partitionName2, currentStatistics -> EMPTY_TABLE_STATISTICS);
            Map predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues(reservedKeywordPartitionColumnName, new String[]{"value1"}).addBigintValues(regularColumnPartitionName, new Long[]{2L}).build();
            List partitionNames = metastoreClient.getPartitionNamesByFilter(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), predicates);
            Assert.assertTrue((!partitionNames.isEmpty() ? 1 : 0) != 0);
            Assert.assertEquals((Collection)partitionNames, (Collection)ImmutableList.of((Object)"key=value2/int_partition=2"));
            predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues(reservedKeywordPartitionColumnName, new String[]{"value1"}).build();
            partitionNames = metastoreClient.getPartitionNamesByFilter(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), predicates);
            Assert.assertTrue((!partitionNames.isEmpty() ? 1 : 0) != 0);
            Assert.assertEquals((Collection)partitionNames, (Collection)ImmutableList.of((Object)"key=value1/int_partition=1", (Object)"key=value2/int_partition=2"));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testGetPartitionsFilterVarChar() throws Exception {
        Map singleEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues(PARTITION_KEY, new String[]{"2020-01-01"}).build();
        Map greaterThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-02-01")), new Range[0]).build();
        Map betweenInclusive = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-02-01"), (boolean)true, (Object)Slices.utf8Slice((String)"2020-03-01"), (boolean)true), new Range[0]).build();
        Map greaterThanOrEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-03-01")), new Range[0]).build();
        Map inClause = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues(PARTITION_KEY, new String[]{"2020-01-01", "2020-02-01"}).build();
        Map lessThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-03-01")), new Range[0]).build();
        Map all = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.all((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<Map<Column, Domain>>)ImmutableList.of((Object)singleEquals, (Object)greaterThan, (Object)betweenInclusive, (Object)greaterThanOrEquals, (Object)inClause, (Object)lessThan, (Object)all), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"2020-01-01"), (Object)ImmutableList.of((Object)"2020-03-01", (Object)"2020-04-01"), (Object)ImmutableList.of((Object)"2020-02-01", (Object)"2020-03-01"), (Object)ImmutableList.of((Object)"2020-03-01", (Object)"2020-04-01"), (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01"), (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01"), (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01")));
    }

    @Test
    public void testGetPartitionsFilterBigInt() throws Exception {
        Map singleEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addBigintValues(PARTITION_KEY, new Long[]{1000L}).build();
        Map greaterThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThan((Type)BigintType.BIGINT, (Object)100L), new Range[0]).build();
        Map betweenInclusive = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.range((Type)BigintType.BIGINT, (Object)100L, (boolean)true, (Object)1000L, (boolean)true), new Range[0]).build();
        Map greaterThanOrEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)100L), new Range[0]).build();
        Map inClause = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addBigintValues(PARTITION_KEY, new Long[]{1L, 1000000L}).build();
        Map lessThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.lessThan((Type)BigintType.BIGINT, (Object)1000L), new Range[0]).build();
        Map all = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.all((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_BIGINT, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"1000000"), (List<Map<Column, Domain>>)ImmutableList.of((Object)singleEquals, (Object)greaterThan, (Object)betweenInclusive, (Object)greaterThanOrEquals, (Object)inClause, (Object)lessThan, (Object)all), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"1000"), (Object)ImmutableList.of((Object)"1000", (Object)"1000000"), (Object)ImmutableList.of((Object)"100", (Object)"1000"), (Object)ImmutableList.of((Object)"100", (Object)"1000", (Object)"1000000"), (Object)ImmutableList.of((Object)"1", (Object)"1000000"), (Object)ImmutableList.of((Object)"1", (Object)"100"), (Object)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"1000000")));
    }

    @Test
    public void testGetPartitionsFilterInteger() throws Exception {
        Map singleEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addIntegerValues(PARTITION_KEY, new Long[]{1000L}).build();
        Map greaterThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThan((Type)IntegerType.INTEGER, (Object)100L), new Range[0]).build();
        Map betweenInclusive = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.range((Type)IntegerType.INTEGER, (Object)100L, (boolean)true, (Object)1000L, (boolean)true), new Range[0]).build();
        Map greaterThanOrEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)IntegerType.INTEGER, (Object)100L), new Range[0]).build();
        Map inClause = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addIntegerValues(PARTITION_KEY, new Long[]{1L, 1000000L}).build();
        Map lessThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.lessThan((Type)IntegerType.INTEGER, (Object)1000L), new Range[0]).build();
        Map all = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.all((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_INTEGER, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"1000000"), (List<Map<Column, Domain>>)ImmutableList.of((Object)singleEquals, (Object)greaterThan, (Object)betweenInclusive, (Object)greaterThanOrEquals, (Object)inClause, (Object)lessThan, (Object)all), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"1000"), (Object)ImmutableList.of((Object)"1000", (Object)"1000000"), (Object)ImmutableList.of((Object)"100", (Object)"1000"), (Object)ImmutableList.of((Object)"100", (Object)"1000", (Object)"1000000"), (Object)ImmutableList.of((Object)"1", (Object)"1000000"), (Object)ImmutableList.of((Object)"1", (Object)"100"), (Object)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"1000000")));
    }

    @Test
    public void testGetPartitionsFilterSmallInt() throws Exception {
        Map singleEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addSmallintValues(PARTITION_KEY, new Long[]{1000L}).build();
        Map greaterThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThan((Type)SmallintType.SMALLINT, (Object)100L), new Range[0]).build();
        Map betweenInclusive = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.range((Type)SmallintType.SMALLINT, (Object)100L, (boolean)true, (Object)1000L, (boolean)true), new Range[0]).build();
        Map greaterThanOrEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)SmallintType.SMALLINT, (Object)100L), new Range[0]).build();
        Map inClause = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addSmallintValues(PARTITION_KEY, new Long[]{1L, 10000L}).build();
        Map lessThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.lessThan((Type)SmallintType.SMALLINT, (Object)1000L), new Range[0]).build();
        Map all = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.all((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_SMALLINT, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"10000"), (List<Map<Column, Domain>>)ImmutableList.of((Object)singleEquals, (Object)greaterThan, (Object)betweenInclusive, (Object)greaterThanOrEquals, (Object)inClause, (Object)lessThan, (Object)all), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"1000"), (Object)ImmutableList.of((Object)"1000", (Object)"10000"), (Object)ImmutableList.of((Object)"100", (Object)"1000"), (Object)ImmutableList.of((Object)"100", (Object)"1000", (Object)"10000"), (Object)ImmutableList.of((Object)"1", (Object)"10000"), (Object)ImmutableList.of((Object)"1", (Object)"100"), (Object)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"10000")));
    }

    @Test
    public void testGetPartitionsFilterTinyInt() throws Exception {
        Map singleEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addTinyintValues(PARTITION_KEY, new Long[]{127L}).build();
        Map greaterThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThan((Type)TinyintType.TINYINT, (Object)10L), new Range[0]).build();
        Map betweenInclusive = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.range((Type)TinyintType.TINYINT, (Object)10L, (boolean)true, (Object)100L, (boolean)true), new Range[0]).build();
        Map greaterThanOrEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)TinyintType.TINYINT, (Object)10L), new Range[0]).build();
        Map inClause = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addTinyintValues(PARTITION_KEY, new Long[]{1L, 127L}).build();
        Map lessThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.lessThan((Type)TinyintType.TINYINT, (Object)100L), new Range[0]).build();
        Map all = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.all((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TINYINT, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"1", (Object)"10", (Object)"100", (Object)"127"), (List<Map<Column, Domain>>)ImmutableList.of((Object)singleEquals, (Object)greaterThan, (Object)betweenInclusive, (Object)greaterThanOrEquals, (Object)inClause, (Object)lessThan, (Object)all), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"127"), (Object)ImmutableList.of((Object)"100", (Object)"127"), (Object)ImmutableList.of((Object)"10", (Object)"100"), (Object)ImmutableList.of((Object)"10", (Object)"100", (Object)"127"), (Object)ImmutableList.of((Object)"1", (Object)"127"), (Object)ImmutableList.of((Object)"1", (Object)"10"), (Object)ImmutableList.of((Object)"1", (Object)"10", (Object)"100", (Object)"127")));
    }

    @Test
    public void testGetPartitionsFilterTinyIntNegatives() throws Exception {
        Map singleEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addTinyintValues(PARTITION_KEY, new Long[]{-128L}).build();
        Map greaterThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThan((Type)TinyintType.TINYINT, (Object)0L), new Range[0]).build();
        Map betweenInclusive = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.range((Type)TinyintType.TINYINT, (Object)0L, (boolean)true, (Object)50L, (boolean)true), new Range[0]).build();
        Map greaterThanOrEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)TinyintType.TINYINT, (Object)0L), new Range[0]).build();
        Map inClause = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addTinyintValues(PARTITION_KEY, new Long[]{0L, -128L}).build();
        Map lessThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.lessThan((Type)TinyintType.TINYINT, (Object)0L), new Range[0]).build();
        Map all = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.all((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TINYINT, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"-128", (Object)"0", (Object)"50", (Object)"100"), (List<Map<Column, Domain>>)ImmutableList.of((Object)singleEquals, (Object)greaterThan, (Object)betweenInclusive, (Object)greaterThanOrEquals, (Object)inClause, (Object)lessThan, (Object)all), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"-128"), (Object)ImmutableList.of((Object)"100", (Object)"50"), (Object)ImmutableList.of((Object)"0", (Object)"50"), (Object)ImmutableList.of((Object)"0", (Object)"100", (Object)"50"), (Object)ImmutableList.of((Object)"-128", (Object)"0"), (Object)ImmutableList.of((Object)"-128"), (Object)ImmutableList.of((Object)"-128", (Object)"0", (Object)"100", (Object)"50")));
    }

    @Test
    public void testGetPartitionsFilterDecimal() throws Exception {
        String value1 = "1.000";
        String value2 = "10.134";
        String value3 = "25.111";
        String value4 = "30.333";
        Map singleEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDecimalValues(PARTITION_KEY, new String[]{value1}).build();
        Map greaterThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThan((Type)PartitionFilterBuilder.DECIMAL_TYPE, (Object)PartitionFilterBuilder.decimalOf((String)value2)), new Range[0]).build();
        Map betweenInclusive = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.range((Type)PartitionFilterBuilder.DECIMAL_TYPE, (Object)PartitionFilterBuilder.decimalOf((String)value2), (boolean)true, (Object)PartitionFilterBuilder.decimalOf((String)value3), (boolean)true), new Range[0]).build();
        Map greaterThanOrEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)PartitionFilterBuilder.DECIMAL_TYPE, (Object)PartitionFilterBuilder.decimalOf((String)value3)), new Range[0]).build();
        Map inClause = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDecimalValues(PARTITION_KEY, new String[]{value1, value4}).build();
        Map lessThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.lessThan((Type)PartitionFilterBuilder.DECIMAL_TYPE, (Object)PartitionFilterBuilder.decimalOf((String)"25.5")), new Range[0]).build();
        Map all = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.all((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_DECIMAL, PARTITION_KEY, (List<String>)ImmutableList.of((Object)value1, (Object)value2, (Object)value3, (Object)value4), (List<Map<Column, Domain>>)ImmutableList.of((Object)singleEquals, (Object)greaterThan, (Object)betweenInclusive, (Object)greaterThanOrEquals, (Object)inClause, (Object)lessThan, (Object)all), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)value1), (Object)ImmutableList.of((Object)value3, (Object)value4), (Object)ImmutableList.of((Object)value2, (Object)value3), (Object)ImmutableList.of((Object)value3, (Object)value4), (Object)ImmutableList.of((Object)value1, (Object)value4), (Object)ImmutableList.of((Object)value1, (Object)value2, (Object)value3), (Object)ImmutableList.of((Object)value1, (Object)value2, (Object)value3, (Object)value4)));
    }

    @Test
    public void testGetPartitionsFilterDate() throws Exception {
        Map singleEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDateValues(PARTITION_KEY, new Long[]{18000L}).build();
        Map greaterThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThan((Type)DateType.DATE, (Object)19000L), new Range[0]).build();
        Map betweenInclusive = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.range((Type)DateType.DATE, (Object)19000L, (boolean)true, (Object)20000L, (boolean)true), new Range[0]).build();
        Map greaterThanOrEquals = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)DateType.DATE, (Object)19000L), new Range[0]).build();
        Map inClause = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDateValues(PARTITION_KEY, new Long[]{18000L, 21000L}).build();
        Map lessThan = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.lessThan((Type)DateType.DATE, (Object)20000L), new Range[0]).build();
        Map all = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.all((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_DATE, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (List<Map<Column, Domain>>)ImmutableList.of((Object)singleEquals, (Object)greaterThan, (Object)betweenInclusive, (Object)greaterThanOrEquals, (Object)inClause, (Object)lessThan, (Object)all), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000")));
    }

    @Test
    public void testGetPartitionsFilterTwoPartitionKeys() throws Exception {
        Map equalsFilter = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues(PARTITION_KEY, new String[]{"2020-03-01"}).addBigintValues(PARTITION_KEY2, new Long[]{300L}).build();
        Map rangeFilter = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-02-01")), new Range[0]).addRanges(PARTITION_KEY2, Range.greaterThan((Type)BigintType.BIGINT, (Object)200L), new Range[0]).build();
        Map all = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.all((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TWO_KEYS, (List<String>)ImmutableList.of((Object)PARTITION_KEY, (Object)PARTITION_KEY2), (List<PartitionValues>)ImmutableList.of((Object)PartitionValues.make(new String[]{"2020-01-01", "100"}), (Object)PartitionValues.make(new String[]{"2020-02-01", "200"}), (Object)PartitionValues.make(new String[]{"2020-03-01", "300"}), (Object)PartitionValues.make(new String[]{"2020-04-01", "400"})), (List<Map<Column, Domain>>)ImmutableList.of((Object)equalsFilter, (Object)rangeFilter, (Object)all), (List<List<PartitionValues>>)ImmutableList.of((Object)ImmutableList.of((Object)PartitionValues.make(new String[]{"2020-03-01", "300"})), (Object)ImmutableList.of((Object)PartitionValues.make(new String[]{"2020-03-01", "300"}), (Object)PartitionValues.make(new String[]{"2020-04-01", "400"})), (Object)ImmutableList.of((Object)PartitionValues.make(new String[]{"2020-01-01", "100"}), (Object)PartitionValues.make(new String[]{"2020-02-01", "200"}), (Object)PartitionValues.make(new String[]{"2020-03-01", "300"}), (Object)PartitionValues.make(new String[]{"2020-04-01", "400"}))));
    }

    @Test
    public void testGetPartitionsFilterMaxLengthWildcard() throws Exception {
        Map filter = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues(PARTITION_KEY, new String[]{Strings.repeat((String)"x", (int)2048)}).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<Map<Column, Domain>>)ImmutableList.of((Object)filter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01")));
    }

    @Test
    public void testGetPartitionsFilterTwoPartitionKeysPartialQuery() throws Exception {
        Map equalsFilter = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues(PARTITION_KEY, new String[]{Strings.repeat((String)"x", (int)2048)}).addBigintValues(PARTITION_KEY2, new Long[]{300L}).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TWO_KEYS, (List<String>)ImmutableList.of((Object)PARTITION_KEY, (Object)PARTITION_KEY2), (List<PartitionValues>)ImmutableList.of((Object)PartitionValues.make(new String[]{"2020-01-01", "100"}), (Object)PartitionValues.make(new String[]{"2020-02-01", "200"}), (Object)PartitionValues.make(new String[]{"2020-03-01", "300"}), (Object)PartitionValues.make(new String[]{"2020-04-01", "400"})), (List<Map<Column, Domain>>)ImmutableList.of((Object)equalsFilter), (List<List<PartitionValues>>)ImmutableList.of((Object)ImmutableList.of((Object)PartitionValues.make(new String[]{"2020-03-01", "300"}))));
    }

    @Test
    public void testGetPartitionsFilterNone() throws Exception {
        Map noneFilter = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.none((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<Map<Column, Domain>>)ImmutableList.of((Object)noneFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01")));
    }

    @Test
    public void testGetPartitionsFilterNotNull() throws Exception {
        Map notNullFilter = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.notNull((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<Map<Column, Domain>>)ImmutableList.of((Object)notNullFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01")));
    }

    @Test
    public void testGetPartitionsFilterIsNull() throws Exception {
        Map isNullFilter = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.onlyNull((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<Map<Column, Domain>>)ImmutableList.of((Object)isNullFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of()));
    }

    @Test
    public void testGetPartitionsFilterIsNullWithValue() throws Exception {
        Map isNullFilter = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain(PARTITION_KEY, Domain.onlyNull((Type)VarcharType.VARCHAR)).build();
        ArrayList<String> partitionList = new ArrayList<String>();
        partitionList.add(null);
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, partitionList, (List<Map<Column, Domain>>)ImmutableList.of((Object)isNullFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"__HIVE_DEFAULT_PARTITION__")));
    }

    private void doGetPartitionsFilterTest(List<ColumnMetadata> columnMetadata, String partitionColumnName, List<String> partitionStringValues, List<Map<Column, Domain>> filterList, List<List<String>> expectedSingleValueList) throws Exception {
        List partitionValuesList = (List)partitionStringValues.stream().map(xva$0 -> PartitionValues.make(new String[]{xva$0})).collect(ImmutableList.toImmutableList());
        List expectedPartitionValuesList = (List)expectedSingleValueList.stream().map(expectedValue -> (ImmutableList)expectedValue.stream().map(xva$0 -> PartitionValues.make(new String[]{xva$0})).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        this.doGetPartitionsFilterTest(columnMetadata, (List<String>)ImmutableList.of((Object)partitionColumnName), partitionValuesList, filterList, expectedPartitionValuesList);
    }

    private void doGetPartitionsFilterTest(List<ColumnMetadata> columnMetadata, List<String> partitionColumnNames, List<PartitionValues> partitionValues, List<Map<Column, Domain>> filterList, List<List<PartitionValues>> expectedValuesList) throws Exception {
        try (CloseableSchemaTableName closeableTableName = new CloseableSchemaTableName(this.temporaryTable("get_partitions"));){
            SchemaTableName tableName = closeableTableName.getSchemaTableName();
            this.createDummyPartitionedTable(tableName, columnMetadata, partitionColumnNames, partitionValues);
            ExtendedHiveMetastore metastoreClient = this.getMetastoreClient();
            for (int i = 0; i < filterList.size(); ++i) {
                Map<Column, Domain> filter = filterList.get(i);
                List<PartitionValues> expectedValues = expectedValuesList.get(i);
                List expectedResults = (List)expectedValues.stream().map(expectedPartitionValues -> FileUtils.makePartName((List)partitionColumnNames, expectedPartitionValues.getValues())).collect(ImmutableList.toImmutableList());
                List partitionNames = metastoreClient.getPartitionNamesByFilter(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), filter);
                Assert.assertEquals((Collection)partitionNames, (Collection)expectedResults, (String)String.format("lists \nactual: %s\nexpected: %s\nmismatch for filter %s (input index %d)\n", partitionNames, expectedResults, filter, i));
            }
        }
    }

    private void createDummyPartitionedTable(SchemaTableName tableName, List<ColumnMetadata> columns, List<String> partitionColumnNames, List<PartitionValues> partitionValues) throws Exception {
        this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, columns, partitionColumnNames);
        ExtendedHiveMetastore metastoreClient = this.getMetastoreClient();
        Table table = (Table)metastoreClient.getTable(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        ArrayList partitions = new ArrayList();
        ArrayList partitionNames = new ArrayList();
        partitionValues.stream().map(partitionValue -> FileUtils.makePartName((List)partitionColumnNames, (List)((PartitionValues)partitionValue).values)).forEach(partitionName -> {
            partitions.add(new PartitionWithStatistics(this.createDummyPartition(table, (String)partitionName), partitionName, PartitionStatistics.empty()));
            partitionNames.add(partitionName);
        });
        metastoreClient.addPartitions(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), partitions);
        partitionNames.forEach(partitionName -> metastoreClient.updatePartitionStatistics(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), partitionName, currentStatistics -> EMPTY_TABLE_STATISTICS));
    }

    private static class PartitionValues {
        private final List<String> values;

        private static PartitionValues make(String ... values) {
            return new PartitionValues(Arrays.asList(values));
        }

        private static PartitionValues make(List<String> values) {
            return new PartitionValues(values);
        }

        private PartitionValues(List<String> values) {
            this.values = values;
        }

        public List<String> getValues() {
            return this.values;
        }
    }

    private class CloseableSchemaTableName
    implements AutoCloseable {
        private final SchemaTableName schemaTableName;

        private CloseableSchemaTableName(SchemaTableName schemaTableName) {
            this.schemaTableName = schemaTableName;
        }

        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public void close() {
            TestHiveClientGlueMetastore.this.dropTable(this.schemaTableName);
        }
    }
}

