/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.parquet.ParquetTester;
import com.facebook.presto.parquet.cache.CachingParquetMetadataSource;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.cache.ParquetFileMetadata;
import com.facebook.presto.parquet.cache.ParquetMetadataSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.tests.StructuralTestUtil;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.primitives.Shorts;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.parquet.format.Statistics;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestParquetReader {
    private static final int MAX_PRECISION_INT32 = (int)AbstractTestParquetReader.maxPrecision(4);
    private static final int MAX_PRECISION_INT64 = (int)AbstractTestParquetReader.maxPrecision(8);
    private Logger parquetLogger;
    private final ParquetTester tester;

    public AbstractTestParquetReader(ParquetTester tester) {
        this.tester = tester;
    }

    @BeforeClass
    public void setUp() {
        Assert.assertEquals((Object)DateTimeZone.getDefault(), (Object)ParquetTester.HIVE_STORAGE_TIME_ZONE);
        this.parquetLogger = Logger.getLogger("org.apache.parquet.hadoop");
        this.parquetLogger.setLevel(Level.WARNING);
    }

    @Test
    public void testArray() throws Exception {
        List values = this.createTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, (Type)new ArrayType((Type)IntegerType.INTEGER));
    }

    @Test
    public void testEmptyArrays() throws Exception {
        Iterable values = Iterables.limit((Iterable)Iterables.cycle(Collections.singletonList(Collections.emptyList())), (int)30000);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, (Type)new ArrayType((Type)IntegerType.INTEGER));
    }

    @Test
    public void testNestedArrays() throws Exception {
        int nestingLevel = ThreadLocalRandom.current().nextInt(1, 15);
        StandardListObjectInspector objectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
        ArrayType type = new ArrayType((Type)IntegerType.INTEGER);
        Iterable values = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, null, 5, null, 7, null, null, null, 11, null, 13)), (int)3210);
        for (int i = 0; i < nestingLevel; ++i) {
            values = this.createNullableTestArrays(values);
            objectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)objectInspector);
            type = new ArrayType((Type)type);
        }
        values = this.createTestArrays(values);
        this.tester.testRoundTrip((ObjectInspector)objectInspector, values, values, (Type)type);
    }

    @Test
    public void testSingleLevelSchemaNestedArrays() throws Exception {
        int nestingLevel = ThreadLocalRandom.current().nextInt(1, 15);
        StandardListObjectInspector objectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
        ArrayType type = new ArrayType((Type)IntegerType.INTEGER);
        Object values = AbstractTestParquetReader.intsBetween(0, 31234);
        for (int i = 0; i < nestingLevel; ++i) {
            values = this.createTestArrays((Iterable)values);
            objectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)objectInspector);
            type = new ArrayType((Type)type);
        }
        values = this.createTestArrays((Iterable)values);
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)objectInspector, (Iterable<?>)values, (Iterable<?>)values, (Type)type);
    }

    @Test
    public void testArrayOfStructs() throws Exception {
        Iterable<List> structs = this.createNullableTestStructs(new Iterable[]{Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString), AbstractTestParquetReader.longsBetween(0L, 31234L)});
        List<List<List>> values = this.createTestArrays(structs);
        List<String> structFieldNames = Arrays.asList("stringField", "longField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringField", (Type)VarcharType.VARCHAR), RowType.field((String)"longField", (Type)BigintType.BIGINT)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector))), values, values, (Type)new ArrayType((Type)structType));
    }

    @Test
    public void testCustomSchemaArrayOfStructs() throws Exception {
        MessageType customSchemaArrayOfStructs = MessageTypeParser.parseMessageType((String)"message ParquetSchema {   optional group self (LIST) {     repeated group self_tuple {       optional int64 a;       optional boolean b;       required binary c (UTF8);     }   } }");
        Iterable aValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1L, null, 3L, 5L, null, null, null, 7L, 11L, null, 13L, 17L)), (int)30000);
        Iterable bValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, true, false, null, null, true, false)), (int)30000);
        Iterable cValues = Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString);
        List<List> structs = this.createTestStructs(aValues, bValues, cValues);
        List<List<List>> values = this.createTestArrays(structs);
        List<String> structFieldNames = Arrays.asList("a", "b", "c");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)BooleanType.BOOLEAN), RowType.field((String)"c", (Type)VarcharType.VARCHAR)));
        this.tester.testSingleLevelArrayRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaLongObjectInspector, PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, PrimitiveObjectInspectorFactory.javaStringObjectInspector))), values, values, "self", (Type)new ArrayType((Type)structType), Optional.of(customSchemaArrayOfStructs));
    }

    @Test
    public void testSingleLevelSchemaArrayOfStructs() throws Exception {
        Iterable aValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1L, null, 3L, 5L, null, null, null, 7L, 11L, null, 13L, 17L)), (int)30000);
        Iterable bValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, true, false, null, null, true, false)), (int)30000);
        Iterable cValues = Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString);
        List<List> structs = this.createTestStructs(aValues, bValues, cValues);
        List<List<List>> values = this.createTestArrays(structs);
        List<String> structFieldNames = Arrays.asList("a", "b", "c");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)BooleanType.BOOLEAN), RowType.field((String)"c", (Type)VarcharType.VARCHAR)));
        StandardListObjectInspector objectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaLongObjectInspector, PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, PrimitiveObjectInspectorFactory.javaStringObjectInspector)));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)objectInspector, values, values, (Type)new ArrayType((Type)structType));
    }

    @Test
    public void testArrayOfArrayOfStructOfArray() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        Iterable<List> structs = this.createNullableTestStructs(stringArrayField, Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, 7, 11, null, 17)), (int)31234));
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        Iterable<List<List>> arrays = this.createNullableTestArrays(structs);
        List<List<List<List>>> values = this.createTestArrays(arrays);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)))), values, values, (Type)new ArrayType((Type)new ArrayType((Type)structType)));
    }

    @Test
    public void testSingleLevelSchemaArrayOfArrayOfStructOfArray() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        List<List> structs = this.createTestStructs(stringArrayField, Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, 7, 11, null, 17)), (int)31234));
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        List<List<List>> arrays = this.createTestArrays(structs);
        List<List<List<List>>> values = this.createTestArrays(arrays);
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)))), values, values, (Type)new ArrayType((Type)new ArrayType((Type)structType)));
    }

    @Test
    public void testArrayOfStructOfArray() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        Iterable<List> structs = this.createNullableTestStructs(stringArrayField, Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, 3, null, 5, 7, null, 11, 13, null, 17)), (int)31234));
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        List<List<List>> values = this.createTestArrays(structs);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector))), values, values, (Type)new ArrayType((Type)structType));
    }

    @Test
    public void testSingleLevelSchemaArrayOfStructOfArray() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        List<List> structs = this.createTestStructs(stringArrayField, Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, 3, null, 5, 7, null, 11, 13, null, 17)), (int)31234));
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        List<List<List>> values = this.createTestArrays(structs);
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector))), values, values, (Type)new ArrayType((Type)structType));
    }

    @Test
    public void testMap() throws Exception {
        Iterable values = this.createTestMaps(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 100000), Object::toString), (Iterable)AbstractTestParquetReader.longsBetween(0L, 10000L));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector), values, values, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT));
    }

    @Test
    public void testNestedMaps() throws Exception {
        int nestingLevel = ThreadLocalRandom.current().nextInt(1, 15);
        ContiguousSet<Integer> keys = AbstractTestParquetReader.intsBetween(0, 3210);
        Iterable maps = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, "value2", "value3", null, null, "value6", "value7")), (int)3210);
        StandardMapObjectInspector objectInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        MapType type = StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR);
        for (int i = 0; i < nestingLevel; ++i) {
            maps = this.createNullableTestMaps((Iterable)keys, maps);
            objectInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)objectInspector);
            type = StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)type);
        }
        maps = this.createTestMaps((Iterable)keys, maps);
        this.tester.testRoundTrip((ObjectInspector)objectInspector, maps, maps, (Type)type);
    }

    @Test
    public void testArrayOfMaps() throws Exception {
        Iterable maps = this.createNullableTestMaps(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 10), Object::toString), (Iterable)AbstractTestParquetReader.longsBetween(0L, 10L));
        List values = this.createTestArrays(maps);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector)), values, values, (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)));
    }

    @Test
    public void testSingleLevelSchemaArrayOfMaps() throws Exception {
        Iterable maps = this.createTestMaps(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 10), Object::toString), (Iterable)AbstractTestParquetReader.longsBetween(0L, 10L));
        List values = this.createTestArrays(maps);
        StandardListObjectInspector objectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)objectInspector, values, values, (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)));
    }

    @Test
    public void testArrayOfMapOfStruct() throws Exception {
        ContiguousSet<Integer> keys = AbstractTestParquetReader.intsBetween(0, 10000);
        Iterable<List> structs = this.createNullableTestStructs(new Iterable[]{Iterables.transform(AbstractTestParquetReader.intsBetween(0, 10000), Object::toString), AbstractTestParquetReader.longsBetween(0L, 10000L)});
        List<String> structFieldNames = Arrays.asList("stringField", "longField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringField", (Type)VarcharType.VARCHAR), RowType.field((String)"longField", (Type)BigintType.BIGINT)));
        Iterable<Map<Integer, List>> maps = this.createNullableTestMaps((Iterable)keys, (Iterable)structs);
        List<List<Map<Integer, List>>> values = this.createTestArrays(maps);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector)))), values, values, (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)structType)));
    }

    @Test
    public void testSingleLevelArrayOfMapOfStruct() throws Exception {
        ContiguousSet<Integer> keys = AbstractTestParquetReader.intsBetween(0, 10000);
        Iterable<List> structs = this.createNullableTestStructs(new Iterable[]{Iterables.transform(AbstractTestParquetReader.intsBetween(0, 10000), Object::toString), AbstractTestParquetReader.longsBetween(0L, 10000L)});
        List<String> structFieldNames = Arrays.asList("stringField", "longField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringField", (Type)VarcharType.VARCHAR), RowType.field((String)"longField", (Type)BigintType.BIGINT)));
        Iterable<Map<Integer, List>> maps = this.createTestMaps((Iterable)keys, (Iterable)structs);
        List<List<Map<Integer, List>>> values = this.createTestArrays(maps);
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector)))), values, values, (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)structType)));
    }

    @Test
    public void testSingleLevelArrayOfStructOfSingleElement() throws Exception {
        List<List> structs = this.createTestStructs(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        List<List<List>> values = this.createTestArrays(structs);
        List<String> structFieldNames = Collections.singletonList("test");
        RowType structType = RowType.from(Collections.singletonList(RowType.field((String)"test", (Type)VarcharType.VARCHAR)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector))), values, values, (Type)new ArrayType((Type)structType));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector))), values, values, (Type)new ArrayType((Type)structType));
    }

    @Test
    public void testSingleLevelArrayOfStructOfStructOfSingleElement() throws Exception {
        List<List> structs = this.createTestStructs(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        List<List> structsOfStructs = this.createTestStructs((Iterable)structs);
        List<List<List>> values = this.createTestArrays(structsOfStructs);
        List<String> structFieldNames = Collections.singletonList("test");
        List<String> structsOfStructsFieldNames = Collections.singletonList("test");
        RowType structType = RowType.from(Collections.singletonList(RowType.field((String)"test", (Type)VarcharType.VARCHAR)));
        RowType structsOfStructsType = RowType.from(Collections.singletonList(RowType.field((String)"test", (Type)structType)));
        StandardStructObjectInspector structObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structsOfStructsFieldNames, Collections.singletonList(structObjectInspector))), values, values, (Type)new ArrayType((Type)structsOfStructsType));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structsOfStructsFieldNames, Collections.singletonList(structObjectInspector))), values, values, (Type)new ArrayType((Type)structsOfStructsType));
    }

    @Test
    public void testArrayOfMapOfArray() throws Exception {
        Iterable arrays = this.createNullableTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)10000));
        Iterable keys = Iterables.transform(AbstractTestParquetReader.intsBetween(0, 10000), Object::toString);
        Iterable maps = this.createNullableTestMaps(keys, arrays);
        List values = this.createTestArrays(maps);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector))), values, values, (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)IntegerType.INTEGER))));
    }

    @Test
    public void testSingleLevelArrayOfMapOfArray() throws Exception {
        Iterable<List<Integer>> arrays = this.createNullableTestArrays((Iterable)AbstractTestParquetReader.intsBetween(0, 10000));
        Iterable keys = Iterables.transform(AbstractTestParquetReader.intsBetween(0, 10000), Object::toString);
        Iterable maps = this.createTestMaps(keys, arrays);
        List values = this.createTestArrays(maps);
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector))), values, values, (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)IntegerType.INTEGER))));
    }

    @Test
    public void testMapOfArrayValues() throws Exception {
        Iterable arrays = this.createNullableTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        ContiguousSet<Integer> keys = AbstractTestParquetReader.intsBetween(0, 30000);
        Iterable values = this.createTestMaps((Iterable)keys, arrays);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)IntegerType.INTEGER)));
    }

    @Test
    public void testMapOfArrayKeys() throws Exception {
        List mapKeys = this.createTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        ContiguousSet<Integer> mapValues = AbstractTestParquetReader.intsBetween(0, 30000);
        Iterable testMaps = this.createTestMaps(mapKeys, (Iterable)mapValues);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), testMaps, testMaps, (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)IntegerType.INTEGER));
    }

    @Test
    public void testMapOfSingleLevelArray() throws Exception {
        Iterable<List<Integer>> arrays = this.createNullableTestArrays((Iterable)AbstractTestParquetReader.intsBetween(0, 30000));
        ContiguousSet<Integer> keys = AbstractTestParquetReader.intsBetween(0, 30000);
        Iterable<Map<Integer, List<Integer>>> values = this.createTestMaps((Iterable)keys, (Iterable)arrays);
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)IntegerType.INTEGER)));
    }

    @Test
    public void testMapOfStruct() throws Exception {
        ContiguousSet<Long> keys = AbstractTestParquetReader.longsBetween(0L, 30000L);
        Iterable<List> structs = this.createNullableTestStructs(new Iterable[]{Iterables.transform(AbstractTestParquetReader.intsBetween(0, 30000), Object::toString), AbstractTestParquetReader.longsBetween(0L, 30000L)});
        List<String> structFieldNames = Arrays.asList("stringField", "longField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringField", (Type)VarcharType.VARCHAR), RowType.field((String)"longField", (Type)BigintType.BIGINT)));
        Iterable<Map<Long, List>> values = this.createTestMaps((Iterable)keys, (Iterable)structs);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector))), values, values, (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)structType));
    }

    @Test
    public void testMapWithNullValues() throws Exception {
        ContiguousSet<Integer> mapKeys = AbstractTestParquetReader.intsBetween(0, 31234);
        Iterable mapValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, "value2", "value3", null, null, "value6", "value7")), (int)31234);
        Iterable values = this.createTestMaps((Iterable)mapKeys, mapValues);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), values, values, (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR));
    }

    @Test
    public void testStruct() throws Exception {
        List<List> values = this.createTestStructs(new Iterable[]{Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString), AbstractTestParquetReader.longsBetween(0L, 31234L)});
        List<String> structFieldNames = Arrays.asList("stringField", "longField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringField", (Type)VarcharType.VARCHAR), RowType.field((String)"longField", (Type)BigintType.BIGINT)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector)), values, values, (Type)structType);
    }

    @Test
    public void testNestedStructs() throws Exception {
        int nestingLevel = ThreadLocalRandom.current().nextInt(1, 15);
        Optional<List<String>> structFieldNames = Optional.of(Collections.singletonList("structField"));
        Iterable<List> values = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, null, 5, null, 7, null, null, null, 11, null, 13)), (int)3210);
        StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames.get(), Collections.singletonList(PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        RowType type = RowType.from(Collections.singletonList(RowType.field((String)"structField", (Type)IntegerType.INTEGER)));
        for (int i = 0; i < nestingLevel; ++i) {
            values = this.createNullableTestStructs(values);
            objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames.get(), Collections.singletonList(objectInspector));
            type = RowType.from(Collections.singletonList(RowType.field((String)"structField", (Type)type)));
        }
        values = this.createTestStructs((Iterable)values);
        this.tester.testRoundTrip((ObjectInspector)objectInspector, values, values, (Type)type);
    }

    @Test
    public void testComplexNestedStructs() throws Exception {
        int n = 30;
        ContiguousSet<Integer> mapKeys = AbstractTestParquetReader.intsBetween(0, 30);
        Iterable intPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, null, 5, null, 7, null, null, null, 11, null, 13)), (int)30);
        Iterable stringPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, "value2", "value3", null, null, "value6", "value7")), (int)30);
        Iterable doublePrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1.1, null, 3.3, null, 5.5, null, 7.7, null, null, null, 11.11, null, 13.13)), (int)30);
        Iterable booleanPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, true, false, null, null, true, false)), (int)30);
        Iterable mapStringKeys = Stream.generate(() -> UUID.randomUUID().toString()).limit(30L).collect(Collectors.toList());
        Iterable mapsIntString = this.createNullableTestMaps((Iterable)mapKeys, stringPrimitives);
        Iterable arraysString = this.createNullableTestArrays(stringPrimitives);
        Iterable mapsIntDouble = this.createNullableTestMaps((Iterable)mapKeys, doublePrimitives);
        Iterable arraysBoolean = this.createNullableTestArrays(booleanPrimitives);
        Iterable mapsStringString = this.createNullableTestMaps(mapStringKeys, stringPrimitives);
        List<String> struct1FieldNames = Arrays.asList("mapIntStringField", "stringArrayField", "intField");
        Iterable<List> structs1 = this.createNullableTestStructs(mapsIntString, arraysString, intPrimitives);
        StandardStructObjectInspector struct1ObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(struct1FieldNames, Arrays.asList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        RowType struct1Type = RowType.from(Arrays.asList(RowType.field((String)"mapIntStringField", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR)), RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        List<String> struct2FieldNames = Arrays.asList("mapIntStringField", "stringArrayField", "structField");
        Iterable<List> structs2 = this.createNullableTestStructs(mapsIntString, arraysString, structs1);
        StandardStructObjectInspector struct2ObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(struct2FieldNames, Arrays.asList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), struct1ObjectInspector));
        RowType struct2Type = RowType.from(Arrays.asList(RowType.field((String)"mapIntStringField", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR)), RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"structField", (Type)struct1Type)));
        List<String> struct3FieldNames = Arrays.asList("mapIntDoubleField", "booleanArrayField", "booleanField");
        Iterable<List> structs3 = this.createNullableTestStructs(mapsIntDouble, arraysBoolean, booleanPrimitives);
        StandardStructObjectInspector struct3ObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(struct3FieldNames, Arrays.asList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector), PrimitiveObjectInspectorFactory.javaBooleanObjectInspector));
        RowType struct3Type = RowType.from(Arrays.asList(RowType.field((String)"mapIntDoubleField", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE)), RowType.field((String)"booleanArrayField", (Type)new ArrayType((Type)BooleanType.BOOLEAN)), RowType.field((String)"booleanField", (Type)BooleanType.BOOLEAN)));
        List<String> struct4FieldNames = Arrays.asList("mapIntDoubleField", "booleanArrayField", "structField");
        Iterable<List> structs4 = this.createNullableTestStructs(mapsIntDouble, arraysBoolean, structs3);
        StandardStructObjectInspector struct4ObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(struct4FieldNames, Arrays.asList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector), struct3ObjectInspector));
        RowType struct4Type = RowType.from(Arrays.asList(RowType.field((String)"mapIntDoubleField", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE)), RowType.field((String)"booleanArrayField", (Type)new ArrayType((Type)BooleanType.BOOLEAN)), RowType.field((String)"structField", (Type)struct3Type)));
        List<String> structFieldNames = Arrays.asList("structField1", "structField2", "structField3", "structField4", "mapIntDoubleField", "booleanArrayField", "mapStringStringField");
        List<ObjectInspector> objectInspectors = Arrays.asList(struct1ObjectInspector, struct2ObjectInspector, struct3ObjectInspector, struct4ObjectInspector, ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector), ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        ImmutableList types = ImmutableList.of((Object)struct1Type, (Object)struct2Type, (Object)struct3Type, (Object)struct4Type, (Object)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE), (Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR));
        Iterable[] values = new Iterable[]{structs1, structs2, structs3, structs4, mapsIntDouble, arraysBoolean, mapsStringString};
        this.tester.assertRoundTrip(objectInspectors, values, values, structFieldNames, (List<Type>)types, Optional.empty());
    }

    @Test
    public void testStructOfMaps() throws Exception {
        Iterable mapKeys = Stream.generate(() -> ThreadLocalRandom.current().nextInt(10000)).limit(10000L).collect(Collectors.toList());
        Iterable intPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, null, 5, null, 7, null, null, null, 11, null, 13)), (int)10000);
        Iterable stringPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, "value2", "value3", null, null, "value6", "value7")), (int)10000);
        Iterable maps = this.createNullableTestMaps(mapKeys, stringPrimitives);
        Iterable stringArrayField = this.createNullableTestArrays(stringPrimitives);
        List<List> values = this.createTestStructs(maps, stringArrayField, intPrimitives);
        List<String> structFieldNames = Arrays.asList("mapIntStringField", "stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"mapIntStringField", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR)), RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)structType);
    }

    @Test
    public void testStructOfNullableMapBetweenNonNullFields() throws Exception {
        ContiguousSet<Integer> intPrimitives = AbstractTestParquetReader.intsBetween(0, 10000);
        Iterable stringPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, "value2", "value3", null, null, "value6", "value7")), (int)10000);
        Iterable maps = this.createNullableTestMaps((Iterable)intPrimitives, stringPrimitives);
        List<List> values = this.createTestStructs(new Iterable[]{intPrimitives, maps, intPrimitives});
        List<String> structFieldNames = Arrays.asList("intField1", "mapIntStringField", "intField2");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"intField1", (Type)IntegerType.INTEGER), RowType.field((String)"mapIntStringField", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR)), RowType.field((String)"intField2", (Type)IntegerType.INTEGER)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaIntObjectInspector, ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)structType);
    }

    @Test
    public void testStructOfNullableArrayBetweenNonNullFields() throws Exception {
        ContiguousSet<Integer> intPrimitives = AbstractTestParquetReader.intsBetween(0, 10000);
        Iterable stringPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, "value2", "value3", null, null, "value6", "value7")), (int)10000);
        Iterable stringArrayField = this.createNullableTestArrays(stringPrimitives);
        List<List> values = this.createTestStructs(new Iterable[]{intPrimitives, stringArrayField, intPrimitives});
        List<String> structFieldNames = Arrays.asList("intField1", "arrayStringField", "intField2");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"intField1", (Type)IntegerType.INTEGER), RowType.field((String)"arrayStringField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField2", (Type)IntegerType.INTEGER)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaIntObjectInspector, ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)structType);
    }

    @Test
    public void testStructOfArrayAndPrimitive() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        List<List> values = this.createTestStructs(stringArrayField, Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)31234));
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)structType);
    }

    @Test
    public void testStructOfSingleLevelArrayAndPrimitive() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        List<List> values = this.createTestStructs(stringArrayField, Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)31234));
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)structType);
    }

    @Test
    public void testStructOfPrimitiveAndArray() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        Iterable intField = Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)31234);
        List<List> values = this.createTestStructs(intField, stringArrayField);
        List<String> structFieldNames = Arrays.asList("intField", "stringArrayField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"intField", (Type)IntegerType.INTEGER), RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR))));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaIntObjectInspector, ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector))), values, values, (Type)structType);
    }

    @Test
    public void testStructOfPrimitiveAndSingleLevelArray() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        Iterable intField = Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)31234);
        List<List> values = this.createTestStructs(intField, stringArrayField);
        List<String> structFieldNames = Arrays.asList("intField", "stringArrayField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"intField", (Type)IntegerType.INTEGER), RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR))));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaIntObjectInspector, ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector))), values, values, (Type)structType);
    }

    @Test
    public void testStructOfTwoArrays() throws Exception {
        Iterable intArrayField = this.createNullableTestArrays(Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)30000));
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 30000), Object::toString));
        List<List> values = this.createTestStructs(stringArrayField, intArrayField);
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intArrayField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intArrayField", (Type)new ArrayType((Type)IntegerType.INTEGER))));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector))), values, values, (Type)structType);
    }

    @Test
    public void testStructOfTwoNestedArrays() throws Exception {
        Iterable intArrayField = this.createNullableTestArrays(this.createNullableTestArrays(Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)30000)));
        Iterable stringArrayField = this.createNullableTestArrays(this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString)));
        List<List> values = this.createTestStructs(stringArrayField, intArrayField);
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intArrayField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR))), RowType.field((String)"intArrayField", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)))));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector)), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector)))), values, values, (Type)structType);
    }

    @Test
    public void testStructOfTwoNestedSingleLevelSchemaArrays() throws Exception {
        Iterable intArrayField = this.createNullableTestArrays(this.createTestArrays(Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)30000)));
        Iterable stringArrayField = this.createNullableTestArrays(this.createTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString)));
        List<List> values = this.createTestStructs(stringArrayField, intArrayField);
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intArrayField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR))), RowType.field((String)"intArrayField", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)))));
        StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector)), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector))));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)objectInspector, values, values, (Type)structType);
    }

    @Test
    public void testBooleanSequence() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)true, (Object)false, (Object)false)), (int)30000), (Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testSmallIntSequence() throws Exception {
        List values = Stream.of(1, 2, 3, 4, 5).map(value -> value.shortValue()).collect(Collectors.toList());
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector, Iterables.limit((Iterable)Iterables.cycle(values), (int)30000), (Type)SmallintType.SMALLINT);
    }

    @Test
    public void testLongSequence() throws Exception {
        this.testRoundTripNumeric((Iterable<Integer>)AbstractTestParquetReader.intsBetween(0, 31234));
    }

    @Test
    public void testLongSequenceWithHoles() throws Exception {
        this.testRoundTripNumeric(AbstractTestParquetReader.skipEvery(5, AbstractTestParquetReader.intsBetween(0, 31234)));
    }

    @Test
    public void testLongDirect() throws Exception {
        this.testRoundTripNumeric(Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)30000));
    }

    @Test
    public void testLongDirect2() throws Exception {
        ArrayList<Integer> values = new ArrayList<Integer>(31234);
        for (int i = 0; i < 31234; ++i) {
            values.add(i);
        }
        Collections.shuffle(values, new Random(0L));
        this.testRoundTripNumeric(values);
    }

    @Test
    public void testLongShortRepeat() throws Exception {
        this.testRoundTripNumeric(Iterables.limit(AbstractTestParquetReader.repeatEach(4, Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17))), (int)30000));
    }

    @Test
    public void testLongPatchedBase() throws Exception {
        this.testRoundTripNumeric(Iterables.limit((Iterable)Iterables.cycle((Iterable)Iterables.concat(AbstractTestParquetReader.intsBetween(0, 18), (Iterable)ImmutableList.of((Object)30000, (Object)20000))), (int)30000));
    }

    private static long maxPrecision(int numBytes) {
        return Math.round(Math.floor(Math.log10(Math.pow(2.0, 8 * numBytes - 1) - 1.0)));
    }

    @Test
    public void testDecimalBackedByINT32() throws Exception {
        for (int precision = 1; precision <= MAX_PRECISION_INT32; ++precision) {
            int scale = ThreadLocalRandom.current().nextInt(precision);
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional INT32 test (DECIMAL(%d, %d)); }", precision, scale));
            ContiguousSet<Integer> intValues = AbstractTestParquetReader.intsBetween(1, 1000);
            ImmutableList.Builder expectedValues = new ImmutableList.Builder();
            for (Integer value : intValues) {
                expectedValues.add((Object)SqlDecimal.of((long)value.intValue(), (int)precision, (int)scale));
            }
            this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (Iterable<?>)intValues, (Iterable<?>)expectedValues.build(), (Type)DecimalType.createDecimalType((int)precision, (int)scale), Optional.of(parquetSchema));
        }
    }

    @Test
    public void testTimestampMicrosBackedByINT64() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message ts_micros { optional INT64 test (TIMESTAMP_MICROS); }");
        ContiguousSet<Long> longValues = AbstractTestParquetReader.longsBetween(1000000L, 1001000L);
        ImmutableList.Builder expectedValues = new ImmutableList.Builder();
        for (Long value : longValues) {
            expectedValues.add((Object)new SqlTimestamp(value / 1000L, TimeZoneKey.UTC_KEY, TimeUnit.MILLISECONDS));
        }
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector, (Iterable<?>)longValues, (Iterable<?>)expectedValues.build(), (Type)TimestampType.TIMESTAMP, parquetSchema);
    }

    @Test
    public void testTimestampMillisBackedByINT64() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message ts_millis { optional INT64 test (TIMESTAMP_MILLIS); }");
        ContiguousSet<Long> longValues = AbstractTestParquetReader.longsBetween(1000000L, 1001000L);
        ImmutableList.Builder expectedValues = new ImmutableList.Builder();
        for (Long value : longValues) {
            expectedValues.add((Object)new SqlTimestamp(value.longValue(), TimeZoneKey.UTC_KEY, TimeUnit.MILLISECONDS));
        }
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (Iterable<?>)longValues, (Iterable<?>)expectedValues.build(), (Type)TimestampType.TIMESTAMP, Optional.of(parquetSchema));
    }

    @Test
    public void testDecimalBackedByINT64() throws Exception {
        for (int precision = MAX_PRECISION_INT32 + 1; precision <= MAX_PRECISION_INT64; ++precision) {
            int scale = ThreadLocalRandom.current().nextInt(precision);
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional INT64 test (DECIMAL(%d, %d)); }", precision, scale));
            ContiguousSet<Long> longValues = AbstractTestParquetReader.longsBetween(1L, 1000L);
            ImmutableList.Builder expectedValues = new ImmutableList.Builder();
            for (Long value : longValues) {
                expectedValues.add((Object)SqlDecimal.of((long)value, (int)precision, (int)scale));
            }
            this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (Iterable<?>)longValues, (Iterable<?>)expectedValues.build(), (Type)DecimalType.createDecimalType((int)precision, (int)scale), Optional.of(parquetSchema));
        }
    }

    @Test
    public void testDecimalBackedByFixedLenByteArray() throws Exception {
        for (int precision = MAX_PRECISION_INT64 + 1; precision < 38; ++precision) {
            int scale = ThreadLocalRandom.current().nextInt(precision);
            ContiguousSet<BigInteger> values = AbstractTestParquetReader.bigIntegersBetween(BigDecimal.valueOf(Math.pow(10.0, precision - 1)).toBigInteger(), BigDecimal.valueOf(Math.pow(10.0, precision)).toBigInteger());
            ImmutableList.Builder expectedValues = new ImmutableList.Builder();
            ImmutableList.Builder writeValues = new ImmutableList.Builder();
            for (BigInteger value : Iterables.limit(values, (int)1000)) {
                writeValues.add((Object)HiveDecimal.create((BigInteger)value, (int)scale));
                expectedValues.add((Object)new SqlDecimal(value, precision, scale));
            }
            this.tester.testRoundTrip((ObjectInspector)new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(precision, scale)), (Iterable<?>)writeValues.build(), (Iterable<?>)expectedValues.build(), (Type)DecimalType.createDecimalType((int)precision, (int)scale));
        }
    }

    @Test
    public void testSchemaWithRepeatedOptionalRequiredFields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group address_book {    required binary owner (UTF8);    optional group owner_phone_numbers (LIST) {      repeated group bag {        optional binary array_element (UTF8);      }    }    optional group contacts (LIST) {      repeated group bag {        optional group array_element {          required binary name (UTF8);          optional binary phone_number (UTF8);        }      }    }  }} ");
        Iterable owner = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList("owner1", "owner2", "owner3")), (int)50000);
        Iterable ownerPhoneNumbers = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, Arrays.asList("phoneNumber2", "phoneNumber3", null), Arrays.asList(null, "phoneNumber6", "phoneNumber7"))), (int)50000);
        List<String> name = Arrays.asList("name1", "name2", "name3", "name4", "name5", "name6", "name7");
        List<String> phoneNumber = Arrays.asList(null, "phoneNumber2", "phoneNumber3", null, null, "phoneNumber6", "phoneNumber7");
        Iterable<List> contact = this.createNullableTestStructs(name, phoneNumber);
        Iterable contacts = this.createNullableTestArrays(Iterables.limit((Iterable)Iterables.cycle(contact), (int)50000));
        List<List> values = this.createTestStructs(owner, ownerPhoneNumbers, contacts);
        List<String> addressBookFieldNames = Arrays.asList("owner", "owner_phone_numbers", "contacts");
        List<String> contactsFieldNames = Arrays.asList("name", "phone_number");
        ArrayType contactsType = new ArrayType((Type)RowType.from(Arrays.asList(RowType.field((String)"name", (Type)VarcharType.VARCHAR), RowType.field((String)"phone_number", (Type)VarcharType.VARCHAR))));
        RowType addressBookType = RowType.from(Arrays.asList(RowType.field((String)"owner", (Type)VarcharType.VARCHAR), RowType.field((String)"owner_phone_numbers", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"contacts", (Type)contactsType)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(addressBookFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(contactsFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaStringObjectInspector))))), values, values, "address_book", (Type)addressBookType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithOptionalOptionalRequiredFields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group a {    optional group b {      optional group c {        required binary d (UTF8);      }    }  }} ");
        RowType cType = RowType.from(Collections.singletonList(RowType.field((String)"d", (Type)VarcharType.VARCHAR)));
        RowType bType = RowType.from(Collections.singletonList(RowType.field((String)"c", (Type)cType)));
        RowType aType = RowType.from(Collections.singletonList(RowType.field((String)"b", (Type)bType)));
        List<String> dValues = Arrays.asList("d1", "d2", "d3", "d4", "d5", "d6", "d7");
        Iterable<List> cValues = this.createNullableTestStructs(dValues);
        Iterable<List> bValues = this.createNullableTestStructs(cValues);
        List<List> aValues = this.createTestStructs((Iterable)bValues);
        StandardStructObjectInspector cInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("d"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("c"), Collections.singletonList(cInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("b"), Collections.singletonList(bInspector));
        this.tester.testRoundTrip((ObjectInspector)aInspector, aValues, aValues, "a", (Type)aType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithOptionalRequiredOptionalFields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group a {    optional group b {      required group c {        optional int32 d;      }    }  }} ");
        RowType cType = RowType.from(Collections.singletonList(RowType.field((String)"d", (Type)IntegerType.INTEGER)));
        RowType bType = RowType.from(Collections.singletonList(RowType.field((String)"c", (Type)cType)));
        RowType aType = RowType.from(Collections.singletonList(RowType.field((String)"b", (Type)bType)));
        List<Integer> dValues = Arrays.asList(111, null, 333, 444, null, 666, 777);
        List<List> cValues = this.createTestStructs((Iterable)dValues);
        Iterable<List> bValues = this.createNullableTestStructs(cValues);
        List<List> aValues = this.createTestStructs((Iterable)bValues);
        StandardStructObjectInspector cInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("d"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("c"), Collections.singletonList(cInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("b"), Collections.singletonList(bInspector));
        this.tester.testRoundTrip((ObjectInspector)aInspector, aValues, aValues, "a", (Type)aType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithRequiredRequiredOptionalFields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group a {    required group b {      required group c {        optional int32 d;      }    }  }} ");
        RowType cType = RowType.from(Collections.singletonList(RowType.field((String)"d", (Type)IntegerType.INTEGER)));
        RowType bType = RowType.from(Collections.singletonList(RowType.field((String)"c", (Type)cType)));
        RowType aType = RowType.from(Collections.singletonList(RowType.field((String)"b", (Type)bType)));
        List<Integer> dValues = Arrays.asList(111, null, 333, 444, null, 666, 777);
        List<List> cValues = this.createTestStructs((Iterable)dValues);
        List<List> bValues = this.createTestStructs((Iterable)cValues);
        List<List> aValues = this.createTestStructs((Iterable)bValues);
        StandardStructObjectInspector cInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("d"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("c"), Collections.singletonList(cInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("b"), Collections.singletonList(bInspector));
        this.tester.testRoundTrip((ObjectInspector)aInspector, aValues, aValues, "a", (Type)aType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithRequiredOptionalOptionalFields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group a {    required group b {      optional group c {        optional int32 d;      }    }  }} ");
        RowType cType = RowType.from(Collections.singletonList(RowType.field((String)"d", (Type)IntegerType.INTEGER)));
        RowType bType = RowType.from(Collections.singletonList(RowType.field((String)"c", (Type)cType)));
        RowType aType = RowType.from(Collections.singletonList(RowType.field((String)"b", (Type)bType)));
        List<Integer> dValues = Arrays.asList(111, null, 333, 444, null, 666, 777);
        Iterable<List> cValues = this.createNullableTestStructs(dValues);
        List<List> bValues = this.createTestStructs((Iterable)cValues);
        List<List> aValues = this.createTestStructs((Iterable)bValues);
        StandardStructObjectInspector cInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("d"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("c"), Collections.singletonList(cInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("b"), Collections.singletonList(bInspector));
        this.tester.testRoundTrip((ObjectInspector)aInspector, aValues, aValues, "a", (Type)aType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithRequiredOptionalRequiredFields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group a {    required group b {      optional group c {        required binary d (UTF8);      }    }  }} ");
        RowType cType = RowType.from(Collections.singletonList(RowType.field((String)"d", (Type)VarcharType.VARCHAR)));
        RowType bType = RowType.from(Collections.singletonList(RowType.field((String)"c", (Type)cType)));
        RowType aType = RowType.from(Collections.singletonList(RowType.field((String)"b", (Type)bType)));
        List<String> dValues = Arrays.asList("d1", "d2", "d3", "d4", "d5", "d6", "d7");
        Iterable<List> cValues = this.createNullableTestStructs(dValues);
        List<List> bValues = this.createTestStructs((Iterable)cValues);
        List<List> aValues = this.createTestStructs((Iterable)bValues);
        StandardStructObjectInspector cInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("d"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("c"), Collections.singletonList(cInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("b"), Collections.singletonList(bInspector));
        this.tester.testRoundTrip((ObjectInspector)aInspector, aValues, aValues, "a", (Type)aType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithRequiredStruct() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  required group a {    required group b {        required binary c (UTF8);        required int32 d;    }    required binary e (UTF8);  }} ");
        RowType bType = RowType.from(Arrays.asList(RowType.field((String)"c", (Type)VarcharType.VARCHAR), RowType.field((String)"d", (Type)IntegerType.INTEGER)));
        RowType aType = RowType.from(Arrays.asList(RowType.field((String)"b", (Type)bType), RowType.field((String)"e", (Type)VarcharType.VARCHAR)));
        Iterable cValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList("c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7")), (int)30000);
        ContiguousSet<Integer> dValues = AbstractTestParquetReader.intsBetween(0, 30000);
        Iterable eValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList("e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7")), (int)30000);
        List<List> bValues = this.createTestStructs(new Iterable[]{cValues, dValues});
        List<List> aValues = this.createTestStructs(bValues, eValues);
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("c", "d"), Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("b", "e"), Arrays.asList(bInspector, PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        this.tester.assertRoundTrip(Collections.singletonList(aInspector), new Iterable[]{aValues}, new Iterable[]{aValues}, Collections.singletonList("a"), Collections.singletonList(aType), Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithRequiredOptionalRequired2Fields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group a {    required group b {      optional group c {        required binary d (UTF8);      }    }  }  optional group e {    required group f {      optional group g {        required binary h (UTF8);      }    }  }} ");
        RowType cType = RowType.from(Collections.singletonList(RowType.field((String)"d", (Type)VarcharType.VARCHAR)));
        RowType bType = RowType.from(Collections.singletonList(RowType.field((String)"c", (Type)cType)));
        RowType aType = RowType.from(Collections.singletonList(RowType.field((String)"b", (Type)bType)));
        List<String> dValues = Arrays.asList("d1", "d2", "d3", "d4", "d5", "d6", "d7");
        Iterable<List> cValues = this.createNullableTestStructs(dValues);
        List<List> bValues = this.createTestStructs((Iterable)cValues);
        List<List> aValues = this.createTestStructs((Iterable)bValues);
        RowType gType = RowType.from(Collections.singletonList(RowType.field((String)"h", (Type)VarcharType.VARCHAR)));
        RowType fType = RowType.from(Collections.singletonList(RowType.field((String)"g", (Type)gType)));
        RowType eType = RowType.from(Collections.singletonList(RowType.field((String)"f", (Type)fType)));
        List<String> hValues = Arrays.asList("h1", "h2", "h3", "h4", "h5", "h6", "h7");
        Iterable<List> gValues = this.createNullableTestStructs(hValues);
        List<List> fValues = this.createTestStructs((Iterable)gValues);
        List<List> eValues = this.createTestStructs((Iterable)fValues);
        StandardStructObjectInspector cInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("d"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("c"), Collections.singletonList(cInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("b"), Collections.singletonList(bInspector));
        StandardStructObjectInspector gInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("h"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        StandardStructObjectInspector fInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("g"), Collections.singletonList(gInspector));
        StandardStructObjectInspector eInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("f"), Collections.singletonList(fInspector));
        this.tester.testRoundTrip(Arrays.asList(aInspector, eInspector), new Iterable[]{aValues, eValues}, new Iterable[]{aValues, eValues}, Arrays.asList("a", "e"), Arrays.asList(aType, eType), Optional.of(parquetSchema), false);
    }

    @Test
    public void testOldAvroArray() throws Exception {
        MessageType parquetMrAvroSchema = MessageTypeParser.parseMessageType((String)"message avro_schema_old {  optional group my_list (LIST){        repeated int32 array;  }} ");
        List<List<Integer>> nonNullArrayElements = this.createTestArrays((Iterable)AbstractTestParquetReader.intsBetween(0, 31234));
        this.tester.testSingleLevelArrayRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), nonNullArrayElements, nonNullArrayElements, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(parquetMrAvroSchema));
    }

    @Test
    public void testNewAvroArray() throws Exception {
        MessageType parquetMrAvroSchema = MessageTypeParser.parseMessageType((String)"message avro_schema_new {   optional group my_list (LIST) {     repeated group list {       optional int32 element;     }   } }");
        List values = this.createTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(parquetMrAvroSchema));
    }

    @Test
    public void testArraySchemas() throws Exception {
        MessageType parquetMrNullableSpecSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group my_list (LIST){    repeated group list {        required int32 element;    }  }} ");
        List<List<Integer>> nonNullArrayElements = this.createTestArrays((Iterable)AbstractTestParquetReader.intsBetween(0, 31234));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), nonNullArrayElements, nonNullArrayElements, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(parquetMrNullableSpecSchema));
        MessageType parquetMrNonNullSpecSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  required group my_list (LIST){    repeated group list {        optional int32 element;    }  }} ");
        List values = this.createTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        this.tester.assertRoundTrip(Collections.singletonList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector)), new Iterable[]{values}, new Iterable[]{values}, Collections.singletonList("my_list"), Collections.singletonList(new ArrayType((Type)IntegerType.INTEGER)), Optional.of(parquetMrNonNullSpecSchema));
        MessageType sparkSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group my_list (LIST){    repeated group list {        optional int32 element;    }  }} ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(sparkSchema));
        MessageType hiveSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group my_list (LIST){    repeated group bag {        optional int32 array_element;    }  }} ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(hiveSchema));
        MessageType customNamingSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group my_list (LIST){    repeated group bag {        optional int32 array;    }  }} ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(customNamingSchema));
    }

    @Test
    public void testMapSchemas() throws Exception {
        Iterable values = this.createTestMaps(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 100000), Object::toString), (Iterable)AbstractTestParquetReader.intsBetween(0, 10000));
        Iterable nullableValues = this.createTestMaps(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 30000), Object::toString), Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER));
        MessageType map = MessageTypeParser.parseMessageType((String)"message hive_schema { optional group my_map (MAP) {     repeated group map {         required binary str (UTF8);           required int32 num;      }    }}   ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { optional group my_map (MAP_KEY_VALUE) {     repeated group map {         required binary str (UTF8);           required int32 num;      }    }}   ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { required group my_map (MAP) {     repeated group map {          required binary key (UTF8);             optional int32 value;       }     } }  ");
        this.tester.assertRoundTrip(Collections.singletonList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector)), new Iterable[]{nullableValues}, new Iterable[]{nullableValues}, Collections.singletonList("my_map"), Collections.singletonList(StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER)), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { required group my_map (MAP_KEY_VALUE) {     repeated group map {          required binary key (UTF8);             optional int32 value;       }     } }  ");
        this.tester.assertRoundTrip(Collections.singletonList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector)), new Iterable[]{nullableValues}, new Iterable[]{nullableValues}, Collections.singletonList("my_map"), Collections.singletonList(StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER)), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { required group my_map (MAP) {     repeated group map {          required binary key (UTF8);             required int32 value;       }     } }  ");
        this.tester.assertRoundTrip(Collections.singletonList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector)), new Iterable[]{values}, new Iterable[]{values}, Collections.singletonList("my_map"), Collections.singletonList(StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER)), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { required group my_map (MAP_KEY_VALUE) {     repeated group map {          required binary key (UTF8);             required int32 value;       }     } }  ");
        this.tester.assertRoundTrip(Collections.singletonList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector)), new Iterable[]{values}, new Iterable[]{values}, Collections.singletonList("my_map"), Collections.singletonList(StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER)), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { optional group my_map (MAP) {     repeated group map {         required binary key (UTF8);             optional int32 value;       }     } }  ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), nullableValues, nullableValues, "my_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { optional group my_map (MAP_KEY_VALUE) {     repeated group map {         required binary key (UTF8);             optional int32 value;       }     } }  ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), nullableValues, nullableValues, "my_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), Optional.of(map));
    }

    @Test
    public void testLongStrideDictionary() throws Exception {
        this.testRoundTripNumeric(Iterables.concat((Iterable)ImmutableList.of((Object)1), Collections.nCopies(9999, 123), (Iterable)ImmutableList.of((Object)2), Collections.nCopies(9999, 123)));
    }

    private void testRoundTripNumeric(Iterable<Integer> writeValues) throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector, Iterables.transform(writeValues, AbstractTestParquetReader::intToByte), AbstractTestParquetReader::byteToInt, (Type)IntegerType.INTEGER);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector, Iterables.transform(writeValues, AbstractTestParquetReader::intToShort), AbstractTestParquetReader::shortToInt, (Type)IntegerType.INTEGER);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, writeValues, (Type)IntegerType.INTEGER);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, Iterables.transform(writeValues, AbstractTestParquetReader::intToLong), (Type)BigintType.BIGINT);
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector, Iterables.transform(writeValues, AbstractTestParquetReader::intToTimestamp), Iterables.transform(writeValues, AbstractTestParquetReader::intToSqlTimestamp), (Type)TimestampType.TIMESTAMP);
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaDateObjectInspector, Iterables.transform(writeValues, AbstractTestParquetReader::intToDate), Iterables.transform(writeValues, AbstractTestParquetReader::intToSqlDate), (Type)DateType.DATE);
    }

    @Test
    public void testFloatSequence() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, AbstractTestParquetReader.floatSequence(0.0, 0.1f, 30000), (Type)RealType.REAL);
    }

    @Test
    public void testFloatNaNInfinity() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(1000.0f), (Object)Float.valueOf(-1.23f), (Object)Float.valueOf(Float.POSITIVE_INFINITY)), (Type)RealType.REAL);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(-1000.0f), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(1.23f)), (Type)RealType.REAL);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(Float.POSITIVE_INFINITY)), (Type)RealType.REAL);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(-0.0f), (Object)Float.valueOf(1.0f)), (Type)RealType.REAL);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(-1.0f), (Object)Float.valueOf(Float.POSITIVE_INFINITY)), (Type)RealType.REAL);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(1.0f)), (Type)RealType.REAL);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(Float.POSITIVE_INFINITY)), (Type)RealType.REAL);
    }

    @Test
    public void testDoubleSequence() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, AbstractTestParquetReader.doubleSequence(0.0, 0.1, 30000), (Type)DoubleType.DOUBLE);
    }

    @Test
    public void testDoubleNaNInfinity() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)1000.0, (Object)-1.0, (Object)Double.POSITIVE_INFINITY), (Type)DoubleType.DOUBLE);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)-1000.0, (Object)Double.NEGATIVE_INFINITY, (Object)1.0), (Type)DoubleType.DOUBLE);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)0.0, (Object)Double.NEGATIVE_INFINITY, (Object)Double.POSITIVE_INFINITY), (Type)DoubleType.DOUBLE);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)Double.NaN, (Object)-1.0, (Object)1.0), (Type)DoubleType.DOUBLE);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)Double.NaN, (Object)-1.0, (Object)Double.POSITIVE_INFINITY), (Type)DoubleType.DOUBLE);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)Double.NaN, (Object)Double.NEGATIVE_INFINITY, (Object)1.0), (Type)DoubleType.DOUBLE);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)Double.NaN, (Object)Double.NEGATIVE_INFINITY, (Object)Double.POSITIVE_INFINITY), (Type)DoubleType.DOUBLE);
    }

    @Test
    public void testStringUnicode() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"apple", (Object)"apple pie", (Object)"apple\ud835\udc03", (Object)"apple\ufffd")), (int)30000), (Type)VarcharType.createUnboundedVarcharType());
    }

    @Test
    public void testStringDirectSequence() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, Iterables.transform(AbstractTestParquetReader.intsBetween(0, 30000), Object::toString), (Type)VarcharType.createUnboundedVarcharType());
    }

    @Test
    public void testStringDictionarySequence() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, Iterables.limit((Iterable)Iterables.cycle((Iterable)Iterables.transform((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17), Object::toString)), (int)30000), (Type)VarcharType.createUnboundedVarcharType());
    }

    @Test
    public void testStringStrideDictionary() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, Iterables.concat((Iterable)ImmutableList.of((Object)"a"), Collections.nCopies(9999, "123"), (Iterable)ImmutableList.of((Object)"b"), Collections.nCopies(9999, "123")), (Type)VarcharType.createUnboundedVarcharType());
    }

    @Test
    public void testEmptyStringSequence() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, Iterables.limit((Iterable)Iterables.cycle((Object[])new String[]{""}), (int)30000), (Type)VarcharType.createUnboundedVarcharType());
    }

    @Test
    public void testBinaryDirectSequence() throws Exception {
        Iterable writeValues = Iterables.transform(AbstractTestParquetReader.intsBetween(0, 30000), (Function)Functions.compose(AbstractTestParquetReader::stringToByteArray, Object::toString));
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector, writeValues, Iterables.transform((Iterable)writeValues, AbstractTestParquetReader::byteArrayToVarbinary), (Type)VarbinaryType.VARBINARY);
    }

    @Test
    public void testBinaryDictionarySequence() throws Exception {
        Iterable writeValues = Iterables.limit((Iterable)Iterables.cycle((Iterable)Iterables.transform((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17), (Function)Functions.compose(AbstractTestParquetReader::stringToByteArray, Object::toString))), (int)30000);
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector, writeValues, Iterables.transform((Iterable)writeValues, AbstractTestParquetReader::byteArrayToVarbinary), (Type)VarbinaryType.VARBINARY);
    }

    @Test
    public void testEmptyBinarySequence() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector, Iterables.limit((Iterable)Iterables.cycle((Object[])new byte[][]{new byte[0]}), (int)30000), AbstractTestParquetReader::byteArrayToVarbinary, (Type)VarbinaryType.VARBINARY);
    }

    private static <T> Iterable<T> skipEvery(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private int position;
            private final Iterator delegate;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                while (this.delegate.hasNext()) {
                    Object next = this.delegate.next();
                    ++this.position;
                    if (this.position <= n) {
                        return next;
                    }
                    this.position = 0;
                }
                return this.endOfData();
            }
        };
    }

    @Test
    public void testStructMaxReadBytes() throws Exception {
        DataSize maxReadBlockSize = new DataSize(1000.0, DataSize.Unit.BYTE);
        List<List> structValues = this.createTestStructs(Collections.nCopies(500, String.join((CharSequence)"", Collections.nCopies(33, "test"))), Collections.nCopies(500, String.join((CharSequence)"", Collections.nCopies(1, "test"))));
        List<String> structFieldNames = Arrays.asList("a", "b");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)VarcharType.VARCHAR), RowType.field((String)"b", (Type)VarcharType.VARCHAR)));
        this.tester.testMaxReadBytes((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaStringObjectInspector)), structValues, structValues, (Type)structType, maxReadBlockSize);
    }

    @Test
    public void testNullableNullCount() {
        PrimitiveType primitiveType = new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "testColumn");
        Statistics statistics = new Statistics();
        Assert.assertEquals((long)MetadataReader.readStats((Statistics)statistics, (PrimitiveType.PrimitiveTypeName)primitiveType.getPrimitiveTypeName()).getNumNulls(), (long)-1L);
        statistics.setNull_count(10L);
        Assert.assertEquals((long)MetadataReader.readStats((Statistics)statistics, (PrimitiveType.PrimitiveTypeName)primitiveType.getPrimitiveTypeName()).getNumNulls(), (long)10L);
    }

    @Test
    public void testArrayMaxReadBytes() throws Exception {
        DataSize maxReadBlockSize = new DataSize(1000.0, DataSize.Unit.BYTE);
        List values = this.createFixedTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        this.tester.testMaxReadBytes((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, (Type)new ArrayType((Type)IntegerType.INTEGER), maxReadBlockSize);
    }

    @Test
    public void testMapMaxReadBytes() throws Exception {
        DataSize maxReadBlockSize = new DataSize(1000.0, DataSize.Unit.BYTE);
        Iterable<Map<String, Long>> values = this.createFixedTestMaps((Iterable)Collections.nCopies(5000, String.join((CharSequence)"", Collections.nCopies(33, "test"))), (Iterable)AbstractTestParquetReader.longsBetween(0L, 5000L));
        this.tester.testMaxReadBytes((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector), values, values, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT), maxReadBlockSize);
    }

    @Test
    public void testCaching() throws Exception {
        Cache parquetFileMetadataCache = CacheBuilder.newBuilder().maximumWeight(new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes()).weigher((id, metadata) -> ((ParquetFileMetadata)metadata).getMetadataSize()).expireAfterAccess(new Duration(10.0, TimeUnit.MINUTES).toMillis(), TimeUnit.MILLISECONDS).recordStats().build();
        CachingParquetMetadataSource parquetMetadataSource = new CachingParquetMetadataSource(parquetFileMetadataCache, (ParquetMetadataSource)new MetadataReader());
        try (ParquetTester.TempFile tempFile = new ParquetTester.TempFile("test", "parquet");){
            ContiguousSet<Integer> values = AbstractTestParquetReader.intsBetween(0, 10);
            Iterator[] readValues = (Iterator[])Arrays.stream(new Iterable[]{values}).map(Iterable::iterator).toArray(Iterator[]::new);
            List<String> columnNames = Collections.singletonList("column1");
            List<IntegerType> columnTypes = Collections.singletonList(IntegerType.INTEGER);
            ParquetTester.writeParquetFileFromPresto(tempFile.getFile(), columnTypes, columnNames, readValues, 10, CompressionCodecName.GZIP);
            long tempFileCreationTime = System.currentTimeMillis();
            ParquetTester.testSingleRead(new Iterable[]{values}, columnNames, columnTypes, (ParquetMetadataSource)parquetMetadataSource, tempFile.getFile(), tempFileCreationTime);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().missCount(), (long)1L);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().hitCount(), (long)0L);
            ParquetTester.testSingleRead(new Iterable[]{values}, columnNames, columnTypes, (ParquetMetadataSource)parquetMetadataSource, tempFile.getFile(), tempFileCreationTime);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().missCount(), (long)1L);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().hitCount(), (long)1L);
            ParquetTester.testSingleRead(new Iterable[]{values}, columnNames, columnTypes, (ParquetMetadataSource)parquetMetadataSource, tempFile.getFile(), tempFileCreationTime);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().missCount(), (long)1L);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().hitCount(), (long)2L);
            parquetFileMetadataCache.invalidateAll();
            ParquetTester.testSingleRead(new Iterable[]{values}, columnNames, columnTypes, (ParquetMetadataSource)parquetMetadataSource, tempFile.getFile(), tempFileCreationTime);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().missCount(), (long)2L);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().hitCount(), (long)2L);
            ParquetTester.testSingleRead(new Iterable[]{values}, columnNames, columnTypes, (ParquetMetadataSource)parquetMetadataSource, tempFile.getFile(), tempFileCreationTime);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().missCount(), (long)2L);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().hitCount(), (long)3L);
            long tempFileModificationTime = System.currentTimeMillis();
            ParquetTester.testSingleRead(new Iterable[]{values}, columnNames, columnTypes, (ParquetMetadataSource)parquetMetadataSource, tempFile.getFile(), tempFileModificationTime);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().missCount(), (long)2L);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().hitCount(), (long)4L);
            ParquetTester.testSingleRead(new Iterable[]{values}, columnNames, columnTypes, (ParquetMetadataSource)parquetMetadataSource, tempFile.getFile(), tempFileModificationTime);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().missCount(), (long)3L);
            Assert.assertEquals((long)parquetFileMetadataCache.stats().hitCount(), (long)4L);
        }
    }

    private static <T> Iterable<T> repeatEach(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private int position;
            private final Iterator delegate;
            private Object value;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                if (this.position == 0) {
                    if (!this.delegate.hasNext()) {
                        return this.endOfData();
                    }
                    this.value = this.delegate.next();
                }
                ++this.position;
                if (this.position >= n) {
                    this.position = 0;
                }
                return this.value;
            }
        };
    }

    private static Iterable<Float> floatSequence(double start, double step, int items) {
        return Iterables.transform(AbstractTestParquetReader.doubleSequence(start, step, items), input -> {
            if (input == null) {
                return null;
            }
            return Float.valueOf(input.floatValue());
        });
    }

    private static Iterable<Double> doubleSequence(double start, final double step, final int items) {
        return () -> new AbstractSequentialIterator<Double>(Double.valueOf(start)){
            private int item;

            protected Double computeNext(Double previous) {
                if (this.item >= items) {
                    return null;
                }
                ++this.item;
                return previous + step;
            }
        };
    }

    private static ContiguousSet<Integer> intsBetween(int lowerInclusive, int upperExclusive) {
        return ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(lowerInclusive), (Comparable)Integer.valueOf(upperExclusive)), (DiscreteDomain)DiscreteDomain.integers());
    }

    private static ContiguousSet<Long> longsBetween(long lowerInclusive, long upperExclusive) {
        return ContiguousSet.create((Range)Range.closedOpen((Comparable)Long.valueOf(lowerInclusive), (Comparable)Long.valueOf(upperExclusive)), (DiscreteDomain)DiscreteDomain.longs());
    }

    private static ContiguousSet<BigInteger> bigIntegersBetween(BigInteger lowerInclusive, BigInteger upperExclusive) {
        return ContiguousSet.create((Range)Range.closedOpen((Comparable)lowerInclusive, (Comparable)upperExclusive), (DiscreteDomain)DiscreteDomain.bigIntegers());
    }

    private <F> List<List> createTestStructs(Iterable<F> fieldValues) {
        Preconditions.checkArgument((boolean)fieldValues.iterator().hasNext(), (Object)"struct field values cannot be empty");
        ArrayList<List> structs = new ArrayList<List>();
        for (F field : fieldValues) {
            structs.add(Collections.singletonList(field));
        }
        return structs;
    }

    private List<List> createTestStructs(Iterable<?> ... values) {
        ArrayList<List> structs = new ArrayList<List>();
        List<Iterator> iterators = Arrays.stream(values).map(Iterable::iterator).collect(Collectors.toList());
        iterators.forEach(iter -> Preconditions.checkArgument((boolean)iter.hasNext(), (Object)"struct field values cannot be empty"));
        while (iterators.stream().allMatch(Iterator::hasNext)) {
            structs.add(iterators.stream().map(Iterator::next).collect(Collectors.toList()));
        }
        return structs;
    }

    private Iterable<List> createNullableTestStructs(Iterable<?> ... values) {
        return ParquetTester.insertNullEvery(ThreadLocalRandom.current().nextInt(2, 5), this.createTestStructs(values));
    }

    private <T> List<List<T>> createTestArrays(Iterable<T> values) {
        ArrayList<List<T>> arrays = new ArrayList<List<T>>();
        Iterator<T> valuesIter = values.iterator();
        ArrayList<T> array = new ArrayList<T>();
        while (valuesIter.hasNext()) {
            if (ThreadLocalRandom.current().nextBoolean()) {
                arrays.add(array);
                array = new ArrayList();
            }
            if (ThreadLocalRandom.current().nextInt(10) == 0) {
                arrays.add(Collections.emptyList());
            }
            array.add(valuesIter.next());
        }
        return arrays;
    }

    private <T> Iterable<List<T>> createNullableTestArrays(Iterable<T> values) {
        return ParquetTester.insertNullEvery(ThreadLocalRandom.current().nextInt(2, 5), this.createTestArrays(values));
    }

    private <T> List<List<T>> createFixedTestArrays(Iterable<T> values) {
        ArrayList<List<T>> arrays = new ArrayList<List<T>>();
        Iterator<T> valuesIter = values.iterator();
        ArrayList<T> array = new ArrayList<T>();
        int count = 1;
        while (valuesIter.hasNext()) {
            if (count % 10 == 0) {
                arrays.add(array);
                array = new ArrayList();
            }
            if (count % 20 == 0) {
                arrays.add(Collections.emptyList());
            }
            array.add(valuesIter.next());
            ++count;
        }
        return arrays;
    }

    private <K, V> Iterable<Map<K, V>> createFixedTestMaps(Iterable<K> keys, Iterable<V> values) {
        ArrayList<Map<K, V>> maps = new ArrayList<Map<K, V>>();
        Iterator<K> keysIterator = keys.iterator();
        Iterator<V> valuesIterator = values.iterator();
        HashMap<K, V> map = new HashMap<K, V>();
        int count = 1;
        while (keysIterator.hasNext() && valuesIterator.hasNext()) {
            if (count % 5 == 0) {
                maps.add(map);
                map = new HashMap();
            }
            if (count % 10 == 0) {
                maps.add(Collections.emptyMap());
            }
            map.put(keysIterator.next(), valuesIterator.next());
            ++count;
        }
        return maps;
    }

    private <K, V> Iterable<Map<K, V>> createTestMaps(Iterable<K> keys, Iterable<V> values) {
        ArrayList<Map<K, V>> maps = new ArrayList<Map<K, V>>();
        Iterator<K> keysIterator = keys.iterator();
        Iterator<V> valuesIterator = values.iterator();
        HashMap<K, V> map = new HashMap<K, V>();
        while (keysIterator.hasNext() && valuesIterator.hasNext()) {
            if (ThreadLocalRandom.current().nextInt(5) == 0) {
                maps.add(map);
                map = new HashMap();
            }
            if (ThreadLocalRandom.current().nextInt(10) == 0) {
                maps.add(Collections.emptyMap());
            }
            map.put(keysIterator.next(), valuesIterator.next());
        }
        return maps;
    }

    private <K, V> Iterable<Map<K, V>> createNullableTestMaps(Iterable<K> keys, Iterable<V> values) {
        return ParquetTester.insertNullEvery(ThreadLocalRandom.current().nextInt(2, 5), this.createTestMaps(keys, values));
    }

    private static Byte intToByte(Integer input) {
        if (input == null) {
            return null;
        }
        return input.byteValue();
    }

    private static Short intToShort(Integer input) {
        if (input == null) {
            return null;
        }
        return Shorts.checkedCast((long)input.intValue());
    }

    private static Integer byteToInt(Byte input) {
        return AbstractTestParquetReader.toInteger(input);
    }

    private static Integer shortToInt(Short input) {
        return AbstractTestParquetReader.toInteger(input);
    }

    private static Long intToLong(Integer input) {
        return AbstractTestParquetReader.toLong(input);
    }

    private static <N extends Number> Integer toInteger(N input) {
        if (input == null) {
            return null;
        }
        return input.intValue();
    }

    private static <N extends Number> Long toLong(N input) {
        if (input == null) {
            return null;
        }
        return input.longValue();
    }

    private static byte[] stringToByteArray(String input) {
        return input.getBytes(StandardCharsets.UTF_8);
    }

    private static SqlVarbinary byteArrayToVarbinary(byte[] input) {
        if (input == null) {
            return null;
        }
        return new SqlVarbinary(input);
    }

    private static Timestamp intToTimestamp(Integer input) {
        if (input == null) {
            return null;
        }
        Timestamp timestamp = new Timestamp(0L);
        long seconds = input / 1000;
        int nanos = input % 1000 * 1000000;
        if ((nanos += 888888) < 0) {
            nanos += 1000000000;
            --seconds;
        }
        if (nanos > 1000000000) {
            nanos -= 1000000000;
            ++seconds;
        }
        timestamp.setTime(seconds * 1000L);
        timestamp.setNanos(nanos);
        return timestamp;
    }

    protected static SqlTimestamp intToSqlTimestamp(Integer input) {
        if (input == null) {
            return null;
        }
        return DateTimeTestingUtils.sqlTimestampOf((long)input.intValue(), (ConnectorSession)TestingConnectorSession.SESSION);
    }

    private static Date intToDate(Integer input) {
        if (input == null) {
            return null;
        }
        return Date.valueOf(LocalDate.ofEpochDay(input.intValue()));
    }

    private static SqlDate intToSqlDate(Integer input) {
        if (input == null) {
            return null;
        }
        return new SqlDate(input.intValue());
    }
}

