/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.predicate;

import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParquetPredicateUtils {
    @Test
    public void testParquetTupleDomainPrimitiveArray() {
        HiveColumnHandle columnHandle = new HiveColumnHandle("my_array", HiveType.valueOf((String)"array<int>"), TypeSignature.parseTypeSignature((String)"array"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((com.facebook.presto.common.type.Type)new ArrayType((com.facebook.presto.common.type.Type)IntegerType.INTEGER))));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_array", new Type[]{new GroupType(Type.Repetition.REPEATED, "bag", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "array_element")})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain);
        Assert.assertTrue((boolean)((Map)tupleDomain.getDomains().get()).isEmpty());
    }

    @Test
    public void testParquetTupleDomainStructArray() {
        HiveColumnHandle columnHandle = new HiveColumnHandle("my_array_struct", HiveType.valueOf((String)"array<struct<a:int>>"), TypeSignature.parseTypeSignature((String)"array"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
        RowType.Field rowField = new RowType.Field(Optional.of("a"), (com.facebook.presto.common.type.Type)IntegerType.INTEGER);
        RowType rowType = RowType.from((List)ImmutableList.of((Object)rowField));
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((com.facebook.presto.common.type.Type)new ArrayType((com.facebook.presto.common.type.Type)rowType))));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_array_struct", new Type[]{new GroupType(Type.Repetition.REPEATED, "bag", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "array_element", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a")})})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain);
        Assert.assertTrue((boolean)((Map)tupleDomain.getDomains().get()).isEmpty());
    }

    @Test
    public void testParquetTupleDomainPrimitive() {
        HiveColumnHandle columnHandle = new HiveColumnHandle("my_primitive", HiveType.valueOf((String)"bigint"), TypeSignature.parseTypeSignature((String)"bigint"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
        Domain singleValueDomain = Domain.singleValue((com.facebook.presto.common.type.Type)BigintType.BIGINT, (Object)123L);
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)singleValueDomain));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "my_primitive")});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain);
        Assert.assertEquals((int)((Map)tupleDomain.getDomains().get()).size(), (int)1);
        ColumnDescriptor descriptor = (ColumnDescriptor)((Map)tupleDomain.getDomains().get()).keySet().iterator().next();
        Assert.assertEquals((int)descriptor.getPath().length, (int)1);
        Assert.assertEquals((String)descriptor.getPath()[0], (String)"my_primitive");
        Domain predicateDomain = (Domain)Iterables.getOnlyElement(((Map)tupleDomain.getDomains().get()).values());
        Assert.assertEquals((Object)predicateDomain, (Object)singleValueDomain);
    }

    @Test
    public void testParquetTupleDomainStruct() {
        HiveColumnHandle columnHandle = new HiveColumnHandle("my_struct", HiveType.valueOf((String)"struct<a:int,b:int>"), TypeSignature.parseTypeSignature((String)"row"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
        RowType.Field rowField = new RowType.Field(Optional.of("my_struct"), (com.facebook.presto.common.type.Type)IntegerType.INTEGER);
        RowType rowType = RowType.from((List)ImmutableList.of((Object)rowField));
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((com.facebook.presto.common.type.Type)rowType)));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_struct", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b")})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain);
        Assert.assertTrue((boolean)((Map)tupleDomain.getDomains().get()).isEmpty());
    }

    @Test
    public void testParquetTupleDomainMap() {
        HiveColumnHandle columnHandle = new HiveColumnHandle("my_map", HiveType.valueOf((String)"map<int,int>"), TypeSignature.parseTypeSignature((String)"map"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
        MapType mapType = new MapType((com.facebook.presto.common.type.Type)IntegerType.INTEGER, (com.facebook.presto.common.type.Type)IntegerType.INTEGER, MethodHandleUtil.methodHandle(TestParquetPredicateUtils.class, (String)"throwUnsupportedOperationException", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestParquetPredicateUtils.class, (String)"throwUnsupportedOperationException", (Class[])new Class[0]));
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((com.facebook.presto.common.type.Type)mapType)));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_map", new Type[]{new GroupType(Type.Repetition.REPEATED, "map", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "key"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "value")})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain);
        Assert.assertTrue((boolean)((Map)tupleDomain.getDomains().get()).isEmpty());
    }

    public static void throwUnsupportedOperationException() {
        throw new UnsupportedOperationException();
    }
}

