/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3select;

import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.s3select.S3SelectPushdown;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestS3SelectPushdown {
    private static final String S3_SELECT_PUSHDOWN_ENABLED = "s3_select_pushdown_enabled";
    private TextInputFormat inputFormat;
    private ConnectorSession session;
    private Table table;
    private Partition partition;
    private Storage storage;
    private Column column;
    private Properties schema;

    @BeforeClass
    public void setUp() {
        this.inputFormat = new TextInputFormat();
        this.inputFormat.configure(new JobConf());
        this.session = this.initTestingConnectorSession(true);
        this.column = new Column("column", HiveType.HIVE_BOOLEAN, Optional.empty(), Optional.empty());
        this.storage = Storage.builder().setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.TEXTFILE)).setLocation("location").build();
        this.partition = new Partition("db", "table", Collections.emptyList(), this.storage, Collections.singletonList(this.column), Collections.emptyMap(), Optional.empty(), false, false, 1234, 4567L);
        this.table = new Table("db", "table", "owner", PrestoTableType.EXTERNAL_TABLE, this.storage, Collections.singletonList(this.column), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), Optional.empty());
        this.schema = new Properties();
        this.schema.setProperty("serialization.lib", LazySimpleSerDe.class.getName());
    }

    @Test
    public void testIsCompressionCodecSupported() {
        Assert.assertTrue((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.gz")));
        Assert.assertTrue((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject")));
        Assert.assertFalse((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.lz4")));
        Assert.assertFalse((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.snappy")));
        Assert.assertTrue((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.bz2")));
    }

    @Test
    public void testShouldEnableSelectPushdown() {
        Assert.assertTrue((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)this.table, (String)"s3://fakeBucket/fakeObject", Optional.empty()));
        Assert.assertTrue((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)this.table, (String)"s3://fakeBucket/fakeObject", Optional.of(this.partition)));
    }

    @Test
    public void testShouldNotEnableSelectPushdownWhenDisabledOnSession() {
        TestingConnectorSession testSession = this.initTestingConnectorSession(false);
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)testSession, (Table)this.table, (String)"", Optional.empty()));
    }

    @Test
    public void testShouldNotEnableSelectPushdownWhenIsNotS3StoragePath() {
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)this.table, null, Optional.empty()));
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)this.table, (String)"", Optional.empty()));
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)this.table, (String)"s3:/invalid", Optional.empty()));
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)this.table, (String)"s3:/invalid", Optional.of(this.partition)));
    }

    @Test
    public void testShouldNotEnableSelectPushdownWhenIsNotSupportedSerde() {
        Storage newStorage = Storage.builder().setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC)).setLocation("location").build();
        Table newTable = new Table("db", "table", "owner", PrestoTableType.EXTERNAL_TABLE, newStorage, Collections.singletonList(this.column), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), Optional.empty());
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.empty()));
        Partition newPartition = new Partition("db", "table", Collections.emptyList(), newStorage, Collections.singletonList(this.column), Collections.emptyMap(), Optional.empty(), false, false, 1234, 4567L);
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.of(newPartition)));
    }

    @Test
    public void testShouldNotEnableSelectPushdownWhenInputFormatIsNotSupported() {
        Storage newStorage = Storage.builder().setStorageFormat(StorageFormat.create((String)LazySimpleSerDe.class.getName(), (String)"inputFormat", (String)"outputFormat")).setLocation("location").build();
        Table newTable = new Table("db", "table", "owner", PrestoTableType.EXTERNAL_TABLE, newStorage, Collections.singletonList(this.column), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), Optional.empty());
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.empty()));
    }

    @Test
    public void testShouldNotEnableSelectPushdownWhenColumnTypesAreNotSupported() {
        Column newColumn = new Column("column", HiveType.HIVE_BINARY, Optional.empty(), Optional.empty());
        Table newTable = new Table("db", "table", "owner", PrestoTableType.EXTERNAL_TABLE, this.storage, Collections.singletonList(newColumn), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), Optional.empty());
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.empty()));
        Partition newPartition = new Partition("db", "table", Collections.emptyList(), this.storage, Collections.singletonList(this.column), Collections.emptyMap(), Optional.empty(), false, false, 1234, 4567L);
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.of(newPartition)));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.inputFormat = null;
        this.session = null;
        this.table = null;
        this.partition = null;
        this.storage = null;
        this.column = null;
        this.schema = null;
    }

    private TestingConnectorSession initTestingConnectorSession(boolean enableSelectPushdown) {
        return new TestingConnectorSession(Collections.singletonList(PropertyMetadata.booleanProperty((String)S3_SELECT_PUSHDOWN_ENABLED, (String)"S3 Select pushdown enabled", (Boolean)true, (boolean)false)), (Map)ImmutableMap.of((Object)S3_SELECT_PUSHDOWN_ENABLED, (Object)enableSelectPushdown));
    }
}

