/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3select;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.SortedRangeSet;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.TestBackgroundHiveSplitLoader;
import com.facebook.presto.hive.s3.PrestoS3ClientFactory;
import com.facebook.presto.hive.s3select.S3SelectRecordCursorProvider;
import com.facebook.presto.hive.s3select.TestS3SelectRecordCursor;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestS3SelectRecordCursorProvider {
    @Test
    public void shouldReturnSelectRecordCursor() {
        ArrayList<HiveColumnHandle> columns = new ArrayList<HiveColumnHandle>();
        TupleDomain effectivePredicate = TupleDomain.all();
        Optional<RecordCursor> recordCursor = TestS3SelectRecordCursorProvider.getRecordCursor((TupleDomain<HiveColumnHandle>)effectivePredicate, columns, true);
        Assert.assertTrue((boolean)recordCursor.isPresent());
    }

    @Test
    public void shouldReturnSelectRecordCursorWhenEffectivePredicateExists() {
        TupleDomain effectivePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)TestS3SelectRecordCursor.QUANTITY_COLUMN, (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)3L))), (boolean)false)));
        Optional<RecordCursor> recordCursor = TestS3SelectRecordCursorProvider.getRecordCursor((TupleDomain<HiveColumnHandle>)effectivePredicate, TestS3SelectRecordCursorProvider.getAllColumns(), true);
        Assert.assertTrue((boolean)recordCursor.isPresent());
    }

    @Test
    public void shouldReturnSelectRecordCursorWhenProjectionExists() {
        TupleDomain effectivePredicate = TupleDomain.all();
        ImmutableList columns = ImmutableList.of((Object)TestS3SelectRecordCursor.QUANTITY_COLUMN, (Object)TestS3SelectRecordCursor.AUTHOR_COLUMN, (Object)TestS3SelectRecordCursor.ARTICLE_COLUMN);
        Optional<RecordCursor> recordCursor = TestS3SelectRecordCursorProvider.getRecordCursor((TupleDomain<HiveColumnHandle>)effectivePredicate, (List<HiveColumnHandle>)columns, true);
        Assert.assertTrue((boolean)recordCursor.isPresent());
    }

    @Test
    public void shouldNotReturnSelectRecordCursorWhenPushdownIsDisabled() {
        ArrayList<HiveColumnHandle> columns = new ArrayList<HiveColumnHandle>();
        TupleDomain effectivePredicate = TupleDomain.all();
        Optional<RecordCursor> recordCursor = TestS3SelectRecordCursorProvider.getRecordCursor((TupleDomain<HiveColumnHandle>)effectivePredicate, columns, false);
        Assert.assertFalse((boolean)recordCursor.isPresent());
    }

    @Test
    public void shouldNotReturnSelectRecordCursorWhenQueryIsNotFiltering() {
        TupleDomain effectivePredicate = TupleDomain.all();
        Optional<RecordCursor> recordCursor = TestS3SelectRecordCursorProvider.getRecordCursor((TupleDomain<HiveColumnHandle>)effectivePredicate, TestS3SelectRecordCursorProvider.getAllColumns(), true);
        Assert.assertFalse((boolean)recordCursor.isPresent());
    }

    @Test
    public void shouldNotReturnSelectRecordCursorWhenProjectionOrderIsDifferent() {
        TupleDomain effectivePredicate = TupleDomain.all();
        ImmutableList columns = ImmutableList.of((Object)TestS3SelectRecordCursor.DATE_ARTICLE_COLUMN, (Object)TestS3SelectRecordCursor.QUANTITY_COLUMN, (Object)TestS3SelectRecordCursor.ARTICLE_COLUMN, (Object)TestS3SelectRecordCursor.AUTHOR_COLUMN);
        Optional<RecordCursor> recordCursor = TestS3SelectRecordCursorProvider.getRecordCursor((TupleDomain<HiveColumnHandle>)effectivePredicate, (List<HiveColumnHandle>)columns, true);
        Assert.assertFalse((boolean)recordCursor.isPresent());
    }

    private static Optional<RecordCursor> getRecordCursor(TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> columns, boolean s3SelectPushdownEnabled) {
        S3SelectRecordCursorProvider s3SelectRecordCursorProvider = new S3SelectRecordCursorProvider((HdfsEnvironment)new TestBackgroundHiveSplitLoader.TestingHdfsEnvironment(new ArrayList<LocatedFileStatus>()), new HiveClientConfig(), new PrestoS3ClientFactory());
        HiveFileSplit fileSplit = new HiveFileSplit("s3://fakeBucket/fakeObject.gz", 0L, 100L, 100L, 0L, Optional.empty(), (Map)ImmutableMap.of());
        return s3SelectRecordCursorProvider.createRecordCursor(new Configuration(), HiveTestUtils.SESSION, fileSplit, TestS3SelectRecordCursorProvider.createTestingSchema(), columns, effectivePredicate, DateTimeZone.forID((String)HiveTestUtils.SESSION.getSqlFunctionProperties().getTimeZoneKey().getId()), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, s3SelectPushdownEnabled);
    }

    private static Properties createTestingSchema() {
        List<HiveColumnHandle> schemaColumns = TestS3SelectRecordCursorProvider.getAllColumns();
        Properties schema = new Properties();
        String columnNames = TestS3SelectRecordCursorProvider.buildPropertyFromColumns(schemaColumns, HiveColumnHandle::getName);
        String columnTypeNames = TestS3SelectRecordCursorProvider.buildPropertyFromColumns(schemaColumns, column -> column.getHiveType().getTypeInfo().getTypeName());
        schema.setProperty("columns", columnNames);
        schema.setProperty("columns.types", columnTypeNames);
        String deserializerClassName = LazySimpleSerDe.class.getName();
        schema.setProperty("serialization.lib", deserializerClassName);
        return schema;
    }

    private static String buildPropertyFromColumns(List<HiveColumnHandle> columns, Function<HiveColumnHandle, String> mapper) {
        if (columns.isEmpty()) {
            return "";
        }
        return columns.stream().map(mapper).collect(Collectors.joining(","));
    }

    private static List<HiveColumnHandle> getAllColumns() {
        return ImmutableList.of((Object)TestS3SelectRecordCursor.ARTICLE_COLUMN, (Object)TestS3SelectRecordCursor.AUTHOR_COLUMN, (Object)TestS3SelectRecordCursor.DATE_ARTICLE_COLUMN, (Object)TestS3SelectRecordCursor.QUANTITY_COLUMN);
    }
}

