/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security.ranger;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.testing.TestingHttpClient;
import com.facebook.airlift.http.client.testing.TestingResponse;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.hive.security.ranger.RangerBasedAccessControl;
import com.facebook.presto.hive.security.ranger.RangerBasedAccessControlConfig;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.spi.security.Privilege;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRangerBasedAccessControl {
    public static final ConnectorTransactionHandle TRANSACTION_HANDLE = new ConnectorTransactionHandle(){};
    public static final AccessControlContext CONTEXT = new AccessControlContext(new QueryId("query_id"), Optional.empty(), Optional.empty());

    @Test
    public void testTablePriviledgesRolesNotAllowed() {
        ConnectorAccessControl accessControl = this.createRangerAccessControl("default-allow-all.json", "user_groups.json");
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanRevokeTablePrivilege(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("anyuser"), CONTEXT, Privilege.SELECT, new SchemaTableName("foodmart", "test"), new PrestoPrincipal(PrincipalType.ROLE, "role"), true));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanGrantTablePrivilege(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("anyuser"), CONTEXT, Privilege.SELECT, new SchemaTableName("foodmart", "test"), new PrestoPrincipal(PrincipalType.ROLE, "role"), true));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanCreateRole(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("anyuser"), CONTEXT, "schemaName", Optional.empty()));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanDropRole(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("anyuser"), CONTEXT, "schemaName"));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanGrantRoles(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("anyuser"), CONTEXT, (Set)ImmutableSet.of((Object)""), (Set)ImmutableSet.of((Object)new PrestoPrincipal(PrincipalType.ROLE, "role")), true, Optional.empty(), ""));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanSetRole(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("anyuser"), CONTEXT, "schemaName", ""));
    }

    @Test
    public void testDefaultAccessAllowedNotChecked() {
        ConnectorAccessControl accessControl = this.createRangerAccessControl("default-allow-all.json", "user_groups.json");
        accessControl.checkCanShowTablesMetadata(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("anyuser"), CONTEXT, "schemaName");
        accessControl.checkCanSetCatalogSessionProperty(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("anyuser"), CONTEXT, "schemaName");
        accessControl.checkCanCreateSchema(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("anyuser"), CONTEXT, "schemaName");
        accessControl.checkCanShowSchemas(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("anyuser"), CONTEXT);
    }

    @Test
    public void testDefaultTableAccessIfNotDefined() {
        ConnectorAccessControl accessControl = this.createRangerAccessControl("default-allow-all.json", "user_groups.json");
        accessControl.checkCanCreateTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("admin"), CONTEXT, new SchemaTableName("test", "test"));
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("alice"), CONTEXT, new SchemaTableName("test", "test"), (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("bobschema", "bobtable"), (Set)ImmutableSet.of());
        accessControl.checkCanRenameTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("admin"), CONTEXT, new SchemaTableName("test", "test"), new SchemaTableName("test1", "test1"));
        accessControl.checkCanInsertIntoTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("bobschema", "bobtable"));
        accessControl.checkCanDeleteFromTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("bobschema", "bobtable"));
        accessControl.checkCanCreateViewWithSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("bobschema", "bobtable"), (Set)ImmutableSet.of());
    }

    @Test
    public void testTableOperations() {
        ConnectorAccessControl accessControl = this.createRangerAccessControl("default-schema-level-access.json", "user_groups.json");
        accessControl.checkCanCreateTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("alice"), CONTEXT, new SchemaTableName("foodmart", "test"));
        accessControl.checkCanRenameTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("alice"), CONTEXT, new SchemaTableName("foodmart", "test"), new SchemaTableName("foodmart", "test1"));
        accessControl.checkCanDropTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("alice"), CONTEXT, new SchemaTableName("foodmart", "test"));
        accessControl.checkCanDropSchema(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("alice"), CONTEXT, "foodmart");
        accessControl.checkCanAddColumn(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("alice"), CONTEXT, new SchemaTableName("foodmart", "test"));
        accessControl.checkCanDropColumn(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("alice"), CONTEXT, new SchemaTableName("foodmart", "test"));
        accessControl.checkCanRenameColumn(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("alice"), CONTEXT, new SchemaTableName("foodmart", "test"));
        accessControl.checkCanCreateTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("joe"), CONTEXT, new SchemaTableName("foodmart", "test"));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanRenameTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("joe"), CONTEXT, new SchemaTableName("foodmart", "test"), new SchemaTableName("foodmart", "test1")));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanDropTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("joe"), CONTEXT, new SchemaTableName("foodmart", "test")));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanDropSchema(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("joe"), CONTEXT, "foodmart"));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanAddColumn(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("joe"), CONTEXT, new SchemaTableName("foodmart", "test")));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanDropColumn(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("joe"), CONTEXT, new SchemaTableName("foodmart", "test")));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanRenameColumn(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("joe"), CONTEXT, new SchemaTableName("foodmart", "test")));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("foodmart", "test"), (Set)ImmutableSet.of((Object)new Subfield("column1"))));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanCreateTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("foodmart", "test")));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanRenameTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("foodmart", "test"), new SchemaTableName("foodmart", "test1")));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanDropTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("foodmart", "test")));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanAddColumn(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("foodmart", "test")));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanDropColumn(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("foodmart", "test")));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanRenameColumn(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("foodmart", "test")));
    }

    @Test
    public void testSelectUpdateAccess() {
        ConnectorAccessControl accessControl = this.createRangerAccessControl("default-table-select-update.json", "user_groups.json");
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("alice"), CONTEXT, new SchemaTableName("foodmart", "test"), (Set)ImmutableSet.of((Object)new Subfield("column1")));
        accessControl.checkCanInsertIntoTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("alice"), CONTEXT, new SchemaTableName("foodmart", "test"));
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("joe"), CONTEXT, new SchemaTableName("foodmart", "test"), (Set)ImmutableSet.of((Object)new Subfield("column1")));
        accessControl.checkCanInsertIntoTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("joe"), CONTEXT, new SchemaTableName("foodmart", "test"));
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("foodmart", "test"), (Set)ImmutableSet.of((Object)new Subfield("column1")));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanInsertIntoTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("foodmart", "test")));
    }

    @Test
    public void testColumnLevelAccess() {
        ConnectorAccessControl accessControl = this.createRangerAccessControl("default-table-column-access.json", "user_groups.json");
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("joe"), CONTEXT, new SchemaTableName("foodmart", "salary"), (Set)ImmutableSet.of((Object)new Subfield("salary_paid"), (Object)new Subfield("overtime_paid")));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("bob"), CONTEXT, new SchemaTableName("foodmart", "salary"), (Set)ImmutableSet.of((Object)new Subfield("currency_id"), (Object)new Subfield("overtime_paid"))));
    }

    @Test
    public void testRoleBasedAccess() {
        ConnectorAccessControl accessControl = this.createRangerAccessControl("ranger-role-based-access.json", "user_groups.json");
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("raj"), CONTEXT, new SchemaTableName("default", "customer"), (Set)ImmutableSet.of((Object)new Subfield("column1")));
        accessControl.checkCanInsertIntoTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("raj"), CONTEXT, new SchemaTableName("default", "customer"));
        accessControl.checkCanDropTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("raj"), CONTEXT, new SchemaTableName("default", "customer"));
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("maria"), CONTEXT, new SchemaTableName("default", "orders"), (Set)ImmutableSet.of((Object)new Subfield("column1")));
        accessControl.checkCanInsertIntoTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("maria"), CONTEXT, new SchemaTableName("default", "orders"));
        accessControl.checkCanDropTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("maria"), CONTEXT, new SchemaTableName("default", "orders"));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("maria"), CONTEXT, new SchemaTableName("default", "customer"), (Set)ImmutableSet.of((Object)new Subfield("column1"))));
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("sam"), CONTEXT, new SchemaTableName("default", "lineitem"), (Set)ImmutableSet.of((Object)new Subfield("column1")));
        accessControl.checkCanInsertIntoTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("sam"), CONTEXT, new SchemaTableName("default", "lineitem"));
        accessControl.checkCanDropTable(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("sam"), CONTEXT, new SchemaTableName("default", "lineitem"));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("sam"), CONTEXT, new SchemaTableName("default", "customer"), (Set)ImmutableSet.of((Object)new Subfield("column1"))));
        TestRangerBasedAccessControl.assertDenied(() -> accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestRangerBasedAccessControl.user("sam"), CONTEXT, new SchemaTableName("default", "supplier"), (Set)ImmutableSet.of((Object)new Subfield("column1"))));
    }

    private static ConnectorIdentity user(String name) {
        return new ConnectorIdentity(name, Optional.empty(), Optional.empty());
    }

    private ConnectorAccessControl createRangerAccessControl(String policyFile, String usersFile) {
        String policyFilePath = "com.facebook.presto.hive.security.ranger/" + policyFile;
        String usersFilePath = "com.facebook.presto.hive.security.ranger/" + usersFile;
        TestingHttpClient httpClient = new TestingHttpClient(httpRequest -> {
            String uriPath = httpRequest.getUri().getPath();
            if (uriPath.contains("/service/plugins/policies/download")) {
                return this.makeHttpResponse(ByteStreams.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream(policyFilePath)));
            }
            if (uriPath.contains("/service/xusers/users")) {
                return this.makeHttpResponse(ByteStreams.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream(usersFilePath)));
            }
            if (uriPath.contains("/service/roles/roles/user")) {
                if (uriPath.contains("raj")) {
                    return this.makeHttpResponse("[\"admin_role\"]".getBytes(StandardCharsets.UTF_8));
                }
                if (uriPath.contains("maria")) {
                    return this.makeHttpResponse("[\"etl_role\"]".getBytes(StandardCharsets.UTF_8));
                }
                if (uriPath.contains("sam")) {
                    return this.makeHttpResponse("[\"analyst_role\"]".getBytes(StandardCharsets.UTF_8));
                }
                return this.makeHttpResponse("[\"dev_role\"]".getBytes(StandardCharsets.UTF_8));
            }
            throw new IllegalStateException("Testing client is not configured correctly");
        });
        RangerBasedAccessControlConfig config = new RangerBasedAccessControlConfig().setRangerHttpEndPoint("http://test").setRangerHiveServiceName("dummy");
        RangerBasedAccessControl rangerBasedAccessControl = new RangerBasedAccessControl(config, (HttpClient)httpClient);
        return rangerBasedAccessControl;
    }

    private TestingResponse makeHttpResponse(byte[] answerJson) {
        ImmutableListMultimap.Builder headers = ImmutableListMultimap.builder();
        headers.put((Object)"Content-Type", (Object)"application/json");
        return new TestingResponse(HttpStatus.OK, (ListMultimap)headers.build(), answerJson);
    }

    private static <T> T jsonParse(File file, Class<T> clazz) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T)mapper.readValue((Reader)bufferedReader, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON file '%s'", file.getPath()), e);
        }
    }

    private static void assertDenied(Assert.ThrowingRunnable runnable) {
        Assert.assertThrows(AccessDeniedException.class, (Assert.ThrowingRunnable)runnable);
    }
}

