/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ColumnEncryptionInformation;
import com.facebook.presto.hive.EncryptionMetadata;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DwrfEncryptionMetadata
implements EncryptionMetadata {
    public static final String TABLE_IDENTIFIER = "__TABLE__";
    private final Map<String, byte[]> fieldToKeyData;
    private final Map<String, String> extraMetadata;
    private final String encryptionAlgorithm;
    private final String encryptionProvider;

    @JsonCreator
    public DwrfEncryptionMetadata(@JsonProperty Map<String, byte[]> fieldToKeyData, @JsonProperty Map<String, String> extraMetadata, @JsonProperty String encryptionAlgorithm, @JsonProperty String encryptionProvider) {
        this.fieldToKeyData = ImmutableMap.copyOf(Objects.requireNonNull(fieldToKeyData, "fieldToKeyData is null"));
        this.extraMetadata = ImmutableMap.copyOf(Objects.requireNonNull(extraMetadata, "extraMetadata is null"));
        this.encryptionAlgorithm = Objects.requireNonNull(encryptionAlgorithm, "encryptionAlgorithm is null");
        this.encryptionProvider = Objects.requireNonNull(encryptionProvider, "encryptionProvider is null");
        if (this.fieldToKeyData.containsKey(TABLE_IDENTIFIER) && this.fieldToKeyData.size() != 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Cannot have both table and column level settings. Given: %s", fieldToKeyData.keySet().toString()));
        }
    }

    @JsonProperty
    public Map<String, byte[]> getFieldToKeyData() {
        return this.fieldToKeyData;
    }

    @JsonProperty
    public Map<String, String> getExtraMetadata() {
        return this.extraMetadata;
    }

    @JsonProperty
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @JsonProperty
    public String getEncryptionProvider() {
        return this.encryptionProvider;
    }

    public static DwrfEncryptionMetadata forTable(byte[] keyData, Map<String, String> extraMetadata, String encryptionAlgorithm, String encryptionProvider) {
        return new DwrfEncryptionMetadata((Map<String, byte[]>)ImmutableMap.of((Object)TABLE_IDENTIFIER, (Object)keyData), extraMetadata, encryptionAlgorithm, encryptionProvider);
    }

    public static DwrfEncryptionMetadata forPerField(Map<String, byte[]> fieldToKeyData, Map<String, String> extraMetadata, String encryptionAlgorithm, String encryptionProvider) {
        return new DwrfEncryptionMetadata(fieldToKeyData, extraMetadata, encryptionAlgorithm, encryptionProvider);
    }

    public int hashCode() {
        return Objects.hash(this.fieldToKeyData, this.extraMetadata, this.encryptionAlgorithm, this.encryptionProvider);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        DwrfEncryptionMetadata otherObj = (DwrfEncryptionMetadata)obj;
        return DwrfEncryptionMetadata.compareFieldMap(this.fieldToKeyData, otherObj.fieldToKeyData) && Objects.equals(this.extraMetadata, otherObj.extraMetadata) && Objects.equals(this.encryptionAlgorithm, otherObj.encryptionAlgorithm) && Objects.equals(this.encryptionProvider, otherObj.encryptionProvider);
    }

    private static boolean compareFieldMap(Map<String, byte[]> obj1, Map<String, byte[]> obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1.size() != obj2.size()) {
            return false;
        }
        return obj1.entrySet().stream().allMatch(entry -> Arrays.equals((byte[])entry.getValue(), (byte[])obj2.get(entry.getKey())));
    }

    public Map<Integer, Slice> toKeyMap(List<OrcType> types, List<HiveColumnHandle> physicalColumnHandles) {
        Map columnIndexMap = (Map)physicalColumnHandles.stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, HiveColumnHandle::getHiveColumnIndex));
        return this.toKeyMap(types, columnIndexMap);
    }

    public Map<Integer, Slice> toKeyMap(List<OrcType> types, Map<String, Integer> columnNamesToHiveIndex) {
        if (this.fieldToKeyData.containsKey(TABLE_IDENTIFIER)) {
            return ImmutableMap.of((Object)0, (Object)Slices.wrappedBuffer((byte[])this.fieldToKeyData.get(TABLE_IDENTIFIER)));
        }
        return (Map)this.fieldToKeyData.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> DwrfEncryptionMetadata.toOrcColumnIndex((String)entry.getKey(), types, columnNamesToHiveIndex), entry -> Slices.wrappedBuffer((byte[])((byte[])entry.getValue()))));
    }

    private static int toOrcColumnIndex(String fieldString, List<OrcType> types, Map<String, Integer> columnNamesToHiveIndex) {
        ColumnEncryptionInformation.ColumnWithStructSubfield columnWithStructSubfield = ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)fieldString);
        if (!columnNamesToHiveIndex.containsKey(columnWithStructSubfield.getColumnName())) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_ENCRYPTION_METADATA, String.format("no column found for encryption field %s", columnWithStructSubfield.getColumnName()));
        }
        int columnRoot = columnNamesToHiveIndex.get(columnWithStructSubfield.getColumnName());
        return DwrfEncryptionMetadata.getOrcColumnIndexRecursive(types, types.get(0).getFieldTypeIndex(columnRoot), columnWithStructSubfield.getChildField());
    }

    private static int getOrcColumnIndexRecursive(List<OrcType> types, int typeId, Optional<ColumnEncryptionInformation.ColumnWithStructSubfield> subfield) {
        OrcType type = types.get(typeId);
        int columnId = typeId;
        if (subfield.isPresent()) {
            Verify.verify((type.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT ? 1 : 0) != 0, (String)"subfield references are only permitted for struct types, but found %s for column %s", subfield, (int)columnId);
            String name = subfield.get().getColumnName().toLowerCase(Locale.ENGLISH);
            Optional nextSubfield = subfield.get().getChildField();
            int children = type.getFieldCount();
            for (int i = 0; i < children; ++i) {
                String fieldName = ((String)type.getFieldNames().get(i)).toLowerCase(Locale.ENGLISH);
                if (!name.equals(fieldName)) continue;
                columnId = DwrfEncryptionMetadata.getOrcColumnIndexRecursive(types, type.getFieldTypeIndex(i), nextSubfield);
            }
            if (columnId == typeId) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_ENCRYPTION_METADATA, "subfield not found");
            }
        }
        return columnId;
    }
}

