/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.hive.HiveMetadataUpdateHandle;
import com.facebook.presto.spi.ConnectorMetadataUpdateHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorMetadataUpdater;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;

public class HiveMetadataUpdater
implements ConnectorMetadataUpdater {
    private final Executor boundedExecutor;
    private final Map<Integer, UUID> writerRequestMap = new ConcurrentHashMap<Integer, UUID>();
    private final Map<UUID, SettableFuture<String>> requestFutureMap = new ConcurrentHashMap<UUID, SettableFuture<String>>();
    private final Queue<HiveMetadataUpdateHandle> hiveMetadataRequestQueue = new ConcurrentLinkedQueue<HiveMetadataUpdateHandle>();

    HiveMetadataUpdater(Executor boundedExecutor) {
        this.boundedExecutor = Objects.requireNonNull(boundedExecutor, "boundedExecutor is null");
    }

    public List<ConnectorMetadataUpdateHandle> getPendingMetadataUpdateRequests() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (HiveMetadataUpdateHandle request : this.hiveMetadataRequestQueue) {
            result.add((Object)request);
        }
        return result.build();
    }

    public void setMetadataUpdateResults(List<ConnectorMetadataUpdateHandle> results) {
        this.boundedExecutor.execute(() -> this.updateResultAsync(results));
    }

    private void updateResultAsync(List<ConnectorMetadataUpdateHandle> results) {
        for (ConnectorMetadataUpdateHandle connectorMetadataUpdateHandle : results) {
            Optional<String> fileName;
            HiveMetadataUpdateHandle updateResult = (HiveMetadataUpdateHandle)connectorMetadataUpdateHandle;
            UUID requestId = updateResult.getRequestId();
            if (!this.requestFutureMap.containsKey(requestId) || !(fileName = updateResult.getMetadataUpdate()).isPresent()) continue;
            this.hiveMetadataRequestQueue.removeIf(metadataUpdateRequest -> metadataUpdateRequest.getRequestId().equals(requestId));
            this.requestFutureMap.get(requestId).set((Object)fileName.get());
        }
    }

    public void addMetadataUpdateRequest(String schemaName, String tableName, Optional<String> partitionName, int writerIndex) {
        UUID requestId = UUID.randomUUID();
        this.requestFutureMap.put(requestId, (SettableFuture<String>)SettableFuture.create());
        this.writerRequestMap.put(writerIndex, requestId);
        this.hiveMetadataRequestQueue.add(new HiveMetadataUpdateHandle(requestId, new SchemaTableName(schemaName, tableName), partitionName, Optional.empty()));
    }

    public void removeResultFuture(int writerIndex) {
        UUID requestId = this.writerRequestMap.get(writerIndex);
        this.requestFutureMap.remove(requestId);
        this.writerRequestMap.remove(writerIndex);
    }

    public CompletableFuture<String> getMetadataResult(int writerIndex) {
        UUID requestId = this.writerRequestMap.get(writerIndex);
        return MoreFutures.toCompletableFuture((ListenableFuture)((ListenableFuture)this.requestFutureMap.get(requestId)));
    }
}

