/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3select;

import com.amazonaws.services.s3.model.CSVInput;
import com.amazonaws.services.s3.model.CSVOutput;
import com.amazonaws.services.s3.model.InputSerialization;
import com.amazonaws.services.s3.model.OutputSerialization;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.s3.PrestoS3ClientFactory;
import com.facebook.presto.hive.s3select.S3SelectLineRecordReader;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class S3SelectCsvRecordReader
extends S3SelectLineRecordReader {
    private static final String COMMENTS_CHAR_STR = "\ufdd0";

    S3SelectCsvRecordReader(Configuration configuration, HiveClientConfig clientConfig, Path path, long start, long length, Properties schema, String ionSqlQuery, PrestoS3ClientFactory s3ClientFactory) {
        super(configuration, clientConfig, path, start, length, schema, ionSqlQuery, s3ClientFactory);
    }

    @Override
    public InputSerialization buildInputSerialization() {
        Properties schema = this.getSchema();
        String fieldDelimiter = this.getFieldDelimiter(schema);
        String quoteChar = schema.getProperty("quote.delim", null);
        String escapeChar = schema.getProperty("escape.delim", null);
        CSVInput selectObjectCSVInputSerialization = new CSVInput();
        selectObjectCSVInputSerialization.setRecordDelimiter(this.lineDelimiter);
        selectObjectCSVInputSerialization.setFieldDelimiter(fieldDelimiter);
        selectObjectCSVInputSerialization.setComments(COMMENTS_CHAR_STR);
        selectObjectCSVInputSerialization.setQuoteCharacter(quoteChar);
        selectObjectCSVInputSerialization.setQuoteEscapeCharacter(escapeChar);
        InputSerialization selectObjectInputSerialization = new InputSerialization();
        selectObjectInputSerialization.setCompressionType(this.getCompressionType());
        selectObjectInputSerialization.setCsv(selectObjectCSVInputSerialization);
        return selectObjectInputSerialization;
    }

    @Override
    public OutputSerialization buildOutputSerialization() {
        Properties schema = this.getSchema();
        String fieldDelimiter = this.getFieldDelimiter(schema);
        String quoteChar = schema.getProperty("quote.delim", null);
        String escapeChar = schema.getProperty("escape.delim", null);
        OutputSerialization selectObjectOutputSerialization = new OutputSerialization();
        CSVOutput selectObjectCSVOutputSerialization = new CSVOutput();
        selectObjectCSVOutputSerialization.setRecordDelimiter(this.lineDelimiter);
        selectObjectCSVOutputSerialization.setFieldDelimiter(fieldDelimiter);
        selectObjectCSVOutputSerialization.setQuoteCharacter(quoteChar);
        selectObjectCSVOutputSerialization.setQuoteEscapeCharacter(escapeChar);
        selectObjectOutputSerialization.setCsv(selectObjectCSVOutputSerialization);
        return selectObjectOutputSerialization;
    }
}

