/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.hive.AbstractTestHiveClient;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.security.PrincipalType;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractTestHiveClientLocal
extends AbstractTestHiveClient {
    private static final String DEFAULT_TEST_DB_NAME = "test";
    private File tempDir;
    private String testDbName;

    protected AbstractTestHiveClientLocal() {
        this(DEFAULT_TEST_DB_NAME);
    }

    protected AbstractTestHiveClientLocal(String testDbName) {
        this.testDbName = Objects.requireNonNull(testDbName, "testDbName is null");
    }

    protected abstract ExtendedHiveMetastore createMetastore(File var1);

    @BeforeClass
    public void initialize() {
        this.tempDir = Files.createTempDir();
        ExtendedHiveMetastore metastore = this.createMetastore(this.tempDir);
        metastore.createDatabase(HiveQueryRunner.METASTORE_CONTEXT, Database.builder().setDatabaseName(this.testDbName).setOwnerName("public").setOwnerType(PrincipalType.ROLE).build());
        HiveClientConfig hiveConfig = new HiveClientConfig().setTimeZone("America/Los_Angeles");
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        this.setup(this.testDbName, hiveConfig, new CacheConfig(), metastoreClientConfig, metastore);
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws IOException {
        try {
            this.getMetastoreClient().dropDatabase(HiveQueryRunner.METASTORE_CONTEXT, this.testDbName);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Override
    protected ConnectorTableHandle getTableHandle(ConnectorMetadata metadata, SchemaTableName tableName) {
        if (tableName.getTableName().startsWith("tmp_presto_test_")) {
            return super.getTableHandle(metadata, tableName);
        }
        throw new SkipException("tests using existing tables are not supported");
    }

    @Override
    public void testGetAllTableNames() {
    }

    @Override
    public void testGetAllTableColumns() {
    }

    @Override
    public void testGetAllTableColumnsInSchema() {
    }

    @Override
    public void testGetTableNames() {
    }

    @Override
    public void testGetTableSchemaOffline() {
    }
}

