/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.event.client.EventClient;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.GroupByHashPageIndexerFactory;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.AbstractTestHiveClient;
import com.facebook.presto.hive.CacheQuotaRequirementProvider;
import com.facebook.presto.hive.CachingDirectoryLister;
import com.facebook.presto.hive.CoercionPolicy;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.ConfigBasedCacheQuotaRequirementProvider;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HadoopDirectoryLister;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCoercionPolicy;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveEncryptionInformationProvider;
import com.facebook.presto.hive.HiveEventClient;
import com.facebook.presto.hive.HiveFileRenamer;
import com.facebook.presto.hive.HiveFileSystemTestUtils;
import com.facebook.presto.hive.HiveLocationService;
import com.facebook.presto.hive.HiveMetadataFactory;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePageSinkProvider;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionObjectBuilder;
import com.facebook.presto.hive.HivePartitionStats;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplitManager;
import com.facebook.presto.hive.HiveStagingFileCommitter;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.HiveWriterStats;
import com.facebook.presto.hive.HiveZeroRowFileCreator;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.PartitionMutator;
import com.facebook.presto.hive.PartitionObjectBuilder;
import com.facebook.presto.hive.StagingFileCommitter;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.ZeroRowFileCreator;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.datasink.DataSinkFactory;
import com.facebook.presto.hive.datasink.OutputStreamDataSinkFactory;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePartitionMutator;
import com.facebook.presto.hive.metastore.MetastoreCacheStats;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreOperationResult;
import com.facebook.presto.hive.metastore.NoopMetastoreCacheStats;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.thrift.BridgingHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.TestingHiveCluster;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastore;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.testing.TestingNodeManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestHiveFileSystem {
    protected static final HdfsContext TESTING_CONTEXT = new HdfsContext(new ConnectorIdentity("test", Optional.empty(), Optional.empty()));
    public static final ConnectorSplitManager.SplitSchedulingContext SPLIT_SCHEDULING_CONTEXT = new ConnectorSplitManager.SplitSchedulingContext(ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING, false, WarningCollector.NOOP);
    protected String database;
    protected SchemaTableName table;
    protected SchemaTableName temporaryCreateTable;
    protected HdfsEnvironment hdfsEnvironment;
    protected LocationService locationService;
    protected TestingHiveMetastore metastoreClient;
    protected HiveMetadataFactory metadataFactory;
    protected HiveTransactionManager transactionManager;
    protected ConnectorSplitManager splitManager;
    protected ConnectorPageSinkProvider pageSinkProvider;
    protected ConnectorPageSourceProvider pageSourceProvider;
    private ExecutorService executor;
    private HiveClientConfig config;
    private CacheConfig cacheConfig;
    private MetastoreClientConfig metastoreClientConfig;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    protected abstract Path getBasePath();

    protected void setup(String host, int port, String databaseName, BiFunction<HiveClientConfig, MetastoreClientConfig, HdfsConfiguration> hdfsConfigurationProvider, boolean s3SelectPushdownEnabled) {
        this.database = databaseName;
        this.table = new SchemaTableName(this.database, "presto_test_external_fs");
        String random = UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
        this.temporaryCreateTable = new SchemaTableName(this.database, "tmp_presto_test_create_" + random);
        this.config = new HiveClientConfig().setS3SelectPushdownEnabled(s3SelectPushdownEnabled);
        this.cacheConfig = new CacheConfig();
        this.metastoreClientConfig = new MetastoreClientConfig();
        String proxy = System.getProperty("hive.metastore.thrift.client.socks-proxy");
        if (proxy != null) {
            this.metastoreClientConfig.setMetastoreSocksProxy(HostAndPort.fromString((String)proxy));
        }
        TestingHiveCluster hiveCluster = new TestingHiveCluster(this.metastoreClientConfig, host, port);
        ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-%s"));
        HivePartitionManager hivePartitionManager = new HivePartitionManager((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, this.config);
        HdfsConfiguration hdfsConfiguration = hdfsConfigurationProvider.apply(this.config, this.metastoreClientConfig);
        this.hdfsEnvironment = new HdfsEnvironment(hdfsConfiguration, this.metastoreClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        HiveColumnConverterProvider columnConverterProvider = HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER;
        this.metastoreClient = new TestingHiveMetastore((ExtendedHiveMetastore)new BridgingHiveMetastore((HiveMetastore)new ThriftHiveMetastore((HiveCluster)hiveCluster, this.metastoreClientConfig, this.hdfsEnvironment), (PartitionMutator)new HivePartitionMutator()), executor, this.metastoreClientConfig, this.getBasePath(), this.hdfsEnvironment);
        this.locationService = new HiveLocationService(this.hdfsEnvironment);
        this.metadataFactory = new HiveMetadataFactory(this.config, this.metastoreClientConfig, (ExtendedHiveMetastore)this.metastoreClient, this.hdfsEnvironment, hivePartitionManager, MoreExecutors.newDirectExecutorService(), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, this.locationService, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.ROW_EXPRESSION_SERVICE, HiveTestUtils.FILTER_STATS_CALCULATOR_SERVICE, new TableParameterCodec(), HiveTestUtils.PARTITION_UPDATE_CODEC, HiveTestUtils.PARTITION_UPDATE_SMILE_CODEC, (TypeTranslator)new HiveTypeTranslator(), (StagingFileCommitter)new HiveStagingFileCommitter(this.hdfsEnvironment, MoreExecutors.listeningDecorator((ExecutorService)executor)), (ZeroRowFileCreator)new HiveZeroRowFileCreator(this.hdfsEnvironment, (DataSinkFactory)new OutputStreamDataSinkFactory(), MoreExecutors.listeningDecorator((ExecutorService)executor)), new NodeVersion("test_version"), (PartitionObjectBuilder)new HivePartitionObjectBuilder(), new HiveEncryptionInformationProvider((List)ImmutableList.of()), new HivePartitionStats(), new HiveFileRenamer(), (ColumnConverterProvider)columnConverterProvider);
        this.transactionManager = new HiveTransactionManager();
        this.splitManager = new HiveSplitManager(this.transactionManager, new NamenodeStats(), this.hdfsEnvironment, (DirectoryLister)new CachingDirectoryLister((DirectoryLister)new HadoopDirectoryLister(), new HiveClientConfig()), (Executor)new BoundedExecutor((Executor)executor, this.config.getMaxSplitIteratorThreads()), (CoercionPolicy)new HiveCoercionPolicy((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER), new CounterStat(), this.config.getMaxOutstandingSplits(), this.config.getMaxOutstandingSplitsSize(), this.config.getMinPartitionBatchSize(), this.config.getMaxPartitionBatchSize(), this.config.getSplitLoaderConcurrency(), this.config.getRecursiveDirWalkerEnabled(), (CacheQuotaRequirementProvider)new ConfigBasedCacheQuotaRequirementProvider(this.cacheConfig), new HiveEncryptionInformationProvider((Set)ImmutableSet.of()));
        this.pageSinkProvider = new HivePageSinkProvider(HiveTestUtils.getDefaultHiveFileWriterFactories(this.config, this.metastoreClientConfig), this.hdfsEnvironment, HiveTestUtils.PAGE_SORTER, (ExtendedHiveMetastore)this.metastoreClient, (PageIndexerFactory)new GroupByHashPageIndexerFactory(new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig())), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, this.config, this.metastoreClientConfig, this.locationService, HiveTestUtils.PARTITION_UPDATE_CODEC, HiveTestUtils.PARTITION_UPDATE_SMILE_CODEC, (NodeManager)new TestingNodeManager("fake-environment"), (EventClient)new HiveEventClient(), new HiveSessionProperties(this.config, new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()), new HiveWriterStats(), HiveTestUtils.getDefaultOrcFileWriterFactory(this.config, this.metastoreClientConfig), (ColumnConverterProvider)columnConverterProvider);
        Set<HiveRecordCursorProvider> recordCursorProviderSet = s3SelectPushdownEnabled ? HiveTestUtils.getDefaultS3HiveRecordCursorProvider(this.config, this.metastoreClientConfig) : HiveTestUtils.getDefaultHiveRecordCursorProvider(this.config, this.metastoreClientConfig);
        this.pageSourceProvider = new HivePageSourceProvider(this.config, this.hdfsEnvironment, recordCursorProviderSet, HiveTestUtils.getDefaultHiveBatchPageSourceFactories(this.config, this.metastoreClientConfig), HiveTestUtils.getDefaultHiveSelectivePageSourceFactories(this.config, this.metastoreClientConfig), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.ROW_EXPRESSION_SERVICE);
    }

    protected ConnectorSession newSession() {
        return new TestingConnectorSession(new HiveSessionProperties(this.config, new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
    }

    protected AbstractTestHiveClient.Transaction newTransaction() {
        return new AbstractTestHiveClient.HiveTransaction(this.transactionManager, this.metadataFactory.get());
    }

    protected MaterializedResult readTable(SchemaTableName tableName) throws IOException {
        return HiveFileSystemTestUtils.readTable(tableName, this.transactionManager, this.config, this.metadataFactory, this.pageSourceProvider, this.splitManager);
    }

    protected MaterializedResult filterTable(SchemaTableName tableName, List<ColumnHandle> projectedColumns) throws IOException {
        return HiveFileSystemTestUtils.filterTable(tableName, projectedColumns, this.transactionManager, this.config, this.metadataFactory, this.pageSourceProvider, this.splitManager);
    }

    @Test
    public void testGetRecords() throws Exception {
        Assertions.assertEqualsIgnoreOrder((Iterable)this.readTable(this.table), (Iterable)MaterializedResult.resultBuilder((ConnectorSession)this.newSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{70000L}).row(new Object[]{8000L}).row(new Object[]{300L}).row(new Object[]{70000L}).row(new Object[]{8000L}).row(new Object[]{300L}).row(new Object[]{70000L}).row(new Object[]{8000L}).row(new Object[]{300L}).row(new Object[]{70000L}).row(new Object[]{8000L}).row(new Object[]{300L}).build());
    }

    @Test
    public void testGetFileStatus() throws Exception {
        Path basePath = this.getBasePath();
        Path tablePath = new Path(basePath, "presto_test_external_fs");
        Path filePath = new Path(tablePath, "test1.csv");
        ExtendedFileSystem fs = this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, basePath);
        Assert.assertTrue((boolean)fs.getFileStatus(basePath).isDirectory());
        Assert.assertTrue((boolean)fs.getFileStatus(tablePath).isDirectory());
        Assert.assertFalse((boolean)fs.getFileStatus(filePath).isDirectory());
        Assert.assertFalse((boolean)fs.exists(new Path(basePath, "foo")));
    }

    @Test
    public void testRename() throws Exception {
        Path basePath = new Path(this.getBasePath(), UUID.randomUUID().toString());
        ExtendedFileSystem fs = this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, basePath);
        Assert.assertFalse((boolean)fs.exists(basePath));
        Path path = new Path(basePath, "foo.txt");
        Assert.assertTrue((boolean)fs.createNewFile(path));
        Assert.assertTrue((boolean)fs.exists(path));
        Path newPath = new Path(basePath, "bar.txt");
        Assert.assertFalse((boolean)fs.exists(newPath));
        Assert.assertTrue((boolean)fs.rename(path, newPath));
        Assert.assertFalse((boolean)fs.exists(path));
        Assert.assertTrue((boolean)fs.exists(newPath));
        Assert.assertFalse((boolean)fs.rename(path, path));
        Assert.assertTrue((boolean)fs.createNewFile(path));
        Assert.assertFalse((boolean)fs.rename(path, newPath));
        Assert.assertFalse((boolean)fs.rename(path, path));
        Assert.assertTrue((boolean)fs.delete(path, false));
        Assert.assertFalse((boolean)fs.exists(path));
        Path source = new Path(basePath, "source");
        Assert.assertTrue((boolean)fs.createNewFile(new Path(source, "test.txt")));
        Path target = new Path(basePath, "target");
        Assert.assertFalse((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.rename(source, target));
        Assert.assertFalse((boolean)fs.exists(source));
        Assert.assertTrue((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.createNewFile(new Path(source, "test.txt")));
        Assert.assertTrue((boolean)fs.rename(source, target));
        Assert.assertFalse((boolean)fs.exists(source));
        target = new Path(target, "source");
        Assert.assertTrue((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.exists(new Path(target, "test.txt")));
        target = new Path(basePath, "target");
        Assert.assertTrue((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.delete(target, true));
        Assert.assertFalse((boolean)fs.exists(target));
        fs.delete(basePath, true);
    }

    @Test
    public void testTableCreation() throws Exception {
        for (HiveStorageFormat storageFormat : this.getSupportedHiveStorageFormats()) {
            this.createTable(HiveQueryRunner.METASTORE_CONTEXT, this.temporaryCreateTable, storageFormat);
            this.dropTable(this.temporaryCreateTable);
        }
    }

    protected List<HiveStorageFormat> getSupportedHiveStorageFormats() {
        return (List)Arrays.stream(HiveStorageFormat.values()).filter(format -> format != HiveStorageFormat.CSV && format != HiveStorageFormat.ALPHA).collect(ImmutableList.toImmutableList());
    }

    private void createTable(MetastoreContext metastoreContext, SchemaTableName tableName, HiveStorageFormat storageFormat) throws Exception {
        ConnectorSession session;
        ConnectorMetadata metadata;
        ImmutableList columns = ImmutableList.builder().add((Object)new ColumnMetadata("id", (Type)BigintType.BIGINT)).build();
        MaterializedResult data = MaterializedResult.resultBuilder((ConnectorSession)this.newSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{3L}).row(new Object[]{2L}).build();
        try (AbstractTestHiveClient.Transaction transaction = this.newTransaction();){
            metadata = transaction.getMetadata();
            session = this.newSession();
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, (List)columns, AbstractTestHiveClient.createTableProperties(storageFormat));
            ConnectorOutputTableHandle outputHandle = metadata.beginCreateTable(session, tableMetadata, Optional.empty());
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, outputHandle, AbstractTestHiveClient.TEST_HIVE_PAGE_SINK_CONTEXT);
            sink.appendPage(data.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishCreateTable(session, outputHandle, fragments, (Collection)ImmutableList.of());
            transaction.commit();
            this.metastoreClient.updateTableLocation(metastoreContext, this.database, tableName.getTableName(), this.locationService.getTableWriteInfo(((HiveOutputTableHandle)outputHandle).getLocationHandle()).getTargetPath().toString());
        }
        transaction = this.newTransaction();
        var7_7 = null;
        try {
            metadata = transaction.getMetadata();
            session = this.newSession();
            ConnectorTableHandle hiveTableHandle = HiveFileSystemTestUtils.getTableHandle(metadata, tableName, session);
            List<ColumnHandle> columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, hiveTableHandle).values());
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, HiveFileSystemTestUtils.getTableHandle(metadata, tableName, session));
            Assert.assertEquals(AbstractTestHiveClient.filterNonHiddenColumnMetadata(tableMetadata.getColumns()), (Collection)columns);
            List tableLayoutResults = metadata.getTableLayouts(session, hiveTableHandle, Constraint.alwaysTrue(), Optional.empty());
            HiveTableLayoutHandle layoutHandle = (HiveTableLayoutHandle)((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle();
            Assert.assertEquals((int)((List)layoutHandle.getPartitions().get()).size(), (int)1);
            ConnectorSplitSource splitSource = this.splitManager.getSplits(transaction.getTransactionHandle(), session, (ConnectorTableLayoutHandle)layoutHandle, SPLIT_SCHEDULING_CONTEXT);
            ConnectorSplit split = (ConnectorSplit)Iterables.getOnlyElement(AbstractTestHiveClient.getAllSplits(splitSource));
            TableHandle tableHandle = new TableHandle(new ConnectorId("hive"), hiveTableHandle, transaction.getTransactionHandle(), Optional.of(layoutHandle));
            try (ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, (ConnectorTableLayoutHandle)tableHandle.getLayout().get(), columnHandles, SplitContext.NON_CACHEABLE);){
                MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes(columnHandles));
                Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)data.getMaterializedRows());
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var7_7 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    private void dropTable(SchemaTableName table) {
        try (AbstractTestHiveClient.Transaction transaction = this.newTransaction();){
            transaction.getMetastore().dropTable(new HdfsContext(this.newSession()), table.getSchemaName(), table.getTableName());
            transaction.commit();
        }
    }

    public static class TestingHiveMetastore
    extends CachingHiveMetastore {
        private final Path basePath;
        private final HdfsEnvironment hdfsEnvironment;

        public TestingHiveMetastore(ExtendedHiveMetastore delegate, ExecutorService executor, MetastoreClientConfig metastoreClientConfig, Path basePath, HdfsEnvironment hdfsEnvironment) {
            super(delegate, executor, (MetastoreCacheStats)NoopMetastoreCacheStats.NOOP_METASTORE_CACHE_STATS, metastoreClientConfig);
            this.basePath = basePath;
            this.hdfsEnvironment = hdfsEnvironment;
        }

        public Optional<Database> getDatabase(MetastoreContext metastoreContext, String databaseName) {
            return super.getDatabase(metastoreContext, databaseName).map(database -> Database.builder((Database)database).setLocation(Optional.of(this.basePath.toString())).build());
        }

        public MetastoreOperationResult createTable(MetastoreContext metastoreContext, Table table, PrincipalPrivileges privileges) {
            Table.Builder tableBuilder = Table.builder((Table)table);
            tableBuilder.getStorageBuilder().setLocation("/");
            super.createTable(metastoreContext, tableBuilder.build(), privileges);
            return MetastoreOperationResult.EMPTY_RESULT;
        }

        public void dropTable(MetastoreContext metastoreContext, String databaseName, String tableName, boolean deleteData) {
            try {
                Optional table = this.getTable(metastoreContext, databaseName, tableName);
                if (!table.isPresent()) {
                    throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
                }
                List<String> locations = this.listAllDataPaths(metastoreContext, databaseName, tableName);
                Table.Builder tableBuilder = Table.builder((Table)((Table)table.get()));
                tableBuilder.getStorageBuilder().setLocation("/");
                this.replaceTable(metastoreContext, databaseName, tableName, tableBuilder.build(), new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of()));
                this.delegate.dropTable(metastoreContext, databaseName, tableName, false);
                if (deleteData) {
                    for (String location : locations) {
                        Path path = new Path(location);
                        this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, path).delete(path, true);
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.invalidateTable(databaseName, tableName);
            }
        }

        public void updateTableLocation(MetastoreContext metastoreContext, String databaseName, String tableName, String location) {
            Optional table = this.getTable(metastoreContext, databaseName, tableName);
            if (!table.isPresent()) {
                throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            }
            Table.Builder tableBuilder = Table.builder((Table)((Table)table.get()));
            tableBuilder.getStorageBuilder().setLocation(location);
            this.replaceTable(metastoreContext, databaseName, tableName, tableBuilder.build(), new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of()));
        }

        private List<String> listAllDataPaths(MetastoreContext metastoreContext, String schemaName, String tableName) {
            Optional partitionNames;
            ImmutableList.Builder locations = ImmutableList.builder();
            Table table = (Table)this.getTable(metastoreContext, schemaName, tableName).get();
            if (table.getStorage().getLocation() != null) {
                locations.add((Object)table.getStorage().getLocation());
            }
            if ((partitionNames = this.getPartitionNames(metastoreContext, schemaName, tableName)).isPresent()) {
                this.getPartitionsByNames(metastoreContext, schemaName, tableName, (List)partitionNames.get()).values().stream().map(Optional::get).map(partition -> partition.getStorage().getLocation()).filter(location -> !location.startsWith(table.getStorage().getLocation())).forEach(arg_0 -> ((ImmutableList.Builder)locations).add(arg_0));
            }
            return locations.build();
        }
    }
}

