/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.log.Level;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.log.Logging;
import com.facebook.presto.Session;
import com.facebook.presto.connector.jmx.JmxPlugin;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HivePlugin;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.TestHiveEventListenerPlugin;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.file.FileHiveMetastore;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.tests.tpcds.TpcdsTableName;
import com.facebook.presto.tpcds.TpcdsPlugin;
import com.facebook.presto.tpch.TpchPlugin;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.tpch.TpchTable;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.joda.time.DateTimeZone;
import org.testng.Assert;

public final class HiveQueryRunner {
    private static final Logger log = Logger.get(HiveQueryRunner.class);
    public static final String HIVE_CATALOG = "hive";
    public static final String HIVE_BUCKETED_CATALOG = "hive_bucketed";
    public static final String TPCH_SCHEMA = "tpch";
    public static final String TPCH_BUCKETED_SCHEMA = "tpch_bucketed";
    public static final String TPCDS_SCHEMA = "tpcds";
    public static final String TPCDS_BUCKETED_SCHEMA = "tpcds_bucketed";
    public static final MetastoreContext METASTORE_CONTEXT = new MetastoreContext("test_user", "test_queryId", Optional.empty(), Optional.empty(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
    private static final String TEMPORARY_TABLE_SCHEMA = "__temporary_tables__";
    private static final DateTimeZone TIME_ZONE = DateTimeZone.forID((String)"America/Bahia_Banderas");

    private HiveQueryRunner() {
    }

    public static DistributedQueryRunner createQueryRunner(TpchTable<?> ... tables) throws Exception {
        return HiveQueryRunner.createQueryRunner(ImmutableList.copyOf((Object[])tables));
    }

    public static DistributedQueryRunner createQueryRunner(Iterable<TpchTable<?>> tables) throws Exception {
        return HiveQueryRunner.createQueryRunner(tables, (Map<String, String>)ImmutableMap.of(), Optional.empty());
    }

    public static DistributedQueryRunner createQueryRunner(Iterable<TpchTable<?>> tpchTables, Map<String, String> extraProperties, Map<String, String> extraCoordinatorProperties, Optional<Path> dataDirectory) throws Exception {
        return HiveQueryRunner.createQueryRunner(tpchTables, (Iterable<String>)ImmutableList.of(), extraProperties, extraCoordinatorProperties, "sql-standard", (Map<String, String>)ImmutableMap.of(), Optional.empty(), dataDirectory, Optional.empty());
    }

    public static DistributedQueryRunner createQueryRunner(Iterable<TpchTable<?>> tpchTables, Map<String, String> extraProperties, Optional<Path> dataDirectory) throws Exception {
        return HiveQueryRunner.createQueryRunner(tpchTables, (Iterable<String>)ImmutableList.of(), extraProperties, (Map<String, String>)ImmutableMap.of(), "sql-standard", (Map<String, String>)ImmutableMap.of(), Optional.empty(), dataDirectory, Optional.empty());
    }

    public static DistributedQueryRunner createQueryRunner(Iterable<TpchTable<?>> tpchTables, List<String> tpcdsTableNames, Map<String, String> extraProperties, Optional<Path> dataDirectory) throws Exception {
        return HiveQueryRunner.createQueryRunner(tpchTables, tpcdsTableNames, extraProperties, (Map<String, String>)ImmutableMap.of(), "sql-standard", (Map<String, String>)ImmutableMap.of(), Optional.empty(), dataDirectory, Optional.empty());
    }

    public static DistributedQueryRunner createQueryRunner(Iterable<TpchTable<?>> tpchTables, Map<String, String> extraProperties, String security, Map<String, String> extraHiveProperties, Optional<Path> dataDirectory) throws Exception {
        return HiveQueryRunner.createQueryRunner(tpchTables, (Iterable<String>)ImmutableList.of(), extraProperties, (Map<String, String>)ImmutableMap.of(), security, extraHiveProperties, Optional.empty(), dataDirectory, Optional.empty());
    }

    public static DistributedQueryRunner createQueryRunner(Iterable<TpchTable<?>> tpchTables, Iterable<String> tpcdsTableNames, Map<String, String> extraProperties, Map<String, String> extraCoordinatorProperties, String security, Map<String, String> extraHiveProperties, Optional<Integer> workerCount, Optional<Path> dataDirectory, Optional<BiFunction<Integer, URI, Process>> externalWorkerLauncher) throws Exception {
        return HiveQueryRunner.createQueryRunner(tpchTables, tpcdsTableNames, extraProperties, extraCoordinatorProperties, security, extraHiveProperties, workerCount, dataDirectory, externalWorkerLauncher, Optional.empty());
    }

    public static DistributedQueryRunner createQueryRunner(Iterable<TpchTable<?>> tpchTables, Iterable<String> tpcdsTableNames, Map<String, String> extraProperties, Map<String, String> extraCoordinatorProperties, String security, Map<String, String> extraHiveProperties, Optional<Integer> workerCount, Optional<Path> dataDirectory, Optional<BiFunction<Integer, URI, Process>> externalWorkerLauncher, Optional<ExtendedHiveMetastore> externalMetastore) throws Exception {
        return HiveQueryRunner.createQueryRunner(tpchTables, tpcdsTableNames, extraProperties, extraCoordinatorProperties, security, extraHiveProperties, workerCount, dataDirectory, externalWorkerLauncher, externalMetastore, false);
    }

    public static DistributedQueryRunner createQueryRunner(Iterable<TpchTable<?>> tpchTables, Iterable<String> tpcdsTableNames, Map<String, String> extraProperties, Map<String, String> extraCoordinatorProperties, String security, Map<String, String> extraHiveProperties, Optional<Integer> workerCount, Optional<Path> dataDirectory, Optional<BiFunction<Integer, URI, Process>> externalWorkerLauncher, Optional<ExtendedHiveMetastore> externalMetastore, boolean addJmxPlugin) throws Exception {
        Assert.assertEquals((Object)DateTimeZone.getDefault(), (Object)TIME_ZONE, (String)"Timezone not configured correctly. Add -Duser.timezone=America/Bahia_Banderas to your JVM arguments");
        HiveQueryRunner.setupLogging();
        ImmutableMap systemProperties = ImmutableMap.builder().put((Object)"task.writer-count", (Object)"2").put((Object)"task.partitioned-writer-count", (Object)"4").put((Object)"tracing.tracer-type", (Object)"simple").put((Object)"tracing.enable-distributed-tracing", (Object)"simple").putAll(extraProperties).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)HiveQueryRunner.createSession(Optional.of(new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))))).setNodeCount(workerCount.orElse(4).intValue()).setExtraProperties((Map)systemProperties).setCoordinatorProperties(extraCoordinatorProperties).setDataDirectory(dataDirectory).setExternalWorkerLauncher(externalWorkerLauncher).build();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.installPlugin((Plugin)new TpcdsPlugin());
            queryRunner.installPlugin((Plugin)new TestHiveEventListenerPlugin.TestingHiveEventListenerPlugin());
            queryRunner.createCatalog(TPCH_SCHEMA, TPCH_SCHEMA);
            queryRunner.createCatalog(TPCDS_SCHEMA, TPCDS_SCHEMA);
            ImmutableMap tpchProperties = ImmutableMap.builder().put((Object)"tpch.column-naming", (Object)"standard").build();
            queryRunner.createCatalog("tpchstandard", TPCH_SCHEMA, (Map)tpchProperties);
            ExtendedHiveMetastore metastore = externalMetastore.orElse(HiveQueryRunner.getFileHiveMetastore(queryRunner));
            queryRunner.installPlugin((Plugin)new HivePlugin(HIVE_CATALOG, Optional.of(metastore)));
            if (addJmxPlugin) {
                queryRunner.installPlugin((Plugin)new JmxPlugin());
                queryRunner.createCatalog("jmx", "jmx");
            }
            ImmutableMap hiveProperties = ImmutableMap.builder().putAll(extraHiveProperties).put((Object)"hive.time-zone", (Object)TIME_ZONE.getID()).put((Object)"hive.security", (Object)security).put((Object)"hive.max-partitions-per-scan", (Object)"1000").put((Object)"hive.assume-canonical-partition-keys", (Object)"true").put((Object)"hive.collect-column-statistics-on-write", (Object)"true").put((Object)"hive.temporary-table-schema", (Object)TEMPORARY_TABLE_SCHEMA).build();
            ImmutableMap storageProperties = extraHiveProperties.containsKey("hive.storage-format") ? ImmutableMap.copyOf((Map)hiveProperties) : ImmutableMap.builder().putAll((Map)hiveProperties).put((Object)"hive.storage-format", (Object)"TEXTFILE").put((Object)"hive.compression-codec", (Object)"NONE").build();
            ImmutableMap hiveBucketedProperties = ImmutableMap.builder().putAll((Map)storageProperties).put((Object)"hive.max-initial-split-size", (Object)"10kB").put((Object)"hive.max-split-size", (Object)"10kB").build();
            queryRunner.createCatalog(HIVE_CATALOG, HIVE_CATALOG, (Map)hiveProperties);
            queryRunner.createCatalog(HIVE_BUCKETED_CATALOG, HIVE_CATALOG, (Map)hiveBucketedProperties);
            List<String> tpchTableNames = HiveQueryRunner.getTpchTableNames(tpchTables);
            if (!metastore.getDatabase(METASTORE_CONTEXT, TPCH_SCHEMA).isPresent()) {
                metastore.createDatabase(METASTORE_CONTEXT, HiveQueryRunner.createDatabaseMetastoreObject(TPCH_SCHEMA));
                QueryAssertions.copyTables((QueryRunner)queryRunner, (String)TPCH_SCHEMA, (String)"tiny", (Session)HiveQueryRunner.createSession(Optional.empty()), tpchTableNames, (boolean)true, (boolean)false);
            }
            if (!metastore.getDatabase(METASTORE_CONTEXT, TPCH_BUCKETED_SCHEMA).isPresent()) {
                metastore.createDatabase(METASTORE_CONTEXT, HiveQueryRunner.createDatabaseMetastoreObject(TPCH_BUCKETED_SCHEMA));
                QueryAssertions.copyTables((QueryRunner)queryRunner, (String)TPCH_SCHEMA, (String)"tiny", (Session)HiveQueryRunner.createBucketedSession(Optional.empty()), tpchTableNames, (boolean)true, (boolean)true);
            }
            if (!metastore.getDatabase(METASTORE_CONTEXT, TEMPORARY_TABLE_SCHEMA).isPresent()) {
                metastore.createDatabase(METASTORE_CONTEXT, HiveQueryRunner.createDatabaseMetastoreObject(TEMPORARY_TABLE_SCHEMA));
            }
            if (!metastore.getDatabase(METASTORE_CONTEXT, TPCDS_SCHEMA).isPresent()) {
                metastore.createDatabase(METASTORE_CONTEXT, HiveQueryRunner.createDatabaseMetastoreObject(TPCDS_SCHEMA));
                QueryAssertions.copyTables((QueryRunner)queryRunner, (String)TPCDS_SCHEMA, (String)"tiny", (Session)HiveQueryRunner.createSession(Optional.empty(), TPCDS_SCHEMA), tpcdsTableNames, (boolean)true, (boolean)false);
            }
            if (!metastore.getDatabase(METASTORE_CONTEXT, TPCDS_BUCKETED_SCHEMA).isPresent()) {
                metastore.createDatabase(METASTORE_CONTEXT, HiveQueryRunner.createDatabaseMetastoreObject(TPCDS_BUCKETED_SCHEMA));
                QueryAssertions.copyTables((QueryRunner)queryRunner, (String)TPCDS_SCHEMA, (String)"tiny", (Session)HiveQueryRunner.createBucketedSession(Optional.empty(), TPCDS_BUCKETED_SCHEMA), tpcdsTableNames, (boolean)true, (boolean)true);
            }
            return queryRunner;
        }
        catch (Exception e) {
            queryRunner.close();
            throw e;
        }
    }

    private static List<String> getTpchTableNames(Iterable<TpchTable<?>> tables) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        tables.forEach(table -> tableNames.add((Object)table.getTableName().toLowerCase(Locale.ENGLISH)));
        return tableNames.build();
    }

    public static List<String> getAllTpcdsTableNames() {
        ImmutableList.Builder tables = ImmutableList.builder();
        for (TpcdsTableName tpcdsTable : TpcdsTableName.getBaseTables()) {
            tables.add((Object)tpcdsTable.getTableName().toLowerCase(Locale.ENGLISH));
        }
        return tables.build();
    }

    private static ExtendedHiveMetastore getFileHiveMetastore(DistributedQueryRunner queryRunner) {
        File dataDirectory = queryRunner.getCoordinator().getDataDirectory().resolve("hive_data").toFile();
        HiveClientConfig hiveClientConfig = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(hiveClientConfig, metastoreClientConfig), (Set)ImmutableSet.of(), hiveClientConfig);
        HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, metastoreClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        return new FileHiveMetastore(hdfsEnvironment, dataDirectory.toURI().toString(), "test");
    }

    public static DistributedQueryRunner createMaterializingQueryRunner(Iterable<TpchTable<?>> tables) throws Exception {
        return HiveQueryRunner.createQueryRunner(tables, (Map<String, String>)ImmutableMap.of((Object)"query.partitioning-provider-catalog", (Object)HIVE_CATALOG, (Object)"query.exchange-materialization-strategy", (Object)"ALL", (Object)"query.hash-partition-count", (Object)"11", (Object)"colocated-joins-enabled", (Object)"true", (Object)"grouped-execution-enabled", (Object)"true"), "sql-standard", (Map<String, String>)ImmutableMap.of((Object)"hive.create-empty-bucket-files-for-temporary-table", (Object)"false"), Optional.empty());
    }

    public static DistributedQueryRunner createMaterializingAndSpillingQueryRunner(Iterable<TpchTable<?>> tables) throws Exception {
        return HiveQueryRunner.createQueryRunner(tables, (Map<String, String>)ImmutableMap.builder().put((Object)"query.partitioning-provider-catalog", (Object)HIVE_CATALOG).put((Object)"query.exchange-materialization-strategy", (Object)"ALL").put((Object)"query.hash-partition-count", (Object)"11").put((Object)"colocated-joins-enabled", (Object)"true").put((Object)"grouped-execution-enabled", (Object)"true").put((Object)"experimental.spill-enabled", (Object)"true").put((Object)"experimental.spiller-spill-path", (Object)Paths.get(System.getProperty("java.io.tmpdir"), "presto", "spills").toString()).put((Object)"experimental.spiller-max-used-space-threshold", (Object)"1.0").put((Object)"experimental.memory-revoking-threshold", (Object)"0.0").put((Object)"experimental.memory-revoking-target", (Object)"0.0").build(), Optional.empty());
    }

    private static void setupLogging() {
        Logging logging = Logging.initialize();
        logging.setLevel("com.facebook.presto.event", Level.WARN);
        logging.setLevel("com.facebook.presto.security.AccessControlManager", Level.WARN);
        logging.setLevel("com.facebook.presto.server.PluginManager", Level.WARN);
        logging.setLevel("com.facebook.airlift.bootstrap.LifeCycleManager", Level.WARN);
        logging.setLevel("org.apache.parquet.hadoop", Level.WARN);
        logging.setLevel("org.eclipse.jetty.server.handler.ContextHandler", Level.WARN);
        logging.setLevel("org.eclipse.jetty.server.AbstractConnector", Level.WARN);
        logging.setLevel("org.glassfish.jersey.internal.inject.Providers", Level.ERROR);
        logging.setLevel("parquet.hadoop", Level.WARN);
    }

    private static Database createDatabaseMetastoreObject(String name) {
        return Database.builder().setDatabaseName(name).setOwnerName("public").setOwnerType(PrincipalType.ROLE).build();
    }

    public static Session createSession(Optional<SelectedRole> role) {
        return HiveQueryRunner.createSession(role, TPCH_SCHEMA);
    }

    public static Session createSession(Optional<SelectedRole> role, String schema) {
        return TestingSession.testSessionBuilder().setIdentity(new Identity(HIVE_CATALOG, Optional.empty(), (Map)role.map(selectedRole -> ImmutableMap.of((Object)HIVE_CATALOG, (Object)selectedRole)).orElse(ImmutableMap.of()), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty())).setCatalog(HIVE_CATALOG).setSchema(schema).build();
    }

    public static Session createBucketedSession(Optional<SelectedRole> role) {
        return HiveQueryRunner.createBucketedSession(role, TPCH_BUCKETED_SCHEMA);
    }

    public static Session createBucketedSession(Optional<SelectedRole> role, String schema) {
        return TestingSession.testSessionBuilder().setIdentity(new Identity(HIVE_CATALOG, Optional.empty(), (Map)role.map(selectedRole -> ImmutableMap.of((Object)HIVE_BUCKETED_CATALOG, (Object)selectedRole)).orElse(ImmutableMap.of()), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty())).setCatalog(HIVE_BUCKETED_CATALOG).setSchema(schema).build();
    }

    public static Session createMaterializeExchangesSession(Optional<SelectedRole> role) {
        return TestingSession.testSessionBuilder().setIdentity(new Identity(HIVE_CATALOG, Optional.empty(), (Map)role.map(selectedRole -> ImmutableMap.of((Object)HIVE_CATALOG, (Object)selectedRole)).orElse(ImmutableMap.of()), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty())).setSystemProperty("partitioning_provider_catalog", HIVE_CATALOG).setSystemProperty("exchange_materialization_strategy", QueryManagerConfig.ExchangeMaterializationStrategy.ALL.name()).setSystemProperty("hash_partition_count", "13").setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution", "true").setCatalog(HIVE_CATALOG).setSchema(TPCH_SCHEMA).build();
    }

    public static void main(String[] args) throws Exception {
        Logging.initialize();
        Optional<Path> dataDirectory = Optional.empty();
        if (args.length > 0) {
            File dataDirectoryFile;
            if (args.length != 1) {
                log.error("usage: HiveQueryRunner [dataDirectory]\n");
                log.error("       [dataDirectory] is a local directory under which you want the hive_data directory to be created.]\n");
                System.exit(1);
            }
            if ((dataDirectoryFile = new File(args[0])).exists()) {
                if (!dataDirectoryFile.isDirectory()) {
                    log.error("Error: " + dataDirectoryFile.getAbsolutePath() + " is not a directory.");
                    System.exit(1);
                } else if (!dataDirectoryFile.canRead() || !dataDirectoryFile.canWrite()) {
                    log.error("Error: " + dataDirectoryFile.getAbsolutePath() + " is not readable/writable.");
                    System.exit(1);
                }
            } else {
                while (!dataDirectoryFile.exists()) {
                    dataDirectoryFile = dataDirectoryFile.getParentFile();
                }
                if (!dataDirectoryFile.canRead() || !dataDirectoryFile.canWrite()) {
                    log.error("Error: The ancestor directory " + dataDirectoryFile.getAbsolutePath() + " is not readable/writable.");
                    System.exit(1);
                }
            }
            dataDirectory = Optional.of(dataDirectoryFile.toPath());
        }
        DistributedQueryRunner queryRunner = HiveQueryRunner.createQueryRunner(TpchTable.getTables(), HiveQueryRunner.getAllTpcdsTableNames(), (Map<String, String>)ImmutableMap.of((Object)"http-server.http.port", (Object)"8080"), dataDirectory);
        Thread.sleep(10L);
        Logger log = Logger.get(DistributedQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }
}

