/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.smile.SmileCodec;
import com.facebook.presto.PagesIndexPageSorter;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.cost.ConnectorFilterStatsCalculatorService;
import com.facebook.presto.cost.FilterStatsCalculator;
import com.facebook.presto.cost.ScalarStatsCalculator;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveDwrfEncryptionProvider;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSelectivePageSourceFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.OrcFileWriterFactory;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.RcFileFileWriterFactory;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.datasink.DataSinkFactory;
import com.facebook.presto.hive.datasink.OutputStreamDataSinkFactory;
import com.facebook.presto.hive.gcs.GcsConfigurationInitializer;
import com.facebook.presto.hive.gcs.HiveGcsConfig;
import com.facebook.presto.hive.gcs.HiveGcsConfigurationInitializer;
import com.facebook.presto.hive.orc.DwrfBatchPageSourceFactory;
import com.facebook.presto.hive.orc.DwrfSelectivePageSourceFactory;
import com.facebook.presto.hive.orc.OrcBatchPageSourceFactory;
import com.facebook.presto.hive.orc.OrcSelectivePageSourceFactory;
import com.facebook.presto.hive.orc.TupleDomainFilterCache;
import com.facebook.presto.hive.pagefile.PageFilePageSourceFactory;
import com.facebook.presto.hive.pagefile.PageFileWriterFactory;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.hive.rcfile.RcFilePageSourceFactory;
import com.facebook.presto.hive.s3.HiveS3Config;
import com.facebook.presto.hive.s3.PrestoS3ClientFactory;
import com.facebook.presto.hive.s3.PrestoS3ConfigurationUpdater;
import com.facebook.presto.hive.s3.S3ConfigurationUpdater;
import com.facebook.presto.hive.s3select.S3SelectRecordCursorProvider;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.cache.ParquetMetadataSource;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterStatsCalculatorService;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.PredicateCompiler;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.sql.gen.RowExpressionPredicateCompiler;
import com.facebook.presto.sql.planner.planPrinter.RowExpressionFormatter;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.sql.relational.RowExpressionOptimizer;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class HiveTestUtils {
    public static final JsonCodec<PartitionUpdate> PARTITION_UPDATE_CODEC = JsonCodec.jsonCodec(PartitionUpdate.class);
    public static final SmileCodec<PartitionUpdate> PARTITION_UPDATE_SMILE_CODEC = SmileCodec.smileCodec(PartitionUpdate.class);
    public static final ConnectorSession SESSION = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig(), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
    public static final MetadataManager METADATA = MetadataManager.createTestMetadataManager();
    public static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = METADATA.getFunctionAndTypeManager();
    public static final StandardFunctionResolution FUNCTION_RESOLUTION = new FunctionResolution(METADATA.getFunctionAndTypeManager().getFunctionAndTypeResolver());
    public static final RowExpressionService ROW_EXPRESSION_SERVICE = new RowExpressionService(){

        public DomainTranslator getDomainTranslator() {
            return new RowExpressionDomainTranslator((Metadata)METADATA);
        }

        public ExpressionOptimizer getExpressionOptimizer() {
            return new RowExpressionOptimizer((Metadata)METADATA);
        }

        public PredicateCompiler getPredicateCompiler() {
            return new RowExpressionPredicateCompiler((Metadata)METADATA);
        }

        public DeterminismEvaluator getDeterminismEvaluator() {
            return new RowExpressionDeterminismEvaluator((Metadata)METADATA);
        }

        public String formatRowExpression(ConnectorSession session, RowExpression expression) {
            return new RowExpressionFormatter(METADATA.getFunctionAndTypeManager()).formatRowExpression(session, expression);
        }
    };
    public static final FilterStatsCalculatorService FILTER_STATS_CALCULATOR_SERVICE = new ConnectorFilterStatsCalculatorService(new FilterStatsCalculator((Metadata)METADATA, new ScalarStatsCalculator((Metadata)METADATA), new StatsNormalizer()));
    public static final HiveClientConfig HIVE_CLIENT_CONFIG = new HiveClientConfig();
    public static final MetastoreClientConfig METASTORE_CLIENT_CONFIG = new MetastoreClientConfig();
    public static final HdfsEnvironment HDFS_ENVIRONMENT = HiveTestUtils.createTestHdfsEnvironment(HIVE_CLIENT_CONFIG, METASTORE_CLIENT_CONFIG);
    public static final PageSorter PAGE_SORTER = new PagesIndexPageSorter((PagesIndex.Factory)new PagesIndex.TestingFactory(false));

    private HiveTestUtils() {
    }

    public static Set<HiveBatchPageSourceFactory> getDefaultHiveBatchPageSourceFactories(HiveClientConfig hiveClientConfig, MetastoreClientConfig metastoreClientConfig) {
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        HdfsEnvironment testHdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(hiveClientConfig, metastoreClientConfig);
        return ImmutableSet.builder().add((Object)new RcFilePageSourceFactory((TypeManager)FUNCTION_AND_TYPE_MANAGER, testHdfsEnvironment, stats)).add((Object)new OrcBatchPageSourceFactory((TypeManager)FUNCTION_AND_TYPE_MANAGER, FUNCTION_RESOLUTION, hiveClientConfig, testHdfsEnvironment, stats, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource()))).add((Object)new DwrfBatchPageSourceFactory((TypeManager)FUNCTION_AND_TYPE_MANAGER, FUNCTION_RESOLUTION, hiveClientConfig, testHdfsEnvironment, stats, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource()), HiveDwrfEncryptionProvider.NO_ENCRYPTION)).add((Object)new ParquetPageSourceFactory((TypeManager)FUNCTION_AND_TYPE_MANAGER, FUNCTION_RESOLUTION, testHdfsEnvironment, stats, (ParquetMetadataSource)new MetadataReader())).add((Object)new PageFilePageSourceFactory(testHdfsEnvironment, (BlockEncodingSerde)new BlockEncodingManager())).build();
    }

    public static Set<HiveSelectivePageSourceFactory> getDefaultHiveSelectivePageSourceFactories(HiveClientConfig hiveClientConfig, MetastoreClientConfig metastoreClientConfig) {
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        HdfsEnvironment testHdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(hiveClientConfig, metastoreClientConfig);
        return ImmutableSet.builder().add((Object)new OrcSelectivePageSourceFactory((TypeManager)FUNCTION_AND_TYPE_MANAGER, FUNCTION_RESOLUTION, ROW_EXPRESSION_SERVICE, hiveClientConfig, testHdfsEnvironment, stats, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource()), new TupleDomainFilterCache())).add((Object)new DwrfSelectivePageSourceFactory((TypeManager)FUNCTION_AND_TYPE_MANAGER, FUNCTION_RESOLUTION, ROW_EXPRESSION_SERVICE, hiveClientConfig, testHdfsEnvironment, stats, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource()), new TupleDomainFilterCache(), HiveDwrfEncryptionProvider.NO_ENCRYPTION)).build();
    }

    public static Set<HiveRecordCursorProvider> getDefaultHiveRecordCursorProvider(HiveClientConfig hiveClientConfig, MetastoreClientConfig metastoreClientConfig) {
        HdfsEnvironment testHdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(hiveClientConfig, metastoreClientConfig);
        return ImmutableSet.builder().add((Object)new GenericHiveRecordCursorProvider(testHdfsEnvironment)).build();
    }

    public static Set<HiveRecordCursorProvider> getDefaultS3HiveRecordCursorProvider(HiveClientConfig hiveClientConfig, MetastoreClientConfig metastoreClientConfig) {
        HdfsEnvironment testHdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(hiveClientConfig, metastoreClientConfig);
        return ImmutableSet.builder().add((Object)new S3SelectRecordCursorProvider(testHdfsEnvironment, hiveClientConfig, new PrestoS3ClientFactory())).add((Object)new GenericHiveRecordCursorProvider(testHdfsEnvironment)).build();
    }

    public static Set<HiveFileWriterFactory> getDefaultHiveFileWriterFactories(HiveClientConfig hiveClientConfig, MetastoreClientConfig metastoreClientConfig) {
        HdfsEnvironment testHdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(hiveClientConfig, metastoreClientConfig);
        return ImmutableSet.builder().add((Object)new RcFileFileWriterFactory(testHdfsEnvironment, (TypeManager)FUNCTION_AND_TYPE_MANAGER, new NodeVersion("test_version"), hiveClientConfig, new FileFormatDataSourceStats())).add((Object)new PageFileWriterFactory(testHdfsEnvironment, (DataSinkFactory)new OutputStreamDataSinkFactory(), (BlockEncodingSerde)new BlockEncodingManager())).add((Object)HiveTestUtils.getDefaultOrcFileWriterFactory(hiveClientConfig, metastoreClientConfig)).build();
    }

    public static OrcFileWriterFactory getDefaultOrcFileWriterFactory(HiveClientConfig hiveClientConfig, MetastoreClientConfig metastoreClientConfig) {
        HdfsEnvironment testHdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(hiveClientConfig, metastoreClientConfig);
        return new OrcFileWriterFactory(testHdfsEnvironment, (DataSinkFactory)new OutputStreamDataSinkFactory(), (TypeManager)FUNCTION_AND_TYPE_MANAGER, new NodeVersion("test_version"), hiveClientConfig, new FileFormatDataSourceStats(), new OrcFileWriterConfig(), HiveDwrfEncryptionProvider.NO_ENCRYPTION);
    }

    public static List<Type> getTypes(List<? extends ColumnHandle> columnHandles) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (ColumnHandle columnHandle : columnHandles) {
            types.add((Object)FUNCTION_AND_TYPE_MANAGER.getType(((HiveColumnHandle)columnHandle).getTypeSignature()));
        }
        return types.build();
    }

    public static HdfsEnvironment createTestHdfsEnvironment(HiveClientConfig config, MetastoreClientConfig metastoreClientConfig) {
        HiveHdfsConfiguration hdfsConfig = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(config, metastoreClientConfig, (S3ConfigurationUpdater)new PrestoS3ConfigurationUpdater(new HiveS3Config()), (GcsConfigurationInitializer)new HiveGcsConfigurationInitializer(new HiveGcsConfig())), (Set)ImmutableSet.of(), config);
        return new HdfsEnvironment((HdfsConfiguration)hdfsConfig, metastoreClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
    }

    public static MapType mapType(Type keyType, Type valueType) {
        return (MapType)FUNCTION_AND_TYPE_MANAGER.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
    }

    public static ArrayType arrayType(Type elementType) {
        return (ArrayType)FUNCTION_AND_TYPE_MANAGER.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)elementType.getTypeSignature())));
    }

    public static RowType rowType(List<NamedTypeSignature> elementTypeSignatures) {
        return (RowType)FUNCTION_AND_TYPE_MANAGER.getParameterizedType("row", (List)ImmutableList.copyOf((Collection)elementTypeSignatures.stream().map(TypeSignatureParameter::of).collect(Collectors.toList())));
    }

    public static Long shortDecimal(String value) {
        return new BigDecimal(value).unscaledValue().longValueExact();
    }

    public static Slice longDecimal(String value) {
        return Decimals.encodeScaledValue((BigDecimal)new BigDecimal(value));
    }
}

