/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.OrcFileWriterFactory;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableSet;
import java.util.Properties;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TesOrcFileWriterFactory {
    @Test
    public void tesDefaultFlatMapOptions() {
        Properties serDe = new Properties();
        OrcWriterOptions orcWriterOptions = TesOrcFileWriterFactory.getOrcWriterOptions(serDe);
        Assert.assertEquals((int)orcWriterOptions.getMaxFlattenedMapKeyCount(), (int)25000);
        Assert.assertFalse((boolean)orcWriterOptions.isMapStatisticsEnabled());
        Assert.assertEquals((int)orcWriterOptions.getFlattenedColumns().size(), (int)0);
    }

    @Test
    public void testFlatMapColumnsDisabled() {
        Properties serDe = new Properties();
        serDe.setProperty("orc.flatten.map", "false");
        serDe.setProperty("orc.map.flat.cols", "1,2");
        OrcWriterOptions orcWriterOptions = TesOrcFileWriterFactory.getOrcWriterOptions(serDe);
        Assert.assertEquals((int)orcWriterOptions.getFlattenedColumns().size(), (int)0);
    }

    @Test
    public void testFlatMapColumnsEnabled() {
        Properties serDe = new Properties();
        serDe.setProperty("orc.flatten.map", "true");
        serDe.setProperty("orc.map.flat.cols", "1,2");
        OrcWriterOptions orcWriterOptions = TesOrcFileWriterFactory.getOrcWriterOptions(serDe);
        Assert.assertEquals((Set)orcWriterOptions.getFlattenedColumns(), (Set)ImmutableSet.of((Object)1, (Object)2));
    }

    @Test
    public void testFlatMapKeyLimit() {
        Properties serDe = new Properties();
        serDe.setProperty("orc.map.flat.max.keys", "23");
        OrcWriterOptions orcWriterOptions = TesOrcFileWriterFactory.getOrcWriterOptions(serDe);
        Assert.assertEquals((int)orcWriterOptions.getMaxFlattenedMapKeyCount(), (int)23);
    }

    @Test
    public void testFlatMapStatsEnabled() {
        Properties serDe = new Properties();
        serDe.setProperty("orc.map.statistics", "true");
        OrcWriterOptions orcWriterOptions = TesOrcFileWriterFactory.getOrcWriterOptions(serDe);
        Assert.assertTrue((boolean)orcWriterOptions.isMapStatisticsEnabled());
    }

    private static OrcWriterOptions getOrcWriterOptions(Properties serDe) {
        OrcFileWriterConfig orcFileWriterConfig = new OrcFileWriterConfig();
        orcFileWriterConfig.setFlatMapWriterEnabled(true);
        OrcFileWriterFactory orcFileWriterFactory = HiveTestUtils.getDefaultOrcFileWriterFactory(HiveTestUtils.HIVE_CLIENT_CONFIG, HiveTestUtils.METASTORE_CLIENT_CONFIG);
        HiveSessionProperties sessionProperties = new HiveSessionProperties(new HiveClientConfig(), orcFileWriterConfig, new ParquetFileWriterConfig(), new CacheConfig());
        TestingConnectorSession session = new TestingConnectorSession(sessionProperties.getSessionProperties());
        return orcFileWriterFactory.buildOrcWriterOptions((ConnectorSession)session, serDe);
    }
}

