/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.hive.ColumnEncryptionInformation;
import com.facebook.presto.hive.DwrfEncryptionMetadata;
import com.facebook.presto.hive.DwrfTableEncryptionProperties;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.EncryptionInformationSource;
import com.facebook.presto.hive.EncryptionMetadata;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.TableEncryptionProperties;
import com.facebook.presto.hive.TestDwrfEncryptionInformationSource;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAbstractDwrfEncryptionInformationSource {
    private static final HiveType STRUCT_TYPE = HiveType.valueOf((String)"struct<a:string,b:struct<b1:map<string,bigint>,b2:bigint>>");
    private final EncryptionInformationSource encryptionInformationSource = new TestDwrfEncryptionInformationSource();

    private static Table createTable(HiveStorageFormat storageFormat, Optional<DwrfTableEncryptionProperties> tableEncryptionProperties, boolean isPartitioned) {
        return new Table("dbName", "tableName", "owner", PrestoTableType.MANAGED_TABLE, new Storage(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)storageFormat), "location", Optional.empty(), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (List)ImmutableList.of((Object)new Column("col_string", HiveType.HIVE_STRING, Optional.empty(), Optional.empty()), (Object)new Column("col_bigint", HiveType.HIVE_LONG, Optional.empty(), Optional.empty()), (Object)new Column("col_map", HiveType.valueOf((String)"map<string,string>"), Optional.empty(), Optional.empty()), (Object)new Column("col_struct", STRUCT_TYPE, Optional.empty(), Optional.empty())), (List)(isPartitioned ? ImmutableList.of((Object)new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty())) : ImmutableList.of()), tableEncryptionProperties.map(TableEncryptionProperties::toHiveProperties).orElse((Map)ImmutableMap.of()), Optional.empty(), Optional.empty());
    }

    @Test
    public void testNotDwrfTable() {
        Table table = TestAbstractDwrfEncryptionInformationSource.createTable(HiveStorageFormat.ORC, Optional.of(DwrfTableEncryptionProperties.forTable((String)"foo", (String)"AES_GCM_256", (String)"TEST")), true);
        Assert.assertFalse((boolean)this.encryptionInformationSource.getReadEncryptionInformation(HiveTestUtils.SESSION, table, Optional.of(ImmutableSet.of()), (Map)ImmutableMap.of()).isPresent());
        Assert.assertFalse((boolean)this.encryptionInformationSource.getReadEncryptionInformation(HiveTestUtils.SESSION, table, Optional.of(ImmutableSet.of())).isPresent());
        Assert.assertFalse((boolean)this.encryptionInformationSource.getWriteEncryptionInformation(HiveTestUtils.SESSION, (TableEncryptionProperties)new NonDwrfTableEncryptionProperties(), "db", "table").isPresent());
    }

    @Test
    public void testNotEncryptedTable() {
        Table table = TestAbstractDwrfEncryptionInformationSource.createTable(HiveStorageFormat.DWRF, Optional.empty(), true);
        Assert.assertFalse((boolean)this.encryptionInformationSource.getReadEncryptionInformation(HiveTestUtils.SESSION, table, Optional.of(ImmutableSet.of()), (Map)ImmutableMap.of()).isPresent());
        Assert.assertFalse((boolean)this.encryptionInformationSource.getReadEncryptionInformation(HiveTestUtils.SESSION, table, Optional.of(ImmutableSet.of())).isPresent());
    }

    @Test
    public void testGetReadEncryptionInformationForPartitionedTableWithTableLevelEncryption() {
        Table table = TestAbstractDwrfEncryptionInformationSource.createTable(HiveStorageFormat.DWRF, Optional.of(DwrfTableEncryptionProperties.forTable((String)"table_level_key", (String)"algo", (String)"provider")), true);
        Optional encryptionInformation = this.encryptionInformationSource.getReadEncryptionInformation(HiveTestUtils.SESSION, table, Optional.of(ImmutableSet.of((Object)new HiveColumnHandle("col_bigint", HiveType.HIVE_LONG, HiveType.HIVE_LONG.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("col_struct", STRUCT_TYPE, STRUCT_TYPE.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), (List)ImmutableList.of((Object)new Subfield("col_struct.a"), (Object)new Subfield("col_struct.b.b2")), Optional.empty()))), (Map)ImmutableMap.of((Object)"ds=2020-01-01", (Object)new Partition("dbName", "tableName", (List)ImmutableList.of((Object)"2020-01-01"), table.getStorage(), table.getDataColumns(), (Map)ImmutableMap.of(), Optional.empty(), false, true, 0, 0L), (Object)"ds=2020-01-02", (Object)new Partition("dbName", "tableName", (List)ImmutableList.of((Object)"2020-01-02"), table.getStorage(), table.getDataColumns(), (Map)ImmutableMap.of(), Optional.empty(), false, true, 0, 0L)));
        Assert.assertTrue((boolean)encryptionInformation.isPresent());
        Assert.assertEquals((Map)((Map)encryptionInformation.get()), (Map)ImmutableMap.of((Object)"ds=2020-01-01", (Object)EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forTable((byte[])"table_level_key".getBytes(), (Map)ImmutableMap.of((Object)"test.extra.metadata", (Object)"ds=2020-01-01"), (String)"algo", (String)"provider")), (Object)"ds=2020-01-02", (Object)EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forTable((byte[])"table_level_key".getBytes(), (Map)ImmutableMap.of((Object)"test.extra.metadata", (Object)"ds=2020-01-02"), (String)"algo", (String)"provider"))));
    }

    @Test
    public void testGetReadEncryptionInformationForPartitionedTableWithTableLevelEncryptionAndNoRequestedColumns() {
        Table table = TestAbstractDwrfEncryptionInformationSource.createTable(HiveStorageFormat.DWRF, Optional.of(DwrfTableEncryptionProperties.forTable((String)"key1", (String)"algo", (String)"provider")), true);
        Optional encryptionInformation = this.encryptionInformationSource.getReadEncryptionInformation(HiveTestUtils.SESSION, table, Optional.of(ImmutableSet.of()), (Map)ImmutableMap.of((Object)"ds=2020-01-01", (Object)new Partition("dbName", "tableName", (List)ImmutableList.of((Object)"2020-01-01"), table.getStorage(), table.getDataColumns(), (Map)ImmutableMap.of(), Optional.empty(), false, true, 0, 0L), (Object)"ds=2020-01-02", (Object)new Partition("dbName", "tableName", (List)ImmutableList.of((Object)"2020-01-02"), table.getStorage(), table.getDataColumns(), (Map)ImmutableMap.of(), Optional.empty(), false, true, 0, 0L)));
        Assert.assertTrue((boolean)encryptionInformation.isPresent());
        Assert.assertEquals((Map)((Map)encryptionInformation.get()), (Map)ImmutableMap.of((Object)"ds=2020-01-01", (Object)EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forPerField((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"test.extra.metadata", (Object)"ds=2020-01-01"), (String)"algo", (String)"provider")), (Object)"ds=2020-01-02", (Object)EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forPerField((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"test.extra.metadata", (Object)"ds=2020-01-02"), (String)"algo", (String)"provider"))));
    }

    @Test
    public void testGetReadEncryptionInformationForPartitionedTableWithColumnLevelEncryption() {
        Table table = TestAbstractDwrfEncryptionInformationSource.createTable(HiveStorageFormat.DWRF, Optional.of(DwrfTableEncryptionProperties.forPerColumn((ColumnEncryptionInformation)ColumnEncryptionInformation.fromHiveProperty((String)"key1:col_string,col_struct.b.b2;key2:col_bigint,col_struct.a"), (String)"algo", (String)"provider")), true);
        Optional encryptionInformation = this.encryptionInformationSource.getReadEncryptionInformation(HiveTestUtils.SESSION, table, Optional.of(ImmutableSet.of((Object)new HiveColumnHandle("col_bigint", HiveType.HIVE_LONG, HiveType.HIVE_LONG.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("col_map", HiveType.HIVE_LONG, HiveType.HIVE_LONG.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("col_struct", STRUCT_TYPE, STRUCT_TYPE.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), (List)ImmutableList.of((Object)new Subfield("col_struct.a"), (Object)new Subfield("col_struct.b.b2")), Optional.empty()))), (Map)ImmutableMap.of((Object)"ds=2020-01-01", (Object)new Partition("dbName", "tableName", (List)ImmutableList.of((Object)"2020-01-01"), table.getStorage(), table.getDataColumns(), (Map)ImmutableMap.of(), Optional.empty(), false, true, 0, 0L), (Object)"ds=2020-01-02", (Object)new Partition("dbName", "tableName", (List)ImmutableList.of((Object)"2020-01-02"), table.getStorage(), table.getDataColumns(), (Map)ImmutableMap.of(), Optional.empty(), false, true, 0, 0L)));
        ImmutableMap expectedFieldToKeyData = ImmutableMap.of((Object)"col_bigint", (Object)"key2".getBytes(), (Object)"col_struct.a", (Object)"key2".getBytes(), (Object)"col_struct.b.b2", (Object)"key1".getBytes());
        Assert.assertTrue((boolean)encryptionInformation.isPresent());
        Assert.assertEquals((Map)((Map)encryptionInformation.get()), (Map)ImmutableMap.of((Object)"ds=2020-01-01", (Object)EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forPerField((Map)expectedFieldToKeyData, (Map)ImmutableMap.of((Object)"test.extra.metadata", (Object)"ds=2020-01-01"), (String)"algo", (String)"provider")), (Object)"ds=2020-01-02", (Object)EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forPerField((Map)expectedFieldToKeyData, (Map)ImmutableMap.of((Object)"test.extra.metadata", (Object)"ds=2020-01-02"), (String)"algo", (String)"provider"))));
    }

    @Test
    public void testGetReadEncryptionInformationForUnPartitionedTableWithColumnLevelEncryption() {
        Table table = TestAbstractDwrfEncryptionInformationSource.createTable(HiveStorageFormat.DWRF, Optional.of(DwrfTableEncryptionProperties.forPerColumn((ColumnEncryptionInformation)ColumnEncryptionInformation.fromHiveProperty((String)"key1:col_string,col_struct.b.b2;key2:col_bigint,col_struct.a"), (String)"algo", (String)"provider")), false);
        Optional encryptionInformation = this.encryptionInformationSource.getReadEncryptionInformation(HiveTestUtils.SESSION, table, Optional.of(ImmutableSet.of((Object)new HiveColumnHandle("col_bigint", HiveType.HIVE_LONG, HiveType.HIVE_LONG.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("col_map", HiveType.HIVE_LONG, HiveType.HIVE_LONG.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("col_struct", STRUCT_TYPE, STRUCT_TYPE.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), (List)ImmutableList.of((Object)new Subfield("col_struct.a"), (Object)new Subfield("col_struct.b.b2")), Optional.empty()))));
        ImmutableMap expectedFieldToKeyData = ImmutableMap.of((Object)"col_bigint", (Object)"key2".getBytes(), (Object)"col_struct.a", (Object)"key2".getBytes(), (Object)"col_struct.b.b2", (Object)"key1".getBytes());
        Assert.assertTrue((boolean)encryptionInformation.isPresent());
        Assert.assertEquals(encryptionInformation.get(), (Object)EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forPerField((Map)expectedFieldToKeyData, (Map)ImmutableMap.of((Object)"test.extra.metadata", (Object)table.getTableName()), (String)"algo", (String)"provider")));
    }

    @Test
    public void testGetWriteEncryptionInformation() {
        Optional encryptionInformation = this.encryptionInformationSource.getWriteEncryptionInformation(HiveTestUtils.SESSION, (TableEncryptionProperties)DwrfTableEncryptionProperties.forTable((String)"table_level", (String)"algo", (String)"provider"), "dbName", "tableName");
        Assert.assertTrue((boolean)encryptionInformation.isPresent());
        Assert.assertEquals(encryptionInformation.get(), (Object)EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forTable((byte[])"table_level".getBytes(), (Map)ImmutableMap.of((Object)"test.extra.metadata", (Object)"algo"), (String)"algo", (String)"provider")));
    }

    private static final class NonDwrfTableEncryptionProperties
    extends TableEncryptionProperties {
        NonDwrfTableEncryptionProperties() {
            super(Optional.of("foo"), Optional.empty());
        }
    }
}

