/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.BackgroundHiveSplitLoader;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.CacheQuotaRequirement;
import com.facebook.presto.hive.CacheQuotaScope;
import com.facebook.presto.hive.CachingDirectoryLister;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HadoopDirectoryLister;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitLoader;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.StoragePartitionLoader;
import com.facebook.presto.hive.TableToPartitionMapping;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.Test;

public class TestBackgroundHiveSplitLoader {
    private static final int BUCKET_COUNT = 2;
    private static final String SAMPLE_PATH = "hdfs://VOL1:9000/db_name/table_name/000000_0";
    private static final String SAMPLE_PATH_FILTERED = "hdfs://VOL1:9000/db_name/table_name/000000_1";
    private static final Path RETURNED_PATH = new Path("hdfs://VOL1:9000/db_name/table_name/000000_0");
    private static final Path FILTERED_PATH = new Path("hdfs://VOL1:9000/db_name/table_name/000000_1");
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));
    private static final Domain RETURNED_PATH_DOMAIN = Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)RETURNED_PATH.toString()));
    private static final List<LocatedFileStatus> TEST_FILES = ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(RETURNED_PATH, 0L), (Object)TestBackgroundHiveSplitLoader.locatedFileStatus(FILTERED_PATH, 0L));
    private static final String PARTITION_COLUMN_NAME = "partitionColumn";
    private static final List<Column> PARTITION_COLUMNS = ImmutableList.of((Object)new Column("partitionColumn", HiveType.HIVE_INT, Optional.empty(), Optional.empty()));
    private static final List<HiveColumnHandle> BUCKET_COLUMN_HANDLES = ImmutableList.of((Object)new HiveColumnHandle("col1", HiveType.HIVE_INT, IntegerType.INTEGER.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
    private static final Optional<HiveBucketProperty> BUCKET_PROPERTY = Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"col1"), 2, (List)ImmutableList.of(), BucketFunctionType.HIVE_COMPATIBLE, Optional.empty()));
    private static final Table SIMPLE_TABLE = TestBackgroundHiveSplitLoader.table((List<Column>)ImmutableList.of(), Optional.empty());
    private static final Table PARTITIONED_TABLE = TestBackgroundHiveSplitLoader.table(PARTITION_COLUMNS, BUCKET_PROPERTY);

    @Test
    public void testNoPathFilter() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader(TEST_FILES, Optional.empty());
        HiveSplitSource hiveSplitSource = TestBackgroundHiveSplitLoader.hiveSplitSource(backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drain(hiveSplitSource).size(), (int)2);
    }

    @Test
    public void testPathFilter() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader(TEST_FILES, Optional.of(RETURNED_PATH_DOMAIN));
        HiveSplitSource hiveSplitSource = TestBackgroundHiveSplitLoader.hiveSplitSource(backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> paths = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertEquals((int)paths.size(), (int)1);
        Assert.assertEquals((String)paths.get(0), (String)RETURNED_PATH.toString());
    }

    @Test
    public void testPathFilterOneBucketMatchPartitionedTable() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader(TEST_FILES, Optional.of(RETURNED_PATH_DOMAIN), Optional.of(new HiveBucketing.HiveBucketFilter((Set)ImmutableSet.of((Object)0, (Object)1))), PARTITIONED_TABLE, Optional.of(new HiveBucketHandle(BUCKET_COLUMN_HANDLES, 2, 2)));
        HiveSplitSource hiveSplitSource = TestBackgroundHiveSplitLoader.hiveSplitSource(backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> paths = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertEquals((int)paths.size(), (int)1);
        Assert.assertEquals((String)paths.get(0), (String)RETURNED_PATH.toString());
    }

    @Test
    public void testPathFilterBucketedPartitionedTable() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader(TEST_FILES, Optional.of(RETURNED_PATH_DOMAIN), Optional.empty(), PARTITIONED_TABLE, Optional.of(new HiveBucketHandle(HiveUtil.getRegularColumnHandles((Table)PARTITIONED_TABLE), 2, 2)));
        HiveSplitSource hiveSplitSource = TestBackgroundHiveSplitLoader.hiveSplitSource(backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> paths = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertEquals((int)paths.size(), (int)1);
        Assert.assertEquals((String)paths.get(0), (String)RETURNED_PATH.toString());
    }

    @Test
    public void testEmptyFileWithNoBlocks() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader((List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatusWithNoBlocks(RETURNED_PATH)), Optional.empty());
        HiveSplitSource hiveSplitSource = TestBackgroundHiveSplitLoader.hiveSplitSource(backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<HiveSplit> splits = TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
        Assert.assertEquals((int)splits.size(), (int)1);
        Assert.assertEquals((String)splits.get(0).getFileSplit().getPath(), (String)RETURNED_PATH.toString());
        Assert.assertEquals((long)splits.get(0).getFileSplit().getLength(), (long)0L);
    }

    @Test
    public void testNoHangIfPartitionIsOffline() {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoaderOfflinePartitions();
        HiveSplitSource hiveSplitSource = TestBackgroundHiveSplitLoader.hiveSplitSource(backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertThrows(RuntimeException.class, () -> TestBackgroundHiveSplitLoader.drain(hiveSplitSource));
        Assert.assertThrows(RuntimeException.class, () -> ((HiveSplitSource)hiveSplitSource).isFinished());
    }

    @Test
    public void testUnsupportedTableFormat() throws Exception {
        StorageFormat storageFormat = StorageFormat.create((String)"NonExistentSerde", (String)"NonExistentInputFormat", (String)"NonExistentOutputFormat");
        Table unsupportedTable = TestBackgroundHiveSplitLoader.table(PARTITION_COLUMNS, Optional.empty(), storageFormat);
        String partitionId = "partitionColumn=Partition_Value";
        ImmutableList hivePartitionMetadatas = ImmutableList.of((Object)new HivePartitionMetadata(new HivePartition(unsupportedTable.getSchemaTableName(), partitionId, (Map)ImmutableMap.of()), Optional.of(TestBackgroundHiveSplitLoader.orcPartition()), TableToPartitionMapping.empty(), Optional.empty(), (Set)ImmutableSet.of()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader(HiveTestUtils.SESSION, (List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(new Path(SAMPLE_PATH), HiveSessionProperties.getMaxInitialSplitSize((ConnectorSession)HiveTestUtils.SESSION).toBytes())), Optional.empty(), Optional.empty(), unsupportedTable, Optional.empty(), (List<HivePartitionMetadata>)hivePartitionMetadatas);
        HiveSplitSource hiveSplitSource = TestBackgroundHiveSplitLoader.hiveSplitSource(backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource).size(), (int)1);
    }

    private static Partition orcPartition() {
        return new Partition("test_db", "test_table", PARTITION_COLUMNS.stream().map(x -> "Partition_Value").collect(Collectors.toList()), new Storage(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC), "location", Optional.empty(), true, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), PARTITION_COLUMNS, (Map)ImmutableMap.of(), Optional.empty(), false, true, 0, 0L);
    }

    @Test
    public void testCachingDirectoryLister() throws Exception {
        this.testCachingDirectoryLister(new CachingDirectoryLister((DirectoryLister)new HadoopDirectoryLister(), new Duration(5.0, TimeUnit.MINUTES), 1000L, (List)ImmutableList.of((Object)"test_dbname.test_table")), "test_dbname.test_table");
        this.testCachingDirectoryLister(new CachingDirectoryLister((DirectoryLister)new HadoopDirectoryLister(), new Duration(5.0, TimeUnit.MINUTES), 1000L, (List)ImmutableList.of((Object)"*")), "*");
        this.testCachingDirectoryLister(new CachingDirectoryLister((DirectoryLister)new HadoopDirectoryLister(), new Duration(5.0, TimeUnit.MINUTES), 1000L, (List)ImmutableList.of((Object)"*")), "");
        Assert.assertThrows(IllegalArgumentException.class, () -> this.testCachingDirectoryLister(new CachingDirectoryLister((DirectoryLister)new HadoopDirectoryLister(), new Duration(5.0, TimeUnit.MINUTES), 1000L, (List)ImmutableList.of((Object)"*", (Object)"test_dbname.test_table")), "*,test_dbname.test_table"));
    }

    @Test
    public void testSplittableNotCheckedOnSmallFiles() throws Exception {
        DataSize initialSplitSize = HiveSessionProperties.getMaxInitialSplitSize((ConnectorSession)HiveTestUtils.SESSION);
        StorageFormat splittableStorageFormat = StorageFormat.create((String)LazySimpleSerDe.class.getName(), (String)TestSplittableFailureInputFormat.class.getName(), (String)TestSplittableFailureInputFormat.class.getName());
        Table table = TestBackgroundHiveSplitLoader.table((List<Column>)ImmutableList.of(), Optional.empty(), splittableStorageFormat);
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader(HiveTestUtils.SESSION, (List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(new Path(SAMPLE_PATH), initialSplitSize.toBytes())), Optional.empty(), Optional.empty(), table, Optional.empty(), TestBackgroundHiveSplitLoader.samplePartitionMetadatas());
        HiveSplitSource hiveSplitSource = TestBackgroundHiveSplitLoader.hiveSplitSource(backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource).size(), (int)1);
        backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader(HiveTestUtils.SESSION, (List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(new Path(SAMPLE_PATH), initialSplitSize.toBytes() + 1L)), Optional.empty(), Optional.empty(), table, Optional.empty(), TestBackgroundHiveSplitLoader.samplePartitionMetadatas());
        hiveSplitSource = TestBackgroundHiveSplitLoader.hiveSplitSource(backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        try {
            TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
            FileAssert.fail((String)"Expected split generation to call isSplittable and fail");
        }
        catch (PrestoException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            Assert.assertTrue((boolean)(cause instanceof IllegalStateException));
            Assert.assertEquals((String)cause.getMessage(), (String)"isSplittable called");
        }
    }

    @Test
    public void testTextInputHeaderFooterSplitCounts() throws Exception {
        DataSize fileSize = new DataSize(2.0, DataSize.Unit.GIGABYTE);
        this.assertTextFileSplitCount(fileSize, (Map<String, String>)ImmutableMap.of(), 33);
        this.assertTextFileSplitCount(fileSize, (Map<String, String>)ImmutableMap.of((Object)"skip.header.line.count", (Object)"1"), 33);
        this.assertTextFileSplitCount(fileSize, (Map<String, String>)ImmutableMap.of((Object)"skip.header.line.count", (Object)"2"), 1);
        this.assertTextFileSplitCount(fileSize, (Map<String, String>)ImmutableMap.of((Object)"skip.footer.line.count", (Object)"1"), 1);
        this.assertTextFileSplitCount(fileSize, (Map<String, String>)ImmutableMap.of((Object)"skip.header.line.count", (Object)"1", (Object)"skip.footer.line.count", (Object)"1"), 1);
    }

    private void assertTextFileSplitCount(DataSize fileSize, Map<String, String> tableProperties, int expectedSplitCount) throws Exception {
        Table.Builder tableBuilder = Table.builder((Table)SIMPLE_TABLE).setParameters((Map)ImmutableMap.copyOf(tableProperties));
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.TEXTFILE));
        Table table = tableBuilder.build();
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader((List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(new Path(SAMPLE_PATH), fileSize.toBytes())), Optional.empty(), Optional.empty(), table, Optional.empty());
        HiveSplitSource hiveSplitSource = TestBackgroundHiveSplitLoader.hiveSplitSource(backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource).size(), (int)expectedSplitCount);
    }

    private void testCachingDirectoryLister(CachingDirectoryLister cachingDirectoryLister, String fileStatusCacheTables) throws Exception {
        Assert.assertEquals((long)cachingDirectoryLister.getRequestCount(), (long)0L);
        int totalCount = 50;
        CountDownLatch firstVisit = new CountDownLatch(1);
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
        futures.add(EXECUTOR.submit(() -> {
            BackgroundHiveSplitLoader backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader(TEST_FILES, (DirectoryLister)cachingDirectoryLister, fileStatusCacheTables);
            HiveSplitSource hiveSplitSource = TestBackgroundHiveSplitLoader.hiveSplitSource(backgroundHiveSplitLoader);
            backgroundHiveSplitLoader.start(hiveSplitSource);
            try {
                List<HiveSplit> list = TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
                return list;
            }
            finally {
                firstVisit.countDown();
            }
        }));
        for (int i = 0; i < totalCount - 1; ++i) {
            futures.add(EXECUTOR.submit(() -> {
                firstVisit.await();
                BackgroundHiveSplitLoader backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader(TEST_FILES, (DirectoryLister)cachingDirectoryLister, fileStatusCacheTables);
                HiveSplitSource hiveSplitSource = TestBackgroundHiveSplitLoader.hiveSplitSource(backgroundHiveSplitLoader);
                backgroundHiveSplitLoader.start(hiveSplitSource);
                return TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
            }));
        }
        for (Future future : futures) {
            Assert.assertEquals((int)((List)future.get()).size(), (int)TEST_FILES.size());
        }
        if (fileStatusCacheTables.length() == 0) {
            Assert.assertEquals((long)cachingDirectoryLister.getRequestCount(), (long)0L);
            Assert.assertEquals((long)cachingDirectoryLister.getHitCount(), (long)0L);
            Assert.assertEquals((long)cachingDirectoryLister.getMissCount(), (long)0L);
        } else {
            Assert.assertEquals((long)cachingDirectoryLister.getRequestCount(), (long)totalCount);
            Assert.assertEquals((long)cachingDirectoryLister.getHitCount(), (long)(totalCount - 1));
            Assert.assertEquals((long)cachingDirectoryLister.getMissCount(), (long)1L);
        }
    }

    private static List<String> drain(HiveSplitSource source) throws Exception {
        return (List)TestBackgroundHiveSplitLoader.drainSplits(source).stream().map(HiveSplit::getFileSplit).map(HiveFileSplit::getPath).collect(ImmutableList.toImmutableList());
    }

    private static List<HiveSplit> drainSplits(HiveSplitSource source) throws Exception {
        ImmutableList.Builder splits = ImmutableList.builder();
        while (!source.isFinished()) {
            ((ConnectorSplitSource.ConnectorSplitBatch)source.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, 100).get()).getSplits().stream().map(HiveSplit.class::cast).forEach(arg_0 -> ((ImmutableList.Builder)splits).add(arg_0));
        }
        return splits.build();
    }

    private static BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<LocatedFileStatus> files, Optional<Domain> pathDomain) {
        return TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader(files, pathDomain, Optional.empty(), SIMPLE_TABLE, Optional.empty());
    }

    private static BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<LocatedFileStatus> files, Optional<Domain> pathDomain, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveBucketHandle> bucketHandle) {
        TestingConnectorSession connectorSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setMaxSplitSize(new DataSize(1.0, DataSize.Unit.GIGABYTE)), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        return TestBackgroundHiveSplitLoader.backgroundHiveSplitLoader((ConnectorSession)connectorSession, files, pathDomain, hiveBucketFilter, table, bucketHandle, TestBackgroundHiveSplitLoader.samplePartitionMetadatas());
    }

    private static BackgroundHiveSplitLoader backgroundHiveSplitLoader(ConnectorSession connectorSession, List<LocatedFileStatus> files, Optional<Domain> pathDomain, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveBucketHandle> bucketHandle, List<HivePartitionMetadata> hivePartitionMetadatas) {
        return new BackgroundHiveSplitLoader(table, hivePartitionMetadatas, pathDomain, StoragePartitionLoader.BucketSplitInfo.createBucketSplitInfo(bucketHandle, hiveBucketFilter), connectorSession, (HdfsEnvironment)new TestingHdfsEnvironment(files), new NamenodeStats(), (DirectoryLister)new CachingDirectoryLister((DirectoryLister)new HadoopDirectoryLister(), new HiveClientConfig()), (Executor)EXECUTOR, 2, false, false, false);
    }

    private static List<HivePartitionMetadata> samplePartitionMetadatas() {
        return ImmutableList.of((Object)new HivePartitionMetadata(new HivePartition(new SchemaTableName("testSchema", "table_name")), Optional.empty(), TableToPartitionMapping.empty(), Optional.empty(), (Set)ImmutableSet.of()));
    }

    private static BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<LocatedFileStatus> files, DirectoryLister directoryLister, String fileStatusCacheTables) {
        TestingConnectorSession connectorSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setMaxSplitSize(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setFileStatusCacheTables(fileStatusCacheTables), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        return new BackgroundHiveSplitLoader(SIMPLE_TABLE, TestBackgroundHiveSplitLoader.samplePartitionMetadatas(), Optional.empty(), StoragePartitionLoader.BucketSplitInfo.createBucketSplitInfo(Optional.empty(), Optional.empty()), (ConnectorSession)connectorSession, (HdfsEnvironment)new TestingHdfsEnvironment(files), new NamenodeStats(), directoryLister, (Executor)EXECUTOR, 2, false, false, false);
    }

    private static BackgroundHiveSplitLoader backgroundHiveSplitLoaderOfflinePartitions() {
        TestingConnectorSession connectorSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setMaxSplitSize(new DataSize(1.0, DataSize.Unit.GIGABYTE)), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        return new BackgroundHiveSplitLoader(SIMPLE_TABLE, TestBackgroundHiveSplitLoader.createPartitionMetadataWithOfflinePartitions(), Optional.empty(), StoragePartitionLoader.BucketSplitInfo.createBucketSplitInfo(Optional.empty(), Optional.empty()), (ConnectorSession)connectorSession, (HdfsEnvironment)new TestingHdfsEnvironment(TEST_FILES), new NamenodeStats(), (DirectoryLister)new CachingDirectoryLister((DirectoryLister)new HadoopDirectoryLister(), new HiveClientConfig()), MoreExecutors.directExecutor(), 2, false, false, false);
    }

    private static Iterable<HivePartitionMetadata> createPartitionMetadataWithOfflinePartitions() throws RuntimeException {
        return () -> new AbstractIterator<HivePartitionMetadata>(){
            private int position = -1;

            protected HivePartitionMetadata computeNext() {
                ++this.position;
                switch (this.position) {
                    case 0: {
                        return new HivePartitionMetadata(new HivePartition(new SchemaTableName("testSchema", "table_name")), Optional.empty(), TableToPartitionMapping.empty(), Optional.empty(), (Set)ImmutableSet.of());
                    }
                    case 1: {
                        throw new RuntimeException("OFFLINE");
                    }
                }
                return (HivePartitionMetadata)this.endOfData();
            }
        };
    }

    private static HiveSplitSource hiveSplitSource(BackgroundHiveSplitLoader backgroundHiveSplitLoader) {
        return HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)SIMPLE_TABLE.getDatabaseName(), (String)SIMPLE_TABLE.getTableName(), (CacheQuotaRequirement)new CacheQuotaRequirement(CacheQuotaScope.GLOBAL, Optional.empty()), (int)1, (int)1, (DataSize)new DataSize(32.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)backgroundHiveSplitLoader, (Executor)EXECUTOR, (CounterStat)new CounterStat());
    }

    private static Table table(List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty) {
        return TestBackgroundHiveSplitLoader.table(partitionColumns, bucketProperty, StorageFormat.create((String)"com.facebook.hive.orc.OrcSerde", (String)"org.apache.hadoop.hive.ql.io.RCFileInputFormat", (String)"org.apache.hadoop.hive.ql.io.RCFileInputFormat"));
    }

    private static Table table(List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, StorageFormat storageFormat) {
        Table.Builder tableBuilder = Table.builder();
        tableBuilder.getStorageBuilder().setStorageFormat(storageFormat).setLocation("hdfs://VOL1:9000/db_name/table_name").setSkewed(false).setBucketProperty(bucketProperty);
        return tableBuilder.setDatabaseName("test_dbname").setOwner("testOwner").setTableName("test_table").setTableType(PrestoTableType.MANAGED_TABLE).setDataColumns((List)ImmutableList.of((Object)new Column("col1", HiveType.HIVE_STRING, Optional.empty(), Optional.empty()))).setParameters((Map)ImmutableMap.of()).setPartitionColumns(partitionColumns).build();
    }

    private static LocatedFileStatus locatedFileStatus(Path path, long fileSize) {
        return new LocatedFileStatus(fileSize, false, 0, 0L, 0L, 0L, null, null, null, null, path, new BlockLocation[]{new BlockLocation(new String[1], new String[]{"localhost"}, 0L, fileSize)});
    }

    private static LocatedFileStatus locatedFileStatusWithNoBlocks(Path path) {
        return new LocatedFileStatus(0L, false, 0, 0L, 0L, 0L, null, null, null, null, path, new BlockLocation[0]);
    }

    private static class TestingHdfsFileSystem
    extends ExtendedFileSystem {
        private final List<LocatedFileStatus> files;

        public TestingHdfsFileSystem(List<LocatedFileStatus> files) {
            this.files = ImmutableList.copyOf(files);
        }

        public boolean delete(Path f, boolean recursive) {
            throw new UnsupportedOperationException();
        }

        public boolean rename(Path src, Path dst) {
            throw new UnsupportedOperationException();
        }

        public void setWorkingDirectory(Path dir) {
            throw new UnsupportedOperationException();
        }

        public FileStatus[] listStatus(Path f) {
            throw new UnsupportedOperationException();
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) {
            return new RemoteIterator<LocatedFileStatus>(){
                private final Iterator<LocatedFileStatus> iterator;
                {
                    this.iterator = files.iterator();
                }

                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                public LocatedFileStatus next() {
                    return this.iterator.next();
                }
            };
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
            throw new UnsupportedOperationException();
        }

        public boolean mkdirs(Path f, FsPermission permission) {
            throw new UnsupportedOperationException();
        }

        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
            throw new UnsupportedOperationException();
        }

        public FSDataInputStream open(Path f, int bufferSize) {
            throw new UnsupportedOperationException();
        }

        public FileStatus getFileStatus(Path f) {
            throw new UnsupportedOperationException();
        }

        public Path getWorkingDirectory() {
            throw new UnsupportedOperationException();
        }

        public URI getUri() {
            throw new UnsupportedOperationException();
        }
    }

    public static class TestingHdfsEnvironment
    extends HdfsEnvironment {
        private final List<LocatedFileStatus> files;

        public TestingHdfsEnvironment(List<LocatedFileStatus> files) {
            super((HdfsConfiguration)new HiveHdfsConfiguration(new HdfsConfigurationInitializer(new HiveClientConfig(), new MetastoreClientConfig()), (Set)ImmutableSet.of(), new HiveClientConfig()), new MetastoreClientConfig(), (HdfsAuthentication)new NoHdfsAuthentication());
            this.files = ImmutableList.copyOf(files);
        }

        public ExtendedFileSystem getFileSystem(String user, Path path, Configuration configuration) {
            return new TestingHdfsFileSystem(this.files);
        }
    }

    public static final class TestSplittableFailureInputFormat
    extends FileInputFormat<Void, Void> {
        protected boolean isSplitable(FileSystem fs, Path filename) {
            throw new IllegalStateException("isSplittable called");
        }

        public RecordReader<Void, Void> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) {
            throw new UnsupportedOperationException();
        }
    }
}

