/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.CopyOnFirstWriteConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCopyOnFirstWriteConfiguration {
    private static final String TEST_KEY = "test-key";
    private static final String TEST_VALUE = "test-value";
    private static final String TEST_UPDATED_VALUE = "test-updated-value";
    private static final String TEST_KEY_INT = "test-key-int";
    private static final int TEST_VALUE_INT = 1;

    @Test
    public void testCopyOnWriteConfiguration() {
        Configuration originalConfig = new Configuration();
        originalConfig.set(TEST_KEY, TEST_VALUE);
        CopyOnFirstWriteConfiguration copyOnWriteConfig = new CopyOnFirstWriteConfiguration(originalConfig);
        Assert.assertEquals((String)originalConfig.get(TEST_KEY), (String)copyOnWriteConfig.get(TEST_KEY));
        Assert.assertEquals((String)TEST_VALUE, (String)copyOnWriteConfig.get(TEST_KEY));
        Assert.assertSame((Object)originalConfig, (Object)copyOnWriteConfig.getConfig());
        copyOnWriteConfig.set(TEST_KEY, TEST_UPDATED_VALUE);
        Assert.assertEquals((String)TEST_UPDATED_VALUE, (String)copyOnWriteConfig.get(TEST_KEY));
        Assert.assertNotEquals((Object)originalConfig.get(TEST_KEY), (Object)copyOnWriteConfig.get(TEST_KEY));
        Configuration configAfterUpdate1 = copyOnWriteConfig.getConfig();
        Assert.assertNotSame((Object)originalConfig, (Object)configAfterUpdate1);
        copyOnWriteConfig.setInt(TEST_KEY_INT, 1);
        Configuration configAfterUpdate2 = copyOnWriteConfig.getConfig();
        Assert.assertSame((Object)configAfterUpdate1, (Object)configAfterUpdate2);
    }
}

