/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.AbstractDwrfEncryptionInformationSource;
import com.facebook.presto.hive.ColumnEncryptionInformation;
import com.facebook.presto.hive.DwrfEncryptionMetadata;
import com.facebook.presto.hive.DwrfTableEncryptionProperties;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.EncryptionMetadata;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

class TestDwrfEncryptionInformationSource
extends AbstractDwrfEncryptionInformationSource {
    public static final String TEST_EXTRA_METADATA = "test.extra.metadata";

    TestDwrfEncryptionInformationSource() {
    }

    protected Map<String, EncryptionInformation> getReadEncryptionInformationInternal(ConnectorSession session, Table table, Optional<Set<HiveColumnHandle>> requestedColumns, Map<String, Partition> partitions, Map<String, String> fieldToKeyReference, DwrfTableEncryptionProperties encryptionProperties) {
        Map fieldToKeyData = (Map)fieldToKeyReference.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((String)entry.getValue()).getBytes()));
        return (Map)partitions.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), partitionName -> EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forPerField((Map)fieldToKeyData, (Map)ImmutableMap.of((Object)TEST_EXTRA_METADATA, (Object)partitionName), (String)encryptionProperties.getEncryptionAlgorithm(), (String)encryptionProperties.getEncryptionProvider()))));
    }

    protected EncryptionInformation getReadEncryptionInformationInternal(ConnectorSession session, Table table, Optional<Set<HiveColumnHandle>> requestedColumns, Map<String, String> fieldToKeyReference, DwrfTableEncryptionProperties encryptionProperties) {
        Map fieldToKeyData = (Map)fieldToKeyReference.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((String)entry.getValue()).getBytes()));
        return EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forPerField((Map)fieldToKeyData, (Map)ImmutableMap.of((Object)TEST_EXTRA_METADATA, (Object)table.getTableName()), (String)encryptionProperties.getEncryptionAlgorithm(), (String)encryptionProperties.getEncryptionProvider()));
    }

    protected EncryptionInformation getWriteEncryptionInformationInternal(ConnectorSession session, DwrfTableEncryptionProperties tableEncryptionProperties, String dbName, String tableName) {
        if (tableEncryptionProperties.getEncryptTable().isPresent()) {
            return EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forTable((byte[])((String)tableEncryptionProperties.getEncryptTable().get()).getBytes(), (Map)ImmutableMap.of((Object)TEST_EXTRA_METADATA, (Object)tableEncryptionProperties.getEncryptionAlgorithm()), (String)tableEncryptionProperties.getEncryptionAlgorithm(), (String)tableEncryptionProperties.getEncryptionProvider()));
        }
        if (tableEncryptionProperties.getColumnEncryptionInformation().isPresent()) {
            return EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forPerField((Map)((Map)((ColumnEncryptionInformation)tableEncryptionProperties.getColumnEncryptionInformation().get()).getColumnToKeyReference().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((ColumnEncryptionInformation.ColumnWithStructSubfield)entry.getKey()).toString(), entry -> ((String)entry.getValue()).getBytes()))), (Map)ImmutableMap.of((Object)TEST_EXTRA_METADATA, (Object)tableEncryptionProperties.getEncryptionAlgorithm()), (String)tableEncryptionProperties.getEncryptionAlgorithm(), (String)tableEncryptionProperties.getEncryptionProvider()));
        }
        throw new IllegalStateException("One of table or column property should have a non-empty value");
    }
}

