/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.DwrfEncryptionMetadata;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDwrfEncryptionMetadata {
    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Cannot have both table and column level settings. Given: \\[__TABLE__, foo\\]")
    public void testOnlyOneTableProperty() {
        new DwrfEncryptionMetadata((Map)ImmutableMap.of((Object)"__TABLE__", (Object)"abcd".getBytes(), (Object)"foo", (Object)"def".getBytes()), (Map)ImmutableMap.of(), "", "");
    }

    @Test
    public void testToKeyMap() {
        DwrfEncryptionMetadata dwrfEncryptionMetadata = new DwrfEncryptionMetadata((Map)ImmutableMap.of((Object)"c1", (Object)"abcd".getBytes(), (Object)"c3.d2.e1.f1", (Object)"def".getBytes(), (Object)"c3.d2.e2", (Object)"ghi".getBytes()), (Map)ImmutableMap.of(), "test_algo", "test_provider");
        ImmutableList columnHandleList = ImmutableList.of((Object)new HiveColumnHandle("c1", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"bigint"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("c3", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"bigint"), 2, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
        ImmutableList orcTypes = ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.STRUCT, (List)ImmutableList.of((Object)1, (Object)2, (Object)4), (List)ImmutableList.of((Object)"c1", (Object)"c2,", (Object)"c3"), Optional.empty(), Optional.empty(), Optional.empty()), (Object)new OrcType(OrcType.OrcTypeKind.INT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), (Object)new OrcType(OrcType.OrcTypeKind.STRUCT, (List)ImmutableList.of((Object)3), (List)ImmutableList.of((Object)"d1"), Optional.empty(), Optional.empty(), Optional.empty()), (Object)new OrcType(OrcType.OrcTypeKind.INT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), (Object)new OrcType(OrcType.OrcTypeKind.STRUCT, (List)ImmutableList.of((Object)5, (Object)6), (List)ImmutableList.of((Object)"d1", (Object)"d2"), Optional.empty(), Optional.empty(), Optional.empty()), (Object)new OrcType(OrcType.OrcTypeKind.INT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), (Object)new OrcType(OrcType.OrcTypeKind.STRUCT, (List)ImmutableList.of((Object)7, (Object)9), (List)ImmutableList.of((Object)"e1", (Object)"e2"), Optional.empty(), Optional.empty(), Optional.empty()), (Object)new OrcType(OrcType.OrcTypeKind.STRUCT, (List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)"f1"), Optional.empty(), Optional.empty(), Optional.empty()), (Object)new OrcType(OrcType.OrcTypeKind.INT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), (Object)new OrcType(OrcType.OrcTypeKind.INT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()));
        Map actualKeyMap = dwrfEncryptionMetadata.toKeyMap((List)orcTypes, (List)columnHandleList);
        ImmutableMap expectedKeyMap = ImmutableMap.of((Object)1, (Object)Slices.wrappedBuffer((byte[])"abcd".getBytes()), (Object)8, (Object)Slices.wrappedBuffer((byte[])"def".getBytes()), (Object)9, (Object)Slices.wrappedBuffer((byte[])"ghi".getBytes()));
        Assert.assertEquals((Map)actualKeyMap, (Map)expectedKeyMap);
    }

    @Test
    public void testWholeTable() {
        DwrfEncryptionMetadata dwrfEncryptionMetadata = new DwrfEncryptionMetadata((Map)ImmutableMap.of((Object)"__TABLE__", (Object)"abcd".getBytes()), (Map)ImmutableMap.of(), "test_algo", "test_provider");
        ImmutableList columnHandleList = ImmutableList.of((Object)new HiveColumnHandle("c1", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"bigint"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("c2", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"bigint"), 2, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
        ImmutableList orcTypes = ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.INT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), (Object)new OrcType(OrcType.OrcTypeKind.INT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()));
        Map actualKeyMap = dwrfEncryptionMetadata.toKeyMap((List)orcTypes, (List)columnHandleList);
        ImmutableMap expectedKeyMap = ImmutableMap.of((Object)0, (Object)Slices.wrappedBuffer((byte[])"abcd".getBytes()));
        Assert.assertEquals((Map)actualKeyMap, (Map)expectedKeyMap);
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testInvalidKeyMap() {
        DwrfEncryptionMetadata dwrfEncryptionMetadata = new DwrfEncryptionMetadata((Map)ImmutableMap.of((Object)"c1", (Object)"abcd".getBytes()), (Map)ImmutableMap.of(), "test_algo", "test_provider");
        ImmutableList columnHandleList = ImmutableList.of((Object)new HiveColumnHandle("column1", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"bigint"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
        ImmutableList orcTypes = ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.STRUCT, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)"column1"), Optional.empty(), Optional.empty(), Optional.empty()), (Object)new OrcType(OrcType.OrcTypeKind.INT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()));
        dwrfEncryptionMetadata.toKeyMap((List)orcTypes, (List)columnHandleList);
    }
}

