/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.testing.TempFile;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.CacheQuotaRequirement;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveEmptySplitPageSource;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HivePageSource;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.TableToPartitionMapping;
import com.facebook.presto.hive.TestHivePageSink;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDynamicPruning {
    private static final String SCHEMA_NAME = "test";
    private static final String TABLE_NAME = "test";
    private static final Column BUCKET_COLUMN = new Column("l_orderkey", HiveType.HIVE_INT, Optional.empty(), Optional.empty());
    private static final Column PARTITION_COLUMN = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
    private static final HiveColumnHandle PARTITION_HIVE_COLUMN_HANDLE = new HiveColumnHandle("ds", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 1, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty(), (List)ImmutableList.of(), Optional.empty());

    @Test
    public void testDynamicBucketPruning() {
        HiveClientConfig config = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        HiveTransactionHandle transaction = new HiveTransactionHandle();
        try (TempFile tempFile = new TempFile();){
            ConnectorPageSource emptyPageSource = TestDynamicPruning.createTestingPageSource(transaction, config, new SplitContext(false, this.getToSkipTupleDomainForPartition()), metastoreClientConfig, tempFile.file());
            Assert.assertEquals(emptyPageSource.getClass(), HiveEmptySplitPageSource.class);
            ConnectorPageSource nonEmptyPageSource = TestDynamicPruning.createTestingPageSource(transaction, config, new SplitContext(false, this.getToKeepTupleDomainForPartition()), metastoreClientConfig, tempFile.file());
            Assert.assertEquals(nonEmptyPageSource.getClass(), HivePageSource.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testDynamicPartitionPruning() {
        HiveClientConfig config = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        HiveTransactionHandle transaction = new HiveTransactionHandle();
        try (TempFile tempFile = new TempFile();){
            ConnectorPageSource emptyPageSource = TestDynamicPruning.createTestingPageSource(transaction, config, new SplitContext(false, TestDynamicPruning.getToSkipTupleDomain()), metastoreClientConfig, tempFile.file());
            Assert.assertEquals(emptyPageSource.getClass(), HiveEmptySplitPageSource.class);
            ConnectorPageSource nonEmptyPageSource = TestDynamicPruning.createTestingPageSource(transaction, config, new SplitContext(false, TestDynamicPruning.getToKeepTupleDomain()), metastoreClientConfig, tempFile.file());
            Assert.assertEquals(nonEmptyPageSource.getClass(), HivePageSource.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private static ConnectorPageSource createTestingPageSource(HiveTransactionHandle transaction, HiveClientConfig config, SplitContext splitContext, MetastoreClientConfig metastoreClientConfig, File outputFile) {
        ImmutableList partitionKeys = ImmutableList.of((Object)new HivePartitionKey(PARTITION_COLUMN.getName(), Optional.of("2020-09-09")));
        ImmutableMap partitionSchemaDifference = ImmutableMap.of((Object)1, (Object)new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty()));
        HiveFileSplit fileSplit = new HiveFileSplit("file:///" + outputFile.getAbsolutePath(), 0L, outputFile.length(), outputFile.length(), Instant.now().toEpochMilli(), Optional.empty(), (Map)ImmutableMap.of());
        HiveSplit split = new HiveSplit(fileSplit, "test", "test", "", new Storage(StorageFormat.create((String)config.getHiveStorageFormat().getSerDe(), (String)config.getHiveStorageFormat().getInputFormat(), (String)config.getHiveStorageFormat().getOutputFormat()), "location", Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"l_orderkey"), 10, (List)ImmutableList.of(), BucketFunctionType.HIVE_COMPATIBLE, Optional.empty())), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (List)partitionKeys, (List)ImmutableList.of(), OptionalInt.of(1), OptionalInt.of(1), NodeSelectionStrategy.NO_PREFERENCE, TestHivePageSink.getColumnHandles().size(), TableToPartitionMapping.mapColumnsByIndex((Map)partitionSchemaDifference), Optional.empty(), false, CacheQuotaRequirement.NO_CACHE_REQUIREMENT, Optional.empty(), (Set)ImmutableSet.of(), SplitWeight.standard());
        HiveTableHandle hiveTableHandle = new HiveTableHandle("test", "test");
        HiveTableLayoutHandle tableLayoutHandle = new HiveTableLayoutHandle.Builder().setSchemaTableName(new SchemaTableName("test", "test")).setTablePath("path").setPartitionColumns((List)ImmutableList.of((Object)PARTITION_HIVE_COLUMN_HANDLE)).setDataColumns((List)TestHivePageSink.getColumnHandles().stream().map(column -> new Column(column.getName(), column.getHiveType(), Optional.empty(), Optional.empty())).collect(ImmutableList.toImmutableList())).setTableParameters((Map)ImmutableMap.of()).setDomainPredicate(TupleDomain.all()).setRemainingPredicate((RowExpression)LogicalRowExpressions.TRUE_CONSTANT).setPredicateColumns((Map)ImmutableMap.of()).setPartitionColumnPredicate(TupleDomain.all()).setBucketHandle(Optional.empty()).setBucketFilter(Optional.empty()).setPushdownFilterEnabled(false).setLayoutString("layout").setRequestedColumns(Optional.empty()).setPartialAggregationsPushedDown(false).setAppendRowNumberEnabled(false).setPartitions(Optional.empty()).setHiveTableHandle(hiveTableHandle).build();
        TableHandle tableHandle = new TableHandle(new ConnectorId("hive"), (ConnectorTableHandle)hiveTableHandle, (ConnectorTransactionHandle)transaction, Optional.of(tableLayoutHandle));
        HivePageSourceProvider provider = new HivePageSourceProvider(config, HiveTestUtils.createTestHdfsEnvironment(config, metastoreClientConfig), HiveTestUtils.getDefaultHiveRecordCursorProvider(config, metastoreClientConfig), HiveTestUtils.getDefaultHiveBatchPageSourceFactories(config, metastoreClientConfig), HiveTestUtils.getDefaultHiveSelectivePageSourceFactories(config, metastoreClientConfig), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.ROW_EXPRESSION_SERVICE);
        return provider.createPageSource((ConnectorTransactionHandle)transaction, (ConnectorSession)TestDynamicPruning.getSession(config), (ConnectorSplit)split, (ConnectorTableLayoutHandle)tableHandle.getLayout().get(), (List)ImmutableList.copyOf(TestHivePageSink.getColumnHandles()), splitContext);
    }

    private static TupleDomain<ColumnHandle> getToSkipTupleDomain() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new HiveColumnHandle(BUCKET_COLUMN.getName(), BUCKET_COLUMN.getType(), TypeSignature.parseTypeSignature((String)"varchar"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L)));
    }

    private TupleDomain<ColumnHandle> getToSkipTupleDomainForPartition() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new HiveColumnHandle(PARTITION_COLUMN.getName(), PARTITION_COLUMN.getType(), TypeSignature.parseTypeSignature((String)"varchar"), 1, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty(), Optional.empty()), (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)15), (Object)Slices.utf8Slice((String)"2020-09-08"))));
    }

    private static TupleDomain<ColumnHandle> getToKeepTupleDomain() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new HiveColumnHandle(BUCKET_COLUMN.getName(), BUCKET_COLUMN.getType(), TypeSignature.parseTypeSignature((String)"varchar"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
    }

    private TupleDomain<ColumnHandle> getToKeepTupleDomainForPartition() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new HiveColumnHandle(PARTITION_COLUMN.getName(), PARTITION_COLUMN.getType(), TypeSignature.parseTypeSignature((String)"varchar"), 1, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty(), Optional.empty()), (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)15), (Object)Slices.utf8Slice((String)"2020-09-09"))));
    }

    private static TestingConnectorSession getSession(HiveClientConfig config) {
        return new TestingConnectorSession(new HiveSessionProperties(config, new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
    }
}

