/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.spi.eventlistener.EventListenerFactory;
import com.facebook.presto.spi.eventlistener.QueryCompletedEvent;
import com.facebook.presto.spi.eventlistener.QueryCreatedEvent;
import com.facebook.presto.spi.eventlistener.QueryMetadata;
import com.facebook.presto.spi.eventlistener.SplitCompletedEvent;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.tpch.TpchTable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestEventListenerWithExchangeMaterialization {
    private EventsBuilder generatedEvents = new EventsBuilder();
    private DistributedQueryRunner queryRunner;
    private Session session;

    @BeforeClass
    private void setUp() throws Exception {
        this.queryRunner = HiveQueryRunner.createQueryRunner(TpchTable.getTables(), (Map<String, String>)new ImmutableMap.Builder().put((Object)"query.partitioning-provider-catalog", (Object)"hive").put((Object)"query.exchange-materialization-strategy", (Object)"ALL").put((Object)"experimental.runtime-optimizer-enabled", (Object)"true").put((Object)"experimental.enable-stats-collection-for-temporary-table", (Object)"true").put((Object)"join-distribution-type", (Object)"PARTITIONED").put((Object)"optimizer.join-reordering-strategy", (Object)"ELIMINATE_CROSS_JOINS").put((Object)"query.hash-partition-count", (Object)"11").put((Object)"colocated-joins-enabled", (Object)"true").put((Object)"grouped-execution-enabled", (Object)"true").build(), Optional.empty());
        this.queryRunner.installPlugin((Plugin)new TestingEventListenerPlugin(this.generatedEvents));
        this.session = this.queryRunner.getDefaultSession();
        this.generatedEvents.initialize(16);
        this.generatedEvents.waitForEvents(180);
    }

    @AfterClass(alwaysRun=true)
    private void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
        this.session = null;
        this.generatedEvents = null;
    }

    private QueryId runQueryAndWaitForEvents(@Language(value="SQL") String sql, int numEventsExpected) throws Exception {
        this.generatedEvents.initialize(numEventsExpected);
        QueryId resultId = this.queryRunner.executeWithQueryId(this.session, sql).getQueryId();
        this.generatedEvents.waitForEvents(600);
        return resultId;
    }

    @Test
    public void testRuntimeOptimizedStagesCorrectness() throws Exception {
        int expectedEvents = 2;
        QueryId queryId = this.runQueryAndWaitForEvents("SELECT phone, regionkey FROM nation INNER JOIN supplier ON supplier.nationkey=nation.nationkey", expectedEvents);
        QueryCreatedEvent queryCreatedEvent = (QueryCreatedEvent)Iterables.getOnlyElement(this.generatedEvents.getQueryCreatedEvents());
        QueryCompletedEvent queryCompletedEvent = (QueryCompletedEvent)Iterables.getOnlyElement(this.generatedEvents.getQueryCompletedEvents());
        QueryMetadata queryMetadata = queryCompletedEvent.getMetadata();
        Optional runtimeOptimizedStages = this.queryRunner.getCoordinator().getQueryManager().getFullQueryInfo(new QueryId(queryCreatedEvent.getMetadata().getQueryId())).getRuntimeOptimizedStages();
        Assert.assertEquals((String)queryMetadata.getQueryId(), (String)queryId.toString());
        Assert.assertEquals((int)queryMetadata.getRuntimeOptimizedStages().size(), (int)1);
        Assert.assertEquals((String)((String)queryMetadata.getRuntimeOptimizedStages().get(0)), (String)"1");
        Assert.assertTrue((boolean)runtimeOptimizedStages.isPresent());
        Assert.assertEquals((int)((List)runtimeOptimizedStages.get()).size(), (int)1);
        Assert.assertEquals((Collection)queryMetadata.getRuntimeOptimizedStages(), (Collection)((Collection)((List)runtimeOptimizedStages.get()).stream().map(stageId -> String.valueOf(stageId.getId())).collect(ImmutableList.toImmutableList())));
        this.runQueryAndWaitForEvents("SELECT phone, regionkey FROM supplier INNER JOIN nation ON supplier.nationkey=nation.nationkey", expectedEvents);
        queryCreatedEvent = (QueryCreatedEvent)Iterables.getOnlyElement(this.generatedEvents.getQueryCreatedEvents());
        queryCompletedEvent = (QueryCompletedEvent)Iterables.getOnlyElement(this.generatedEvents.getQueryCompletedEvents());
        runtimeOptimizedStages = this.queryRunner.getCoordinator().getQueryManager().getFullQueryInfo(new QueryId(queryCreatedEvent.getMetadata().getQueryId())).getRuntimeOptimizedStages();
        Assert.assertTrue((boolean)queryCompletedEvent.getMetadata().getRuntimeOptimizedStages().isEmpty());
        Assert.assertFalse((boolean)runtimeOptimizedStages.isPresent());
        this.runQueryAndWaitForEvents("SELECT supplier.phone, regionkey, custkey FROM nation INNER JOIN supplier ON supplier.nationkey=nation.nationkey INNER JOIN customer ON nation.nationkey=customer.nationkey", expectedEvents);
        queryCreatedEvent = (QueryCreatedEvent)Iterables.getOnlyElement(this.generatedEvents.getQueryCreatedEvents());
        queryCompletedEvent = (QueryCompletedEvent)Iterables.getOnlyElement(this.generatedEvents.getQueryCompletedEvents());
        queryMetadata = queryCompletedEvent.getMetadata();
        runtimeOptimizedStages = this.queryRunner.getCoordinator().getQueryManager().getFullQueryInfo(new QueryId(queryCreatedEvent.getMetadata().getQueryId())).getRuntimeOptimizedStages();
        Assert.assertEquals((int)queryMetadata.getRuntimeOptimizedStages().size(), (int)1);
        Assert.assertEquals((String)((String)queryMetadata.getRuntimeOptimizedStages().get(0)), (String)"1");
        Assert.assertTrue((boolean)runtimeOptimizedStages.isPresent());
        Assert.assertEquals((int)((List)runtimeOptimizedStages.get()).size(), (int)1);
        Assert.assertEquals((Collection)queryMetadata.getRuntimeOptimizedStages(), (Collection)((Collection)((List)runtimeOptimizedStages.get()).stream().map(stageId -> String.valueOf(stageId.getId())).collect(ImmutableList.toImmutableList())));
        this.runQueryAndWaitForEvents("WITH natreg AS (SELECT nation.regionkey, nationkey, region.name FROM region INNER JOIN nation ON nation.regionkey=region.regionkey) SELECT phone, regionkey FROM natreg INNER JOIN supplier ON supplier.nationkey=natreg.nationkey", expectedEvents);
        queryCreatedEvent = (QueryCreatedEvent)Iterables.getOnlyElement(this.generatedEvents.getQueryCreatedEvents());
        queryCompletedEvent = (QueryCompletedEvent)Iterables.getOnlyElement(this.generatedEvents.getQueryCompletedEvents());
        queryMetadata = queryCompletedEvent.getMetadata();
        runtimeOptimizedStages = this.queryRunner.getCoordinator().getQueryManager().getFullQueryInfo(new QueryId(queryCreatedEvent.getMetadata().getQueryId())).getRuntimeOptimizedStages();
        Assert.assertEquals((int)queryMetadata.getRuntimeOptimizedStages().size(), (int)2);
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)queryMetadata.getRuntimeOptimizedStages()), (Set)ImmutableSet.of((Object)"1", (Object)"4"));
        Assert.assertTrue((boolean)runtimeOptimizedStages.isPresent());
        Assert.assertEquals((int)((List)runtimeOptimizedStages.get()).size(), (int)2);
        Assert.assertEquals((Collection)queryMetadata.getRuntimeOptimizedStages(), (Collection)((Collection)((List)runtimeOptimizedStages.get()).stream().map(stageId -> String.valueOf(stageId.getId())).collect(ImmutableList.toImmutableList())));
    }

    static class EventsBuilder {
        private ImmutableList.Builder<QueryCreatedEvent> queryCreatedEvents;
        private ImmutableList.Builder<QueryCompletedEvent> queryCompletedEvents;
        private CountDownLatch eventsLatch;

        EventsBuilder() {
        }

        public synchronized void initialize(int numEvents) {
            this.queryCreatedEvents = ImmutableList.builder();
            this.queryCompletedEvents = ImmutableList.builder();
            this.eventsLatch = new CountDownLatch(numEvents);
        }

        public void waitForEvents(int timeoutSeconds) throws InterruptedException {
            this.eventsLatch.await(timeoutSeconds, TimeUnit.SECONDS);
        }

        public synchronized void addQueryCreated(QueryCreatedEvent event) {
            this.queryCreatedEvents.add((Object)event);
            this.eventsLatch.countDown();
        }

        public synchronized void addQueryCompleted(QueryCompletedEvent event) {
            this.queryCompletedEvents.add((Object)event);
            this.eventsLatch.countDown();
        }

        public List<QueryCreatedEvent> getQueryCreatedEvents() {
            return this.queryCreatedEvents.build();
        }

        public List<QueryCompletedEvent> getQueryCompletedEvents() {
            return this.queryCompletedEvents.build();
        }
    }

    private static class TestingEventListener
    implements EventListener {
        private final EventsBuilder eventsBuilder;

        public TestingEventListener(EventsBuilder eventsBuilder) {
            this.eventsBuilder = eventsBuilder;
        }

        public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
            this.eventsBuilder.addQueryCreated(queryCreatedEvent);
        }

        public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
            this.eventsBuilder.addQueryCompleted(queryCompletedEvent);
        }

        public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
        }
    }

    private static class TestingEventListenerFactory
    implements EventListenerFactory {
        private final EventsBuilder eventsBuilder;

        public TestingEventListenerFactory(EventsBuilder eventsBuilder) {
            this.eventsBuilder = eventsBuilder;
        }

        public String getName() {
            return "test";
        }

        public EventListener create(Map<String, String> config) {
            return new TestingEventListener(this.eventsBuilder);
        }
    }

    static class TestingEventListenerPlugin
    implements Plugin {
        private final EventsBuilder eventsBuilder;

        public TestingEventListenerPlugin(EventsBuilder eventsBuilder) {
            this.eventsBuilder = Objects.requireNonNull(eventsBuilder, "eventsBuilder is null");
        }

        public Iterable<EventListenerFactory> getEventListenerFactories() {
            return ImmutableList.of((Object)new TestingEventListenerFactory(this.eventsBuilder));
        }
    }
}

