/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.authentication.HadoopAuthentication;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.ImpersonatingHdfsAuthentication;
import com.facebook.presto.hive.authentication.SimpleHadoopAuthentication;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFileSystemCache {
    @Test
    public void testFileSystemCache() throws IOException {
        ImpersonatingHdfsAuthentication auth = new ImpersonatingHdfsAuthentication((HadoopAuthentication)new SimpleHadoopAuthentication());
        HiveClientConfig hiveClientConfig = new HiveClientConfig();
        HdfsEnvironment environment = new HdfsEnvironment((HdfsConfiguration)new HiveHdfsConfiguration(new HdfsConfigurationInitializer(hiveClientConfig, new MetastoreClientConfig()), (Set)ImmutableSet.of(), hiveClientConfig), new MetastoreClientConfig(), (HdfsAuthentication)auth);
        FileSystem fs1 = this.getFileSystem(environment, "user");
        FileSystem fs2 = this.getFileSystem(environment, "user");
        Assert.assertSame((Object)fs1, (Object)fs2);
        FileSystem fs3 = this.getFileSystem(environment, "other_user");
        Assert.assertNotSame((Object)fs1, (Object)fs3);
        FileSystem fs4 = this.getFileSystem(environment, "other_user");
        Assert.assertSame((Object)fs3, (Object)fs4);
    }

    private FileSystem getFileSystem(HdfsEnvironment environment, String user) throws IOException {
        return environment.getFileSystem(user, new Path("/"), new Configuration(false));
    }
}

