/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.CopyOnFirstWriteConfiguration;
import com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.TestBackgroundHiveSplitLoader;
import com.facebook.presto.hive.cache.HiveCachingHdfsConfiguration;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HadoopExtendedFileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeBootstrapBaseFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGenericHiveRecordCursorProvider {
    public static final HiveColumnHandle HOODIE_COMMIT_TIME = new HiveColumnHandle("_hoodie_commit_time", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    public static final HiveColumnHandle HOODIE_COMMIT_SEQNO = new HiveColumnHandle("_hoodie_commit_seqno", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 1, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    public static final HiveColumnHandle HOODIE_RECORD_KEY = new HiveColumnHandle("_hoodie_record_key", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 2, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    public static final HiveColumnHandle HOODIE_PARTITION_PATH = new HiveColumnHandle("_hoodie_partition_path", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 3, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    public static final HiveColumnHandle HOODIE_FILE_NAME = new HiveColumnHandle("_hoodie_file_name", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 4, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    public static final HiveColumnHandle ID = new HiveColumnHandle("id", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 5, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    public static final HiveColumnHandle LAST_UPDATE_MONTH = new HiveColumnHandle("last_update_month", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 6, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    public static final HiveColumnHandle LAST_UPDATE_TIME = new HiveColumnHandle("last_update_time", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 7, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    public static final String TABLE_NAME = "hudi_part_mor_rt";
    public static final String FILE_NAME = "b3711ddf-8c11-4666-82ec-fbc952e1dc72-0_1-61-24052_20210524095413.parquet";

    @Test
    public void shouldReturnHudiRecordCursorForRealtimeFileSplitWithCopyOnFirstWriteEnabled() {
        Optional<RecordCursor> recordCursor = TestGenericHiveRecordCursorProvider.getRecordCursor(HoodieRealtimeFileSplit.class, true);
        Assert.assertTrue((boolean)recordCursor.isPresent());
    }

    @Test
    public void shouldReturnHudiRecordCursorForRealtimeFileSplitWithCopyOnFirstWriteDisabled() {
        Optional<RecordCursor> recordCursor = TestGenericHiveRecordCursorProvider.getRecordCursor(HoodieRealtimeFileSplit.class, false);
        Assert.assertTrue((boolean)recordCursor.isPresent());
    }

    @Test
    public void shouldReturnHudiRecordCursorForRealtimeBootstrapBaseFileSplitWithCopyOnFirstWriteEnabled() {
        Optional<RecordCursor> recordCursor = TestGenericHiveRecordCursorProvider.getRecordCursor(HoodieRealtimeBootstrapBaseFileSplit.class, true);
        Assert.assertTrue((boolean)recordCursor.isPresent());
    }

    @Test
    public void shouldReturnHudiRecordCursorForRealtimeBootstrapBaseFileSplitWithCopyOnFirstWriteDisabled() {
        Optional<RecordCursor> recordCursor = TestGenericHiveRecordCursorProvider.getRecordCursor(HoodieRealtimeBootstrapBaseFileSplit.class, false);
        Assert.assertTrue((boolean)recordCursor.isPresent());
    }

    private static Optional<RecordCursor> getRecordCursor(Class<? extends FileSplit> fileSplitClass, Boolean isCopyOnFirstWriteConfigurationEnabled) {
        GenericHiveRecordCursorProvider genericHiveRecordCursorProvider = new GenericHiveRecordCursorProvider((HdfsEnvironment)new TestBackgroundHiveSplitLoader.TestingHdfsEnvironment(new ArrayList<LocatedFileStatus>()));
        HiveFileSplit fileSplit = TestGenericHiveRecordCursorProvider.getHiveFileSplit(fileSplitClass);
        return genericHiveRecordCursorProvider.createRecordCursor(isCopyOnFirstWriteConfigurationEnabled != false ? TestGenericHiveRecordCursorProvider.getHadoopConfWithCopyOnFirstWriteEnabled() : TestGenericHiveRecordCursorProvider.getHadoopConfWithCopyOnFirstWriteDisabled(), HiveTestUtils.SESSION, fileSplit, TestGenericHiveRecordCursorProvider.createTestingSchema(), TestGenericHiveRecordCursorProvider.getAllColumns(), TupleDomain.all(), DateTimeZone.forID((String)HiveTestUtils.SESSION.getSqlFunctionProperties().getTimeZoneKey().getId()), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, false);
    }

    private static HiveFileSplit getHiveFileSplit(Class<? extends FileSplit> fileSplitClass) {
        switch (fileSplitClass.getName()) {
            case "org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit": {
                return new HiveFileSplit(TestGenericHiveRecordCursorProvider.getTableBasePath(TABLE_NAME) + "/testPartition/" + FILE_NAME, 0L, 435165L, 435165L, 1621850079L, Optional.empty(), (Map)ImmutableMap.of((Object)"custom_split_class", (Object)HoodieRealtimeFileSplit.class.getName(), (Object)"hudi_delta_filepaths", (Object)"", (Object)"hudi_basepath", (Object)TestGenericHiveRecordCursorProvider.getTableBasePath(TABLE_NAME), (Object)"hudi_max_commit_time", (Object)"20210524095413"));
            }
            case "org.apache.hudi.hadoop.realtime.HoodieRealtimeBootstrapBaseFileSplit": {
                ImmutableMap.Builder customSplitInfo = new ImmutableMap.Builder();
                customSplitInfo.put((Object)"custom_split_class", (Object)HoodieRealtimeBootstrapBaseFileSplit.class.getName());
                customSplitInfo.put((Object)"delta_file_paths", (Object)"");
                customSplitInfo.put((Object)"base_path", (Object)TestGenericHiveRecordCursorProvider.getTableBasePath(TABLE_NAME));
                customSplitInfo.put((Object)"max_commit_time", (Object)"20210524095413");
                customSplitInfo.put((Object)"bootstrap_split_path", (Object)(TestGenericHiveRecordCursorProvider.getTableBasePath(TABLE_NAME) + "/testPartition/" + FILE_NAME));
                customSplitInfo.put((Object)"bootstrap_split_start", (Object)"0");
                customSplitInfo.put((Object)"bootstrap_split_len", (Object)"435165");
                return new HiveFileSplit(TestGenericHiveRecordCursorProvider.getTableBasePath(TABLE_NAME) + "/testPartition/" + FILE_NAME, 0L, 435165L, 435165L, 1621850079L, Optional.empty(), (Map)customSplitInfo.build());
            }
        }
        throw new IllegalArgumentException("Unknown file split class " + fileSplitClass.getName());
    }

    private static Configuration getHadoopConfWithCopyOnFirstWriteEnabled() {
        Configuration hadoopConf = new Configuration();
        hadoopConf.set("fs.file.impl", LocalFileSystem.class.getName());
        CopyOnFirstWriteConfiguration configuration = new CopyOnFirstWriteConfiguration(hadoopConf);
        return new HiveCachingHdfsConfiguration.CachingJobConf((factoryConfig, factoryUri) -> {
            LocalFileSystem localFileSystem = new LocalFileSystem();
            try {
                localFileSystem.initialize(URI.create("file:///"), hadoopConf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new HadoopExtendedFileSystem((FileSystem)localFileSystem);
        }, (Configuration)configuration);
    }

    private static Configuration getHadoopConfWithCopyOnFirstWriteDisabled() {
        Configuration hadoopConf = new Configuration();
        hadoopConf.set("fs.file.impl", LocalFileSystem.class.getName());
        return new HiveCachingHdfsConfiguration.CachingJobConf((factoryConfig, factoryUri) -> {
            LocalFileSystem localFileSystem = new LocalFileSystem();
            try {
                localFileSystem.initialize(URI.create("file:///"), hadoopConf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new HadoopExtendedFileSystem((FileSystem)localFileSystem);
        }, hadoopConf);
    }

    private static Properties createTestingSchema() {
        List<HiveColumnHandle> schemaColumns = TestGenericHiveRecordCursorProvider.getAllColumns();
        Properties schema = new Properties();
        String columnNames = TestGenericHiveRecordCursorProvider.buildPropertyFromColumns(schemaColumns, HiveColumnHandle::getName);
        String columnTypeNames = TestGenericHiveRecordCursorProvider.buildPropertyFromColumns(schemaColumns, column -> column.getHiveType().getTypeInfo().getTypeName());
        schema.setProperty("columns", columnNames);
        schema.setProperty("columns.types", columnTypeNames);
        schema.setProperty("name", "test_schema.hudi_part_mor_rt");
        schema.setProperty("serialization.ddl", "struct hudi_part_mor_rt { string _hoodie_commit_time, string _hoodie_commit_seqno, string _hoodie_record_key, string _hoodie_partition_path, string _hoodie_file_name, string id, string last_update_month, string last_update_time}");
        schema.setProperty("serialization.format", "1");
        schema.setProperty("partition_columns", "creation_date");
        schema.setProperty("partition_columns.types", "string");
        schema.setProperty("last_modified_time", "1621850084");
        schema.setProperty("bucket_count", "0");
        schema.setProperty("last_commit_time_sync", "20210524095413");
        schema.setProperty("EXTERNAL", "TRUE");
        String deserializerClassName = ParquetHiveSerDe.class.getName();
        schema.setProperty("serialization.lib", deserializerClassName);
        String inputFormat = HoodieParquetRealtimeInputFormat.class.getName();
        schema.setProperty("file.inputformat", inputFormat);
        String outputFormat = MapredParquetOutputFormat.class.getName();
        schema.setProperty("file.outputformat", outputFormat);
        schema.setProperty("location", TestGenericHiveRecordCursorProvider.getTableBasePath(TABLE_NAME) + "/testPartition");
        schema.setProperty("last_modified_by", "hive");
        return schema;
    }

    private static String buildPropertyFromColumns(List<HiveColumnHandle> columns, Function<HiveColumnHandle, String> mapper) {
        if (columns.isEmpty()) {
            return "";
        }
        return columns.stream().map(mapper).collect(Collectors.joining(","));
    }

    private static List<HiveColumnHandle> getAllColumns() {
        return ImmutableList.of((Object)HOODIE_COMMIT_TIME, (Object)HOODIE_COMMIT_SEQNO, (Object)HOODIE_RECORD_KEY, (Object)HOODIE_PARTITION_PATH, (Object)HOODIE_FILE_NAME, (Object)ID, (Object)LAST_UPDATE_MONTH, (Object)LAST_UPDATE_TIME);
    }

    private static String getTableBasePath(String tableName) {
        return TestGenericHiveRecordCursorProvider.class.getClassLoader().getResource(tableName).toString();
    }
}

