/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.WarningHandlingLevel;
import com.facebook.presto.execution.warnings.DefaultWarningCollector;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.hive.AbstractTestHiveClient;
import com.facebook.presto.hive.AbstractTestHiveClientLocal;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveNotReadableException;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.file.FileHiveMetastore;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hive.common.FileUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class TestHiveClientFileMetastore
extends AbstractTestHiveClientLocal {
    private static final ConnectorSplitManager.SplitSchedulingContext SPLIT_SCHEDULING_CONTEXT = new ConnectorSplitManager.SplitSchedulingContext(ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING, false, (WarningCollector)new DefaultWarningCollector(new WarningCollectorConfig(), WarningHandlingLevel.NORMAL));

    @Override
    protected ExtendedHiveMetastore createMetastore(File tempDir) {
        File baseDir = new File(tempDir, "metastore");
        HiveClientConfig hiveConfig = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        HdfsConfigurationInitializer updater = new HdfsConfigurationInitializer(hiveConfig, metastoreClientConfig);
        HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(updater, (Set)ImmutableSet.of(), hiveConfig);
        HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, metastoreClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        return new FileHiveMetastore(hdfsEnvironment, baseDir.toURI().toString(), "test");
    }

    @Override
    public void testMismatchSchemaTable() {
    }

    @Override
    public void testPartitionSchemaMismatch() {
        throw new SkipException("FileHiveMetastore only supports replaceTable() for views");
    }

    @Override
    public void testBucketedTableEvolution() {
    }

    @Override
    public void testBucketedTableEvolutionWithDifferentReadBucketCount() {
    }

    @Override
    public void testTransactionDeleteInsert() {
    }

    @Override
    public void testTableConstraints() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartitionNotReadable() {
        SchemaTableName tableName = this.temporaryTable("tempTable");
        ImmutableMap dynamicPartitionParameters = ImmutableMap.of((Object)"object_not_readable", (Object)"Testing Unreadable Partition");
        try {
            ConnectorTableLayout tableLayout;
            ColumnHandle dsColumn;
            ConnectorTableHandle tableHandle;
            ConnectorSession session;
            ConnectorMetadata metadata;
            this.createDummyPartitionedTable(tableName, STATISTICS_PARTITIONED_TABLE_COLUMNS, (Map<String, String>)dynamicPartitionParameters);
            try (AbstractTestHiveClient.Transaction transaction = this.newTransaction();){
                metadata = transaction.getMetadata();
                session = this.newSession();
                tableHandle = this.getTableHandle(metadata, tableName);
                Assert.assertNotNull((Object)tableHandle);
                dsColumn = (ColumnHandle)metadata.getColumnHandles(session, tableHandle).get("ds");
                Assert.assertNotNull((Object)dsColumn);
                tableLayout = this.getTableLayout(session, metadata, tableHandle, (Constraint<ColumnHandle>)Constraint.alwaysTrue(), transaction);
                try {
                    TestHiveClientFileMetastore.getSplitCount(this.splitManager.getSplits(transaction.getTransactionHandle(), session, tableLayout.getHandle(), SPLIT_SCHEDULING_CONTEXT));
                    Assert.fail((String)"Expected HiveNotReadableException");
                }
                catch (HiveNotReadableException e) {
                    Assert.assertEquals((Object)e.getTableName(), (Object)tableName);
                    Assert.assertNotNull((Object)SPLIT_SCHEDULING_CONTEXT.getWarningCollector());
                    Assert.assertEquals((int)SPLIT_SCHEDULING_CONTEXT.getWarningCollector().getWarnings().size(), (int)0);
                }
            }
            transaction = this.newTransaction();
            var4_5 = null;
            try {
                metadata = transaction.getMetadata();
                session = this.newSession((Map<String, Object>)ImmutableMap.of((Object)"ignore_unreadable_partition", (Object)true));
                tableHandle = this.getTableHandle(metadata, tableName);
                Assert.assertNotNull((Object)tableHandle);
                dsColumn = (ColumnHandle)metadata.getColumnHandles(session, tableHandle).get("ds");
                Assert.assertNotNull((Object)dsColumn);
                tableLayout = this.getTableLayout(session, metadata, tableHandle, (Constraint<ColumnHandle>)Constraint.alwaysTrue(), transaction);
                this.splitManager.getSplits(transaction.getTransactionHandle(), session, tableLayout.getHandle(), SPLIT_SCHEDULING_CONTEXT);
                Assert.assertNotNull((Object)SPLIT_SCHEDULING_CONTEXT.getWarningCollector());
                Assert.assertEquals((int)SPLIT_SCHEDULING_CONTEXT.getWarningCollector().getWarnings().size(), (int)1);
                Assert.assertTrue((boolean)((PrestoWarning)SPLIT_SCHEDULING_CONTEXT.getWarningCollector().getWarnings().get(0)).getMessage().contains("has 1 out of 3 partitions unreadable: ds=2020-01-03... are due to Testing Unreadable Partition. "));
                Assert.assertEquals((String)((PrestoWarning)SPLIT_SCHEDULING_CONTEXT.getWarningCollector().getWarnings().get(0)).getWarningCode().getName(), (String)"PARTITION_NOT_READABLE");
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (transaction != null) {
                    if (var4_5 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Exception not expected");
        }
        finally {
            this.dropTable(tableName);
        }
    }

    private void createDummyPartitionedTable(SchemaTableName tableName, List<ColumnMetadata> columns, Map<String, String> dynamicPartitionParameters) throws Exception {
        this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, columns);
        ExtendedHiveMetastore metastoreClient = this.getMetastoreClient();
        Table table = (Table)metastoreClient.getTable(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        ImmutableList firstPartitionValues = ImmutableList.of((Object)"2020-01-01");
        ImmutableList secondPartitionValues = ImmutableList.of((Object)"2020-01-02");
        ImmutableList thirdPartitionValues = ImmutableList.of((Object)"2020-01-03");
        String firstPartitionName = FileUtils.makePartName((List)ImmutableList.of((Object)"ds"), (List)firstPartitionValues);
        String secondPartitionName = FileUtils.makePartName((List)ImmutableList.of((Object)"ds"), (List)secondPartitionValues);
        String thirdPartitionName = FileUtils.makePartName((List)ImmutableList.of((Object)"ds"), (List)thirdPartitionValues);
        List partitions = (List)ImmutableList.of((Object)firstPartitionName, (Object)secondPartitionName).stream().map(partitionName -> new PartitionWithStatistics(this.createDummyPartition(table, (String)partitionName), partitionName, PartitionStatistics.empty())).collect(ImmutableList.toImmutableList());
        metastoreClient.addPartitions(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), partitions);
        metastoreClient.updatePartitionStatistics(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), firstPartitionName, currentStatistics -> EMPTY_TABLE_STATISTICS);
        metastoreClient.updatePartitionStatistics(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), secondPartitionName, currentStatistics -> EMPTY_TABLE_STATISTICS);
        List partitionsNotReadable = (List)ImmutableList.of((Object)thirdPartitionName).stream().map(partitionName -> new PartitionWithStatistics(this.createDummyPartition(table, (String)partitionName, dynamicPartitionParameters), partitionName, PartitionStatistics.empty())).collect(ImmutableList.toImmutableList());
        metastoreClient.addPartitions(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), partitionsNotReadable);
        metastoreClient.updatePartitionStatistics(HiveQueryRunner.METASTORE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), thirdPartitionName, currentStatistics -> EMPTY_TABLE_STATISTICS);
    }

    private Partition createDummyPartition(Table table, String partitionName, Map<String, String> dynamicPartitionParameters) {
        return this.createDummyPartition(table, partitionName, Optional.empty(), dynamicPartitionParameters);
    }

    private Partition createDummyPartition(Table table, String partitionName, Optional<HiveBucketProperty> bucketProperty, Map<String, String> dynamicPartitionParameters) {
        ImmutableMap staticPartitionParameters = ImmutableMap.of((Object)"presto_version", (Object)"testversion", (Object)"presto_query_id", (Object)"20200101_123456_00001_x1y2z");
        ImmutableMap partitionParameters = ImmutableMap.builder().putAll((Map)staticPartitionParameters).putAll(dynamicPartitionParameters).build();
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(MetastoreUtil.toPartitionValues((String)partitionName)).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC)).setLocation(this.partitionTargetPath(new SchemaTableName(table.getDatabaseName(), table.getTableName()), partitionName)).setBucketProperty(bucketProperty)).setParameters((Map)partitionParameters).setEligibleToIgnore(true).setSealedPartition(true).build();
    }
}

