/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveType;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveColumnHandle {
    private final JsonCodec<HiveColumnHandle> codec = JsonCodec.jsonCodec(HiveColumnHandle.class);

    @Test
    public void testHiddenColumn() {
        HiveColumnHandle hiddenColumn = HiveColumnHandle.pathColumnHandle();
        this.testRoundTrip(hiddenColumn);
    }

    @Test
    public void testRegularColumn() {
        HiveColumnHandle expectedPartitionColumn = new HiveColumnHandle("name", HiveType.HIVE_FLOAT, TypeSignature.parseTypeSignature((String)"double"), 88, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty(), Optional.empty());
        this.testRoundTrip(expectedPartitionColumn);
    }

    @Test
    public void testPartitionKeyColumn() {
        HiveColumnHandle expectedRegularColumn = new HiveColumnHandle("name", HiveType.HIVE_FLOAT, TypeSignature.parseTypeSignature((String)"double"), 88, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
        this.testRoundTrip(expectedRegularColumn);
    }

    private void testRoundTrip(HiveColumnHandle expected) {
        String json = this.codec.toJson((Object)expected);
        HiveColumnHandle actual = (HiveColumnHandle)this.codec.fromJson(json);
        Assert.assertEquals((String)actual.getName(), (String)expected.getName());
        Assert.assertEquals((Object)actual.getHiveType(), (Object)expected.getHiveType());
        Assert.assertEquals((int)actual.getHiveColumnIndex(), (int)expected.getHiveColumnIndex());
        Assert.assertEquals((boolean)actual.isPartitionKey(), (boolean)expected.isPartitionKey());
    }
}

