/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.hive.HiveDecimalParser;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveDecimalParser {
    @Test
    public void testParseDecimal() {
        this.checkParseDecimal("3", 2, 1, new BigDecimal("3.0"));
        this.checkParseDecimal("3.1", 2, 1, new BigDecimal("3.1"));
        this.checkParseDecimal("3.11", 2, 1, new BigDecimal("3.1"));
        this.checkParseDecimal("3.16", 2, 1, new BigDecimal("3.2"));
        this.checkParseDecimal("3.15", 2, 1, new BigDecimal("3.2"));
        this.checkParseDecimal("3.25", 2, 1, new BigDecimal("3.3"));
        this.checkParseDecimal("-3", 2, 1, new BigDecimal("-3.0"));
        this.checkParseDecimal("-3.1", 2, 1, new BigDecimal("-3.1"));
        this.checkParseDecimal("-3.11", 2, 1, new BigDecimal("-3.1"));
        this.checkParseDecimal("-3.16", 2, 1, new BigDecimal("-3.2"));
        this.checkParseDecimal("-3.15", 2, 1, new BigDecimal("-3.2"));
        this.checkParseDecimal("-3.25", 2, 1, new BigDecimal("-3.3"));
    }

    private void checkParseDecimal(String input, int precision, int scale, BigDecimal expected) {
        byte[] bytes = input.getBytes(StandardCharsets.US_ASCII);
        BigDecimal parsed = HiveDecimalParser.parseHiveDecimal((byte[])bytes, (int)0, (int)bytes.length, (DecimalType)DecimalType.createDecimalType((int)precision, (int)scale));
        Assert.assertEquals((Object)parsed, (Object)expected);
    }
}

