/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.Session;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestJoinQueries;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.facebook.presto.tests.ResultWithQueryId;
import com.google.common.collect.MoreCollectors;
import io.airlift.tpch.TpchTable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveDistributedJoinQueriesWithDynamicFiltering
extends AbstractTestJoinQueries {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createQueryRunner(TpchTable.getTables());
    }

    protected Session getSession() {
        return Session.builder((Session)super.getSession()).setSystemProperty("enable_dynamic_filtering", "true").setSystemProperty("pushdown_subfields_enabled", "true").setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setCatalogSessionProperty("hive", "pushdown_filter_enabled", "true").build();
    }

    @Test
    public void testJoinWithEmptyBuildSide() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("pushdown_subfields_enabled", "false").setCatalogSessionProperty("hive", "pushdown_filter_enabled", "false").build();
        DistributedQueryRunner runner = (DistributedQueryRunner)this.getQueryRunner();
        ResultWithQueryId result = runner.executeWithQueryId(session, "SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.totalprice = 123.4567");
        Assert.assertEquals((int)((MaterializedResult)result.getResult()).getRowCount(), (int)0);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), "lineitem");
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)0L);
    }

    @Test
    public void testJoinWithSelectiveBuildSide() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("pushdown_subfields_enabled", "false").setCatalogSessionProperty("hive", "pushdown_filter_enabled", "false").build();
        DistributedQueryRunner runner = (DistributedQueryRunner)this.getQueryRunner();
        ResultWithQueryId result = runner.executeWithQueryId(session, "SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey = 1");
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(((MaterializedResult)result.getResult()).getRowCount()), (Comparable)Integer.valueOf(0));
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), "lineitem");
        Assertions.assertLessThanOrEqual((Comparable)Long.valueOf(probeStats.getInputPositions()), (Comparable)this.countRows("lineitem"));
    }

    @Test
    public void testJoinDynamicFilteringMultiJoin() {
        this.assertUpdate("CREATE TABLE t0 (k0 integer, v0 real)");
        this.assertUpdate("CREATE TABLE t1 (k1 integer, v1 real)");
        this.assertUpdate("CREATE TABLE t2 (k2 integer, v2 real)");
        this.assertUpdate("INSERT INTO t0 VALUES (1, 1.0)", 1L);
        this.assertUpdate("INSERT INTO t1 VALUES (1, 2.0)", 1L);
        this.assertUpdate("INSERT INTO t2 VALUES (1, 3.0)", 1L);
        String query = "SELECT k0, k1, k2 FROM t0, t1, t2 WHERE (k0 = k1) AND (k0 = k2) AND (v0 + v1 = v2)";
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("enable_dynamic_filtering", "true").setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).build();
        this.assertQuery(session, query, "SELECT 1, 1, 1");
    }

    @Test
    public void testJoinOnNullPartitioning() {
        this.assertUpdate("CREATE TABLE t3(c2 bigint, c1 bigint)");
        this.assertUpdate("INSERT INTO t3 VALUES(null, 2)", 1L);
        this.assertUpdate("CREATE TABLE t4(c2 bigint, c1 bigint) with(partitioned_by=array['c1'])");
        this.assertUpdate("INSERT INTO t4 VALUES(null, null), (2,2)", 2L);
        String query = "select * from t3, t4 where t3.c1=t4.c2";
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("enable_dynamic_filtering", "true").setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.AUTOMATIC.name()).build();
        this.assertQuery(session, query, "SELECT null, 2, 2, 2");
    }

    @Test
    public void testMixedJoin() {
        this.assertQuery("SELECT * FROM\nlineitem l1 LEFT OUTER JOIN part p1\nON l1.orderkey = p1.partkey AND p1.size = 47\nINNER JOIN orders o1 ON l1.orderkey = o1.orderkey\nAND o1.custkey = 397\nLEFT OUTER JOIN part p2\nON p1.name = p2.name AND p1.partkey = p2.partkey\nWHERE o1.shippriority = 0");
    }

    private OperatorStats searchScanFilterAndProjectOperatorStats(QueryId queryId, String tableName) {
        DistributedQueryRunner runner = (DistributedQueryRunner)this.getQueryRunner();
        Plan plan = runner.getQueryPlan(queryId);
        PlanNodeId nodeId = PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> {
            if (!(node instanceof ProjectNode)) {
                return false;
            }
            ProjectNode projectNode = (ProjectNode)node;
            FilterNode filterNode = (FilterNode)projectNode.getSource();
            TableScanNode tableScanNode = (TableScanNode)filterNode.getSource();
            return tableName.equals(((HiveTableHandle)tableScanNode.getTable().getConnectorHandle()).getTableName());
        }).findOnlyElement().getId();
        return (OperatorStats)runner.getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats().getOperatorSummaries().stream().filter(summary -> nodeId.equals((Object)summary.getPlanNodeId())).collect(MoreCollectors.onlyElement());
    }

    private Long countRows(String tableName) {
        MaterializedResult result = this.getQueryRunner().execute("SELECT COUNT() FROM " + tableName);
        return (Long)result.getOnlyValue();
    }
}

