/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.TestHiveIntegrationSmokeTest;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestDistributedQueries;
import com.google.common.collect.Iterables;
import io.airlift.tpch.TpchTable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveDistributedQueriesWithExchangeMaterialization
extends AbstractTestDistributedQueries {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createMaterializingQueryRunner(TpchTable.getTables());
    }

    @Test
    public void testMaterializedExchangesEnabled() {
        this.assertQuery(this.getSession(), "SELECT orderkey, COUNT(*) lines FROM lineitem GROUP BY orderkey", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
    }

    @Test
    public void testMaterializeHiveUnsupportedTypeForTemporaryTable() {
        this.testMaterializeHiveUnsupportedTypeForTemporaryTable(HiveStorageFormat.ORC, true);
        this.testMaterializeHiveUnsupportedTypeForTemporaryTable(HiveStorageFormat.PAGEFILE, false);
        Assert.assertThrows(RuntimeException.class, () -> this.testMaterializeHiveUnsupportedTypeForTemporaryTable(HiveStorageFormat.ORC, false));
    }

    private void testMaterializeHiveUnsupportedTypeForTemporaryTable(HiveStorageFormat storageFormat, boolean usePageFileForHiveUnsupportedType) {
        Session session = this.sessionBuilderNoConstantGrouping().setCatalogSessionProperty("hive", "temporary_table_storage_format", storageFormat.name()).setCatalogSessionProperty("hive", "use_pagefile_for_hive_unsupported_type", String.valueOf(usePageFileForHiveUnsupportedType)).setSystemProperty("enable_stats_collection_for_temporary_table", "true").build();
        this.assertUpdate(session, "CREATE TABLE test_materialize_non_hive_types AS\nWITH t1 AS (\n    SELECT\n        CAST('192.168.0.0' AS IPADDRESS) address,\n        nationkey\n    FROM nation\n),\nt2 AS (\n    SELECT\n        FROM_ISO8601_TIMESTAMP('2020-02-25') time,\n        nationkey\n    FROM nation\n)\nSELECT\n    t1.nationkey,\n    CAST(t1.address AS VARCHAR) address,\n    CAST(t2.time AS VARCHAR) time\nFROM t1\nJOIN t2\n    ON t1.nationkey = t2.nationkey", 25L, TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(2));
        this.assertUpdate("DROP TABLE IF EXISTS test_materialize_non_hive_types");
        this.assertUpdate(session, "CREATE TABLE test_materialize_non_hive_types AS\nWITH t1 AS (\n    SELECT\n        CAST('2000-01-01' AS DATE) date,\n        nationkey\n    FROM nation\n),\nt2 AS (\n    SELECT\n        FROM_ISO8601_TIMESTAMP('2020-02-25') time,\n        nationkey\n    FROM nation\n)\nSELECT\n    t1.nationkey,\n    t1.date,\n    CAST(t2.time AS VARCHAR) time\nFROM t1\nJOIN t2\n    ON t1.nationkey = t2.nationkey", 25L);
        this.assertUpdate("DROP TABLE IF EXISTS test_materialize_non_hive_types");
    }

    @Test
    public void testBucketedByHiveUnsupportedTypeForTemporaryTable() {
        this.testBucketedByHiveUnsupportedTypeForTemporaryTable(HiveStorageFormat.ORC, BucketFunctionType.HIVE_COMPATIBLE, true);
        this.testBucketedByHiveUnsupportedTypeForTemporaryTable(HiveStorageFormat.ORC, BucketFunctionType.PRESTO_NATIVE, true);
        this.testBucketedByHiveUnsupportedTypeForTemporaryTable(HiveStorageFormat.PAGEFILE, BucketFunctionType.HIVE_COMPATIBLE, true);
        this.testBucketedByHiveUnsupportedTypeForTemporaryTable(HiveStorageFormat.PAGEFILE, BucketFunctionType.PRESTO_NATIVE, false);
        Assert.assertThrows(RuntimeException.class, () -> this.testBucketedByHiveUnsupportedTypeForTemporaryTable(HiveStorageFormat.ORC, BucketFunctionType.HIVE_COMPATIBLE, false));
        Assert.assertThrows(RuntimeException.class, () -> this.testBucketedByHiveUnsupportedTypeForTemporaryTable(HiveStorageFormat.ORC, BucketFunctionType.PRESTO_NATIVE, false));
        Assert.assertThrows(RuntimeException.class, () -> this.testBucketedByHiveUnsupportedTypeForTemporaryTable(HiveStorageFormat.PAGEFILE, BucketFunctionType.HIVE_COMPATIBLE, false));
    }

    private void testBucketedByHiveUnsupportedTypeForTemporaryTable(HiveStorageFormat storageFormat, BucketFunctionType bucketFunctionType, boolean usePageFileForHiveUnsupportedType) {
        Session session = this.sessionBuilderNoConstantGrouping().setCatalogSessionProperty("hive", "temporary_table_storage_format", storageFormat.name()).setCatalogSessionProperty("hive", "bucket_function_type_for_exchange", bucketFunctionType.name()).setCatalogSessionProperty("hive", "use_pagefile_for_hive_unsupported_type", String.valueOf(usePageFileForHiveUnsupportedType)).build();
        this.assertUpdate(session, "CREATE TABLE test_materialize_bucket_by_non_hive_types AS\nWITH t1 AS (\n    SELECT\n        CAST('192.168.0.0' AS IPADDRESS) address,\n        nationkey\n    FROM nation\n    GROUP BY\n        nationkey,\n        CAST('192.168.0.0' AS IPADDRESS)\n),\nt2 AS (\n    SELECT\n        FROM_ISO8601_TIMESTAMP('2020-02-25') time,\n        nationkey\n    FROM nation\n    GROUP BY\n        nationkey,\n        FROM_ISO8601_TIMESTAMP('2020-02-25')\n)\nSELECT\n    t1.nationkey,\n    CAST(t1.address AS VARCHAR) address,\n    CAST(t2.time AS VARCHAR) time\nFROM t1\nJOIN t2\n    ON t1.nationkey = t2.nationkey", 25L, TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(3));
        this.assertUpdate("DROP TABLE IF EXISTS test_materialize_bucket_by_non_hive_types");
    }

    private Session.SessionBuilder sessionBuilderNoConstantGrouping() {
        return Session.builder((Session)this.getSession()).setSystemProperty("optimize_constant_grouping_keys", "false");
    }

    public void testDelete() {
    }

    public void testExcept() {
    }

    public void testIntersect() {
    }

    public void testQuantifiedComparison() {
    }

    public void testSemiJoin() {
    }

    public void testUnionRequiringCoercion() {
    }

    public void testValues() {
    }

    @Test
    public void testExchangeMaterializationWithConstantFolding() {
        try {
            this.assertUpdate("CREATE TABLE test_constant_folding_lineitem_bucketed\nWITH (bucket_count = 17, bucketed_by = ARRAY['partkey_mod_9', 'partkey', 'suppkey', 'suppkey_varchar']) AS\nSELECT partkey % 9 partkey_mod_9, partkey, suppkey, CAST(suppkey AS VARCHAR) suppkey_varchar, comment FROM lineitem", "SELECT count(*) from lineitem");
            this.assertUpdate("CREATE TABLE test_constant_folding_partsupp_unbucketed AS\nSELECT partkey % 9 partkey_mod_9, partkey, suppkey, CAST(suppkey AS VARCHAR) suppkey_varchar, comment FROM partsupp", "SELECT count(*) from partsupp");
            this.assertQuery(this.getSession(), "SELECT lineitem.partkey, lineitem.suppkey, lineitem.comment lineitem_comment, partsupp.comment partsupp_comment\nFROM test_constant_folding_lineitem_bucketed lineitem JOIN test_constant_folding_partsupp_unbucketed partsupp\nON\n  lineitem.partkey = partsupp.partkey AND\n  lineitem.partkey_mod_9 = partsupp.partkey_mod_9 AND\n  lineitem.suppkey = partsupp.suppkey AND\n  lineitem.suppkey_varchar = partsupp.suppkey_varchar\nWHERE lineitem.suppkey = 42", "SELECT lineitem.partkey, lineitem.suppkey, lineitem.comment lineitem_comment, partsupp.comment partsupp_comment\nFROM lineitem JOIN partsupp\nON lineitem.partkey = partsupp.partkey AND\nlineitem.suppkey = partsupp.suppkey\nWHERE lineitem.suppkey = 42", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
            this.assertQuery(this.getSession(), "SELECT lineitem.partkey, lineitem.suppkey, lineitem.comment lineitem_comment, partsupp.comment partsupp_comment\nFROM test_constant_folding_lineitem_bucketed lineitem JOIN test_constant_folding_partsupp_unbucketed partsupp\nON\n  lineitem.partkey = partsupp.partkey AND\n  lineitem.partkey_mod_9 = partsupp.partkey_mod_9 AND\n  lineitem.suppkey = partsupp.suppkey AND\n  lineitem.suppkey_varchar = partsupp.suppkey_varchar\nWHERE lineitem.suppkey_varchar = '42'", "SELECT lineitem.partkey, lineitem.suppkey, lineitem.comment lineitem_comment, partsupp.comment partsupp_comment\nFROM lineitem JOIN partsupp\nON lineitem.partkey = partsupp.partkey AND\nlineitem.suppkey = partsupp.suppkey\nWHERE lineitem.suppkey = 42", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
            this.assertQuery(this.getSession(), "SELECT lineitem.partkey, lineitem.suppkey, lineitem.comment lineitem_comment, partsupp.comment partsupp_comment\nFROM test_constant_folding_lineitem_bucketed lineitem JOIN test_constant_folding_partsupp_unbucketed partsupp\nON\n  lineitem.partkey = partsupp.partkey AND\n  lineitem.partkey_mod_9 = partsupp.partkey_mod_9 AND\n  lineitem.suppkey = partsupp.suppkey AND\n  lineitem.suppkey_varchar = partsupp.suppkey_varchar\nWHERE lineitem.partkey_mod_9 = 7 AND lineitem.suppkey = 42", "SELECT lineitem.partkey, lineitem.suppkey, lineitem.comment lineitem_comment, partsupp.comment partsupp_comment\nFROM lineitem JOIN partsupp\nON lineitem.partkey = partsupp.partkey AND\nlineitem.suppkey = partsupp.suppkey\nWHERE lineitem.partkey % 9 = 7 AND lineitem.suppkey = 42", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
            this.assertQuery(this.getSession(), "SELECT lineitem.partkey, lineitem.suppkey, lineitem.comment lineitem_comment, partsupp.comment partsupp_comment\nFROM test_constant_folding_lineitem_bucketed lineitem JOIN test_constant_folding_partsupp_unbucketed partsupp\nON\n  lineitem.partkey = partsupp.partkey AND\n  lineitem.partkey_mod_9 = partsupp.partkey_mod_9 AND\n  lineitem.suppkey = partsupp.suppkey AND\n  lineitem.suppkey_varchar = partsupp.suppkey_varchar\nWHERE lineitem.partkey_mod_9 = 7 AND lineitem.suppkey_varchar = '42'", "SELECT lineitem.partkey, lineitem.suppkey, lineitem.comment lineitem_comment, partsupp.comment partsupp_comment\nFROM lineitem JOIN partsupp\nON lineitem.partkey = partsupp.partkey AND\nlineitem.suppkey = partsupp.suppkey\nWHERE lineitem.partkey % 9 = 7 AND lineitem.suppkey = 42", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS test_constant_folding_lineitem_bucketed");
            this.assertUpdate("DROP TABLE IF EXISTS test_constant_folding_partsupp_unbucketed");
        }
    }

    @Test
    public void testIgnoreTableBucketingWhenTableBucketCountIsSmall() {
        try {
            this.assertUpdate("CREATE TABLE partitioned_nation\nWITH (\n    bucket_count = 17,\n    bucketed_by = ARRAY['nationkey']\n) AS\nSELECT\n    *\nFROM nation", 25L);
            this.assertQuery(this.getSession(), "SELECT\n    *\nFROM partitioned_nation t1\nJOIN nation t2\n    ON t1.nationkey = t2.nationkey", "SELECT\n    *\nFROM nation t1\nJOIN nation t2\n    ON t1.nationkey = t2.nationkey", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
            Session testSession = Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "min_bucket_count_to_not_ignore_table_bucketing", "20").build();
            this.assertQuery(testSession, "SELECT\n    *\nFROM partitioned_nation t1\nJOIN nation t2\n    ON t1.nationkey = t2.nationkey", "SELECT\n    *\nFROM nation t1\nJOIN nation t2\n    ON t1.nationkey = t2.nationkey", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(2));
            this.assertQuery(testSession, "SELECT\n    *\nFROM partitioned_nation t1\nJOIN nation t2\n    ON t1.nationkey = t2.nationkey\nWHERE\n    \"$bucket\" < 20", "SELECT\n    *\nFROM nation t1\nJOIN nation t2\n    ON t1.nationkey = t2.nationkey", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS partitioned_nation");
        }
    }

    @Test
    public void testExplainOfCreateTableAs() {
        String query = "CREATE TABLE copy_orders AS SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("EXPLAIN ", query, ExplainType.Type.LOGICAL));
    }

    protected boolean supportsNotNullColumns() {
        return false;
    }

    @Test
    public void testEmptyBucketedTemporaryTable() {
        this.assertQuery("SELECT COUNT(DISTINCT linenumber), COUNT(*) from lineitem where linenumber < 0");
    }

    @Test
    public void testBucketedTemporaryTableWithMissingFiles() {
        this.testBucketedTemporaryTableWithMissingFiles(true);
        this.testBucketedTemporaryTableWithMissingFiles(false);
    }

    private void testBucketedTemporaryTableWithMissingFiles(boolean isFileRenameEnabled) {
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "file_renaming_enabled", String.valueOf(isFileRenameEnabled)).build();
        this.assertQuery(session, "SELECT COUNT(DISTINCT linenumber), COUNT(*) from (SELECT * from lineitem LIMIT 1)");
    }
}

