/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.DwrfEncryptionMetadata;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.EncryptionInformationSource;
import com.facebook.presto.hive.EncryptionMetadata;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveEncryptionInformationProvider;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.TableEncryptionProperties;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveEncryptionInformationProvider {
    private static final Table TEST_TABLE = new Table("test_db", "test_table", "test_owner", PrestoTableType.MANAGED_TABLE, new Storage(StorageFormat.VIEW_STORAGE_FORMAT, "", Optional.empty(), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (List)ImmutableList.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty());

    @Test
    public void testNoOneReturns() {
        HiveEncryptionInformationProvider provider = new HiveEncryptionInformationProvider((List)ImmutableList.of((Object)new TestEncryptionInformationSource(Optional.empty()), (Object)new TestEncryptionInformationSource(Optional.empty())));
        Assert.assertFalse((boolean)provider.getReadEncryptionInformation(HiveTestUtils.SESSION, TEST_TABLE, Optional.empty()).isPresent());
    }

    @Test
    public void testReturnsFirstNonEmptyObject() {
        EncryptionInformation encryptionInformation1 = TestEncryptionInformationSource.createEncryptionInformation("test1");
        EncryptionInformation encryptionInformation2 = TestEncryptionInformationSource.createEncryptionInformation("test2");
        HiveEncryptionInformationProvider provider = new HiveEncryptionInformationProvider((List)ImmutableList.of((Object)new TestEncryptionInformationSource(Optional.empty()), (Object)new TestEncryptionInformationSource(Optional.empty()), (Object)new TestEncryptionInformationSource(Optional.of(encryptionInformation1)), (Object)new TestEncryptionInformationSource(Optional.of(encryptionInformation2))));
        Assert.assertEquals(provider.getReadEncryptionInformation(HiveTestUtils.SESSION, TEST_TABLE, Optional.empty()).get(), (Object)encryptionInformation1);
    }

    private static final class TestEncryptionInformationSource
    implements EncryptionInformationSource {
        private final Optional<EncryptionInformation> encryptionInformation;

        public TestEncryptionInformationSource(Optional<EncryptionInformation> encryptionInformation) {
            this.encryptionInformation = Objects.requireNonNull(encryptionInformation, "encryptionInformation is null");
        }

        public Optional<Map<String, EncryptionInformation>> getReadEncryptionInformation(ConnectorSession session, Table table, Optional<Set<HiveColumnHandle>> requestedColumns, Map<String, Partition> partitions) {
            return this.encryptionInformation.map(information -> (ImmutableMap)partitions.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), partitionId -> information)));
        }

        public Optional<EncryptionInformation> getReadEncryptionInformation(ConnectorSession session, Table table, Optional<Set<HiveColumnHandle>> requestedColumns) {
            return this.encryptionInformation;
        }

        public Optional<EncryptionInformation> getWriteEncryptionInformation(ConnectorSession session, TableEncryptionProperties tableEncryptionProperties, String dbName, String tableName) {
            return this.encryptionInformation;
        }

        public static EncryptionInformation createEncryptionInformation(String fieldName) {
            return EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forPerField((Map)ImmutableMap.of((Object)fieldName, (Object)fieldName.getBytes()), (Map)ImmutableMap.of(), (String)"algo1", (String)"provider1"));
        }
    }
}

