/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.tpch.TpchTable;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestHiveFileBasedSecurity {
    private QueryRunner queryRunner;

    @BeforeClass
    public void setUp() throws Exception {
        String path = this.getClass().getResource("security.json").getPath();
        this.queryRunner = HiveQueryRunner.createQueryRunner(ImmutableList.of((Object)TpchTable.NATION), (Map<String, String>)ImmutableMap.of(), "file", (Map<String, String>)ImmutableMap.of((Object)"security.config-file", (Object)path), Optional.empty());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
    }

    @Test
    public void testAdminCanRead() {
        Session admin = this.getSession("hive");
        this.queryRunner.execute(admin, "SELECT * FROM nation");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*Access Denied: Cannot select from table tpch.nation.*")
    public void testNonAdminCannotRead() {
        Session bob = this.getSession("bob");
        this.queryRunner.execute(bob, "SELECT * FROM nation");
    }

    private Session getSession(String user) {
        return TestingSession.testSessionBuilder().setCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get()).setSchema((String)this.queryRunner.getDefaultSession().getSchema().get()).setIdentity(new Identity(user, Optional.empty())).build();
    }
}

