/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveFileRenamer;
import com.facebook.presto.hive.HiveMetadataUpdateHandle;
import com.facebook.presto.hive.TestHiveMetadataUpdateHandle;
import com.facebook.presto.spi.ConnectorMetadataUpdateHandle;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class TestHiveFileRenamer {
    private static final QueryId TEST_QUERY_ID = new QueryId("test");
    private static final int REQUEST_COUNT = 10;
    private static final int PARTITION_COUNT = 10;
    private static final int TABLE_COUNT = 10;
    private static final int THREAD_COUNT = 100;
    private static final int THREAD_POOL_SIZE = 10;

    @Test
    public void testHiveFileRenamer() {
        HiveFileRenamer hiveFileRenamer = new HiveFileRenamer();
        ImmutableList requests = ImmutableList.of((Object)TestHiveMetadataUpdateHandle.TEST_HIVE_METADATA_UPDATE_REQUEST);
        List results = hiveFileRenamer.getMetadataUpdateResults((List)requests, TEST_QUERY_ID);
        Assert.assertEquals((int)requests.size(), (int)results.size());
        HiveMetadataUpdateHandle result = (HiveMetadataUpdateHandle)results.get(0);
        Assert.assertEquals((Object)result.getRequestId(), (Object)TestHiveMetadataUpdateHandle.TEST_REQUEST_ID);
        Assert.assertEquals((Object)result.getSchemaTableName(), (Object)TestHiveMetadataUpdateHandle.TEST_SCHEMA_TABLE_NAME);
        Assert.assertEquals((Object)result.getPartitionName(), Optional.of("partition_name"));
        Assert.assertEquals((Object)result.getMetadataUpdate(), Optional.of("0"));
    }

    @Test
    public void testFileNamesForSinglePartition() {
        HiveFileRenamer hiveFileRenamer = new HiveFileRenamer();
        List<ConnectorMetadataUpdateHandle> requests = this.createHiveMetadataUpdateRequests("schema", "table", "partition_name");
        List<String> fileNames = this.getFileNames(hiveFileRenamer, requests);
        ArrayList<String> aggregatedFileNames = new ArrayList<String>(fileNames);
        Assert.assertTrue((boolean)this.areFileNamesIncreasingSequentially(fileNames));
        requests = this.createHiveMetadataUpdateRequests("schema", "table", "partition_name");
        fileNames = this.getFileNames(hiveFileRenamer, requests);
        aggregatedFileNames.addAll(fileNames);
        Assert.assertEquals((int)fileNames.size(), (int)10);
        Assert.assertTrue((boolean)this.areFileNamesIncreasingSequentially(aggregatedFileNames));
    }

    @Test
    public void testFileNamesForMultiplePartitions() {
        HiveFileRenamer hiveFileRenamer = new HiveFileRenamer();
        for (int partitionNumber = 1; partitionNumber <= 10; ++partitionNumber) {
            List<ConnectorMetadataUpdateHandle> requests = this.createHiveMetadataUpdateRequests("schema", "table", "partition_" + partitionNumber);
            List<String> fileNames = this.getFileNames(hiveFileRenamer, requests);
            Assert.assertEquals((int)fileNames.size(), (int)10);
            Assert.assertTrue((boolean)this.areFileNamesIncreasingSequentially(fileNames));
        }
    }

    @Test
    public void testFileNamesForMultipleTables() {
        HiveFileRenamer hiveFileRenamer = new HiveFileRenamer();
        for (int tableNumber = 1; tableNumber <= 10; ++tableNumber) {
            List<ConnectorMetadataUpdateHandle> requests = this.createHiveMetadataUpdateRequests("schema", "table_" + tableNumber, "partition_name");
            List<String> fileNames = this.getFileNames(hiveFileRenamer, requests);
            Assert.assertEquals((int)fileNames.size(), (int)10);
            Assert.assertTrue((boolean)this.areFileNamesIncreasingSequentially(fileNames));
        }
    }

    @Test
    public void testFileNameResultCache() {
        HiveFileRenamer hiveFileRenamer = new HiveFileRenamer();
        List<ConnectorMetadataUpdateHandle> requests = this.createHiveMetadataUpdateRequests("schema", "table", "partition_name");
        List<String> fileNames = this.getFileNames(hiveFileRenamer, requests);
        List<String> fileNamesList = this.getFileNames(hiveFileRenamer, requests);
        Assert.assertEquals(fileNames, fileNamesList);
        Assert.assertEquals(fileNames, this.getFileNames(hiveFileRenamer, requests));
    }

    @Test
    public void testMultiThreadedRequests() throws InterruptedException {
        ExecutorService service = Executors.newFixedThreadPool(10);
        CountDownLatch latch = new CountDownLatch(100);
        CopyOnWriteArrayList<String> fileNames = new CopyOnWriteArrayList<String>();
        HiveFileRenamer hiveFileRenamer = new HiveFileRenamer();
        for (int i = 0; i < 100; ++i) {
            service.execute(() -> {
                List<ConnectorMetadataUpdateHandle> requests = this.createHiveMetadataUpdateRequests("schema", "table", "partition_name");
                fileNames.addAll(this.getFileNames(hiveFileRenamer, requests));
                latch.countDown();
            });
        }
        latch.await();
        Assert.assertEquals((int)fileNames.size(), (int)1000);
        Assert.assertTrue((boolean)this.areFileNamesIncreasingSequentially(fileNames));
    }

    @Test
    public void testCleanup() {
        HiveFileRenamer hiveFileRenamer = new HiveFileRenamer();
        ImmutableList requests = ImmutableList.of((Object)TestHiveMetadataUpdateHandle.TEST_HIVE_METADATA_UPDATE_REQUEST);
        List results = hiveFileRenamer.getMetadataUpdateResults((List)requests, TEST_QUERY_ID);
        Assert.assertEquals((int)results.size(), (int)1);
        HiveMetadataUpdateHandle result = (HiveMetadataUpdateHandle)results.get(0);
        Assert.assertEquals((Object)result.getMetadataUpdate(), Optional.of("0"));
        hiveFileRenamer.cleanup(TEST_QUERY_ID);
        requests = ImmutableList.of((Object)TestHiveMetadataUpdateHandle.TEST_HIVE_METADATA_UPDATE_REQUEST);
        results = hiveFileRenamer.getMetadataUpdateResults((List)requests, TEST_QUERY_ID);
        Assert.assertEquals((int)results.size(), (int)1);
        result = (HiveMetadataUpdateHandle)results.get(0);
        Assert.assertEquals((Object)result.getMetadataUpdate(), Optional.of("0"));
    }

    private List<String> getFileNames(HiveFileRenamer hiveFileRenamer, List<ConnectorMetadataUpdateHandle> requests) {
        List results = hiveFileRenamer.getMetadataUpdateResults(requests, TEST_QUERY_ID);
        return results.stream().map(result -> {
            Optional fileName = ((HiveMetadataUpdateHandle)result).getMetadataUpdate();
            Assert.assertTrue((boolean)fileName.isPresent());
            return (String)fileName.get();
        }).collect(Collectors.toList());
    }

    private List<ConnectorMetadataUpdateHandle> createHiveMetadataUpdateRequests(String schemaName, String tableName, String partitionName) {
        ArrayList<ConnectorMetadataUpdateHandle> requests = new ArrayList<ConnectorMetadataUpdateHandle>();
        for (int i = 1; i <= 10; ++i) {
            requests.add((ConnectorMetadataUpdateHandle)new HiveMetadataUpdateHandle(UUID.randomUUID(), new SchemaTableName(schemaName, tableName), Optional.of(partitionName), Optional.empty()));
        }
        return requests;
    }

    private boolean areFileNamesIncreasingSequentially(List<String> fileNames) {
        fileNames.sort(Comparator.comparingInt(Integer::valueOf));
        long start = 0L;
        for (String fileName : fileNames) {
            if (!fileName.equals(String.valueOf(start))) {
                return false;
            }
            ++start;
        }
        return true;
    }
}

