/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.execution.SqlQueryManager;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.facebook.presto.tests.statistics.InMemoryHistoryBasedPlanStatisticsProvider;
import com.google.common.collect.ImmutableList;
import io.airlift.tpch.TpchTable;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHiveHistoryBasedStatsTracking
extends AbstractTestQueryFramework {
    public QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = HiveQueryRunner.createQueryRunner(ImmutableList.of((Object)TpchTable.ORDERS));
        queryRunner.installPlugin(new Plugin(){

            public Iterable<HistoryBasedPlanStatisticsProvider> getHistoryBasedPlanStatisticsProviders() {
                return ImmutableList.of((Object)new InMemoryHistoryBasedPlanStatisticsProvider());
            }
        });
        return queryRunner;
    }

    @Test
    public void testHistoryBasedStatsCalculator() {
        try {
            this.getQueryRunner().execute("CREATE TABLE test_orders WITH (partitioned_by = ARRAY['ds', 'ts']) AS SELECT orderkey, orderpriority, comment, custkey, '2020-09-01' as ds, '00:01' as ts FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, comment, custkey, '2020-09-02' as ds, '00:02' as ts FROM orders WHERE orderkey >= 1000 AND orderkey < 2000");
            this.assertPlan("SELECT *, 1 FROM test_orders where ds = '2020-09-01' and substr(orderpriority, 1, 1) = '1'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ProjectNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[0])})}).withOutputRowCount(229.5));
            this.executeAndTrackHistory("SELECT *, 1 FROM test_orders where ds = '2020-09-01' and substr(orderpriority, 1, 1) = '1'");
            this.assertPlan("SELECT *, 2 FROM test_orders where ds = '2020-09-02' and substr(orderpriority, 1, 1) = '1'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ProjectNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[0])}).withOutputRowCount(48.0)}));
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_orders");
        }
    }

    @Test
    public void testBroadcastJoin() {
        try {
            this.getQueryRunner().execute("CREATE TABLE test_orders WITH (partitioned_by = ARRAY['ds', 'ts']) AS SELECT orderkey, orderpriority, comment, custkey, '2020-09-01' as ds, '00:01' as ts FROM orders where orderkey < 2000 UNION ALL SELECT orderkey, orderpriority, comment, custkey, '2020-09-02' as ds, '00:02' as ts FROM orders WHERE orderkey >= 1000 AND orderkey < 2000");
            Plan plan = this.plan("SELECT * FROM (SELECT * FROM test_orders where ds = '2020-09-01' and substr(CAST(custkey AS VARCHAR), 1, 3) <> '370') t1 JOIN (SELECT * FROM test_orders where ds = '2020-09-02' and substr(CAST(custkey AS VARCHAR), 1, 3) = '370') t2 ON t1.orderkey = t2.orderkey", this.createSession());
            Assert.assertTrue((boolean)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof JoinNode && ((JoinNode.DistributionType)((JoinNode)node).getDistributionType().get()).equals((Object)JoinNode.DistributionType.PARTITIONED)).findFirst().isPresent());
            this.executeAndTrackHistory("SELECT * FROM (SELECT * FROM test_orders where ds = '2020-09-01' and substr(CAST(custkey AS VARCHAR), 1, 3) <> '370') t1 JOIN (SELECT * FROM test_orders where ds = '2020-09-02' and substr(CAST(custkey AS VARCHAR), 1, 3) = '370') t2 ON t1.orderkey = t2.orderkey");
            plan = this.plan("SELECT * FROM (SELECT * FROM test_orders where ds = '2020-09-01' and substr(CAST(custkey AS VARCHAR), 1, 3) <> '370') t1 JOIN (SELECT * FROM test_orders where ds = '2020-09-02' and substr(CAST(custkey AS VARCHAR), 1, 3) = '370') t2 ON t1.orderkey = t2.orderkey", this.createSession());
            Assert.assertTrue((boolean)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof JoinNode && ((JoinNode.DistributionType)((JoinNode)node).getDistributionType().get()).equals((Object)JoinNode.DistributionType.REPLICATED)).findFirst().isPresent());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_orders");
        }
    }

    protected void assertPlan(@Language(value="SQL") String query, PlanMatchPattern pattern) {
        this.assertPlan(this.createSession(), query, pattern);
    }

    private void executeAndTrackHistory(String sql) {
        DistributedQueryRunner queryRunner = (DistributedQueryRunner)this.getQueryRunner();
        SqlQueryManager sqlQueryManager = (SqlQueryManager)queryRunner.getCoordinator().getQueryManager();
        InMemoryHistoryBasedPlanStatisticsProvider provider = (InMemoryHistoryBasedPlanStatisticsProvider)sqlQueryManager.getHistoryBasedPlanStatisticsTracker().getHistoryBasedPlanStatisticsProvider();
        queryRunner.execute(this.createSession(), sql);
        provider.waitProcessQueryEvents();
    }

    private Session createSession() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("use_history_based_plan_statistics", "true").setSystemProperty("track_history_based_plan_statistics", "true").setSystemProperty("join_distribution_type", "automatic").setCatalogSessionProperty("hive", "pushdown_filter_enabled", "true").build();
    }
}

