/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.TestHiveIntegrationSmokeTest;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.file.FileHiveMetastore;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.tpch.TpchTable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHiveLogicalPlanner
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createQueryRunner(ImmutableList.of((Object)TpchTable.ORDERS, (Object)TpchTable.LINE_ITEM, (Object)TpchTable.CUSTOMER, (Object)TpchTable.NATION), (Map<String, String>)ImmutableMap.of((Object)"experimental.pushdown-subfields-enabled", (Object)"true"), Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRepeatedFilterPushdown() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE orders_partitioned WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, '2019-11-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, '2019-11-02' as ds FROM orders WHERE orderkey < 1000");
            queryRunner.execute("CREATE TABLE lineitem_unpartitioned AS SELECT orderkey, linenumber, shipmode, '2019-11-01' as ds FROM lineitem WHERE orderkey < 1000 UNION ALL SELECT orderkey, linenumber, shipmode, '2019-11-02' as ds FROM lineitem WHERE orderkey < 1000 ");
            TupleDomain ordersDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"orderpriority", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)15), (Object)Slices.utf8Slice((String)"1-URGENT"))));
            TupleDomain lineitemDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"shipmode", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"MAIL")), (Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2019-11-02"))));
            this.assertPlan(this.pushdownFilterEnabled(), "WITH a AS (\n    SELECT ds, orderkey\n    FROM orders_partitioned\n    WHERE orderpriority = '1-URGENT' AND ds > '2019-11-01'\n),\nb AS (\n    SELECT ds, orderkey, linenumber\n    FROM lineitem_unpartitioned\n    WHERE shipmode = 'MAIL'\n)\nSELECT * FROM a LEFT JOIN b ON a.ds = b.ds", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("orders_partitioned", (TupleDomain<String>)ordersDomain, (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"orderpriority"))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("lineitem_unpartitioned", (TupleDomain<String>)lineitemDomain, (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"shipmode", (Object)"ds"))})})}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS orders_partitioned");
            queryRunner.execute("DROP TABLE IF EXISTS lineitem_unpartitioned");
        }
    }

    @Test
    public void testPushdownFilter() {
        Session pushdownFilterEnabled = this.pushdownFilterEnabled();
        this.assertPlan("SELECT linenumber FROM lineitem WHERE partkey = 10", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((PlanMatchPattern)PlanMatchPattern.filter((String)"partkey = 10", (PlanMatchPattern)PlanMatchPattern.strictTableScan((String)"lineitem", TestHiveLogicalPlanner.identityMap("linenumber", "partkey"))))})));
        this.assertPlan(pushdownFilterEnabled, "SELECT linenumber FROM lineitem WHERE partkey = 10", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.strictTableScan((String)"lineitem", TestHiveLogicalPlanner.identityMap("linenumber"))})), plan -> this.assertTableLayout((Plan)plan, "lineitem", (TupleDomain<Subfield>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new Subfield("partkey", (List)ImmutableList.of()), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)10L))), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"partkey")));
        this.assertPlan(pushdownFilterEnabled, "SELECT partkey, linenumber FROM lineitem WHERE partkey = 10", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.strictTableScan((String)"lineitem", TestHiveLogicalPlanner.identityMap("partkey", "linenumber"))})), plan -> this.assertTableLayout((Plan)plan, "lineitem", (TupleDomain<Subfield>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new Subfield("partkey", (List)ImmutableList.of()), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)10L))), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"partkey")));
        this.assertPlan("SELECT linenumber FROM lineitem WHERE mod(orderkey, 2) = 1", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((PlanMatchPattern)PlanMatchPattern.filter((String)"mod(orderkey, 2) = 1", (PlanMatchPattern)PlanMatchPattern.strictTableScan((String)"lineitem", TestHiveLogicalPlanner.identityMap("linenumber", "orderkey"))))})));
        this.assertPlan(pushdownFilterEnabled, "SELECT linenumber FROM lineitem WHERE cardinality(NULL) > 0", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.values((String[])new String[]{"linenumber"})));
        this.assertPlan(pushdownFilterEnabled, "SELECT linenumber FROM lineitem WHERE orderkey > 10 AND cardinality(NULL) > 0", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.values((String[])new String[]{"linenumber"})));
        this.assertPlan(pushdownFilterEnabled, "SELECT linenumber FROM lineitem WHERE cardinality(ARRAY[1]) > 1", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.values((String[])new String[]{"linenumber"})));
        this.assertPlan(pushdownFilterEnabled, "SELECT linenumber FROM lineitem WHERE orderkey > 10 AND cardinality(ARRAY[1]) > 1", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.values((String[])new String[]{"linenumber"})));
        this.assertPlan(pushdownFilterEnabled, "SELECT linenumber FROM lineitem WHERE orderkey = 1 AND orderkey = 2", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.values((String[])new String[]{"linenumber"})));
        this.assertPlan(pushdownFilterEnabled, "SELECT linenumber FROM lineitem WHERE orderkey = 1 AND orderkey = 2 AND linenumber % 2 = 1", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.values((String[])new String[]{"linenumber"})));
        FunctionAndTypeManager functionAndTypeManager = this.getQueryRunner().getMetadata().getFunctionAndTypeManager();
        FunctionResolution functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
        CallExpression remainingPredicate = new CallExpression(OperatorType.EQUAL.name(), functionResolution.comparisonFunction(OperatorType.EQUAL, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)new CallExpression("mod", functionAndTypeManager.lookupFunction("mod", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey", (Type)BigintType.BIGINT), (Object)this.constant(2L))), (Object)this.constant(1L)));
        this.assertPlan(pushdownFilterEnabled, "SELECT linenumber FROM lineitem WHERE mod(orderkey, 2) = 1", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.strictTableScan((String)"lineitem", TestHiveLogicalPlanner.identityMap("linenumber"))})), arg_0 -> this.lambda$testPushdownFilter$2((RowExpression)remainingPredicate, arg_0));
        this.assertPlan(pushdownFilterEnabled, "SELECT orderkey, linenumber FROM lineitem WHERE mod(orderkey, 2) = 1", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.strictTableScan((String)"lineitem", TestHiveLogicalPlanner.identityMap("orderkey", "linenumber"))})), arg_0 -> this.lambda$testPushdownFilter$3((RowExpression)remainingPredicate, arg_0));
        this.assertPlan("SELECT linenumber FROM lineitem WHERE partkey = 10 AND mod(orderkey, 2) = 1", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((PlanMatchPattern)PlanMatchPattern.filter((String)"partkey = 10 AND mod(orderkey, 2) = 1", (PlanMatchPattern)PlanMatchPattern.strictTableScan((String)"lineitem", TestHiveLogicalPlanner.identityMap("linenumber", "orderkey", "partkey"))))})));
        this.assertPlan(pushdownFilterEnabled, "SELECT linenumber FROM lineitem WHERE partkey = 10 AND mod(orderkey, 2) = 1", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.strictTableScan((String)"lineitem", TestHiveLogicalPlanner.identityMap("linenumber"))})), arg_0 -> this.lambda$testPushdownFilter$4((RowExpression)remainingPredicate, arg_0));
        this.assertPlan(pushdownFilterEnabled, "SELECT partkey, orderkey, linenumber FROM lineitem WHERE partkey = 10 AND mod(orderkey, 2) = 1", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.strictTableScan((String)"lineitem", TestHiveLogicalPlanner.identityMap("partkey", "orderkey", "linenumber"))})), arg_0 -> this.lambda$testPushdownFilter$5((RowExpression)remainingPredicate, arg_0));
    }

    @Test
    public void testPartitionPruning() {
        QueryRunner queryRunner = this.getQueryRunner();
        queryRunner.execute("CREATE TABLE test_partition_pruning WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, CAST(to_iso8601(date_add('DAY', orderkey % 7, date('2019-11-01'))) AS VARCHAR) AS ds FROM orders WHERE orderkey < 1000");
        Session pushdownFilterEnabled = this.pushdownFilterEnabled();
        try {
            this.assertPlan(pushdownFilterEnabled, "SELECT * FROM test_partition_pruning WHERE ds = '2019-11-01'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanWithConstraint("test_partition_pruning", (Map<String, Domain>)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2019-11-01"))))}));
            this.assertPlan(pushdownFilterEnabled, "SELECT * FROM test_partition_pruning WHERE date(ds) = date('2019-11-01')", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanWithConstraint("test_partition_pruning", (Map<String, Domain>)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2019-11-01"))))}));
            this.assertPlan(pushdownFilterEnabled, "SELECT * FROM test_partition_pruning WHERE date(ds) BETWEEN date('2019-11-02') AND date('2019-11-04')", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanWithConstraint("test_partition_pruning", (Map<String, Domain>)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.VARCHAR, TestHiveLogicalPlanner.utf8Slices("2019-11-02", "2019-11-03", "2019-11-04"))))}));
            this.assertPlan(pushdownFilterEnabled, "SELECT * FROM test_partition_pruning WHERE ds < '2019-11-05'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanWithConstraint("test_partition_pruning", (Map<String, Domain>)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.VARCHAR, TestHiveLogicalPlanner.utf8Slices("2019-11-01", "2019-11-02", "2019-11-03", "2019-11-04"))))}));
            this.assertPlan(pushdownFilterEnabled, "SELECT * FROM test_partition_pruning WHERE date(ds) > date('2019-11-02')", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanWithConstraint("test_partition_pruning", (Map<String, Domain>)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.VARCHAR, TestHiveLogicalPlanner.utf8Slices("2019-11-03", "2019-11-04", "2019-11-05", "2019-11-06", "2019-11-07"))))}));
            this.assertPlan(pushdownFilterEnabled, "SELECT * FROM test_partition_pruning WHERE ds < '2019-11-05' AND date(ds) > date('2019-11-02')", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanWithConstraint("test_partition_pruning", (Map<String, Domain>)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.VARCHAR, TestHiveLogicalPlanner.utf8Slices("2019-11-03", "2019-11-04"))))}));
        }
        finally {
            queryRunner.execute("DROP TABLE test_partition_pruning");
        }
    }

    @Test
    public void testOptimizeMetadataQueries() {
        QueryRunner queryRunner = this.getQueryRunner();
        Session optimizeMetadataQueries = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("optimize_metadata_queries", Boolean.toString(true)).setCatalogSessionProperty("hive", "pushdown_filter_enabled", Boolean.toString(true)).build();
        queryRunner.execute("CREATE TABLE test_optimize_metadata_queries WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, CAST(to_iso8601(date_add('DAY', orderkey % 7, date('2020-10-01'))) AS VARCHAR) AS ds FROM orders WHERE orderkey < 1000");
        queryRunner.execute("CREATE TABLE test_optimize_metadata_queries_multiple_partition_columns WITH (partitioned_by = ARRAY['ds', 'value']) AS SELECT orderkey, CAST(to_iso8601(date_add('DAY', orderkey % 7, date('2020-10-01'))) AS VARCHAR) AS ds, 1 AS value FROM orders WHERE orderkey < 1000");
        try {
            this.assertPlan(optimizeMetadataQueries, "SELECT DISTINCT ds FROM test_optimize_metadata_queries", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"ds"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new StringLiteral("2020-10-01")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-02")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-03")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-04")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-05")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-06")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-07"))))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT DISTINCT ds FROM test_optimize_metadata_queries WHERE ds > '2020-10-04'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"ds"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new StringLiteral("2020-10-05")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-06")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-07"))))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT DISTINCT ds FROM test_optimize_metadata_queries WHERE ds = '2020-10-04' AND orderkey > 200", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("test_optimize_metadata_queries", (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"orderkey", (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)200L), (Range[])new Range[0]), (boolean)false))), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"orderkey"))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT DISTINCT ds FROM test_optimize_metadata_queries WHERE ds = '2020-10-04' AND orderkey > 200", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("test_optimize_metadata_queries", (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"orderkey", (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)200L), (Range[])new Range[0]), (boolean)false))), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"orderkey"))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT DISTINCT ds FROM test_optimize_metadata_queries_multiple_partition_columns", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"ds"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new StringLiteral("2020-10-01")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-02")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-03")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-04")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-05")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-06")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-07"))))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT DISTINCT ds FROM test_optimize_metadata_queries_multiple_partition_columns WHERE ds > '2020-10-04'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"ds"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new StringLiteral("2020-10-05")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-06")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-07"))))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT DISTINCT ds FROM test_optimize_metadata_queries_multiple_partition_columns WHERE ds = '2020-10-04' AND orderkey > 200", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("test_optimize_metadata_queries_multiple_partition_columns", (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"orderkey", (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)200L), (Range[])new Range[0]), (boolean)false))), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"orderkey"))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT ds, MAX(value) FROM test_optimize_metadata_queries_multiple_partition_columns WHERE ds > '2020-10-04' GROUP BY ds", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"ds", (Object)"value"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new StringLiteral("2020-10-05"), (Object)new LongLiteral("1")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-06"), (Object)new LongLiteral("1")), (Object)ImmutableList.of((Object)new StringLiteral("2020-10-07"), (Object)new LongLiteral("1"))))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT MAX(ds), MAX(value) FROM test_optimize_metadata_queries_multiple_partition_columns WHERE ds > '2020-10-04'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"max", (Object)PlanMatchPattern.expression((String)"'2020-10-07'"), (Object)"max_2", (Object)PlanMatchPattern.expression((String)"1")), (PlanMatchPattern)PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((String[])new String[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT MAX(value), MAX(ds) FROM test_optimize_metadata_queries_multiple_partition_columns WHERE ds > '2020-10-04'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"max", (Object)PlanMatchPattern.expression((String)"1"), (Object)"max_2", (Object)PlanMatchPattern.expression((String)"'2020-10-07'")), (PlanMatchPattern)PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((String[])new String[0])}))}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_optimize_metadata_queries");
            queryRunner.execute("DROP TABLE IF EXISTS test_optimize_metadata_queries_multiple_partition_columns");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataAggregationFolding() {
        QueryRunner queryRunner = this.getQueryRunner();
        Session optimizeMetadataQueries = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("optimize_metadata_queries", Boolean.toString(true)).build();
        Session shufflePartitionColumns = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "shuffle_partitioned_columns_for_table_write", Boolean.toString(true)).build();
        queryRunner.execute(shufflePartitionColumns, "CREATE TABLE test_metadata_aggregation_folding WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, CAST(to_iso8601(date_add('DAY', orderkey % 7, date('2020-07-01'))) AS VARCHAR) AS ds FROM orders WHERE orderkey < 1000");
        queryRunner.execute(shufflePartitionColumns, "CREATE TABLE test_metadata_aggregation_folding_more_partitions WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, CAST(to_iso8601(date_add('DAY', orderkey % 200, date('2020-07-01'))) AS VARCHAR) AS ds FROM orders WHERE orderkey < 1000");
        queryRunner.execute(shufflePartitionColumns, "CREATE TABLE test_metadata_aggregation_folding_null_partitions WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, CAST(to_iso8601(date_add('DAY', orderkey % 7, date('2020-07-01'))) AS VARCHAR) AS ds FROM orders WHERE orderkey < 1000");
        queryRunner.execute(shufflePartitionColumns, "INSERT INTO test_metadata_aggregation_folding_null_partitions SELECT 0 as orderkey, null AS ds");
        try {
            this.assertPlan(optimizeMetadataQueries, "SELECT * FROM test_metadata_aggregation_folding WHERE ds = (SELECT max(ds) from test_metadata_aggregation_folding)", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of(), (PlanMatchPattern)TestHiveLogicalPlanner.tableScan("test_metadata_aggregation_folding", TestHiveLogicalPlanner.getSingleValueColumnDomain("ds", "2020-07-07"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"ds")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT * FROM test_metadata_aggregation_folding WHERE ds = (SELECT min(ds) from test_metadata_aggregation_folding)", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of(), (PlanMatchPattern)TestHiveLogicalPlanner.tableScan("test_metadata_aggregation_folding", TestHiveLogicalPlanner.getSingleValueColumnDomain("ds", "2020-07-01"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"ds")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT * FROM test_metadata_aggregation_folding_more_partitions WHERE ds = (SELECT max(ds) from test_metadata_aggregation_folding_more_partitions)", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of(), (PlanMatchPattern)TestHiveLogicalPlanner.tableScan("test_metadata_aggregation_folding_more_partitions", TestHiveLogicalPlanner.getSingleValueColumnDomain("ds", "2021-01-16"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"ds")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT * FROM test_metadata_aggregation_folding_more_partitions WHERE ds = (SELECT min(ds) from test_metadata_aggregation_folding_more_partitions)", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of(), (PlanMatchPattern)TestHiveLogicalPlanner.tableScan("test_metadata_aggregation_folding_more_partitions", TestHiveLogicalPlanner.getSingleValueColumnDomain("ds", "2020-07-01"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"ds")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT * FROM test_metadata_aggregation_folding WHERE ds = (SELECT max(ds) from test_metadata_aggregation_folding_null_partitions)", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of(), (PlanMatchPattern)TestHiveLogicalPlanner.tableScan("test_metadata_aggregation_folding", TestHiveLogicalPlanner.getSingleValueColumnDomain("ds", "2020-07-07"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"ds")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT * FROM test_metadata_aggregation_folding WHERE ds = (SELECT min(ds) from test_metadata_aggregation_folding_null_partitions)", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of(), (PlanMatchPattern)TestHiveLogicalPlanner.tableScan("test_metadata_aggregation_folding", TestHiveLogicalPlanner.getSingleValueColumnDomain("ds", "2020-07-01"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"ds")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[0])}))}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_metadata_aggregation_folding");
            queryRunner.execute("DROP TABLE IF EXISTS test_metadata_aggregation_folding_more_partitions");
            queryRunner.execute("DROP TABLE IF EXISTS test_metadata_aggregation_folding_null_partitions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataAggregationFoldingWithEmptyPartitions() {
        QueryRunner queryRunner = this.getQueryRunner();
        Session optimizeMetadataQueries = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("optimize_metadata_queries", Boolean.toString(true)).build();
        Session optimizeMetadataQueriesIgnoreStats = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("optimize_metadata_queries_ignore_stats", Boolean.toString(true)).build();
        Session shufflePartitionColumns = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "shuffle_partitioned_columns_for_table_write", Boolean.toString(true)).build();
        queryRunner.execute(shufflePartitionColumns, "CREATE TABLE test_metadata_aggregation_folding_with_empty_partitions WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, CAST(to_iso8601(date_add('DAY', orderkey % 2, date('2020-07-01'))) AS VARCHAR) AS ds FROM orders WHERE orderkey < 1000");
        ExtendedHiveMetastore metastore = TestHiveLogicalPlanner.replicateHiveMetastore((DistributedQueryRunner)queryRunner);
        MetastoreContext metastoreContext = new MetastoreContext(this.getSession().getUser(), this.getSession().getQueryId().getId(), Optional.empty(), Optional.empty(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        Table table = (Table)metastore.getTable(metastoreContext, (String)this.getSession().getSchema().get(), "test_metadata_aggregation_folding_with_empty_partitions").get();
        String partitionNameNoStats = "ds=2020-07-20";
        Partition partitionNoStats = TestHiveLogicalPlanner.createDummyPartition(table, partitionNameNoStats);
        metastore.addPartitions(metastoreContext, table.getDatabaseName(), table.getTableName(), (List)ImmutableList.of((Object)new PartitionWithStatistics(partitionNoStats, partitionNameNoStats, PartitionStatistics.empty())));
        String emptyPartitionName = "ds=2020-06-30";
        Partition emptyPartition = TestHiveLogicalPlanner.createDummyPartition(table, emptyPartitionName);
        metastore.addPartitions(metastoreContext, table.getDatabaseName(), table.getTableName(), (List)ImmutableList.of((Object)new PartitionWithStatistics(emptyPartition, emptyPartitionName, PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(1L, 0L, 0L, 0L)).build())));
        try {
            this.assertPlan(optimizeMetadataQueries, "SELECT * FROM test_metadata_aggregation_folding_with_empty_partitions WHERE ds = (SELECT max(ds) from test_metadata_aggregation_folding_with_empty_partitions)", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"test_metadata_aggregation_folding_with_empty_partitions")}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"test_metadata_aggregation_folding_with_empty_partitions")})}));
            this.assertPlan(optimizeMetadataQueriesIgnoreStats, "SELECT * FROM test_metadata_aggregation_folding_with_empty_partitions WHERE ds = (SELECT max(ds) from test_metadata_aggregation_folding_with_empty_partitions)", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of(), (PlanMatchPattern)TestHiveLogicalPlanner.tableScan("test_metadata_aggregation_folding_with_empty_partitions", TestHiveLogicalPlanner.getSingleValueColumnDomain("ds", "2020-07-20"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"ds")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT * FROM test_metadata_aggregation_folding_with_empty_partitions WHERE ds = (SELECT max(ds) from test_metadata_aggregation_folding_with_empty_partitions WHERE ds <= '2020-07-02')", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of(), (PlanMatchPattern)TestHiveLogicalPlanner.tableScan("test_metadata_aggregation_folding_with_empty_partitions", TestHiveLogicalPlanner.getSingleValueColumnDomain("ds", "2020-07-02"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"ds")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT * FROM test_metadata_aggregation_folding_with_empty_partitions WHERE ds = (SELECT min(ds) from test_metadata_aggregation_folding_with_empty_partitions)", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"test_metadata_aggregation_folding_with_empty_partitions")}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"test_metadata_aggregation_folding_with_empty_partitions")})}));
            this.assertPlan(optimizeMetadataQueries, "SELECT * FROM test_metadata_aggregation_folding_with_empty_partitions WHERE ds = (SELECT min(ds) from test_metadata_aggregation_folding_with_empty_partitions WHERE ds >= '2020-07-01')", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of(), (PlanMatchPattern)TestHiveLogicalPlanner.tableScan("test_metadata_aggregation_folding_with_empty_partitions", TestHiveLogicalPlanner.getSingleValueColumnDomain("ds", "2020-07-01"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set<String>)ImmutableSet.of((Object)"ds")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT DISTINCT ds FROM test_metadata_aggregation_folding_with_empty_partitions", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanWithConstraint("test_metadata_aggregation_folding_with_empty_partitions", (Map<String, Domain>)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.VARCHAR, TestHiveLogicalPlanner.utf8Slices("2020-06-30", "2020-07-01", "2020-07-02", "2020-07-20"))))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT DISTINCT ds FROM test_metadata_aggregation_folding_with_empty_partitions WHERE ds BETWEEN '2020-07-01' AND '2020-07-03'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"ds"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new StringLiteral("2020-07-01")), (Object)ImmutableList.of((Object)new StringLiteral("2020-07-02"))))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT MIN(ds), MAX(ds) FROM test_metadata_aggregation_folding_with_empty_partitions WHERE ds BETWEEN '2020-06-30' AND '2020-07-03'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanWithConstraint("test_metadata_aggregation_folding_with_empty_partitions", (Map<String, Domain>)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.VARCHAR, TestHiveLogicalPlanner.utf8Slices("2020-06-30", "2020-07-01", "2020-07-02"))))}));
            this.assertPlan(optimizeMetadataQueriesIgnoreStats, "SELECT MIN(ds), MAX(ds) FROM test_metadata_aggregation_folding_with_empty_partitions WHERE ds BETWEEN '2020-06-30' AND '2020-07-03'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"min", (Object)PlanMatchPattern.expression((String)"'2020-06-30'"), (Object)"max", (Object)PlanMatchPattern.expression((String)"'2020-07-02'")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((String[])new String[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT MIN(ds), MAX(ds) FROM test_metadata_aggregation_folding_with_empty_partitions WHERE ds BETWEEN '2020-07-01' AND '2020-07-03'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"min", (Object)PlanMatchPattern.expression((String)"'2020-07-01'"), (Object)"max", (Object)PlanMatchPattern.expression((String)"'2020-07-02'")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((String[])new String[0])}))}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_metadata_aggregation_folding_with_empty_partitions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataAggregationFoldingWithEmptyPartitionsAndMetastoreThreshold() {
        QueryRunner queryRunner = this.getQueryRunner();
        Session optimizeMetadataQueriesWithHighThreshold = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("optimize_metadata_queries", Boolean.toString(true)).setSystemProperty("optimize_metadata_queries_call_threshold", Integer.toString(100)).build();
        Session optimizeMetadataQueriesWithLowThreshold = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("optimize_metadata_queries", Boolean.toString(true)).setSystemProperty("optimize_metadata_queries_call_threshold", Integer.toString(1)).build();
        Session optimizeMetadataQueriesIgnoreStatsWithLowThreshold = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("optimize_metadata_queries_ignore_stats", Boolean.toString(true)).setSystemProperty("optimize_metadata_queries_call_threshold", Integer.toString(1)).build();
        Session shufflePartitionColumns = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "shuffle_partitioned_columns_for_table_write", Boolean.toString(true)).build();
        queryRunner.execute(shufflePartitionColumns, "CREATE TABLE test_metadata_aggregation_folding_with_empty_partitions_with_threshold WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, CAST(to_iso8601(date_add('DAY', orderkey % 2, date('2020-07-01'))) AS VARCHAR) AS ds FROM orders WHERE orderkey < 1000");
        ExtendedHiveMetastore metastore = TestHiveLogicalPlanner.replicateHiveMetastore((DistributedQueryRunner)queryRunner);
        MetastoreContext metastoreContext = new MetastoreContext(this.getSession().getUser(), this.getSession().getQueryId().getId(), Optional.empty(), Optional.empty(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        Table table = (Table)metastore.getTable(metastoreContext, (String)this.getSession().getSchema().get(), "test_metadata_aggregation_folding_with_empty_partitions_with_threshold").get();
        String partitionNameNoStats = "ds=2020-07-20";
        Partition partitionNoStats = TestHiveLogicalPlanner.createDummyPartition(table, partitionNameNoStats);
        metastore.addPartitions(metastoreContext, table.getDatabaseName(), table.getTableName(), (List)ImmutableList.of((Object)new PartitionWithStatistics(partitionNoStats, partitionNameNoStats, PartitionStatistics.empty())));
        String emptyPartitionName = "ds=2020-06-30";
        Partition emptyPartition = TestHiveLogicalPlanner.createDummyPartition(table, emptyPartitionName);
        metastore.addPartitions(metastoreContext, table.getDatabaseName(), table.getTableName(), (List)ImmutableList.of((Object)new PartitionWithStatistics(emptyPartition, emptyPartitionName, PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(1L, 0L, 0L, 0L)).build())));
        try {
            this.assertPlan(optimizeMetadataQueriesWithHighThreshold, "SELECT DISTINCT ds FROM test_metadata_aggregation_folding_with_empty_partitions_with_threshold WHERE ds BETWEEN '2020-07-01' AND '2020-07-03'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"ds"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new StringLiteral("2020-07-01")), (Object)ImmutableList.of((Object)new StringLiteral("2020-07-02"))))}));
            this.assertPlan(optimizeMetadataQueriesWithLowThreshold, "SELECT DISTINCT ds FROM test_metadata_aggregation_folding_with_empty_partitions_with_threshold WHERE ds BETWEEN '2020-07-01' AND '2020-07-03'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanWithConstraint("test_metadata_aggregation_folding_with_empty_partitions_with_threshold", (Map<String, Domain>)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.VARCHAR, TestHiveLogicalPlanner.utf8Slices("2020-07-01", "2020-07-02"))))}));
            this.assertPlan(optimizeMetadataQueriesIgnoreStatsWithLowThreshold, "SELECT DISTINCT ds FROM test_metadata_aggregation_folding_with_empty_partitions_with_threshold WHERE ds BETWEEN '2020-07-01' AND '2020-07-03'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"ds"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new StringLiteral("2020-07-01")), (Object)ImmutableList.of((Object)new StringLiteral("2020-07-02"))))}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_metadata_aggregation_folding_with_empty_partitions_with_threshold");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataAggregationFoldingWithTwoPartitionColumns() {
        QueryRunner queryRunner = this.getQueryRunner();
        Session optimizeMetadataQueries = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("optimize_metadata_queries", Boolean.toString(true)).build();
        Session shufflePartitionColumns = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "shuffle_partitioned_columns_for_table_write", Boolean.toString(true)).build();
        queryRunner.execute(shufflePartitionColumns, "CREATE TABLE test_metadata_aggregation_folding_with_two_partitions_columns WITH (partitioned_by = ARRAY['ds', 'status']) AS SELECT orderkey, CAST(to_iso8601(date_add('DAY', orderkey % 2, date('2020-07-01'))) AS VARCHAR) AS ds, IF(orderkey % 2 = 1, 'A', 'B') status FROM orders WHERE orderkey < 1000");
        ExtendedHiveMetastore metastore = TestHiveLogicalPlanner.replicateHiveMetastore((DistributedQueryRunner)queryRunner);
        MetastoreContext metastoreContext = new MetastoreContext(this.getSession().getUser(), this.getSession().getQueryId().getId(), Optional.empty(), Optional.empty(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        Table table = (Table)metastore.getTable(metastoreContext, (String)this.getSession().getSchema().get(), "test_metadata_aggregation_folding_with_two_partitions_columns").get();
        String partitionNameNoStats = "ds=2020-07-03/status=C";
        Partition partitionNoStats = TestHiveLogicalPlanner.createDummyPartition(table, partitionNameNoStats);
        metastore.addPartitions(metastoreContext, table.getDatabaseName(), table.getTableName(), (List)ImmutableList.of((Object)new PartitionWithStatistics(partitionNoStats, partitionNameNoStats, PartitionStatistics.empty())));
        try {
            this.assertPlan(optimizeMetadataQueries, "SELECT MIN(ds), MAX(ds) FROM test_metadata_aggregation_folding_with_two_partitions_columns WHERE ds BETWEEN '2020-07-01' AND '2020-07-02'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"min", (Object)PlanMatchPattern.expression((String)"'2020-07-01'"), (Object)"max", (Object)PlanMatchPattern.expression((String)"'2020-07-02'")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((String[])new String[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT MIN(status), MAX(ds) FROM test_metadata_aggregation_folding_with_two_partitions_columns WHERE ds BETWEEN '2020-07-01' AND '2020-07-02'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"min", (Object)PlanMatchPattern.expression((String)"'A'"), (Object)"max", (Object)PlanMatchPattern.expression((String)"'2020-07-02'")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((String[])new String[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT MIN(ds) ds, MIN(status) status FROM test_metadata_aggregation_folding_with_two_partitions_columns", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"ds", (Object)PlanMatchPattern.expression((String)"'2020-07-01'"), (Object)"status", (Object)PlanMatchPattern.expression((String)"'A'")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((String[])new String[0])}))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT MAX(status) status FROM test_metadata_aggregation_folding_with_two_partitions_columns", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanWithConstraint("test_metadata_aggregation_folding_with_two_partitions_columns", (Map<String, Domain>)ImmutableMap.of((Object)"status", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)1), TestHiveLogicalPlanner.utf8Slices("A", "B", "C")), (Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.VARCHAR, TestHiveLogicalPlanner.utf8Slices("2020-07-01", "2020-07-02", "2020-07-03"))))}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_metadata_aggregation_folding_with_two_partitions_columns");
        }
    }

    @DataProvider(name="optimize_metadata_filter_properties")
    public static Object[][] optimizeMetadataFilterProperties() {
        return new Object[][]{{true, true}, {true, false}, {false, true}, {false, false}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="optimize_metadata_filter_properties")
    public void testMetadataAggregationFoldingWithFilters(boolean pushdownSubfieldsEnabled, boolean pushdownFilterEnabled) {
        QueryRunner queryRunner = this.getQueryRunner();
        Session optimizeMetadataQueries = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("optimize_metadata_queries", Boolean.toString(true)).setSystemProperty("pushdown_subfields_enabled", Boolean.toString(pushdownSubfieldsEnabled)).setCatalogSessionProperty("hive", "pushdown_filter_enabled", Boolean.toString(pushdownFilterEnabled)).build();
        Session shufflePartitionColumns = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "shuffle_partitioned_columns_for_table_write", Boolean.toString(true)).build();
        queryRunner.execute(shufflePartitionColumns, "CREATE TABLE test_metadata_aggregation_folding_with_filters WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, ARRAY[orderstatus] AS orderstatus, CAST (ROW (orderkey) as ROW(subfield BIGINT)) AS struct, CAST(to_iso8601(date_add('DAY', orderkey % 2, date('2020-07-01'))) AS VARCHAR) AS ds FROM orders WHERE orderkey < 1000");
        try {
            this.assertPlan(optimizeMetadataQueries, "SELECT max(ds) from test_metadata_aggregation_folding_with_filters WHERE contains(orderstatus, 'F')", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanWithConstraint("test_metadata_aggregation_folding_with_filters", (Map<String, Domain>)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.VARCHAR, TestHiveLogicalPlanner.utf8Slices("2020-07-01", "2020-07-02"))))}));
            this.assertPlan(optimizeMetadataQueries, "SELECT max(ds) from test_metadata_aggregation_folding_with_filters WHERE struct.subfield is null", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanWithConstraint("test_metadata_aggregation_folding_with_filters", (Map<String, Domain>)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.VARCHAR, TestHiveLogicalPlanner.utf8Slices("2020-07-01", "2020-07-02"))))}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_metadata_aggregation_folding_with_filters");
        }
    }

    private static Partition createDummyPartition(Table table, String partitionName) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(MetastoreUtil.toPartitionValues((String)partitionName)).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC)).setLocation(new Path(table.getStorage().getLocation(), partitionName).toString())).setEligibleToIgnore(true).setSealedPartition(true).build();
    }

    private static TupleDomain<String> getSingleValueColumnDomain(String column, String value) {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)value))));
    }

    static List<Slice> utf8Slices(String ... values) {
        return (List)Arrays.stream(values).map(Slices::utf8Slice).collect(ImmutableList.toImmutableList());
    }

    private static PlanMatchPattern tableScanWithConstraint(String tableName, final Map<String, Domain> expectedConstraint) {
        return PlanMatchPattern.tableScan((String)tableName).with(new Matcher(){

            public boolean shapeMatches(PlanNode node) {
                return node instanceof TableScanNode;
            }

            public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
                TableScanNode tableScan = (TableScanNode)node;
                TupleDomain constraint = tableScan.getCurrentConstraint().transform(HiveColumnHandle.class::cast).transform(HiveColumnHandle::getName);
                if (!expectedConstraint.equals(constraint.getDomains().get())) {
                    return MatchResult.NO_MATCH;
                }
                return MatchResult.match();
            }
        });
    }

    @Test
    public void testPushdownFilterOnSubfields() {
        this.assertUpdate("CREATE TABLE test_pushdown_filter_on_subfields(id bigint, a array(bigint), b map(varchar, bigint), c row(a bigint, b row(x bigint), c array(bigint), d map(bigint, bigint), e map(varchar, bigint)))");
        this.assertPushdownFilterOnSubfields("SELECT * FROM test_pushdown_filter_on_subfields WHERE a[1] = 1", (Map<Subfield, Domain>)ImmutableMap.of((Object)new Subfield("a[1]"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        this.assertPushdownFilterOnSubfields("SELECT * FROM test_pushdown_filter_on_subfields where a[1 + 1] = 1", (Map<Subfield, Domain>)ImmutableMap.of((Object)new Subfield("a[2]"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        this.assertPushdownFilterOnSubfields("SELECT *  FROM test_pushdown_filter_on_subfields WHERE b['foo'] = 1", (Map<Subfield, Domain>)ImmutableMap.of((Object)new Subfield("b[\"foo\"]"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        this.assertPushdownFilterOnSubfields("SELECT * FROM test_pushdown_filter_on_subfields WHERE b[concat('f','o', 'o')] = 1", (Map<Subfield, Domain>)ImmutableMap.of((Object)new Subfield("b[\"foo\"]"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        this.assertPushdownFilterOnSubfields("SELECT * FROM test_pushdown_filter_on_subfields WHERE c.a = 1", (Map<Subfield, Domain>)ImmutableMap.of((Object)new Subfield("c.a"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        this.assertPushdownFilterOnSubfields("SELECT * FROM test_pushdown_filter_on_subfields WHERE c.b.x = 1", (Map<Subfield, Domain>)ImmutableMap.of((Object)new Subfield("c.b.x"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        this.assertPushdownFilterOnSubfields("SELECT * FROM test_pushdown_filter_on_subfields WHERE c.c[5] = 1", (Map<Subfield, Domain>)ImmutableMap.of((Object)new Subfield("c.c[5]"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        this.assertPushdownFilterOnSubfields("SELECT * FROM test_pushdown_filter_on_subfields WHERE c.d[5] = 1", (Map<Subfield, Domain>)ImmutableMap.of((Object)new Subfield("c.d[5]"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        this.assertPushdownFilterOnSubfields("SELECT * FROM test_pushdown_filter_on_subfields WHERE c.e[concat('f', 'o', 'o')] = 1", (Map<Subfield, Domain>)ImmutableMap.of((Object)new Subfield("c.e[\"foo\"]"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        this.assertPushdownFilterOnSubfields("SELECT * FROM test_pushdown_filter_on_subfields WHERE c.e['foo'] = 1", (Map<Subfield, Domain>)ImmutableMap.of((Object)new Subfield("c.e[\"foo\"]"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        this.assertPushdownFilterOnSubfields("SELECT * FROM test_pushdown_filter_on_subfields WHERE c.a IS NOT NULL AND c.c IS NOT NULL", (Map<Subfield, Domain>)ImmutableMap.of((Object)new Subfield("c.a"), (Object)Domain.notNull((Type)BigintType.BIGINT), (Object)new Subfield("c.c"), (Object)Domain.notNull((Type)new ArrayType((Type)BigintType.BIGINT))));
        this.assertPlan(this.pushdownFilterEnabled(), "SELECT id FROM test_pushdown_filter_on_subfields WHERE c.a = 1 AND c.a = 2", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.values((String[])new String[]{"id"})));
        this.assertUpdate("DROP TABLE test_pushdown_filter_on_subfields");
    }

    @Test
    public void testPushdownArraySubscripts() {
        this.assertUpdate("CREATE TABLE test_pushdown_array_subscripts(id bigint, a array(bigint), b array(array(varchar)), y array(row(a bigint, b varchar, c double, d row(d1 bigint, d2 double))), z array(array(row(p bigint, e row(e1 bigint, e2 varchar)))))");
        this.assertPushdownSubscripts("test_pushdown_array_subscripts");
        this.assertPushdownSubfields("SELECT t.b, a[1] FROM test_pushdown_array_subscripts CROSS JOIN UNNEST(b) as t(b)", "test_pushdown_array_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")));
        this.assertPushdownSubfields("SELECT t.b, a[1] FROM test_pushdown_array_subscripts CROSS JOIN UNNEST(b[1]) as t(b)", "test_pushdown_array_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]"), (Object)"b", TestHiveLogicalPlanner.toSubfields("b[1]")));
        this.assertPushdownSubfields("SELECT t.b[2], a[1] FROM test_pushdown_array_subscripts CROSS JOIN UNNEST(b) as t(b)", "test_pushdown_array_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]"), (Object)"b", TestHiveLogicalPlanner.toSubfields("b[*][2]")));
        this.assertPushdownSubfields("SELECT id, grouping(index), sum(length(b[1][2])) FROM test_pushdown_array_subscripts CROSS JOIN UNNEST(a) as t(index) GROUP BY grouping sets ((index, id), (index))", "test_pushdown_array_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"b", TestHiveLogicalPlanner.toSubfields("b[1][2]")));
        this.assertPushdownSubfields("SELECT id, b[1] FROM test_pushdown_array_subscripts CROSS JOIN UNNEST(a) as t(unused)", "test_pushdown_array_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"b", TestHiveLogicalPlanner.toSubfields("b[1]")));
        this.assertPushdownSubfields("SELECT array_sort(a)[1] FROM test_pushdown_array_subscripts", "test_pushdown_array_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of());
        this.assertPushdownSubfields("SELECT id FROM test_pushdown_array_subscripts CROSS JOIN UNNEST(a) as t(index) WHERE a[1] > 10 AND cardinality(b[index]) = 2", "test_pushdown_array_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of());
        this.assertUpdate("DROP TABLE test_pushdown_array_subscripts");
    }

    @Test
    public void testPushdownMapSubscripts() {
        this.assertUpdate("CREATE TABLE test_pushdown_map_subscripts(id bigint, a map(bigint, bigint), b map(bigint, map(bigint, varchar)), c map(varchar, bigint), \ny map(bigint, row(a bigint, b varchar, c double, d row(d1 bigint, d2 double))),z map(bigint, map(bigint, row(p bigint, e row(e1 bigint, e2 varchar)))))");
        this.assertPushdownSubscripts("test_pushdown_map_subscripts");
        this.assertPushdownSubfields("SELECT t.b, a[1] FROM test_pushdown_map_subscripts CROSS JOIN UNNEST(b) as t(k, b)", "test_pushdown_map_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")));
        this.assertPushdownSubfields("SELECT t.b, a[1] FROM test_pushdown_map_subscripts CROSS JOIN UNNEST(b[1]) as t(k, b)", "test_pushdown_map_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]"), (Object)"b", TestHiveLogicalPlanner.toSubfields("b[1]")));
        this.assertPushdownSubfields("SELECT t.b[2], a[1] FROM test_pushdown_map_subscripts CROSS JOIN UNNEST(b) as t(k, b)", "test_pushdown_map_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]"), (Object)"b", TestHiveLogicalPlanner.toSubfields("b[*][2]")));
        this.assertPushdownSubfields("SELECT id, b[1] FROM test_pushdown_map_subscripts CROSS JOIN UNNEST(a) as t(unused_k, unused_v)", "test_pushdown_map_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"b", TestHiveLogicalPlanner.toSubfields("b[1]")));
        this.assertPushdownSubfields("SELECT c['cat'] FROM test_pushdown_map_subscripts", "test_pushdown_map_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"c", TestHiveLogicalPlanner.toSubfields("c[\"cat\"]")));
        this.assertPushdownSubfields("SELECT c[JSON_EXTRACT_SCALAR(JSON_PARSE('{}'),'$.a')] FROM test_pushdown_map_subscripts", "test_pushdown_map_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of());
        this.assertPushdownSubfields("SELECT mod(c['cat'], 2) FROM test_pushdown_map_subscripts WHERE c['dog'] > 10", "test_pushdown_map_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"c", TestHiveLogicalPlanner.toSubfields("c[\"cat\"]", "c[\"dog\"]")));
        this.assertPushdownSubfields("SELECT map_keys(a)[1] FROM test_pushdown_map_subscripts", "test_pushdown_map_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of());
        this.assertUpdate("DROP TABLE test_pushdown_map_subscripts");
    }

    private void assertPushdownSubscripts(String tableName) {
        this.assertPushdownSubfields(String.format("SELECT a[1] FROM %s", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")));
        this.assertPushdownSubfields(String.format("SELECT a[1] + 10 FROM %s", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")));
        this.assertPushdownSubfields(String.format("SELECT a[1] + mod(a[2], 3) FROM %s", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]")));
        this.assertPushdownSubfields(String.format("SELECT a[1] FROM %s WHERE a[2] > 10", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]")));
        this.assertPushdownSubfields(String.format("SELECT a[1] FROM %s WHERE mod(a[2], 3) = 1", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]")));
        this.assertPushdownSubfields(String.format("SELECT a[1], b[2][3] FROM %s", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]"), (Object)"b", TestHiveLogicalPlanner.toSubfields("b[2][3]")));
        this.assertPushdownSubfields(String.format("SELECT cardinality(b[1]), b[1][2] FROM %s", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"b", TestHiveLogicalPlanner.toSubfields("b[1]")));
        this.assertPushdownSubfields(String.format("CREATE TABLE x AS SELECT id, a[1] as a1 FROM %s", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")));
        this.assertPushdownSubfields(String.format("CREATE TABLE x AS SELECT id FROM %s WHERE a[1] > 10", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")));
        this.assertPushdownSubfields(String.format("SELECT a[1] FROM %s ORDER BY id LIMIT 1", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")));
        this.assertPushdownSubfields(String.format("SELECT a[1] FROM %s ORDER BY a[2]", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]")));
        this.assertPlan(String.format("SELECT l.orderkey, a.a[1] FROM lineitem l, %s a WHERE l.linenumber = a.id", tableName), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("lineitem", (Map<String, Set<Subfield>>)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")))})})}));
        this.assertPlan(String.format("SELECT l.orderkey, a.a[1] FROM lineitem l, %s a WHERE l.linenumber = a.id AND a.a[2] > 10", tableName), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("lineitem", (Map<String, Set<Subfield>>)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]")))})})}));
        this.assertPlan(String.format("SELECT a[1] FROM %s WHERE a[2] IN (SELECT a[3] FROM %s)", tableName, tableName), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(SemiJoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]")))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[3]")))})})}));
        this.assertPushdownSubfields(String.format("SELECT id, min(a[1]) FROM %s GROUP BY 1", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")));
        this.assertPushdownSubfields(String.format("SELECT id, min(a[1]) FROM %s GROUP BY 1, a[2]", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]")));
        this.assertPushdownSubfields(String.format("SELECT id, min(a[1]) FROM %s GROUP BY 1 HAVING max(a[2]) > 10", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]")));
        this.assertPushdownSubfields(String.format("SELECT id, min(mod(a[1], 3)) FROM %s GROUP BY 1", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")));
        this.assertPushdownSubfields(String.format("SELECT id, min(a[1]) FILTER (WHERE a[2] > 10) FROM %s GROUP BY 1", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]")));
        this.assertPushdownSubfields(String.format("SELECT id, min(a[1] + length(b[2][3])) * avg(a[4]) FROM %s GROUP BY 1", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[4]"), (Object)"b", TestHiveLogicalPlanner.toSubfields("b[2][3]")));
        this.assertPushdownSubfields(String.format("SELECT min(a[1]) FROM %s GROUP BY id", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")));
        this.assertPushdownSubfields(String.format("SELECT arbitrary(y[1]).a FROM %s GROUP BY id", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"y", TestHiveLogicalPlanner.toSubfields("y[1].a")));
        this.assertPushdownSubfields(String.format("SELECT arbitrary(y[1]).d.d1 FROM %s GROUP BY id", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"y", TestHiveLogicalPlanner.toSubfields("y[1].d.d1")));
        this.assertPushdownSubfields(String.format("SELECT arbitrary(y[2].d).d1 FROM %s GROUP BY id", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"y", TestHiveLogicalPlanner.toSubfields("y[2].d.d1")));
        this.assertPushdownSubfields(String.format("SELECT arbitrary(y[3].d.d1) FROM %s GROUP BY id", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"y", TestHiveLogicalPlanner.toSubfields("y[3].d.d1")));
        this.assertPushdownSubfields(String.format("SELECT arbitrary(z[1][2]).e.e1 FROM %s GROUP BY id", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"z", TestHiveLogicalPlanner.toSubfields("z[1][2].e.e1")));
        this.assertPushdownSubfields(String.format("SELECT arbitrary(z[2][3].e).e2 FROM %s GROUP BY id", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"z", TestHiveLogicalPlanner.toSubfields("z[2][3].e.e2")));
        this.assertPlan(String.format("SELECT a[1] FROM %s UNION ALL SELECT a[2] FROM %s", tableName, tableName), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[2]")))})})}));
        this.assertPlan(String.format("SELECT a[1] FROM (SELECT * FROM %s UNION ALL SELECT * FROM %s)", tableName, tableName), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")))})})}));
        this.assertPlan(String.format("SELECT a[1] FROM (SELECT * FROM %s WHERE a[2] > 10 UNION ALL SELECT * FROM %s)", tableName, tableName), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]")))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")))})})}));
        this.assertPlan(String.format("SELECT a[1] FROM %s EXCEPT SELECT a[2] FROM %s", tableName, tableName), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[2]")))})})}));
        this.assertPlan(String.format("SELECT a[1] FROM %s INTERSECT SELECT a[2] FROM %s", tableName, tableName), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[2]")))})})}));
        this.assertPushdownSubfields(String.format("SELECT id, first_value(a[1]) over (partition by a[2] order by b[1][2]) FROM %s", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]"), (Object)"b", TestHiveLogicalPlanner.toSubfields("b[1][2]")));
        this.assertPushdownSubfields(String.format("SELECT count(*) over (partition by a[1] order by a[2] rows between a[3] preceding and a[4] preceding) FROM %s", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]", "a[3]", "a[4]")));
        this.assertPushdownSubfields(String.format("SELECT a[id] FROM %s", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of());
        this.assertPushdownSubfields(String.format("SELECT a[1] FROM (SELECT DISTINCT * FROM %s) LIMIT 10", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of());
        this.assertPushdownSubfields(String.format("SELECT id, min(y[1]).a FROM %s GROUP BY 1", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"y", TestHiveLogicalPlanner.toSubfields("y[1]")));
        this.assertPushdownSubfields(String.format("SELECT id, min(y[1]).a, min(y[1].d).d1 FROM %s GROUP BY 1", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"y", TestHiveLogicalPlanner.toSubfields("y[1]")));
        this.assertPushdownSubfields(String.format("SELECT id, min(z[1][2]).e.e1 FROM %s GROUP BY 1", tableName), tableName, (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"z", TestHiveLogicalPlanner.toSubfields("z[1][2]")));
    }

    @Test
    public void testPushdownSubfields() {
        this.assertUpdate("CREATE TABLE test_pushdown_struct_subfields(id bigint, x row(a bigint, b varchar, c double, d row(d1 bigint, d2 double)), y array(row(a bigint, b varchar, c double, d row(d1 bigint, d2 double))))");
        this.assertPushdownSubfields("SELECT t.a, t.d.d1, x.a FROM test_pushdown_struct_subfields CROSS JOIN UNNEST(y) as t(a, b, c, d)", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a"), (Object)"y", TestHiveLogicalPlanner.toSubfields("y[*].a", "y[*].d.d1")));
        this.assertPushdownSubfields("SELECT x.a, mod(x.d.d1, 2) FROM test_pushdown_struct_subfields", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a", "x.d.d1")));
        this.assertPushdownSubfields("SELECT x.d, mod(x.d.d1, 2), x.d.d2 FROM test_pushdown_struct_subfields", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.d")));
        this.assertPushdownSubfields("SELECT x.a FROM test_pushdown_struct_subfields WHERE x.b LIKE 'abc%'", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a", "x.b")));
        this.assertPushdownSubfields("SELECT x.a FROM test_pushdown_struct_subfields WHERE x.a > 10 AND x.b LIKE 'abc%'", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a", "x.b")));
        Session session = this.getQueryRunner().getDefaultSession();
        this.assertPlan("SELECT l.orderkey, x.a, mod(x.d.d1, 2) FROM lineitem l, test_pushdown_struct_subfields a WHERE l.linenumber = a.id", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("lineitem", (Map<String, Set<Subfield>>)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a", "x.d.d1")))})})}));
        this.assertPlan("SELECT l.orderkey, x.a, mod(x.d.d1, 2) FROM lineitem l, test_pushdown_struct_subfields a WHERE l.linenumber = a.id AND x.a > 10", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("lineitem", (Map<String, Set<Subfield>>)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a", "x.d.d1")))})})}));
        this.assertPushdownSubfields("SELECT id, min(x.a) FROM test_pushdown_struct_subfields GROUP BY 1", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a")));
        this.assertPushdownSubfields("SELECT id, min(mod(x.a, 3)) FROM test_pushdown_struct_subfields GROUP BY 1", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a")));
        this.assertPushdownSubfields("SELECT id, min(x.a) FILTER (WHERE x.b LIKE 'abc%') FROM test_pushdown_struct_subfields GROUP BY 1", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a", "x.b")));
        this.assertPushdownSubfields("SELECT id, min(x.a + length(y[2].b)) * avg(x.d.d1) FROM test_pushdown_struct_subfields GROUP BY 1", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a", "x.d.d1"), (Object)"y", TestHiveLogicalPlanner.toSubfields("y[2].b")));
        this.assertPushdownSubfields("SELECT id, arbitrary(x.a) FROM test_pushdown_struct_subfields GROUP BY 1", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a")));
        this.assertPushdownSubfields("SELECT id, arbitrary(x).a FROM test_pushdown_struct_subfields GROUP BY 1", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a")));
        this.assertPushdownSubfields("SELECT id, arbitrary(x).d.d1 FROM test_pushdown_struct_subfields GROUP BY 1", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.d.d1")));
        this.assertPushdownSubfields("SELECT id, arbitrary(x.d).d1 FROM test_pushdown_struct_subfields GROUP BY 1", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.d.d1")));
        this.assertPushdownSubfields("SELECT id, arbitrary(x.d.d2) FROM test_pushdown_struct_subfields GROUP BY 1", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.d.d2")));
        this.assertPushdownSubfields("SELECT t.a, t.d.d1, x.a FROM test_pushdown_struct_subfields CROSS JOIN UNNEST(y) as t(a, b, c, d)", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a"), (Object)"y", TestHiveLogicalPlanner.toSubfields("y[*].a", "y[*].d.d1")));
        this.assertPushdownSubfields("SELECT t.*, x.a FROM test_pushdown_struct_subfields CROSS JOIN UNNEST(y) as t(a, b, c, d)", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a"), (Object)"y", TestHiveLogicalPlanner.toSubfields("y[*].a", "y[*].b", "y[*].c", "y[*].d")));
        this.assertPushdownSubfields("SELECT id, x.a FROM test_pushdown_struct_subfields CROSS JOIN UNNEST(y) as t(a, b, c, d)", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a")));
        Session legacyUnnest = Session.builder((Session)this.getSession()).setSystemProperty("legacy_unnest", "true").build();
        this.assertPushdownSubfields(legacyUnnest, "SELECT t.y.a, t.y.d.d1, x.a FROM test_pushdown_struct_subfields CROSS JOIN UNNEST(y) as t(y)", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a"), (Object)"y", TestHiveLogicalPlanner.toSubfields("y[*].a", "y[*].d.d1")));
        this.assertPushdownSubfields(legacyUnnest, "SELECT t.*, x.a FROM test_pushdown_struct_subfields CROSS JOIN UNNEST(y) as t(y)", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a")));
        this.assertPushdownSubfields(legacyUnnest, "SELECT id, x.a FROM test_pushdown_struct_subfields CROSS JOIN UNNEST(y) as t(y)", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a")));
        this.assertPushdownSubfields("SELECT x.a, x.b, x.A + 2 FROM test_pushdown_struct_subfields WHERE x.B LIKE 'abc%'", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a", "x.b")));
        this.assertPushdownSubfields("SELECT id, min(x.d).d1 FROM test_pushdown_struct_subfields GROUP BY 1", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.d")));
        this.assertPushdownSubfields("SELECT id, min(x.d).d1, min(x.d.d2) FROM test_pushdown_struct_subfields GROUP BY 1", "test_pushdown_struct_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.d")));
        this.assertUpdate("DROP TABLE test_pushdown_struct_subfields");
    }

    @Test
    public void testPushdownSubfieldsAssorted() {
        this.assertUpdate("CREATE TABLE test_pushdown_subfields(id bigint, a array(bigint), b map(bigint, bigint), c map(varchar, bigint), d row(d1 bigint, d2 array(bigint), d3 map(bigint, bigint), d4 row(x double, y double)), w array(array(row(p bigint, e row(e1 bigint, e2 varchar)))), x row(a bigint, b varchar, c double, d row(d1 bigint, d2 double)), y array(row(a bigint, b varchar, c double, d row(d1 bigint, d2 double))), z row(a bigint, b varchar, c double))");
        this.assertPushdownSubfields("SELECT id, a[1], mod(a[2], 3), b[10], c['cat'] + c['dog'], d.d1 * d.d2[5] / d.d3[2], d.d4.x FROM test_pushdown_subfields", "test_pushdown_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]"), (Object)"b", TestHiveLogicalPlanner.toSubfields("b[10]"), (Object)"c", TestHiveLogicalPlanner.toSubfields("c[\"cat\"]", "c[\"dog\"]"), (Object)"d", TestHiveLogicalPlanner.toSubfields("d.d1", "d.d2[5]", "d.d3[2]", "d.d4.x")));
        this.assertPushdownSubfields("SELECT count(*) FROM test_pushdown_subfields WHERE a[1] > a[2] AND b[1] * c['cat'] = 5 AND d.d4.x IS NULL", "test_pushdown_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]"), (Object)"b", TestHiveLogicalPlanner.toSubfields("b[1]"), (Object)"c", TestHiveLogicalPlanner.toSubfields("c[\"cat\"]"), (Object)"d", TestHiveLogicalPlanner.toSubfields("d.d4.x")));
        this.assertPushdownSubfields("SELECT a[1], cardinality(b), map_keys(c), k, v, d.d3[5] FROM test_pushdown_subfields CROSS JOIN UNNEST(c) as t(k, v)", "test_pushdown_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]"), (Object)"d", TestHiveLogicalPlanner.toSubfields("d.d3[5]")));
        this.assertPushdownSubfields("SELECT id, arbitrary(x.a), arbitrary(x).a, arbitrary(x).d.d1, arbitrary(x.d).d1, arbitrary(x.d.d2), arbitrary(y[1]).a, arbitrary(y[1]).d.d1, arbitrary(y[2]).d.d1, arbitrary(y[3].d.d1), arbitrary(z).c, arbitrary(w[1][2]).e.e1, arbitrary(w[2][3].e.e2) FROM test_pushdown_subfields GROUP BY 1", "test_pushdown_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a", "x.d.d1", "x.d.d2"), (Object)"y", TestHiveLogicalPlanner.toSubfields("y[1].a", "y[1].d.d1", "y[2].d.d1", "y[3].d.d1"), (Object)"z", TestHiveLogicalPlanner.toSubfields("z.c"), (Object)"w", TestHiveLogicalPlanner.toSubfields("w[1][2].e.e1", "w[2][3].e.e2")));
        this.assertPushdownSubfields("SELECT id, min(x.d).d1, min(x.d.d2), min(z).c, min(z.b), min(y[1]).a, min(y[1]).d.d1, min(y[2].d.d1), min(w[1][2]).e.e1, min(w[2][3].e.e2) FROM test_pushdown_subfields GROUP BY 1", "test_pushdown_subfields", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.d"), (Object)"y", TestHiveLogicalPlanner.toSubfields("y[1]", "y[2].d.d1"), (Object)"w", TestHiveLogicalPlanner.toSubfields("w[1][2]", "w[2][3].e.e2")));
        this.assertUpdate("DROP TABLE test_pushdown_subfields");
    }

    @Test
    public void testPushdownFilterAndSubfields() {
        this.assertUpdate("CREATE TABLE test_pushdown_filter_and_subscripts(id bigint, a array(bigint), b array(array(varchar)))");
        Session pushdownFilterEnabled = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "pushdown_filter_enabled", "true").build();
        this.assertPushdownSubfields("SELECT a[1] FROM test_pushdown_filter_and_subscripts WHERE a[2] > 10", "test_pushdown_filter_and_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]", "a[2]")));
        this.assertPushdownSubfields(pushdownFilterEnabled, "SELECT a[1] FROM test_pushdown_filter_and_subscripts WHERE a[2] > 10", "test_pushdown_filter_and_subscripts", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"a", TestHiveLogicalPlanner.toSubfields("a[1]")));
        this.assertUpdate("DROP TABLE test_pushdown_filter_and_subscripts");
    }

    @Test
    public void testVirtualBucketing() {
        try {
            this.assertUpdate("CREATE TABLE test_virtual_bucket(a bigint, b bigint)");
            Session virtualBucketEnabled = Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "virtual_bucket_count", "2").build();
            this.assertPlan(virtualBucketEnabled, "SELECT COUNT(DISTINCT(\"$path\")) FROM test_virtual_bucket", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE_STREAMING, (ExchangeNode.Type)ExchangeNode.Type.GATHER, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("test_virtual_bucket", (Map<String, Set<Subfield>>)ImmutableMap.of())})})}), TestHiveIntegrationSmokeTest.assertRemoteExchangesCount(1, this.getSession(), (DistributedQueryRunner)this.getQueryRunner()));
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS test_virtual_bucket");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPushdownSubfieldsAndJoinReordering() {
        Session collectStatistics = Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "collect_column_statistics_on_write", "true").build();
        this.getQueryRunner().execute(collectStatistics, "CREATE TABLE orders_ex AS SELECT orderkey, custkey, array[custkey] as keys FROM orders");
        try {
            Session joinReorderingOn = Session.builder((Session)this.pushdownFilterEnabled()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.AUTOMATIC.name()).build();
            Session joinReorderingOff = Session.builder((Session)this.pushdownFilterEnabled()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).build();
            this.assertPlan(joinReorderingOff, "SELECT sum(custkey) FROM orders_ex o, lineitem l WHERE o.orderkey = l.orderkey", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"o_orderkey", (String)"l_orderkey")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_ex", (Map)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"lineitem", (Map)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey"))}))}));
            this.assertPlan(joinReorderingOff, "SELECT sum(keys[1]) FROM orders_ex o, lineitem l WHERE o.orderkey = l.orderkey", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"o_orderkey", (String)"l_orderkey")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_ex", (Map)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"lineitem", (Map)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey"))}))}));
            this.assertPlan(joinReorderingOn, "SELECT sum(custkey) FROM orders_ex o, lineitem l WHERE o.orderkey = l.orderkey", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"l_orderkey", (String)"o_orderkey")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"lineitem", (Map)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey"))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_ex", (Map)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))}))}));
            this.assertPlan(joinReorderingOn, "SELECT sum(keys[1]) FROM orders_ex o, lineitem l WHERE o.orderkey = l.orderkey", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"l_orderkey", (String)"o_orderkey")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"lineitem", (Map)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey"))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_ex", (Map)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))}))}));
            this.assertPlan(joinReorderingOff, "SELECT l.discount, l.orderkey, o.totalprice FROM lineitem l, orders o WHERE l.orderkey = o.orderkey AND l.quantity < 2 AND o.totalprice BETWEEN 0 AND 200000", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("lineitem", (Map<String, Set<Subfield>>)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("orders", (Map<String, Set<Subfield>>)ImmutableMap.of())})})}));
            this.assertPlan(joinReorderingOn, "SELECT l.discount, l.orderkey, o.totalprice FROM lineitem l, orders o WHERE l.orderkey = o.orderkey AND l.quantity < 2 AND o.totalprice BETWEEN 0 AND 200000", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("orders", (Map<String, Set<Subfield>>)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("lineitem", (Map<String, Set<Subfield>>)ImmutableMap.of())})})}));
            this.assertPlan(joinReorderingOff, "SELECT keys[1] FROM orders_ex o, lineitem l WHERE o.orderkey = l.orderkey AND o.keys[1] > 0", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"o_orderkey", (String)"l_orderkey")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_ex", (Map)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"lineitem", (Map)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey"))}))}));
            this.assertPlan(joinReorderingOn, "SELECT keys[1] FROM orders_ex o, lineitem l WHERE o.orderkey = l.orderkey AND o.keys[1] > 0", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"l_orderkey", (String)"o_orderkey")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"lineitem", (Map)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey"))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_ex", (Map)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))}))}));
        }
        finally {
            this.assertUpdate("DROP TABLE orders_ex");
        }
    }

    @Test
    public void testParquetDereferencePushDown() {
        this.assertUpdate("CREATE TABLE test_pushdown_nestedcolumn_parquet(id bigint, x row(a bigint, b varchar, c double, d row(d1 bigint, d2 double)),y array(row(a bigint, b varchar, c double, d row(d1 bigint, d2 double)))) with (format = 'PARQUET')");
        this.assertParquetDereferencePushDown("SELECT x.a FROM test_pushdown_nestedcolumn_parquet", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a"));
        this.assertParquetDereferencePushDown("SELECT x.a, mod(x.d.d1, 2) FROM test_pushdown_nestedcolumn_parquet", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a", "x.d.d1"));
        this.assertParquetDereferencePushDown("SELECT x.d, mod(x.d.d1, 2), x.d.d2 FROM test_pushdown_nestedcolumn_parquet", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.d"));
        this.assertParquetDereferencePushDown("SELECT x.a FROM test_pushdown_nestedcolumn_parquet WHERE x.b LIKE 'abc%'", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a", "x.b"));
        this.assertParquetDereferencePushDown("SELECT x.a FROM test_pushdown_nestedcolumn_parquet WHERE x.a > 10 AND x.b LIKE 'abc%'", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a", "x.b"), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ParquetTypeUtils.pushdownColumnNameForSubfield((Subfield)TestHiveLogicalPlanner.nestedColumn("x.a")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), (boolean)false))), (Set<String>)ImmutableSet.of((Object)ParquetTypeUtils.pushdownColumnNameForSubfield((Subfield)TestHiveLogicalPlanner.nestedColumn("x.a"))), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
        this.assertPlan(this.withParquetDereferencePushDownEnabled(), "SELECT l.orderkey, x.a, mod(x.d.d1, 2) FROM lineitem l, test_pushdown_nestedcolumn_parquet a WHERE l.linenumber = a.id", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("lineitem", (Map<String, Set<Subfield>>)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanParquetDeferencePushDowns("test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a", "x.d.d1"))})})}));
        this.assertPlan(this.withParquetDereferencePushDownEnabled(), "SELECT l.orderkey, x.a, mod(x.d.d1, 2) FROM lineitem l, test_pushdown_nestedcolumn_parquet a WHERE l.linenumber = a.id AND x.a > 10", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("lineitem", (Map<String, Set<Subfield>>)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanParquetDeferencePushDowns("test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a", "x.d.d1"), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ParquetTypeUtils.pushdownColumnNameForSubfield((Subfield)TestHiveLogicalPlanner.nestedColumn("x.a")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), (boolean)false))), (Set<String>)ImmutableSet.of((Object)ParquetTypeUtils.pushdownColumnNameForSubfield((Subfield)TestHiveLogicalPlanner.nestedColumn("x.a"))), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT)})})}));
        this.assertPlan(this.withParquetDereferencePushDownEnabled(), "SELECT t1.x.a, t2.x.a FROM test_pushdown_nestedcolumn_parquet t1, test_pushdown_nestedcolumn_parquet t2 where t1.id = t2.id", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanParquetDeferencePushDowns("test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a"))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanParquetDeferencePushDowns("test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a"))})})}));
        this.assertParquetDereferencePushDown("SELECT id, min(x.a) FROM test_pushdown_nestedcolumn_parquet GROUP BY 1", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a"));
        this.assertParquetDereferencePushDown("SELECT id, min(mod(x.a, 3)) FROM test_pushdown_nestedcolumn_parquet GROUP BY 1", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a"));
        this.assertParquetDereferencePushDown("SELECT id, min(x.a) FILTER (WHERE x.b LIKE 'abc%') FROM test_pushdown_nestedcolumn_parquet GROUP BY 1", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a", "x.b"));
        this.assertParquetDereferencePushDown("SELECT id, min(x.a + 1) * avg(x.d.d1) FROM test_pushdown_nestedcolumn_parquet GROUP BY 1", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a", "x.d.d1"));
        this.assertParquetDereferencePushDown("SELECT id, arbitrary(x.a) FROM test_pushdown_nestedcolumn_parquet GROUP BY 1", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a"));
        this.assertPushdownSubfields("SELECT id, arbitrary(x.a) FROM test_pushdown_nestedcolumn_parquet GROUP BY 1", "test_pushdown_nestedcolumn_parquet", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.a")));
        this.assertPushdownSubfields("SELECT id, arbitrary(x).d.d1 FROM test_pushdown_nestedcolumn_parquet GROUP BY 1", "test_pushdown_nestedcolumn_parquet", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"x", TestHiveLogicalPlanner.toSubfields("x.d.d1")));
        this.assertParquetDereferencePushDown("SELECT id, arbitrary(x.d).d1 FROM test_pushdown_nestedcolumn_parquet GROUP BY 1", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.d"));
        this.assertParquetDereferencePushDown("SELECT id, arbitrary(x.d.d2) FROM test_pushdown_nestedcolumn_parquet GROUP BY 1", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.d.d2"));
        this.assertParquetDereferencePushDown("SELECT t.a, t.d.d1, x.a FROM test_pushdown_nestedcolumn_parquet CROSS JOIN UNNEST(y) as t(a, b, c, d)", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a"));
        this.assertParquetDereferencePushDown("SELECT t.*, x.a FROM test_pushdown_nestedcolumn_parquet CROSS JOIN UNNEST(y) as t(a, b, c, d)", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a"));
        this.assertParquetDereferencePushDown("SELECT id, x.a FROM test_pushdown_nestedcolumn_parquet CROSS JOIN UNNEST(y) as t(a, b, c, d)", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a"));
        Session legacyUnnest = Session.builder((Session)this.withParquetDereferencePushDownEnabled()).setSystemProperty("legacy_unnest", "true").build();
        this.assertParquetDereferencePushDown(legacyUnnest, "SELECT t.y.a, t.y.d.d1, x.a FROM test_pushdown_nestedcolumn_parquet CROSS JOIN UNNEST(y) as t(y)", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a"));
        this.assertParquetDereferencePushDown(legacyUnnest, "SELECT t.*, x.a FROM test_pushdown_nestedcolumn_parquet CROSS JOIN UNNEST(y) as t(y)", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a"));
        this.assertParquetDereferencePushDown(legacyUnnest, "SELECT id, x.a FROM test_pushdown_nestedcolumn_parquet CROSS JOIN UNNEST(y) as t(y)", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a"));
        this.assertParquetDereferencePushDown("SELECT x.a, x.b, x.A + 2 FROM test_pushdown_nestedcolumn_parquet WHERE x.B LIKE 'abc%'", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.a", "x.b"));
        this.assertParquetDereferencePushDown("SELECT id, min(x.d).d1 FROM test_pushdown_nestedcolumn_parquet GROUP BY 1", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.d"));
        this.assertParquetDereferencePushDown("SELECT id, min(x.d).d1, min(x.d.d2) FROM test_pushdown_nestedcolumn_parquet GROUP BY 1", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.d"));
        this.assertParquetDereferencePushDown("SELECT id, x.d.d1 FROM test_pushdown_nestedcolumn_parquet WHERE x.d.d1 = 1", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.d.d1"), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ParquetTypeUtils.pushdownColumnNameForSubfield((Subfield)TestHiveLogicalPlanner.nestedColumn("x.d.d1")), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (Set<String>)ImmutableSet.of((Object)ParquetTypeUtils.pushdownColumnNameForSubfield((Subfield)TestHiveLogicalPlanner.nestedColumn("x.d.d1"))), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
        this.assertParquetDereferencePushDown("SELECT id, x.d.d1 FROM test_pushdown_nestedcolumn_parquet WHERE x.d.d1 = 1 and x.d.d2 = 5.0", "test_pushdown_nestedcolumn_parquet", TestHiveLogicalPlanner.nestedColumnMap("x.d.d1", "x.d.d2"), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ParquetTypeUtils.pushdownColumnNameForSubfield((Subfield)TestHiveLogicalPlanner.nestedColumn("x.d.d1")), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)ParquetTypeUtils.pushdownColumnNameForSubfield((Subfield)TestHiveLogicalPlanner.nestedColumn("x.d.d2")), (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)5.0))), (Set<String>)ImmutableSet.of((Object)ParquetTypeUtils.pushdownColumnNameForSubfield((Subfield)TestHiveLogicalPlanner.nestedColumn("x.d.d1")), (Object)ParquetTypeUtils.pushdownColumnNameForSubfield((Subfield)TestHiveLogicalPlanner.nestedColumn("x.d.d2"))), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
        this.assertUpdate("DROP TABLE test_pushdown_nestedcolumn_parquet");
    }

    @Test
    public void testBucketPruning() {
        QueryRunner queryRunner = this.getQueryRunner();
        queryRunner.execute("CREATE TABLE orders_bucketed WITH (bucket_count = 11, bucketed_by = ARRAY['orderkey']) AS SELECT * FROM orders");
        try {
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed WHERE orderkey = 100", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertBucketFilter((Plan)plan, "orders_bucketed", 11, (Set<Integer>)ImmutableSet.of((Object)1)));
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed WHERE orderkey = 100 OR orderkey = 101", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertBucketFilter((Plan)plan, "orders_bucketed", 11, (Set<Integer>)ImmutableSet.of((Object)1, (Object)2)));
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed WHERE orderkey IN (100, 101, 133)", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertBucketFilter((Plan)plan, "orders_bucketed", 11, (Set<Integer>)ImmutableSet.of((Object)1, (Object)2)));
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertNoBucketFilter((Plan)plan, "orders_bucketed", 11));
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed WHERE orderkey > 100", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertNoBucketFilter((Plan)plan, "orders_bucketed", 11));
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed WHERE orderkey != 100", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertNoBucketFilter((Plan)plan, "orders_bucketed", 11));
        }
        finally {
            queryRunner.execute("DROP TABLE orders_bucketed");
        }
        queryRunner.execute("CREATE TABLE orders_bucketed WITH (bucket_count = 11, bucketed_by = ARRAY['orderkey', 'custkey']) AS SELECT * FROM orders");
        try {
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed WHERE orderkey = 101 AND custkey = 280", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertBucketFilter((Plan)plan, "orders_bucketed", 11, (Set<Integer>)ImmutableSet.of((Object)1)));
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed WHERE orderkey IN (101, 71) AND custkey = 280", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertBucketFilter((Plan)plan, "orders_bucketed", 11, (Set<Integer>)ImmutableSet.of((Object)1, (Object)6)));
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed WHERE orderkey IN (101, 71) AND custkey IN (280, 34)", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertBucketFilter((Plan)plan, "orders_bucketed", 11, (Set<Integer>)ImmutableSet.of((Object)1, (Object)2, (Object)6, (Object)8)));
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed WHERE orderkey = 101 AND custkey = 280 AND orderstatus <> '0'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertBucketFilter((Plan)plan, "orders_bucketed", 11, (Set<Integer>)ImmutableSet.of((Object)1)));
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed WHERE orderkey = 101", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertNoBucketFilter((Plan)plan, "orders_bucketed", 11));
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed WHERE custkey = 280", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertNoBucketFilter((Plan)plan, "orders_bucketed", 11));
            this.assertPlan(this.getSession(), "SELECT * FROM orders_bucketed WHERE orderkey = 101 AND custkey > 280", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_bucketed")}), plan -> this.assertNoBucketFilter((Plan)plan, "orders_bucketed", 11));
        }
        finally {
            queryRunner.execute("DROP TABLE orders_bucketed");
        }
    }

    @Test
    public void testAddRequestedColumnsToLayout() {
        String tableName = "test_add_requested_columns_to_layout";
        this.assertUpdate(String.format("CREATE TABLE %s(id bigint, a row(d1 bigint, d2 array(bigint), d3 map(bigint, bigint), d4 row(x double, y double)), b varchar )", tableName));
        try {
            this.assertPlan(this.getSession(), String.format("SELECT b FROM %s", tableName), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)tableName)}), plan -> this.assertRequestedColumnsInLayout((Plan)plan, tableName, (Set<String>)ImmutableSet.of((Object)"b")));
            this.assertPlan(this.getSession(), String.format("SELECT id, b FROM %s", tableName), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)tableName)}), plan -> this.assertRequestedColumnsInLayout((Plan)plan, tableName, (Set<String>)ImmutableSet.of((Object)"id", (Object)"b")));
            this.assertPlan(this.getSession(), String.format("SELECT id, a FROM %s", tableName), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)tableName)}), plan -> this.assertRequestedColumnsInLayout((Plan)plan, tableName, (Set<String>)ImmutableSet.of((Object)"id", (Object)"a")));
            this.assertPlan(this.getSession(), String.format("SELECT a.d1, a.d4.x FROM %s", tableName), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)tableName)}), plan -> this.assertRequestedColumnsInLayout((Plan)plan, tableName, (Set<String>)ImmutableSet.of((Object)"a.d1", (Object)"a.d4.x")));
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP TABLE %s", tableName));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartialAggregatePushdown() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE orders_partitioned_parquet WITH (partitioned_by = ARRAY['ds'], format='PARQUET') AS SELECT orderkey, orderpriority, comment, '2019-11-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, comment, '2019-11-02' as ds FROM orders WHERE orderkey < 1000");
            ImmutableMap aggregations = ImmutableMap.of(Optional.of("count"), (Object)PlanMatchPattern.functionCall((String)"count", (boolean)false, (List)ImmutableList.of((Object)PlanMatchPattern.anySymbol())));
            ImmutableList groupByKey = ImmutableList.of((Object)"count_star");
            this.assertPlan(this.partialAggregatePushdownEnabled(), "select count(*) from orders_partitioned_parquet", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.globalAggregation(), (Map)aggregations, (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.FINAL, (PlanMatchPattern)PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (ExchangeNode.Type)ExchangeNode.Type.GATHER, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE_STREAMING, (ExchangeNode.Type)ExchangeNode.Type.GATHER, (PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("orders_partitioned_parquet", (Map<String, Set<Subfield>>)ImmutableMap.of())})}))}));
            aggregations = ImmutableMap.of(Optional.of("count_1"), (Object)PlanMatchPattern.functionCall((String)"count", (boolean)false, (List)ImmutableList.of((Object)PlanMatchPattern.anySymbol())), Optional.of("max"), (Object)PlanMatchPattern.functionCall((String)"max", (boolean)false, (List)ImmutableList.of((Object)PlanMatchPattern.anySymbol())), Optional.of("min"), (Object)PlanMatchPattern.functionCall((String)"max", (boolean)false, (List)ImmutableList.of((Object)PlanMatchPattern.anySymbol())));
            this.assertPlan(this.partialAggregatePushdownEnabled(), "select count(orderkey), max(orderpriority), min(ds) from orders_partitioned_parquet", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.globalAggregation(), (Map)aggregations, (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.FINAL, (PlanMatchPattern)PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (ExchangeNode.Type)ExchangeNode.Type.GATHER, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE_STREAMING, (ExchangeNode.Type)ExchangeNode.Type.GATHER, (PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan("orders_partitioned_parquet", (Map<String, Set<Subfield>>)ImmutableMap.of((Object)"orderkey", (Object)ImmutableSet.of(), (Object)"orderpriority", (Object)ImmutableSet.of(), (Object)"ds", (Object)ImmutableSet.of()))})}))}));
            this.assertPlan(this.partialAggregatePushdownEnabled(), "select count(orderkey), max(orderpriority), min(ds) from orders_partitioned_parquet where orderkey = 100", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_partitioned_parquet")}), plan -> this.assertNoAggregatedColumns((Plan)plan, "orders_partitioned_parquet"));
            aggregations = ImmutableMap.of(Optional.of("count_1"), (Object)PlanMatchPattern.functionCall((String)"count", (boolean)false, (List)ImmutableList.of((Object)PlanMatchPattern.anySymbol())), Optional.of("arbitrary"), (Object)PlanMatchPattern.functionCall((String)"arbitrary", (boolean)false, (List)ImmutableList.of((Object)PlanMatchPattern.anySymbol())), Optional.of("min"), (Object)PlanMatchPattern.functionCall((String)"max", (boolean)false, (List)ImmutableList.of((Object)PlanMatchPattern.anySymbol())));
            this.assertPlan(this.partialAggregatePushdownEnabled(), "select count(orderkey), arbitrary(orderpriority), min(ds) from orders_partitioned_parquet", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_partitioned_parquet")}), plan -> this.assertNoAggregatedColumns((Plan)plan, "orders_partitioned_parquet"));
            this.assertPlan(this.partialAggregatePushdownEnabled(), "select count(orderkey), max(orderpriority), min(ds) from orders_partitioned_parquet where ds = '2019-11-01' and orderkey = 100", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders_partitioned_parquet")}), plan -> this.assertNoAggregatedColumns((Plan)plan, "orders_partitioned_parquet"));
            Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "partial_aggregation_pushdown_enabled", "true").build();
            queryRunner.execute("CREATE TABLE variable_length_table(col1 varchar, col2 varchar(100), col3 varbinary) with (format='PARQUET')");
            queryRunner.execute("INSERT INTO variable_length_table values ('foo','bar',cast('baz' as varbinary))");
            this.assertPlan(session, "select min(col1) from variable_length_table", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"variable_length_table")}), plan -> this.assertNoAggregatedColumns((Plan)plan, "variable_length_table"));
            this.assertPlan(session, "select max(col3) from variable_length_table", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"variable_length_table")}), plan -> this.assertNoAggregatedColumns((Plan)plan, "variable_length_table"));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS orders_partitioned_parquet");
            queryRunner.execute("DROP TABLE IF EXISTS variable_length_table");
        }
    }

    private static Set<Subfield> toSubfields(String ... subfieldPaths) {
        return (Set)Arrays.stream(subfieldPaths).map(Subfield::new).collect(ImmutableSet.toImmutableSet());
    }

    private void assertPushdownSubfields(String query, String tableName, Map<String, Set<Subfield>> requiredSubfields) {
        this.assertPlan(query, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, requiredSubfields)}));
    }

    private void assertPushdownSubfields(Session session, String query, String tableName, Map<String, Set<Subfield>> requiredSubfields) {
        this.assertPlan(session, query, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScan(tableName, requiredSubfields)}));
    }

    private static PlanMatchPattern tableScan(String expectedTableName, Map<String, Set<Subfield>> expectedRequiredSubfields) {
        return PlanMatchPattern.tableScan((String)expectedTableName).with((Matcher)new HiveTableScanMatcher(expectedRequiredSubfields));
    }

    private static PlanMatchPattern tableScanParquetDeferencePushDowns(String expectedTableName, Map<String, Subfield> expectedDeferencePushDowns) {
        return PlanMatchPattern.tableScan((String)expectedTableName).with((Matcher)new HiveParquetDereferencePushdownMatcher(expectedDeferencePushDowns, TupleDomain.all(), (Set)ImmutableSet.of(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT));
    }

    private static PlanMatchPattern tableScanParquetDeferencePushDowns(String expectedTableName, Map<String, Subfield> expectedDeferencePushDowns, TupleDomain<String> domainPredicate, Set<String> predicateColumns, RowExpression remainingPredicate) {
        return PlanMatchPattern.tableScan((String)expectedTableName).with((Matcher)new HiveParquetDereferencePushdownMatcher(expectedDeferencePushDowns, domainPredicate, predicateColumns, remainingPredicate));
    }

    private static boolean isTableScanNode(PlanNode node, String tableName) {
        return node instanceof TableScanNode && ((HiveTableHandle)((TableScanNode)node).getTable().getConnectorHandle()).getTableName().equals(tableName);
    }

    private void assertPushdownFilterOnSubfields(String query, Map<Subfield, Domain> predicateDomains) {
        String tableName = "test_pushdown_filter_on_subfields";
        this.assertPlan(this.pushdownFilterAndNestedColumnFilterEnabled(), query, PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)tableName)})), plan -> this.assertTableLayout((Plan)plan, tableName, (TupleDomain<Subfield>)TupleDomain.withColumnDomains((Map)predicateDomains), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (Set)predicateDomains.keySet().stream().map(Subfield::getRootName).collect(ImmutableSet.toImmutableSet())));
    }

    private void assertParquetDereferencePushDown(String query, String tableName, Map<String, Subfield> expectedDeferencePushDowns) {
        this.assertParquetDereferencePushDown(this.withParquetDereferencePushDownEnabled(), query, tableName, expectedDeferencePushDowns);
    }

    private void assertParquetDereferencePushDown(String query, String tableName, Map<String, Subfield> expectedDeferencePushDowns, TupleDomain<String> domainPredicate, Set<String> predicateColumns, RowExpression remainingPredicate) {
        this.assertPlan(this.withParquetDereferencePushDownEnabled(), query, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanParquetDeferencePushDowns(tableName, expectedDeferencePushDowns, domainPredicate, predicateColumns, remainingPredicate)}));
    }

    private void assertParquetDereferencePushDown(Session session, String query, String tableName, Map<String, Subfield> expectedDeferencePushDowns) {
        this.assertPlan(session, query, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{TestHiveLogicalPlanner.tableScanParquetDeferencePushDowns(tableName, expectedDeferencePushDowns)}));
    }

    private Session pushdownFilterEnabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "pushdown_filter_enabled", "true").build();
    }

    private Session pushdownFilterAndNestedColumnFilterEnabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "pushdown_filter_enabled", "true").setCatalogSessionProperty("hive", "range_filters_on_subscripts_enabled", "true").build();
    }

    private Session withParquetDereferencePushDownEnabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("pushdown_dereference_enabled", "true").setCatalogSessionProperty("hive", "parquet_dereference_pushdown_enabled", "true").build();
    }

    private Session partialAggregatePushdownEnabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "partial_aggregation_pushdown_enabled", "true").setCatalogSessionProperty("hive", "partial_aggregation_pushdown_for_variable_length_datatypes_enabled", "true").build();
    }

    private RowExpression constant(long value) {
        return new ConstantExpression((Object)value, (Type)BigintType.BIGINT);
    }

    private static Map<String, String> identityMap(String ... values) {
        return (Map)Arrays.stream(values).collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), (Function)Functions.identity()));
    }

    private void assertTableLayout(Plan plan, String tableName, TupleDomain<Subfield> domainPredicate, RowExpression remainingPredicate, Set<String> predicateColumnNames) {
        TableScanNode tableScan = (TableScanNode)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> TestHiveLogicalPlanner.isTableScanNode(node, tableName)).findOnlyElement();
        org.testng.Assert.assertTrue((boolean)tableScan.getTable().getLayout().isPresent());
        HiveTableLayoutHandle layoutHandle = (HiveTableLayoutHandle)tableScan.getTable().getLayout().get();
        Assert.assertEquals(layoutHandle.getPredicateColumns().keySet(), predicateColumnNames);
        Assert.assertEquals((Object)layoutHandle.getDomainPredicate(), domainPredicate);
        Assert.assertEquals((Object)layoutHandle.getRemainingPredicate(), (Object)remainingPredicate);
        Assert.assertEquals((Object)layoutHandle.getRemainingPredicate(), (Object)remainingPredicate);
    }

    private void assertBucketFilter(Plan plan, String tableName, int readBucketCount, Set<Integer> bucketsToKeep) {
        TableScanNode tableScan = (TableScanNode)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> TestHiveLogicalPlanner.isTableScanNode(node, tableName)).findOnlyElement();
        org.testng.Assert.assertTrue((boolean)tableScan.getTable().getLayout().isPresent());
        HiveTableLayoutHandle layoutHandle = (HiveTableLayoutHandle)tableScan.getTable().getLayout().get();
        org.testng.Assert.assertTrue((boolean)layoutHandle.getBucketHandle().isPresent());
        org.testng.Assert.assertTrue((boolean)layoutHandle.getBucketFilter().isPresent());
        Assert.assertEquals((int)((HiveBucketHandle)layoutHandle.getBucketHandle().get()).getReadBucketCount(), (int)readBucketCount);
        Assert.assertEquals((Set)((HiveBucketing.HiveBucketFilter)layoutHandle.getBucketFilter().get()).getBucketsToKeep(), bucketsToKeep);
    }

    private void assertNoBucketFilter(Plan plan, String tableName, int readBucketCount) {
        TableScanNode tableScan = (TableScanNode)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> TestHiveLogicalPlanner.isTableScanNode(node, tableName)).findOnlyElement();
        org.testng.Assert.assertTrue((boolean)tableScan.getTable().getLayout().isPresent());
        HiveTableLayoutHandle layoutHandle = (HiveTableLayoutHandle)tableScan.getTable().getLayout().get();
        Assert.assertEquals((int)((HiveBucketHandle)layoutHandle.getBucketHandle().get()).getReadBucketCount(), (int)readBucketCount);
        org.testng.Assert.assertFalse((boolean)layoutHandle.getBucketFilter().isPresent());
    }

    private void assertNoAggregatedColumns(Plan plan, String tableName) {
        TableScanNode tableScan = (TableScanNode)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> TestHiveLogicalPlanner.isTableScanNode(node, tableName)).findOnlyElement();
        for (ColumnHandle columnHandle : tableScan.getAssignments().values()) {
            org.testng.Assert.assertTrue((boolean)(columnHandle instanceof HiveColumnHandle));
            HiveColumnHandle hiveColumnHandle = (HiveColumnHandle)columnHandle;
            org.testng.Assert.assertFalse((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.AGGREGATED ? 1 : 0) != 0);
            org.testng.Assert.assertFalse((boolean)hiveColumnHandle.getPartialAggregation().isPresent());
        }
    }

    private void assertRequestedColumnsInLayout(Plan plan, String tableName, Set<String> expectedRequestedColumns) {
        TableScanNode tableScan = (TableScanNode)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> TestHiveLogicalPlanner.isTableScanNode(node, tableName)).findOnlyElement();
        org.testng.Assert.assertTrue((boolean)tableScan.getTable().getLayout().isPresent());
        HiveTableLayoutHandle layoutHandle = (HiveTableLayoutHandle)tableScan.getTable().getLayout().get();
        org.testng.Assert.assertTrue((boolean)layoutHandle.getRequestedColumns().isPresent());
        Set requestedColumns = (Set)layoutHandle.getRequestedColumns().get();
        ArrayList<String> actualRequestedColumns = new ArrayList<String>();
        for (HiveColumnHandle column : requestedColumns) {
            if (!column.getRequiredSubfields().isEmpty()) {
                column.getRequiredSubfields().stream().map(Subfield::serialize).forEach(actualRequestedColumns::add);
                continue;
            }
            actualRequestedColumns.add(column.getName());
        }
        ImmutableSet requestedColumnsSet = ImmutableSet.copyOf(actualRequestedColumns);
        Assert.assertEquals((int)requestedColumnsSet.size(), (int)actualRequestedColumns.size(), (String)"There should be no duplicates in the requested column list");
        Assert.assertEquals((Set)requestedColumnsSet, expectedRequestedColumns);
    }

    static ExtendedHiveMetastore replicateHiveMetastore(DistributedQueryRunner queryRunner) {
        URI dataDirectory = queryRunner.getCoordinator().getDataDirectory().resolve("hive_data").toUri();
        HiveClientConfig hiveClientConfig = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(hiveClientConfig, metastoreClientConfig), (Set)ImmutableSet.of(), hiveClientConfig);
        HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, metastoreClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        return new FileHiveMetastore(hdfsEnvironment, dataDirectory.toString(), "test");
    }

    private static PlanMatchPattern tableScan(String tableName, final TupleDomain<String> domainPredicate, final RowExpression remainingPredicate, final Set<String> predicateColumnNames) {
        return PlanMatchPattern.tableScan((String)tableName).with(new Matcher(){

            public boolean shapeMatches(PlanNode node) {
                return node instanceof TableScanNode;
            }

            public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
                TableScanNode tableScan = (TableScanNode)node;
                Optional layout = tableScan.getTable().getLayout();
                if (!layout.isPresent()) {
                    return MatchResult.NO_MATCH;
                }
                HiveTableLayoutHandle layoutHandle = (HiveTableLayoutHandle)layout.get();
                if (!(Objects.equals(layoutHandle.getPredicateColumns().keySet(), predicateColumnNames) && Objects.equals(layoutHandle.getDomainPredicate(), domainPredicate.transform(Subfield::new)) && Objects.equals(layoutHandle.getRemainingPredicate(), remainingPredicate))) {
                    return MatchResult.NO_MATCH;
                }
                return MatchResult.match();
            }
        });
    }

    private static Map<String, Subfield> nestedColumnMap(String ... columns) {
        return Arrays.stream(columns).collect(Collectors.toMap(column -> ParquetTypeUtils.pushdownColumnNameForSubfield((Subfield)TestHiveLogicalPlanner.nestedColumn(column)), column -> TestHiveLogicalPlanner.nestedColumn(column)));
    }

    private static Subfield nestedColumn(String column) {
        return new Subfield(column);
    }

    private /* synthetic */ void lambda$testPushdownFilter$5(RowExpression remainingPredicate, Plan plan) {
        this.assertTableLayout(plan, "lineitem", (TupleDomain<Subfield>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new Subfield("partkey", (List)ImmutableList.of()), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)10L))), remainingPredicate, (Set<String>)ImmutableSet.of((Object)"partkey", (Object)"orderkey"));
    }

    private /* synthetic */ void lambda$testPushdownFilter$4(RowExpression remainingPredicate, Plan plan) {
        this.assertTableLayout(plan, "lineitem", (TupleDomain<Subfield>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new Subfield("partkey", (List)ImmutableList.of()), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)10L))), remainingPredicate, (Set<String>)ImmutableSet.of((Object)"partkey", (Object)"orderkey"));
    }

    private /* synthetic */ void lambda$testPushdownFilter$3(RowExpression remainingPredicate, Plan plan) {
        this.assertTableLayout(plan, "lineitem", (TupleDomain<Subfield>)TupleDomain.all(), remainingPredicate, (Set<String>)ImmutableSet.of((Object)"orderkey"));
    }

    private /* synthetic */ void lambda$testPushdownFilter$2(RowExpression remainingPredicate, Plan plan) {
        this.assertTableLayout(plan, "lineitem", (TupleDomain<Subfield>)TupleDomain.all(), remainingPredicate, (Set<String>)ImmutableSet.of((Object)"orderkey"));
    }

    private static final class HiveParquetDereferencePushdownMatcher
    implements Matcher {
        private final Map<String, Subfield> dereferenceColumns;
        private final TupleDomain<String> domainPredicate;
        private final Set<String> predicateColumns;
        private final RowExpression remainingPredicate;

        private HiveParquetDereferencePushdownMatcher(Map<String, Subfield> dereferenceColumns, TupleDomain<String> domainPredicate, Set<String> predicateColumns, RowExpression remainingPredicate) {
            this.dereferenceColumns = Objects.requireNonNull(dereferenceColumns, "dereferenceColumns is null");
            this.domainPredicate = Objects.requireNonNull(domainPredicate, "domainPredicate is null");
            this.predicateColumns = Objects.requireNonNull(predicateColumns, "predicateColumns is null");
            this.remainingPredicate = Objects.requireNonNull(remainingPredicate, "remainingPredicate is null");
        }

        public boolean shapeMatches(PlanNode node) {
            return node instanceof TableScanNode;
        }

        public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
            TableScanNode tableScan = (TableScanNode)node;
            for (ColumnHandle column : tableScan.getAssignments().values()) {
                HiveColumnHandle hiveColumn = (HiveColumnHandle)column;
                String columnName = hiveColumn.getName();
                if (this.dereferenceColumns.containsKey(columnName)) {
                    if (hiveColumn.getColumnType() != HiveColumnHandle.ColumnType.SYNTHESIZED || hiveColumn.getRequiredSubfields().size() != 1 || !((Subfield)hiveColumn.getRequiredSubfields().get(0)).equals((Object)this.dereferenceColumns.get(columnName))) {
                        return MatchResult.NO_MATCH;
                    }
                    this.dereferenceColumns.remove(columnName);
                    continue;
                }
                if (!HiveColumnHandle.isPushedDownSubfield((HiveColumnHandle)hiveColumn)) continue;
                return MatchResult.NO_MATCH;
            }
            if (!this.dereferenceColumns.isEmpty()) {
                return MatchResult.NO_MATCH;
            }
            Optional layout = tableScan.getTable().getLayout();
            if (!layout.isPresent()) {
                return MatchResult.NO_MATCH;
            }
            HiveTableLayoutHandle layoutHandle = (HiveTableLayoutHandle)layout.get();
            if (!(Objects.equals(layoutHandle.getPredicateColumns().keySet(), this.predicateColumns) && Objects.equals(layoutHandle.getDomainPredicate(), this.domainPredicate.transform(Subfield::new)) && Objects.equals(layoutHandle.getRemainingPredicate(), this.remainingPredicate))) {
                return MatchResult.NO_MATCH;
            }
            return MatchResult.match();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("dereferenceColumns", this.dereferenceColumns).add("domainPredicate", this.domainPredicate).add("predicateColumns", this.predicateColumns).add("remainingPredicate", (Object)this.remainingPredicate).toString();
        }
    }

    private static final class HiveTableScanMatcher
    implements Matcher {
        private final Map<String, Set<Subfield>> requiredSubfields;

        private HiveTableScanMatcher(Map<String, Set<Subfield>> requiredSubfields) {
            this.requiredSubfields = Objects.requireNonNull(requiredSubfields, "requiredSubfields is null");
        }

        public boolean shapeMatches(PlanNode node) {
            return node instanceof TableScanNode;
        }

        public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
            TableScanNode tableScan = (TableScanNode)node;
            for (ColumnHandle column : tableScan.getAssignments().values()) {
                HiveColumnHandle hiveColumn = (HiveColumnHandle)column;
                String columnName = hiveColumn.getName();
                if (!(this.requiredSubfields.containsKey(columnName) ? !this.requiredSubfields.get(columnName).equals(ImmutableSet.copyOf((Collection)hiveColumn.getRequiredSubfields())) : !hiveColumn.getRequiredSubfields().isEmpty())) continue;
                return MatchResult.NO_MATCH;
            }
            return MatchResult.match();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("requiredSubfields", this.requiredSubfields).toString();
        }
    }
}

