/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.TestHiveLogicalPlanner;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.airlift.slice.Slices;
import io.airlift.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHiveMaterializedViewLogicalPlanner
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createQueryRunner(ImmutableList.of((Object)TpchTable.ORDERS, (Object)TpchTable.LINE_ITEM, (Object)TpchTable.CUSTOMER, (Object)TpchTable.NATION, (Object)TpchTable.SUPPLIER), (Map<String, String>)ImmutableMap.of(), Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewOptimization() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String view = "test_orders_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, '2019-01-02' as ds FROM orders WHERE orderkey > 1000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, ds FROM %s", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate("REFRESH MATERIALIZED VIEW test_orders_view WHERE ds='2020-01-01'", 255L);
            String viewQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", view);
            String baseQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", table);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2019-01-02"))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))), PlanMatchPattern.filter((String)"orderkey_17 < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey_17", (Object)"orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS test_orders_view");
            queryRunner.execute("DROP TABLE IF EXISTS orders_partitioned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewOptimizationWithClause() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "test_orders_partitioned_with_clause";
        String view = "test_view_orders_partitioned_with_clause";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, '2019-01-02' as ds FROM orders WHERE orderkey > 1000", table));
            String viewPart = String.format("WITH X AS (SELECT orderkey, orderpriority, ds FROM %s), Y AS (SELECT orderkey, orderpriority, ds FROM X), Z AS (SELECT orderkey, orderpriority, ds FROM Y) SELECT orderkey, orderpriority, ds FROM Z", table);
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS %s", view, viewPart));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s where ds='2020-01-01'", view), 255L);
            String viewQuery = String.format("SELECT orderkey, orderpriority, ds from %s where orderkey < 100 ORDER BY orderkey", view);
            String baseQuery = viewPart + " where orderkey < 100 ORDER BY orderkey";
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'100'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2019-01-02"))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))), PlanMatchPattern.filter((String)"orderkey_62 < BIGINT'100'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey_62", (Object)"orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewOptimizationFullyMaterialized() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned_fully_materialized";
        String view = "orders_view_fully_materialized";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, '2019-01-02' as ds FROM orders WHERE orderkey > 1000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, ds FROM %s", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds = '2020-01-01'", view), 255L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds = '2019-01-02'", view), 14745L);
            String viewQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", view);
            String baseQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", table);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            Session disableEmptyInputOptimization = Session.builder((Session)this.getSession()).setSystemProperty("simplify_plan_with_empty_input", "false").build();
            this.assertPlan(disableEmptyInputOptimization, viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((String[])new String[]{"orderkey"})}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey_17 < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey_17", (Object)"orderkey")))})}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewOptimizationNotMaterialized() {
        String table = "orders_partitioned_not_materialized";
        String view = "orders_partitioned_view_not_materialized";
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, '2019-01-02' as ds FROM orders WHERE orderkey > 1000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, ds FROM %s", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            String viewQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", view);
            String baseQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", table);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedTooManyMissingPartitions() {
        String table = "orders_partitioned_not_materialized";
        String view = "orders_partitioned_view_not_materialized";
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, '2019-01-02' as ds FROM orders WHERE orderkey >= 1000 and orderkey < 2000 UNION ALL SELECT orderkey, orderpriority, '2019-02-02' as ds FROM orders WHERE orderkey >= 2000 and orderkey < 3000 UNION ALL SELECT orderkey, orderpriority, '2019-03-02' as ds FROM orders WHERE orderkey >= 3000 and orderkey < 4000 UNION ALL SELECT orderkey, orderpriority, '2019-04-02' as ds FROM orders WHERE orderkey >= 4000 and orderkey < 5000 UNION ALL SELECT orderkey, orderpriority, '2019-05-02' as ds FROM orders WHERE orderkey >= 5000 and orderkey < 6000 UNION ALL SELECT orderkey, orderpriority, '2019-06-02' as ds FROM orders WHERE orderkey >= 6000 and orderkey < 7000 UNION ALL SELECT orderkey, orderpriority, '2019-07-02' as ds FROM orders WHERE orderkey >= 7000 and orderkey < 8000 ", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, ds FROM %s", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getQueryRunner().getDefaultSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds = '2020-01-01'", view), 255L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds = '2019-01-02'", view), 248L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds = '2019-02-02'", view), 248L);
            String viewQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", view);
            String baseQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", table);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "materialized_view_missing_partitions_threshold", Integer.toString(2)).build();
            this.assertPlan(session, viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))}));
            session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "materialized_view_missing_partitions_threshold", Integer.toString(100)).build();
            this.assertPlan(session, viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("2019-03-02", "2019-04-02", "2019-05-02", "2019-06-02", "2019-07-02"))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))), PlanMatchPattern.filter((String)"orderkey_17 < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("2020-01-01", "2019-01-02", "2019-02-02"))), (Map)ImmutableMap.of((Object)"orderkey_17", (Object)"orderkey")))}));
            session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").setCatalogSessionProperty("hive", "materialized_view_missing_partitions_threshold", Integer.toString(2)).build();
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            this.assertPlan(session, baseQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewOptimizationWithNullPartition() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned_null_partition";
        String view = "orders_partitioned_view_null_partition";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, '2020-01-01' as ds FROM orders WHERE orderkey < 500 UNION ALL SELECT orderkey, orderpriority, '2019-01-02' as ds FROM orders WHERE orderkey > 500 and orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, NULL as ds FROM orders WHERE orderkey > 1000 and orderkey < 1500", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, ds FROM %s", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds = '2020-01-01'", view), 127L);
            String viewQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", view);
            String baseQuery = String.format("SELECT orderkey from %s  where orderkey < 10000 ORDER BY orderkey", table);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.create((ValueSet)ValueSet.of((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2019-01-02"), (Object[])new Object[0]), (boolean)true)), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))), PlanMatchPattern.filter((String)"orderkey_17 < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey_17", (Object)"orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewWithLessGranularity() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned_less_granularity";
        String view = "orders_partitioned_view_less_granularity";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['orderpriority', 'ds']) AS SELECT orderkey, orderpriority, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, '2019-01-02' as ds FROM orders WHERE orderkey > 1000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, ds FROM %s", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds = '2020-01-01'", view), 255L);
            String viewQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", view);
            String baseQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", table);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2019-01-02")), (Object)"orderpriority", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)15), TestHiveLogicalPlanner.utf8Slices("1-URGENT", "2-HIGH", "3-MEDIUM", "4-NOT SPECIFIED", "5-LOW"))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))), PlanMatchPattern.filter((String)"orderkey_17 < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey_17", (Object)"orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewForIntersect() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table1 = "test_customer_intersect1";
        String table2 = "test_customer_intersect2";
        String view = "test_customer_view_intersect";
        try {
            this.computeActual(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, address, nationkey FROM customer", table1));
            this.computeActual(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, address, nationkey FROM customer", table2));
            String baseQuery = String.format("SELECT name, custkey, nationkey FROM ( SELECT name, custkey, nationkey FROM %s WHERE custkey < 1000 INTERSECT SELECT name, custkey, nationkey FROM %s WHERE custkey <= 900 )", table1, table2);
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['nationkey']) AS %s", view, baseQuery));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE nationkey < 10", view), 380L);
            String viewQuery = String.format("SELECT name, custkey, nationkey from %s ORDER BY name", view);
            baseQuery = String.format("%s ORDER BY name", baseQuery);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"custkey < BIGINT'1000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table1, (Map)ImmutableMap.of((Object)"nationkey", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)10L, (Object)11L, (Object)12L, (Object)13L, (Object)14L, (Object)15L, (Object)16L, (Object)17L, (Object)18L, (Object)19L, (Object)20L, (Object)21L, (Object[])new Long[]{22L, 23L, 24L}))), (Map)ImmutableMap.of((Object)"custkey", (Object)"custkey")))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"custkey_21 <= BIGINT'900'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table2, (Map)ImmutableMap.of((Object)"nationkey", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)10L, (Object)11L, (Object)12L, (Object)13L, (Object)14L, (Object)15L, (Object)16L, (Object)17L, (Object)18L, (Object)19L, (Object)20L, (Object)21L, (Object[])new Long[]{22L, 23L, 24L}))), (Map)ImmutableMap.of((Object)"custkey_21", (Object)"custkey")))})}), PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of())}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewForUnionAll() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table1 = "test_customer_union1";
        String table2 = "test_customer_union2";
        String view = "test_customer_view_union";
        try {
            this.computeActual(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, address, nationkey FROM customer", table1));
            this.computeActual(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, address, nationkey FROM customer", table2));
            String baseQuery = String.format("SELECT name, custkey, nationkey FROM ( SELECT name, custkey, nationkey FROM %s WHERE custkey < 1000 UNION ALL SELECT name, custkey, nationkey FROM %s WHERE custkey >= 1000 )", table1, table2);
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['nationkey']) AS %s", view, baseQuery));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE nationkey < 10", view, baseQuery), 599L);
            String viewQuery = String.format("SELECT name, custkey, nationkey from %s ORDER BY name", view);
            baseQuery = String.format("%s ORDER BY name", baseQuery);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"custkey < BIGINT'1000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table1, (Map)ImmutableMap.of((Object)"nationkey", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)10L, (Object)11L, (Object)12L, (Object)13L, (Object)14L, (Object)15L, (Object)16L, (Object)17L, (Object)18L, (Object)19L, (Object)20L, (Object)21L, (Object[])new Long[]{22L, 23L, 24L}))), (Map)ImmutableMap.of((Object)"custkey", (Object)"custkey"))), PlanMatchPattern.filter((String)"custkey_21 >= BIGINT'1000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table2, (Map)ImmutableMap.of((Object)"nationkey", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)10L, (Object)11L, (Object)12L, (Object)13L, (Object)14L, (Object)15L, (Object)16L, (Object)17L, (Object)18L, (Object)19L, (Object)20L, (Object)21L, (Object[])new Long[]{22L, 23L, 24L}))), (Map)ImmutableMap.of((Object)"custkey_21", (Object)"custkey"))), PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of())}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewForUnionAllWithOneSideMaterialized() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table1 = "orders_key_partitioned_1";
        String table2 = "orders_key_partitioned_2";
        String view = "orders_key_view_union";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, '2020-01-01' as ds FROM orders WHERE orderkey < 1000", table1));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, '2019-01-02' as ds FROM orders WHERE orderkey > 1000 and orderkey < 2000", table2));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, ds FROM %s UNION ALL SELECT orderkey, ds FROM %s", view, table1, table2));
            org.testng.Assert.assertTrue((boolean)queryRunner.tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view), 510L);
            String viewQuery = String.format("SELECT orderkey, ds FROM %s ORDER BY orderkey", view);
            String baseQuery = String.format("(SELECT orderkey, ds FROM %s UNION ALL SELECT orderkey, ds FROM %s) ORDER BY orderkey", table1, table2);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((String[])new String[]{"ds", "orderkey"}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table2, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("2019-01-02")))), PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of())})}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewForExcept() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table1 = "test_customer_except1";
        String table2 = "test_customer_except2";
        String view = "test_customer_view_except";
        try {
            this.computeActual(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, address, nationkey FROM customer", table1));
            this.computeActual(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, address, nationkey FROM customer", table2));
            String baseQuery = String.format("SELECT name, custkey, nationkey FROM %s WHERE custkey < 1000 EXCEPT SELECT name, custkey, nationkey FROM %s WHERE custkey > 900", table1, table2);
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['nationkey']) AS %s", view, baseQuery));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE nationkey < 10", view), 380L);
            String viewQuery = String.format("SELECT name, custkey, nationkey from %s ORDER BY name", view);
            baseQuery = String.format("%s ORDER BY name", baseQuery);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"custkey < BIGINT'1000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table1, (Map)ImmutableMap.of((Object)"nationkey", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)10L, (Object)11L, (Object)12L, (Object)13L, (Object)14L, (Object)15L, (Object)16L, (Object)17L, (Object)18L, (Object)19L, (Object)20L, (Object)21L, (Object[])new Long[]{22L, 23L, 24L}))), (Map)ImmutableMap.of((Object)"custkey", (Object)"custkey")))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"custkey_21 > BIGINT'900'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table2, (Map)ImmutableMap.of((Object)"nationkey", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)10L, (Object)11L, (Object)12L, (Object)13L, (Object)14L, (Object)15L, (Object)16L, (Object)17L, (Object)18L, (Object)19L, (Object)20L, (Object)21L, (Object[])new Long[]{22L, 23L, 24L}))), (Map)ImmutableMap.of((Object)"custkey_21", (Object)"custkey")))})}), PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of())}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewForUnionAllWithMultipleTables() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table1 = "orders_key_small_union";
        String table2 = "orders_key_large_union";
        String view = "orders_view_union";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, '2019-01-02' as ds FROM orders WHERE orderkey > 1000 and orderkey < 2000", table1));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, '2020-01-01' as ds FROM orders WHERE orderkey > 2000 and orderkey < 3000 UNION ALL SELECT orderkey, '2019-01-02' as ds FROM orders WHERE orderkey > 3000 and orderkey < 4000", table2));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey AS view_orderkey, ds FROM ( SELECT orderkey, ds FROM %s UNION ALL SELECT orderkey, ds FROM %s ) ", view, table1, table2));
            org.testng.Assert.assertTrue((boolean)queryRunner.tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view), 503L);
            String viewQuery = String.format("SELECT view_orderkey, ds from %s where view_orderkey <  10000 ORDER BY view_orderkey", view);
            String baseQuery = String.format("SELECT orderkey AS view_orderkey, ds FROM ( SELECT orderkey, ds FROM %s UNION ALL SELECT orderkey, ds FROM %s ) WHERE orderkey < 10000 ORDER BY orderkey", table1, table2);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewForGroupingSet() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "test_lineitem_grouping_set";
        String view = "test_view_lineitem_grouping_set";
        try {
            this.computeActual(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['shipmode']) AS SELECT linenumber, quantity, shipmode FROM lineitem", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['shipmode']) AS SELECT linenumber, SUM(DISTINCT CAST(quantity AS BIGINT)) quantity, shipmode FROM %s GROUP BY GROUPING SETS ((linenumber, shipmode), (shipmode))", view, table));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE shipmode='RAIL'", view), 8L);
            String viewQuery = String.format("SELECT * FROM %s ORDER BY linenumber, shipmode", view);
            String baseQuery = String.format("SELECT linenumber, SUM(DISTINCT CAST(quantity AS BIGINT)) quantity, shipmode FROM %s GROUP BY GROUPING SETS ((linenumber, shipmode), (shipmode)) ORDER BY linenumber, shipmode", table);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"shipmode", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("AIR", "FOB", "MAIL", "REG AIR", "SHIP", "TRUCK"))))}), PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of())}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewWithDifferentPartitions() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned_different_partitions";
        String view = "orders_partitioned_view_different_partitions";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds', 'orderpriority']) AS SELECT orderkey, orderstatus, '2020-01-01' as ds, orderpriority FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderstatus, '2019-01-02' as ds, orderpriority FROM orders WHERE orderkey > 1000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds', 'orderstatus']) AS SELECT orderkey, orderpriority, ds, orderstatus FROM %s", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds = '2020-01-01'", view), 255L);
            String viewQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", view);
            String baseQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", table);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2019-01-02")), (Object)"orderpriority", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)15), TestHiveLogicalPlanner.utf8Slices("1-URGENT", "2-HIGH", "3-MEDIUM", "4-NOT SPECIFIED", "5-LOW"))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))), PlanMatchPattern.filter((String)"orderkey_23 < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey_23", (Object)"orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewJoinsWithOneTableAlias() {
        QueryRunner queryRunner = this.getQueryRunner();
        String view = "view_join_with_one_alias";
        String table1 = "nation_partitioned_join_with_one_alias";
        String table2 = "customer_partitioned_join_with_one_alias";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['nationkey', 'regionkey']) AS SELECT name, nationkey, regionkey FROM nation", table1));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, mktsegment, nationkey FROM customer", table2));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['marketsegment', 'nationkey', 'regionkey']) AS SELECT %s.name AS nationname, customer.custkey, customer.name AS customername, UPPER(customer.mktsegment) AS marketsegment, customer.nationkey, regionkey FROM %s JOIN %s customer ON (%s.nationkey = customer.nationkey)", view, table1, table1, table2, table1));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE regionkey = 1", view), 300L);
            String viewQuery = String.format("SELECT nationname, custkey from %s ORDER BY custkey", view);
            String baseQuery = String.format("SELECT %s.name AS nationname, customer.custkey FROM %s JOIN %s customer ON (%s.nationkey = customer.nationkey)ORDER BY custkey", table1, table1, table2, table1);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(Session.builder((Session)this.getSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).build(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"l_nationkey", (String)"r_nationkey")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table1, (Map)ImmutableMap.of((Object)"regionkey", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)0L, (Object)2L, (Object)3L, (Object)4L)), (Object)"nationkey", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)0L, (Object)4L, (Object)5L, (Object)6L, (Object)7L, (Object)8L, (Object)9L, (Object)10L, (Object)11L, (Object)12L, (Object)13L, (Object)14L, (Object[])new Long[]{15L, 16L, 18L, 19L, 20L, 21L, 22L, 23L}))), (Map)ImmutableMap.of((Object)"l_nationkey", (Object)"nationkey"))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table2, (Map)ImmutableMap.of((Object)"nationkey", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)0L, (Object)4L, (Object)5L, (Object)6L, (Object)7L, (Object)8L, (Object)9L, (Object)10L, (Object)11L, (Object)12L, (Object)13L, (Object)14L, (Object[])new Long[]{15L, 16L, 18L, 19L, 20L, 21L, 22L, 23L}))), (Map)ImmutableMap.of((Object)"r_nationkey", (Object)"nationkey"))})), PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of())}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewSampledRelations() {
        QueryRunner queryRunner = this.getQueryRunner();
        String viewFull = "view_nation_sampled_100";
        String viewHalf = "view_nation_sampled_50";
        String table = "nation_partitioned";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['nationkey', 'regionkey']) AS SELECT name, nationkey, regionkey FROM nation", table));
            String viewFullDefinition = String.format("SELECT SUM(regionkey) AS sum_region_key, nationkey FROM %s TABLESAMPLE BERNOULLI (100) GROUP BY nationkey", table);
            String viewHalfDefinition = String.format("SELECT SUM(regionkey) AS sum_region_key, nationkey FROM %s TABLESAMPLE BERNOULLI (50) GROUP BY nationkey", table);
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['nationkey']) AS %s", viewFull, viewFullDefinition));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['nationkey']) AS %s", viewHalf, viewHalfDefinition));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE nationKey < 5", viewFull), 5L);
            queryRunner.execute(String.format("REFRESH MATERIALIZED VIEW %s WHERE nationKey < 5", viewHalf));
            String viewFullQuery = String.format("SELECT * from %s ORDER BY nationkey", viewFull);
            String baseQuery = String.format("%s ORDER BY nationkey", viewFullDefinition);
            MaterializedResult viewFullTable = this.computeActual(viewFullQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewFullTable, (Iterable)baseTable);
            String viewHalfQuery = String.format("SELECT * from %s ORDER BY nationkey", viewHalf);
            MaterializedResult viewHalfTable = this.computeActual(viewHalfQuery);
            org.testng.Assert.assertFalse((boolean)viewFullTable.equals((Object)viewHalfTable));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + viewFull);
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + viewHalf);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewWithValues() {
        QueryRunner queryRunner = this.getQueryRunner();
        String view = "view_nation_values";
        String table = "nation_partitioned";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['nationkey', 'regionkey']) AS SELECT name, nationkey, regionkey FROM nation", table));
            String viewDefinition = String.format("SELECT name, nationkey, regionkey FROM %s JOIN (VALUES 1, 2, 3) t(a) ON t.a = %s.regionkey", table, table);
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['nationkey', 'regionkey']) AS  %s", view, viewDefinition));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE regionkey = 1", view), 5L);
            String viewQuery = String.format("SELECT name, nationkey, regionkey from %s ORDER BY name", view);
            String baseQuery = String.format("%s ORDER BY name", viewDefinition, table);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewOptimizationWithDerivedFields() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "lineitem_partitioned_derived_fields";
        String view = "lineitem_partitioned_view_derived_fields";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds', 'shipmode']) AS SELECT discount, extendedprice, '2020-01-01' as ds, shipmode FROM lineitem WHERE orderkey < 1000 UNION ALL SELECT discount, extendedprice, '2020-01-02' as ds, shipmode FROM lineitem WHERE orderkey > 1000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds', 'shipmode']) AS SELECT SUM(discount*extendedprice) as _discount_multi_extendedprice_, ds, shipmode FROM %s group by ds, shipmode", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view), 7L);
            String viewQuery = String.format("SELECT sum(_discount_multi_extendedprice_) from %s group by ds, shipmode ORDER BY sum(_discount_multi_extendedprice_)", view);
            String baseQuery = String.format("SELECT sum(discount * extendedprice) as _discount_multi_extendedprice_ from %s group by ds, shipmode ORDER BY _discount_multi_extendedprice_", table);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"shipmode", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("AIR", "FOB", "MAIL", "RAIL", "REG AIR", "SHIP", "TRUCK")), (Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2020-01-02"))))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of())})}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewOptimizationWithDerivedFieldsWithAlias() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "lineitem_partitioned_derived_fields_with_alias";
        String view = "lineitem_partitioned_view_derived_fields_with_alias";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds', 'shipmode']) AS SELECT discount, extendedprice, '2020-01-01' as ds, shipmode FROM lineitem WHERE orderkey < 1000 UNION ALL SELECT discount, extendedprice, '2020-01-02' as ds, shipmode FROM lineitem WHERE orderkey > 1000 ", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds', 'view_shipmode']) AS SELECT SUM(discount*extendedprice) as _discount_multi_extendedprice_, ds, shipmode as view_shipmode FROM %s group by ds, shipmode", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view, table), 7L);
            String viewQuery = String.format("SELECT sum(_discount_multi_extendedprice_) from %s group by ds ORDER BY sum(_discount_multi_extendedprice_)", view);
            String baseQuery = String.format("SELECT sum(discount * extendedprice) as _discount_multi_extendedprice_ from %s group by ds ORDER BY _discount_multi_extendedprice_", table);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"shipmode", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("AIR", "FOB", "MAIL", "RAIL", "REG AIR", "SHIP", "TRUCK")), (Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2020-01-02"))))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of())})}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseToViewConversionWithDerivedFields() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "lineitem_partitioned_derived_fields";
        String view = "lineitem_partitioned_view_derived_fields";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds', 'shipmode']) AS SELECT discount, extendedprice, '2020-01-01' as ds, shipmode FROM lineitem WHERE orderkey < 1000 UNION ALL SELECT discount, extendedprice, '2020-01-02' as ds, shipmode FROM lineitem WHERE orderkey > 1000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['mvds', 'shipmode']) AS SELECT SUM(discount * extendedprice) as _discount_multi_extendedprice_ , MAX(discount*extendedprice) as _max_discount_multi_extendedprice_ , ds as mvds, shipmode FROM %s group by ds, shipmode", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s where mvds='2020-01-01'", view), 7L);
            String baseQuery = String.format("SELECT sum(discount * extendedprice) as _discount_multi_extendedprice_ , MAX(discount*extendedprice) as _max_discount_multi_extendedprice_ , ds, shipmode as method from %s group by ds, shipmode ORDER BY ds, shipmode", table);
            String viewQuery = String.format("SELECT _discount_multi_extendedprice_ , _max_discount_multi_extendedprice_ , mvds, shipmode as method from %s ORDER BY mvds, shipmode", view);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)optimizedQueryResult, (Iterable)baseQueryResult);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"shipmode", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("AIR", "FOB", "MAIL", "RAIL", "REG AIR", "SHIP", "TRUCK")), (Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2020-01-02"))))}), PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of())}));
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"shipmode", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("AIR", "FOB", "MAIL", "RAIL", "REG AIR", "SHIP", "TRUCK")), (Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2020-01-02"))))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of())})}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseToViewConversionWithMultipleCandidates() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").setSystemProperty("simplify_plan_with_empty_input", "false").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String view1 = "test_orders_view1";
        String view2 = "test_orders_view2";
        String view3 = "test_orders_view3";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, orderdate, totalprice, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, orderdate, totalprice, '2020-01-02' as ds FROM orders WHERE orderkey > 1000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, ds FROM %s", view1, table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderdate, ds FROM %s", view2, table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, totalprice, ds FROM %s", view3, table));
            org.testng.Assert.assertTrue((boolean)queryRunner.tableExists(this.getSession(), view1));
            org.testng.Assert.assertTrue((boolean)queryRunner.tableExists(this.getSession(), view2));
            org.testng.Assert.assertTrue((boolean)queryRunner.tableExists(this.getSession(), view3));
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view1, (Object)view2, (Object)view3));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view1), 255L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-02'", view1), 14745L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view2), 255L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-02'", view2), 14745L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view3), 255L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-02'", view3), 14745L);
            String baseQuery = String.format("SELECT orderkey, orderdate from %s where orderkey < 1000 ORDER BY orderkey", table);
            String viewQuery = String.format("SELECT orderkey, orderdate from %s where orderkey < 1000 ORDER BY orderkey", view2);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)optimizedQueryResult, (Iterable)baseQueryResult);
            PlanMatchPattern expectedPattern = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((String[])new String[]{"orderkey", "orderdate"})}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey_25 < BIGINT'1000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view2, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey_25", (Object)"orderkey")))})});
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, expectedPattern);
            Session disableEmptyInputOptimization = Session.builder((Session)this.getSession()).setSystemProperty("simplify_plan_with_empty_input", "false").build();
            this.assertPlan(disableEmptyInputOptimization, viewQuery, expectedPattern);
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view1, (Object)view3));
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'1000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view1);
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view2);
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view3);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseToViewConversionWithGroupBy() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "lineitem_partitioned_derived_fields";
        String view = "lineitem_partitioned_view_derived_fields";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds', 'shipmode']) AS SELECT discount, extendedprice, '2020-01-01' as ds, shipmode FROM lineitem WHERE orderkey < 1000 UNION ALL SELECT discount, extendedprice, '2020-01-02' as ds, shipmode FROM lineitem WHERE orderkey > 1000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds', 'shipmode']) AS SELECT SUM(discount * extendedprice) as _discount_multi_extendedprice_ , MAX(discount*extendedprice) as _max_discount_multi_extendedprice_ , ds, shipmode FROM %s group by ds, shipmode", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s where ds='2020-01-01'", view), 7L);
            String baseQuery = String.format("SELECT SUM(discount * extendedprice) as _discount_multi_extendedprice_, MAX(discount*extendedprice) as _max_discount_multi_extendedprice_ FROM %s", table);
            String viewQuery = String.format("SELECT SUM(_discount_multi_extendedprice_), MAX(_max_discount_multi_extendedprice_) FROM %s", view);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)optimizedQueryResult, (Iterable)baseQueryResult);
            PlanMatchPattern expectedPattern = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"shipmode", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("AIR", "FOB", "MAIL", "RAIL", "REG AIR", "SHIP", "TRUCK")), (Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2020-01-02"))))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of())})});
            this.assertPlan(this.getSession(), viewQuery, expectedPattern);
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, expectedPattern);
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseToViewConversionCountOptimizationWithStitching() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").setSystemProperty("prefer_partial_aggregation", "false").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String view = "test_orders_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = array['ds']) AS SELECT *, '2021-07-11' AS ds FROM orders WHERE orderkey < 10000 UNION ALL SELECT *, '2021-07-12' AS ds FROM orders WHERE orderkey < 10000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT COUNT(*) AS a_count, orderkey, ds FROM %s GROUP BY ds, orderkey", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds= '2021-07-11'", view), 2503L);
            String viewQuery = String.format("SELECT SUM(a_count), orderkey FROM %s GROUP BY orderkey ORDER BY orderkey", view);
            String baseQuery = String.format("SELECT COUNT(*) AS a_count, orderkey FROM %s GROUP BY orderkey ORDER BY orderkey", table);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)baseQueryResult, (Iterable)optimizedQueryResult);
            PlanMatchPattern expectedPattern = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"orderkey"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"sum", (List)ImmutableList.of((Object)"count"))), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((Map)ImmutableMap.of((Object)"count", (Object)PlanMatchPattern.functionCall((String)"count", (boolean)false, (List)ImmutableList.of())), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ProjectNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2021-07-12"))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"ds", (Object)"ds"))})})}))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of())})}))});
            this.assertPlan(queryOptimizationWithMaterializedView, viewQuery, expectedPattern);
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, expectedPattern);
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseToViewConversionCountOptimizationWithFreshView() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").setSystemProperty("prefer_partial_aggregation", "false").setSystemProperty("simplify_plan_with_empty_input", "false").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String view = "test_orders_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = array['ds']) AS SELECT *, '2021-07-11' AS ds FROM orders WHERE orderkey < 10000 UNION ALL SELECT *, '2021-07-12' AS ds FROM orders WHERE orderkey < 10000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT COUNT(*) AS a_count, orderkey, ds FROM %s GROUP BY ds, orderkey", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds= '2021-07-11'", view), 2503L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds= '2021-07-12'", view), 2503L);
            String viewQuery = String.format("SELECT SUM(a_count), orderkey FROM %s GROUP BY orderkey ORDER BY orderkey", view);
            String baseQuery = String.format("SELECT COUNT(*) AS a_count, orderkey FROM %s GROUP BY orderkey ORDER BY orderkey", table);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)baseQueryResult, (Iterable)optimizedQueryResult);
            PlanMatchPattern expectedPattern = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"orderkey"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"sum", (List)ImmutableList.of((Object)"count"))), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((Map)ImmutableMap.of((Object)"count", (Object)PlanMatchPattern.functionCall((String)"count", (boolean)false, (List)ImmutableList.of())), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ProjectNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((String[])new String[]{"orderkey", "ds"})})}))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of())})}))});
            this.assertPlan(queryOptimizationWithMaterializedView, viewQuery, expectedPattern);
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, expectedPattern);
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseToViewConversionCountOptimizationDoesNotOccurWithStaleView() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").setSystemProperty("prefer_partial_aggregation", "false").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String view = "test_orders_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = array['ds']) AS SELECT *, '2021-07-11' AS ds FROM orders WHERE orderkey < 10000 UNION ALL SELECT *, '2021-07-12' AS ds FROM orders WHERE orderkey < 10000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT COUNT(*) AS a_count, orderkey, ds FROM %s GROUP BY ds, orderkey", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            String baseQuery = String.format("SELECT COUNT(*) AS a_count, orderkey FROM %s GROUP BY orderkey ORDER BY orderkey", table);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)baseQueryResult, (Iterable)optimizedQueryResult);
            PlanMatchPattern expectedPatternWithoutCountOptimization = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"orderkey"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"count", (boolean)false, (List)ImmutableList.of())), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("2021-07-11", "2021-07-12"))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))})}))});
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, expectedPatternWithoutCountOptimization);
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseToViewConversionCountOptimizationWithAllColumnsOnSamePartition() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").setSystemProperty("prefer_partial_aggregation", "false").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String view = "test_orders_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = array['ds']) AS SELECT *, '2021-07-11' AS ds FROM orders WHERE orderkey < 10000 UNION ALL SELECT *, '2021-07-12' AS ds FROM orders WHERE orderkey < 10000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT COUNT(*) AS a_count,  ds FROM %s GROUP BY ds", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            String viewQuery = String.format("SELECT SUM(a_count), ds FROM %s GROUP BY ds ORDER BY ds", view);
            String baseQuery = String.format("SELECT COUNT(*) AS a_count, ds FROM %s GROUP BY ds ORDER BY ds", table);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds= '2021-07-11'", view), 1L);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)baseQueryResult, (Iterable)optimizedQueryResult);
            PlanMatchPattern expectedPattern = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"ds"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"sum", (List)ImmutableList.of((Object)"count"))), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((Map)ImmutableMap.of((Object)"count", (Object)PlanMatchPattern.functionCall((String)"count", (boolean)false, (List)ImmutableList.of())), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ProjectNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2021-07-12"))), (Map)ImmutableMap.of((Object)"ds", (Object)"ds"))})})}))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of())})}))});
            this.assertPlan(queryOptimizationWithMaterializedView, viewQuery, expectedPattern);
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, expectedPattern);
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false)
    public void testBaseToViewConversionWithFilterCondition() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String baseTable = "lineitem_partitioned_derived_fields";
        String view = "lineitem_partitioned_view_derived_fields";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds', 'shipmode']) AS SELECT discount, extendedprice, orderkey, '2020-01-01' as ds, shipmode FROM lineitem WHERE orderkey < 1000 UNION ALL SELECT discount, extendedprice, orderkey, '2020-01-02' as ds, shipmode FROM lineitem WHERE orderkey > 1000", baseTable));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['mvds', 'shipmode']) AS SELECT discount, extendedprice, orderkey as ok, ds as mvds, shipmode FROM %s WHERE orderkey < 100 AND orderkey > 50", view, baseTable));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s where mvds='2020-01-01'", view), 50L);
            String baseQuery = String.format("SELECT discount, extendedprice, orderkey, ds, shipmode FROM %s WHERE orderkey <= 70 AND orderkey >= 60 AND orderkey <> 65 ORDER BY extendedprice", baseTable);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)optimizedQueryResult, (Iterable)baseQueryResult);
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + baseTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewForJoin() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table1 = "orders_key_partitioned_join";
        String table2 = "orders_price_partitioned_join";
        String view = "orders_view_join";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, '2019-01-02' as ds FROM orders WHERE orderkey > 1000 and orderkey < 2000", table1));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, totalprice, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, totalprice, '2019-01-02' as ds FROM orders WHERE orderkey > 1000 and orderkey < 2000", table2));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT t1.orderkey as view_orderkey, t2.totalprice as view_totalprice, t1.ds FROM %s t1 inner join %s t2 ON (t1.ds=t2.ds AND t1.orderkey = t2.orderkey)", view, table1, table2));
            org.testng.Assert.assertTrue((boolean)queryRunner.tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view), 255L);
            String viewQuery = String.format("SELECT view_orderkey, view_totalprice, ds FROM %s WHERE view_orderkey <  10000 ORDER BY view_orderkey", view);
            String baseQuery = String.format("SELECT t1.orderkey as view_orderkey, t2.totalprice as view_totalprice, t1.ds FROM %s t1 inner join  %s t2 ON (t1.ds=t2.ds AND t1.orderkey = t2.orderkey) WHERE t1.orderkey < 10000 ORDER BY t1.orderkey", table1, table2);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"orderkey", (String)"orderkey_7")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table1, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2019-01-02"))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table2, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey_7", (Object)"orderkey"))})), PlanMatchPattern.filter((String)"view_orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"view_orderkey", (Object)"view_orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubqueryMaterializedView() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String view = "test_orders_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = array['ds']) AS SELECT *, '2021-07-11' AS ds FROM orders WHERE orderkey < 10000 UNION ALL SELECT *, '2021-07-12' AS ds FROM orders WHERE orderkey < 10000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, ds FROM %s", view, table));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2021-07-12'", view), 2503L);
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            PlanMatchPattern expectedPattern = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("2021-07-11"))), (Map)ImmutableMap.of()), PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey_43", (Object)"orderkey"))});
            String baseQuery = String.format("SELECT orderkey FROM %s ORDER BY orderkey", table);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)baseQueryResult, (Iterable)optimizedQueryResult);
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, expectedPattern);
            String queryWithSubquery = String.format("SELECT orderkey FROM (SELECT orderkey FROM %s) ORDER BY orderkey", table);
            MaterializedResult optimizedSubqueryResult = this.computeActual(queryOptimizationWithMaterializedView, queryWithSubquery);
            MaterializedResult subqueryResult = this.computeActual(queryWithSubquery);
            Assert.assertEquals((Iterable)optimizedSubqueryResult, (Iterable)subqueryResult);
            this.assertPlan(queryOptimizationWithMaterializedView, queryWithSubquery, expectedPattern);
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubqueryMaterializedViewWithMultipleViews() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String lineItemTable = "lineitem_partitioned";
        String supplierTable = "suppliers_partitioned";
        String lineItemView1 = "test_lineitem_view";
        String lineItemView2 = "test_lineitem_view_2";
        String suppliersView = "test_suppliers_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = array['ds']) AS SELECT *, '2021-07-11' AS ds FROM lineitem WHERE orderkey < 10000 UNION ALL SELECT *, '2021-07-12' AS ds FROM lineitem WHERE orderkey < 10000", lineItemTable));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = array['ds']) AS SELECT *, '2021-07-11' AS ds FROM supplier WHERE suppkey < 10000 UNION ALL SELECT *, '2021-07-12' AS ds FROM supplier WHERE suppkey < 10000", supplierTable));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT suppkey, SUM(quantity) as qty, ds FROM %s GROUP BY suppkey, ds", lineItemView1, lineItemTable));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT suppkey, SUM(quantity) as returned_qty, ds FROM %s WHERE returnflag = 'R' GROUP BY suppkey, ds", lineItemView2, lineItemTable));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT suppkey, name, ds\n FROM %s WHERE name != 'bob'", suppliersView, supplierTable));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2021-07-12'", lineItemView1), 100L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2021-07-12'", lineItemView2), 100L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2021-07-11'", suppliersView), 100L);
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), lineItemView1));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), lineItemView2));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), suppliersView));
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, lineItemTable, (List<String>)ImmutableList.of((Object)lineItemView1, (Object)lineItemView2));
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, supplierTable, (List<String>)ImmutableList.of((Object)suppliersView));
            String baseQuery = String.format("WITH long_name_supp AS ( %nSELECT suppkey, name %nFROM %s %nWHERE name != 'bob'), supp_returns AS (%nSELECT suppkey, sum(quantity) AS returned_qty %n FROM %s %nWHERE returnflag = 'R' GROUP BY suppkey, ds), %nsupp_sum AS (%nSELECT suppkey, SUM(quantity) AS qty %n FROM %s %n GROUP BY suppkey, ds) %n SELECT n.suppkey, n.name, r.returned_qty, s.qty %n FROM long_name_supp AS n %n LEFT JOIN supp_returns AS r ON n.suppkey = r.suppkey %n LEFT JOIN supp_sum AS s ON n.suppkey = s.suppkey %n ORDER BY suppkey, name", supplierTable, lineItemTable, lineItemTable);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)baseQueryResult, (Iterable)optimizedQueryResult);
            PlanMatchPattern expectedPattern = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)supplierTable, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("2021-07-12"))), (Map)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)suppliersView, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"suppkey_37", (Object)"suppkey", (Object)"name_38", (Object)"name"))})}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)lineItemTable, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("2021-07-11", "2021-07-12"))), (Map)ImmutableMap.of((Object)"ds_73", (Object)"ds", (Object)"suppkey_71", (Object)"suppkey"))})}), PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)lineItemTable, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("2021-07-11"))), (Map)ImmutableMap.of((Object)"ds_108", (Object)"ds", (Object)"suppkey_94", (Object)"suppkey", (Object)"quantity_96", (Object)"quantity"))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)lineItemView1, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"ds_193", (Object)"ds", (Object)"suppkey_192", (Object)"suppkey"))})})})})})});
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, expectedPattern);
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + lineItemView1);
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + lineItemView2);
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + suppliersView);
            queryRunner.execute("DROP TABLE IF EXISTS " + lineItemTable);
            queryRunner.execute("DROP TABLE IF EXISTS " + supplierTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubqueryMaterializedViewAggregateWithAndJoin() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").setSystemProperty("prefer_partial_aggregation", "false").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String supplierTable = "supplier_partitioned";
        String lineItemTable = "lineitem_partitioned";
        String lineItemView = "test_lineitem_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = array['ds']) AS SELECT *, '2021-07-11' AS ds FROM supplier WHERE suppkey < 10000 UNION ALL SELECT *, '2021-07-12' AS ds FROM supplier WHERE suppkey < 10000", supplierTable));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = array['ds']) AS SELECT *, '2021-07-11' AS ds FROM lineitem WHERE quantity > 1 UNION ALL SELECT *, '2021-07-12' AS ds FROM lineitem WHERE quantity > 1", lineItemTable));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT MIN(extendedprice) AS min_price, partkey, ds FROM %s GROUP BY partkey, ds ", lineItemView, lineItemTable));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), lineItemView));
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, lineItemTable, (List<String>)ImmutableList.of((Object)lineItemView));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2021-07-12'", lineItemView), 2000L);
            String baseQuery = String.format("SELECT t1.name, t1.suppkey, low_cost.partkey %nFROM %s t1 %nLEFT JOIN (%nSELECT t2.partkey, t2.suppkey FROM %s t2 %nLEFT JOIN (SELECT MIN(extendedprice) AS min_price, partkey, ds FROM %s GROUP BY partkey, ds) mp %nON mp.partkey = t2.partkey WHERE t2.extendedprice <= mp.min_price*1.05) low_cost ON low_cost.suppkey = t1.suppkey ORDER BY t1.name, t1.suppkey, low_cost.partkey", supplierTable, lineItemTable, lineItemTable);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)baseQueryResult, (Iterable)optimizedQueryResult);
            PlanMatchPattern expectedPattern = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)supplierTable, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("2021-07-11", "2021-07-12"))), (Map)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)lineItemTable, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)10), TestHiveLogicalPlanner.utf8Slices("2021-07-11", "2021-07-12"))), (Map)ImmutableMap.of((Object)"suppkey_0", (Object)"suppkey", (Object)"extendedprice", (Object)"extendedprice"))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)lineItemTable, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2021-07-11"))), (Map)ImmutableMap.of((Object)"ds_22", (Object)"ds", (Object)"partkey_7", (Object)"partkey", (Object)"extendedprice_11", (Object)"extendedprice"))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)lineItemView, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"ds_103", (Object)"ds", (Object)"partkey_102", (Object)"partkey"))})})})})})})});
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, expectedPattern);
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + lineItemView);
            queryRunner.execute("DROP TABLE IF EXISTS " + lineItemTable);
            queryRunner.execute("DROP TABLE IF EXISTS " + supplierTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestMaterializedViewForMultiWayJoin() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table1 = "orders_key_partitioned_join";
        String table2 = "orders_price_partitioned_join";
        String table3 = "orders_status_partitioned_join";
        String view = "orders_view_join";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, '2020-01-01' AS ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, '2019-01-02' AS ds FROM orders WHERE orderkey > 1000 AND orderkey < 2000", table1));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, totalprice, '2020-01-01' AS ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, totalprice, '2019-01-02' AS ds FROM orders WHERE orderkey > 1000 AND orderkey < 2000", table2));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderstatus, '2020-01-01' AS ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderstatus, '2019-01-02' AS ds FROM orders WHERE orderkey > 1000 AND orderkey < 2000", table3));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT t1.orderkey AS view_orderkey, t2.totalprice AS view_totalprice, t3.orderstatus AS view_orderstatus, t1.ds FROM %s t1 INNER JOIN %s t2 ON (t1.ds=t2.ds AND t1.orderkey = t2.orderkey) INNER JOIN %s t3 ON (t1.ds = t3.ds AND t1.orderkey = t3.orderkey)", view, table1, table2, table3));
            this.assertQueryFails(String.format("CREATE MATERIALIZED VIEW should_fail WITH (partitioned_by = ARRAY['ds']) AS SELECT t1.orderkey AS view_orderkey, t2.totalprice AS view_totalprice, t3.orderstatus AS view_orderstatus, t1.ds FROM %s t1 INNER JOIN %s t2 ON (t1.ds=t2.ds AND t1.orderkey = t2.orderkey) INNER JOIN %s t3 ON (t1.orderkey = t3.orderkey)", table1, table2, table3), "Materialized view tpch.should_fail must have at least one partition column that exists in orders_status_partitioned_join as well");
            org.testng.Assert.assertTrue((boolean)queryRunner.tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view), 255L);
            String viewQuery = String.format("SELECT view_orderkey, view_totalprice, view_orderstatus, ds FROM %s WHERE view_orderkey <  10000 ORDER BY view_orderkey", view);
            String baseQuery = String.format("SELECT t1.orderkey AS view_orderkey, t2.totalprice AS view_totalprice, t3.orderstatus AS view_orderstatus, t1.ds FROM %s t1 INNER JOIN %s t2 ON (t1.ds=t2.ds AND t1.orderkey = t2.orderkey) INNER JOIN %s t3 ON (t1.ds = t3.ds AND t1.orderkey = t3.orderkey) WHERE t1.orderkey < 10000 ORDER BY t1.orderkey", table1, table2, table3);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"orderkey", (String)"orderkey_28")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table1, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2019-01-02"))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"orderkey_7", (String)"orderkey_28")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey_7 < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table2, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey_7", (Object)"orderkey")))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey_28 < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table3, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey_28", (Object)"orderkey")))}))})), PlanMatchPattern.filter((String)"view_orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"view_orderkey", (Object)"view_orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
            queryRunner.execute("DROP TABLE IF EXISTS " + table3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewOptimizationWithDoublePartition() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned_double_partition";
        String view = "orders_view_double_partition";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['totalprice']) AS SELECT orderkey, orderpriority, totalprice FROM orders WHERE orderkey < 10 ", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['totalprice']) AS SELECT orderkey, orderpriority, totalprice FROM %s", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE totalprice<65000", view), 3L);
            String viewQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", view);
            String baseQuery = String.format("SELECT orderkey from %s where orderkey < 10000 ORDER BY orderkey", table);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"totalprice", (Object)Domain.multipleValues((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)105367.67, (Object)172799.49, (Object)205654.3, (Object)271885.66))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))), PlanMatchPattern.filter((String)"orderkey_17 < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"orderkey_17", (Object)"orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewOptimizationWithUnsupportedFunctionSubquery() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String table2 = "lineitem_partitioned";
        String view = "orders_view";
        String view2 = "lineitem_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, comment, '2020-01-01' AS ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, comment, '2019-01-02' AS ds FROM orders WHERE orderkey > 1000 AND orderkey < 2000", table));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, quantity, '2020-01-01' AS ds FROM lineitem WHERE orderkey < 1000 UNION ALL SELECT orderkey, quantity, '2019-01-02' AS ds FROM lineitem WHERE orderkey > 1000 AND orderkey < 2000", table2));
            queryRunner.execute(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT max(length(comment)) as longest_comment, orderkey, ds FROM %s GROUP BY ds, orderkey", view, table));
            queryRunner.execute(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT sum(quantity) as total_quantity, orderkey, ds FROM %s GROUP BY ds, orderkey", view2, table2));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view2));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view), 255L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2019-01-02'", view2), 248L);
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table2, (List<String>)ImmutableList.of((Object)view2));
            String baseQuery = String.format("SELECT * FROM (SELECT ds, orderkey, max(length(comment)) as longest_comment FROM %s GROUP BY ds, orderkey) s1 INNER JOIN (SELECT ds, orderkey, sum(quantity) as total_quantity FROM %s GROUP BY ds, orderkey) s2 ON s1.orderkey = s2.orderkey ORDER BY s1.orderkey, longest_comment", table, table2);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)baseQueryResult, (Iterable)optimizedQueryResult);
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of(), (Map)ImmutableMap.of())})}), PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table2, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"ds_14", (Object)"ds", (Object)"orderkey_13", (Object)"orderkey"))}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)view2, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"ds_42", (Object)"ds", (Object)"orderkey_41", (Object)"orderkey"))})})})})})}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view2);
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewPartitionKeyFilter() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String view = "orders_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, totalprice, '2020-01-01' AS ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, totalprice, '2020-01-02' AS ds FROM orders WHERE orderkey > 1000 AND orderkey < 2000 UNION ALL SELECT orderkey, totalprice, '2020-01-03' AS ds FROM orders WHERE orderkey > 2000 AND orderkey < 3000", table));
            queryRunner.execute(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT max(totalprice) as max_price, orderkey, ds FROM %s GROUP BY orderkey, ds", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view), 255L);
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            String baseQuery = String.format("SELECT max(totalprice) as max_price, orderkey FROM %s GROUP BY orderkey ORDER BY orderkey", table);
            String viewQuery = String.format("SELECT max_price, orderkey FROM %s GROUP BY orderkey, max_price ORDER BY orderkey", view);
            MaterializedResult viewQueryResult = this.computeActual(viewQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)baseQueryResult, (Iterable)viewQueryResult);
            Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("consider-query-filters-for-materialized-view-partitions", "true").setCatalogSessionProperty("hive", "materialized_view_missing_partitions_threshold", Integer.toString(1)).build();
            this.assertPlan(session, viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of(), (Map)ImmutableMap.of())}));
            String viewQueryWithFilterOnPartitionKey = String.format("SELECT max_price, orderkey FROM %s WHERE ds < '2020-01-03' ORDER BY orderkey", view);
            String baseQueryWithFilterOnPartitionkey = String.format("SELECT max(totalprice) as max_price, orderkey FROM %s WHERE ds < '2020-01-03' GROUP BY orderkey ORDER BY orderkey", table);
            MaterializedResult baseQueryResultWithFilter = this.computeActual(session, baseQueryWithFilterOnPartitionkey);
            MaterializedResult viewQueryResultWithFilter = this.computeActual(session, viewQueryWithFilterOnPartitionKey);
            Assert.assertEquals((Iterable)baseQueryResultWithFilter, (Iterable)viewQueryResultWithFilter);
            this.assertPlan(session, viewQueryWithFilterOnPartitionKey, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2020-01-02"))), (Map)ImmutableMap.of())}), PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of())})}));
            Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").setCatalogSessionProperty("hive", "materialized_view_missing_partitions_threshold", Integer.toString(1)).build();
            MaterializedResult baseQueryResultWithFilterAndOptimization = this.computeActual(queryOptimizationWithMaterializedView, baseQueryWithFilterOnPartitionkey);
            Assert.assertEquals((Iterable)baseQueryResultWithFilterAndOptimization, (Iterable)viewQueryResultWithFilter);
            this.assertPlan(queryOptimizationWithMaterializedView, baseQueryWithFilterOnPartitionkey, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2020-01-02"))), (Map)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of())})})}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewPartitionKeyFilterWithRenamedFilterColumn() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String view = "orders_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, totalprice, '2020-01-01' AS ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, totalprice, '2020-01-02' AS ds FROM orders WHERE orderkey > 1000 AND orderkey < 2000 UNION ALL SELECT orderkey, totalprice, '2020-01-03' AS ds FROM orders WHERE orderkey > 2000 AND orderkey < 3000", table));
            queryRunner.execute(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds_mv']) AS SELECT max(totalprice) as max_price, orderkey, ds AS ds_mv FROM %s GROUP BY orderkey, ds", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds_mv='2020-01-01'", view), 255L);
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("consider-query-filters-for-materialized-view-partitions", "true").setCatalogSessionProperty("hive", "materialized_view_missing_partitions_threshold", Integer.toString(1)).build();
            String viewQueryWithFilterOnPartitionKey = String.format("SELECT max_price, orderkey FROM %s WHERE ds_mv < '2020-01-03' ORDER BY orderkey", view);
            String baseQueryWithFilterOnPartitionkey = String.format("SELECT max(totalprice) as max_price, orderkey FROM %s WHERE ds < '2020-01-03' GROUP BY orderkey ORDER BY orderkey", table);
            MaterializedResult baseQueryResultWithFilter = this.computeActual(session, baseQueryWithFilterOnPartitionkey);
            MaterializedResult viewQueryResultWithFilter = this.computeActual(session, viewQueryWithFilterOnPartitionKey);
            Assert.assertEquals((Iterable)baseQueryResultWithFilter, (Iterable)viewQueryResultWithFilter);
            this.assertPlan(session, viewQueryWithFilterOnPartitionKey, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2020-01-02"))), (Map)ImmutableMap.of())}), PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of())})}));
            Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").setCatalogSessionProperty("hive", "materialized_view_missing_partitions_threshold", Integer.toString(1)).build();
            MaterializedResult baseQueryResultWithFilterAndOptimization = this.computeActual(queryOptimizationWithMaterializedView, baseQueryWithFilterOnPartitionkey);
            Assert.assertEquals((Iterable)baseQueryResultWithFilterAndOptimization, (Iterable)viewQueryResultWithFilter);
            this.assertPlan(queryOptimizationWithMaterializedView, baseQueryWithFilterOnPartitionkey, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2020-01-02"))), (Map)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of())})})}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewAvgRewrite() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String view = "orders_view_sum_count";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, totalprice, '2020-01-01' AS ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, totalprice, '2020-01-02' AS ds FROM orders WHERE orderkey > 1000 AND orderkey < 2000 ", table));
            queryRunner.execute(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT sum(totalprice) AS sum_price, count(totalprice) AS price_count, orderkey, ds FROM %s GROUP BY orderkey, ds", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds = '2020-01-01'", view), 255L);
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            String baseQuery = String.format("SELECT avg(totalprice) as base_avg_price, orderkey FROM %s GROUP BY orderkey ORDER BY orderkey", table);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            MaterializedResult optimizedQueryResultSumCount = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            Assert.assertEquals((Iterable)optimizedQueryResultSumCount, (Iterable)baseQueryResult);
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2020-01-02"))), (Map)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of())})})}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewApproxDistinctRewrite() {
        Session queryOptimizationWithMaterializedView = Session.builder((Session)this.getSession()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").build();
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String view = "orders_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, custkey, '2020-01-01' AS ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, custkey, '2020-01-02' AS ds FROM orders WHERE orderkey > 1000 AND orderkey < 2000 ", table));
            queryRunner.execute(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT CAST(approx_set(custkey) AS varbinary) AS customers, orderkey, ds FROM %s GROUP BY orderkey, ds", view, table));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds = '2020-01-01'", view), 255L);
            this.setReferencedMaterializedViews((DistributedQueryRunner)queryRunner, table, (List<String>)ImmutableList.of((Object)view));
            String baseQuery = String.format("SELECT approx_distinct(custkey) as approx_customers, orderkey FROM %s GROUP BY orderkey ORDER BY orderkey", table);
            MaterializedResult optimizedQueryResult = this.computeActual(queryOptimizationWithMaterializedView, baseQuery);
            MaterializedResult baseQueryResult = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)optimizedQueryResult, (Iterable)baseQueryResult);
            this.assertPlan(queryOptimizationWithMaterializedView, baseQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2020-01-02"))), (Map)ImmutableMap.of())}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of())})})}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewForJoinWithMultiplePartitions() {
        QueryRunner queryRunner = this.getQueryRunner();
        String view = "order_view_join_with_multiple_partitions";
        String table1 = "orders_key_partitioned_join_with_multiple_partitions";
        String table2 = "orders_price_partitioned_join_with_multiple_partitions";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds', 'orderpriority']) AS SELECT orderkey, '2020-01-01' as ds, orderpriority FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, '2019-01-02' as ds , orderpriority FROM orders WHERE orderkey > 1000 and orderkey < 2000", table1));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds', 'orderstatus']) AS SELECT totalprice, '2020-01-01' as ds, orderstatus FROM orders WHERE orderkey < 1000 UNION ALL SELECT totalprice, '2019-01-02' as ds, orderstatus FROM orders WHERE orderkey > 1000 and orderkey < 2000", table2));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds', 'view_orderpriority', 'view_orderstatus']) AS SELECT t1.orderkey as view_orderkey, t2.totalprice as view_totalprice, t1.ds as ds, t1.orderpriority as view_orderpriority, t2.orderstatus as view_orderstatus  FROM %s t1 inner join %s t2 ON t1.ds=t2.ds", view, table1, table2));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view, table1, table2), 65025L);
            String viewQuery = String.format("SELECT view_orderkey from %s where view_orderkey < 10000 ORDER BY view_orderkey", view);
            String baseQuery = String.format("SELECT t1.orderkey FROM %s t1 inner join %s t2 ON t1.ds=t2.ds where t1.orderkey < 10000 ORDER BY t1.orderkey", table1, table2);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of(), (PlanMatchPattern)PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table1, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2019-01-02")), (Object)"orderpriority", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)15), TestHiveLogicalPlanner.utf8Slices("1-URGENT", "2-HIGH", "3-MEDIUM", "4-NOT SPECIFIED", "5-LOW"))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table2, (Map)ImmutableMap.of())})), PlanMatchPattern.filter((String)"view_orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"view_orderkey", (Object)"view_orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewInvalidLeftOuterJoin() {
        QueryRunner queryRunner = this.getQueryRunner();
        String view = "view_invalid_left_outer_join";
        String table1 = "t1_invalid_left_outer_join";
        String table2 = "t2_invalid_left_outer_join";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT 1 as a, '2020-01-01' as ds", table1));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT 1 as a, '2020-01-01' as ds", table2));
            this.assertQueryFails(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['t1_ds', 't2_ds']) AS SELECT t1.a as t1_a, t2.a as t2_a, t1.ds as t1_ds, t2.ds as t2_ds FROM %s t1 LEFT JOIN %s t2 ON t1.a = t2.a", view, table1, table2), ".*must have at least one common partition equality constraint.*");
            this.assertQueryFails(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['t2_ds']) AS SELECT t1.a as t1_a, t2.a as t2_a, t2.ds as t2_ds FROM %s t1 LEFT JOIN %s t2 ON t1.ds = t2.ds", view, table1, table2), ".*must have at least one partition column that exists in.*");
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewWithLimit() {
        QueryRunner queryRunner = this.getQueryRunner();
        String view = "view_with_limit";
        String table = "t1_with_limit";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT 1 as a, '2020-01-01' as ds", table));
            this.assertQueryFails(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT a, ds FROM %s t1 LIMIT 10000", view, table), ".*LIMIT clause in materialized view is not supported.*");
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewForLeftOuterJoin() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table1 = "orders_key_partitioned_left_outer_join";
        String table2 = "orders_price_partitioned_left_outer_join";
        String view = "orders_view_left_outer_join";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, '2019-01-01' as ds FROM orders WHERE orderkey < 1500 UNION ALL SELECT orderkey, '2019-01-02' as ds FROM orders WHERE orderkey > 1500 and orderkey < 2000", table1));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, totalprice, '2019-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, totalprice, '2019-01-02' as ds FROM orders WHERE orderkey > 1000 and orderkey < 2000", table2));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['t1_ds', 't2_ds']) AS SELECT t1.orderkey as view_orderkey, t2.totalprice as view_totalprice, t1.ds as t1_ds, t2.ds as t2_ds FROM %s t1 left join %s t2 ON (t1.ds=t2.ds AND t1.orderkey = t2.orderkey)", view, table1, table2));
            org.testng.Assert.assertTrue((boolean)queryRunner.tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE t1_ds='2019-01-01'", view), 375L);
            String viewQuery = String.format("SELECT view_orderkey, view_totalprice, t1_ds FROM %s WHERE view_orderkey <  10000 ORDER BY view_orderkey", view);
            String baseQuery = String.format("SELECT t1.orderkey as view_orderkey, t2.totalprice as view_totalprice, t1.ds FROM %s t1 left join  %s t2 ON (t1.ds=t2.ds AND t1.orderkey = t2.orderkey) WHERE t1.orderkey < 10000 ORDER BY t1.orderkey", table1, table2);
            MaterializedResult viewTable = this.computeActual(viewQuery);
            MaterializedResult baseTable = this.computeActual(baseQuery);
            Assert.assertEquals((Iterable)viewTable, (Iterable)baseTable);
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.LEFT, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"ds", (String)"ds_8"), (Object)PlanMatchPattern.equiJoinClause((String)"orderkey", (String)"orderkey_7")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table1, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2019-01-02"))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"ds", (Object)"ds")))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.constrainedTableScan((String)table2, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2019-01-02"))), (Map)ImmutableMap.of((Object)"orderkey_7", (Object)"orderkey", (Object)"ds_8", (Object)"ds"))})), PlanMatchPattern.filter((String)"view_orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"view_orderkey", (Object)"view_orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewFullOuterJoin() {
        QueryRunner queryRunner = this.getQueryRunner();
        String view = "order_view_full_outer_join";
        String table1 = "orders_key_partitioned_full_outer_join";
        String table2 = "orders_price_partitioned_full_outer_join";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds', 'orderpriority']) AS SELECT orderkey, '2020-01-01' as ds, orderpriority FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, '2019-01-02' as ds , orderpriority FROM orders WHERE orderkey > 1000 and orderkey < 2000", table1));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds', 'orderstatus']) AS SELECT totalprice, '2020-01-01' as ds, orderstatus FROM orders WHERE orderkey < 1000 UNION ALL SELECT totalprice, '2019-01-02' as ds, orderstatus FROM orders WHERE orderkey > 1000 and orderkey < 2000", table2));
            this.assertQueryFails(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds', 'view_orderpriority', 'view_orderstatus']) AS SELECT t1.orderkey as view_orderkey, t2.totalprice as view_totalprice, t1.ds as ds, t1.orderpriority as view_orderpriority, t2.orderstatus as view_orderstatus  FROM %s t1 full outer join %s t2 ON t1.ds=t2.ds", view, table1, table2), ".*Only inner join, left join and cross join unnested are supported for materialized view.*");
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewSameTableTwice() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "same_table";
        String view = "same_table_twice";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT 1 as a, '2020-01-01' as ds", table));
            this.assertQueryFails(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT t1.a, t1.ds FROM %s t1 UNION ALL SELECT t2.a, t2.ds FROM %s t2", view, table, table), ".*Materialized View definition does not support multiple instances of same table*");
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewOrderBy() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_partitioned";
        String view = "test_orders_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, '2019-01-02' as ds FROM orders WHERE orderkey > 1000", table));
            this.assertQueryFails(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, ds FROM %s order by orderkey", view, table), ".*OrderBy are not supported for materialized view.*");
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewSubqueryShapes() {
        QueryRunner queryRunner = this.getQueryRunner();
        String view1 = "orders_key_view1";
        String view2 = "orders_key_view2";
        String view3 = "orders_key_view3";
        String view4 = "orders_key_view4";
        String table1 = "orders_key_partitioned_1";
        String table2 = "orders_key_partitioned_2";
        String table3 = "orders_key_partitioned_3";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT 1 as a, '2020-01-01' as ds", table1));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT 1 as a, '2020-01-01' as ds", table2));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT 1 as a, '2020-01-01' as ds", table3));
            this.assertQueryFails(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT t1.a, t1.ds FROM %s t1 WHERE (t1.a IN (SELECT t2.a FROM %s t2 WHERE t1.ds = t2.ds))", view1, table1, table2), ".*Subqueries are not supported for materialized view.*");
            this.assertQueryFails(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT t1.a, t1.ds FROM %s t1 join (select t2.ds AS t2_ds, t2.a from %s t2 where (t2.a IN (SELECT t3.a FROM %s t3 WHERE t2.ds = t3.ds))) ON t1.ds = t2_ds", view2, table1, table2, table3), ".*Subqueries are not supported for materialized view.*");
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT t1.a, t1.ds FROM %s t1 join (select t2.ds AS t2_ds, t2.a from %s t2 where t2.a <= 420) ON t1.ds = t2_ds", view3, table1, table2));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view1);
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view2);
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view3);
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view4);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
            queryRunner.execute("DROP TABLE IF EXISTS " + table3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewLateralJoin() {
        QueryRunner queryRunner = this.getQueryRunner();
        String view = "order_view_lateral_join";
        String table1 = "orders_key_partitioned_lateral_join";
        String table2 = "orders_price_partitioned_lateral_join";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds', 'orderpriority']) AS SELECT orderkey, '2020-01-01' as ds, orderpriority FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, '2019-01-02' as ds , orderpriority FROM orders WHERE orderkey > 1000 and orderkey < 2000", table1));
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds', 'orderstatus']) AS SELECT totalprice, '2020-01-01' as ds, orderstatus FROM orders WHERE orderkey < 1000 UNION ALL SELECT totalprice, '2019-01-02' as ds, orderstatus FROM orders WHERE orderkey > 1000 and orderkey < 2000", table2));
            this.assertQueryFails(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT t1.ds FROM %s t1, LATERAL(SELECT t2.ds, t2.orderstatus AS view_orderstatus, t1.orderpriority AS view_orderpriority FROM %s t2 WHERE t1.ds = t2.ds)", view, table1, table2), ".*Only inner join, left join and cross join unnested are supported for materialized view.*");
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewForCrossJoinUnnest() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table = "orders_key_cross_join_unnest";
        String view = "orders_view_cross_join_unnest";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, ARRAY['MEDIUM', 'LOW'] as volume, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, ARRAY['HIGH'] as volume, '2019-01-02' as ds FROM orders WHERE orderkey > 1000 and orderkey < 2000", table));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey AS view_orderkey, unnested.view_volume, ds FROM %s CROSS JOIN UNNEST (volume) AS unnested(view_volume)", view, table));
            org.testng.Assert.assertTrue((boolean)queryRunner.tableExists(this.getSession(), view));
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s WHERE ds='2020-01-01'", view), 510L);
            String viewQuery = String.format("SELECT view_orderkey, view_volume, ds from %s where view_orderkey < 10000 ORDER BY view_orderkey, view_volume", view);
            String baseQuery = String.format("SELECT orderkey AS view_orderkey, unnested.view_volume, ds FROM %s CROSS JOIN UNNEST (volume) AS unnested(view_volume) WHERE orderkey < 10000 ORDER BY orderkey, view_volume", table);
            Assert.assertEquals((Iterable)this.computeActual(viewQuery), (Iterable)this.computeActual(baseQuery));
            this.assertPlan(this.getSession(), viewQuery, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.unnest((PlanMatchPattern)PlanMatchPattern.filter((String)"orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)table, (Map)ImmutableMap.of((Object)"ds", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2019-01-02"))), (Map)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))), PlanMatchPattern.filter((String)"view_orderkey < BIGINT'10000'", (PlanMatchPattern)PlanMatchPattern.constrainedTableScan((String)view, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"view_orderkey", (Object)"view_orderkey")))}));
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertBySelectingFromMaterializedView() {
        QueryRunner queryRunner = this.getQueryRunner();
        String table1 = "orders_partitioned_source";
        String table2 = "orders_partitioned_target";
        String table3 = "orders_from_mv";
        String view = "test_orders_view";
        try {
            queryRunner.execute(String.format("CREATE TABLE %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, '2019-01-02' as ds FROM orders WHERE orderkey > 1000", table1));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), table1));
            this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, ds FROM %s", view, table1));
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), view));
            this.assertUpdate(String.format("CREATE TABLE %s AS SELECT * FROM %s WHERE 1=0", table2, table1), 0L);
            org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), table2));
            this.assertQueryFails(String.format("CREATE TABLE %s AS SELECT * FROM %s", table3, view), ".*CreateTableAsSelect by selecting from a materialized view \\w+ is not supported.*");
            this.assertUpdate(String.format("INSERT INTO %s VALUES(99999, '1-URGENT', '2019-01-02')", table2), 1L);
            this.assertUpdate(String.format("INSERT INTO %s SELECT * FROM %s WHERE ds = '2020-01-01'", table2, table1), 255L);
            this.assertQueryFails(String.format("INSERT INTO %s SELECT * FROM %s WHERE ds = '2020-01-01'", table2, view), ".*Insert by selecting from a materialized view \\w+ is not supported.*");
        }
        finally {
            queryRunner.execute("DROP MATERIALIZED VIEW IF EXISTS " + view);
            queryRunner.execute("DROP TABLE IF EXISTS " + table1);
            queryRunner.execute("DROP TABLE IF EXISTS " + table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewQueryAccessControl() {
        QueryRunner queryRunner = this.getQueryRunner();
        Session invokerSession = Session.builder((Session)this.getSession()).setIdentity(new Identity("test_view_invoker", Optional.empty())).setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).setSystemProperty("query_optimization_with_materialized_view_enabled", "true").build();
        Session ownerSession = this.getSession();
        queryRunner.execute(ownerSession, "CREATE TABLE test_orders_base WITH (partitioned_by = ARRAY['orderstatus']) AS SELECT orderkey, custkey, totalprice, orderstatus FROM orders LIMIT 10");
        queryRunner.execute(ownerSession, "CREATE MATERIALIZED VIEW test_orders_view WITH (partitioned_by = ARRAY['orderstatus']) AS SELECT SUM(totalprice) AS totalprice, orderstatus FROM test_orders_base GROUP BY orderstatus");
        this.setReferencedMaterializedViews((DistributedQueryRunner)this.getQueryRunner(), "test_orders_base", (List<String>)ImmutableList.of((Object)"test_orders_view"));
        Consumer<String> testQueryWithDeniedPrivilege = query -> {
            this.assertAccessDenied(invokerSession, (String)query, "Cannot select from columns \\[.*\\] in table .*test_orders_base.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)invokerSession.getUser(), (String)"test_orders_base", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
            this.assertAccessAllowed(invokerSession, (String)query, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)invokerSession.getUser(), (String)"test_orders_view", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        };
        try {
            String directMaterializedViewQuery = "SELECT totalprice, orderstatus FROM test_orders_view";
            String queryWithMaterializedViewOptimization = "SELECT SUM(totalprice) AS totalprice, orderstatus FROM test_orders_base GROUP BY orderstatus";
            testQueryWithDeniedPrivilege.accept(directMaterializedViewQuery);
            testQueryWithDeniedPrivilege.accept(queryWithMaterializedViewOptimization);
            queryRunner.execute(ownerSession, "REFRESH MATERIALIZED VIEW test_orders_view WHERE orderstatus = 'F'");
            testQueryWithDeniedPrivilege.accept(directMaterializedViewQuery);
            testQueryWithDeniedPrivilege.accept(queryWithMaterializedViewOptimization);
            queryRunner.execute(ownerSession, "REFRESH MATERIALIZED VIEW test_orders_view WHERE orderstatus <> 'F'");
            testQueryWithDeniedPrivilege.accept(directMaterializedViewQuery);
            testQueryWithDeniedPrivilege.accept(queryWithMaterializedViewOptimization);
        }
        finally {
            queryRunner.execute(ownerSession, "DROP MATERIALIZED VIEW test_orders_view");
            queryRunner.execute(ownerSession, "DROP TABLE test_orders_base");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRefreshMaterializedViewAccessControl() {
        QueryRunner queryRunner = this.getQueryRunner();
        Session invokerSession = Session.builder((Session)this.getSession()).setIdentity(new Identity("test_view_invoker", Optional.empty())).setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).build();
        Session ownerSession = this.getSession();
        queryRunner.execute(ownerSession, "CREATE TABLE test_orders_base WITH (partitioned_by = ARRAY['orderstatus']) AS SELECT orderkey, custkey, totalprice, orderstatus FROM orders LIMIT 10");
        queryRunner.execute(ownerSession, "CREATE MATERIALIZED VIEW test_orders_view WITH (partitioned_by = ARRAY['orderstatus']) AS SELECT orderkey, totalprice, orderstatus FROM test_orders_base");
        String refreshMaterializedView = "REFRESH MATERIALIZED VIEW test_orders_view WHERE orderstatus = 'F'";
        try {
            this.assertAccessDenied(invokerSession, refreshMaterializedView, "Cannot select from columns \\[.*\\] in table .*test_orders_base.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)ownerSession.getUser(), (String)"test_orders_base", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
            this.assertAccessAllowed(invokerSession, refreshMaterializedView, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)invokerSession.getUser(), (String)"test_orders_base", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
            this.assertAccessDenied(invokerSession, refreshMaterializedView, "Cannot insert into table .*test_orders_view.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)ownerSession.getUser(), (String)"test_orders_view", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
            this.assertAccessAllowed(invokerSession, refreshMaterializedView, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)invokerSession.getUser(), (String)"test_orders_view", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
            this.assertAccessAllowed(invokerSession, refreshMaterializedView, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)ownerSession.getUser(), (String)"test_orders_view", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
            this.assertAccessAllowed(invokerSession, refreshMaterializedView, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)invokerSession.getUser(), (String)"test_orders_view", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
            this.assertAccessDenied(ownerSession, refreshMaterializedView, "Cannot select from columns \\[.*\\] in table .*test_orders_base.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)ownerSession.getUser(), (String)"test_orders_base", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
            this.assertAccessDenied(ownerSession, refreshMaterializedView, "Cannot insert into table .*test_orders_view.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)ownerSession.getUser(), (String)"test_orders_view", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
            this.assertAccessAllowed(ownerSession, refreshMaterializedView, new TestingAccessControlManager.TestingPrivilege[0]);
        }
        finally {
            queryRunner.execute(ownerSession, "DROP MATERIALIZED VIEW test_orders_view");
            queryRunner.execute(ownerSession, "DROP TABLE test_orders_base");
        }
    }

    private void setReferencedMaterializedViews(DistributedQueryRunner queryRunner, String tableName, List<String> referencedMaterializedViews) {
        this.appendTableParameter(TestHiveLogicalPlanner.replicateHiveMetastore(queryRunner), tableName, "referenced_materialized_views", referencedMaterializedViews.stream().map(view -> String.format("%s.%s", this.getSession().getSchema().orElse(""), view)).collect(Collectors.joining(",")));
    }

    private void appendTableParameter(ExtendedHiveMetastore metastore, String tableName, String parameterKey, String parameterValue) {
        MetastoreContext metastoreContext = new MetastoreContext(this.getSession().getUser(), this.getSession().getQueryId().getId(), Optional.empty(), Optional.empty(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        Optional table = metastore.getTable(metastoreContext, (String)this.getSession().getSchema().get(), tableName);
        if (table.isPresent()) {
            Table originalTable = (Table)table.get();
            Table alteredTable = Table.builder((Table)originalTable).setParameter(parameterKey, parameterValue).build();
            metastore.dropTable(metastoreContext, originalTable.getDatabaseName(), originalTable.getTableName(), false);
            metastore.createTable(metastoreContext, alteredTable, new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of()));
        }
    }
}

