/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.ColumnConverter;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.HiveColumnConverter;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveMetadata {
    private static final HiveColumnHandle TEST_COLUMN_HANDLE = new HiveColumnHandle("test", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 0, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty(), Optional.empty());

    @Test
    public void testColumnMetadataGetter() {
        TestingTypeManager mockTypeManager = new TestingTypeManager();
        Column column1 = new Column("c1", HiveType.HIVE_INT, Optional.empty(), Optional.of("some-metadata"));
        HiveColumnHandle hiveColumnHandle1 = new HiveColumnHandle(column1.getName(), HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"int"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
        HiveColumnHandle hidden = new HiveColumnHandle("$path", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"int"), 0, HiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty(), Optional.empty());
        Column partitionColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Table mockTable = new Table("schema", "table", "user", PrestoTableType.MANAGED_TABLE, new Storage(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC), "location", Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)column1.getName()), 100, (List)ImmutableList.of(), BucketFunctionType.HIVE_COMPATIBLE, Optional.empty())), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (List)ImmutableList.of((Object)column1), (List)ImmutableList.of((Object)partitionColumn), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty());
        ColumnMetadata actual = (ColumnMetadata)HiveMetadata.columnMetadataGetter((Table)mockTable, (TypeManager)mockTypeManager, (ColumnConverter)new HiveColumnConverter()).apply(hiveColumnHandle1);
        ColumnMetadata expected = new ColumnMetadata("c1", (Type)IntegerType.INTEGER);
        Assert.assertEquals((Object)actual, (Object)expected);
        actual = (ColumnMetadata)HiveMetadata.columnMetadataGetter((Table)mockTable, (TypeManager)mockTypeManager, (ColumnConverter)new TestColumnConverter()).apply(hidden);
        expected = ColumnMetadata.builder().setName("$path").setType((Type)IntegerType.INTEGER).setHidden(true).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test(timeOut=5000L)
    public void testCreatePredicate() {
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (int i = 0; i < 5000; ++i) {
            partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), Integer.toString(i), (Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)Integer.toString(i))))));
        }
        HiveMetadata.createPredicate((List)ImmutableList.of((Object)TEST_COLUMN_HANDLE), (List)partitions.build());
    }

    @Test
    public void testCreateOnlyNullsPredicate() {
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (int i = 0; i < 5; ++i) {
            partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), Integer.toString(i), (Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE, (Object)NullableValue.asNull((Type)VarcharType.VARCHAR))));
        }
        HiveMetadata.createPredicate((List)ImmutableList.of((Object)TEST_COLUMN_HANDLE), (List)partitions.build());
    }

    @Test
    public void testCreateMixedPredicate() {
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (int i = 0; i < 5; ++i) {
            partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), Integer.toString(i), (Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)Integer.toString(i))))));
        }
        partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), "null", (Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE, (Object)NullableValue.asNull((Type)VarcharType.VARCHAR))));
        HiveMetadata.createPredicate((List)ImmutableList.of((Object)TEST_COLUMN_HANDLE), (List)partitions.build());
    }

    @Test
    public void testPreferredOrderingColumnsSerDe() {
        this.verifyPreferredOrderingColumnsRoundTrip((List<SortingColumn>)ImmutableList.of());
        this.verifyPreferredOrderingColumnsRoundTrip((List<SortingColumn>)ImmutableList.of((Object)new SortingColumn("a", SortingColumn.Order.ASCENDING)));
        this.verifyPreferredOrderingColumnsRoundTrip((List<SortingColumn>)ImmutableList.of((Object)new SortingColumn("a", SortingColumn.Order.DESCENDING)));
        this.verifyPreferredOrderingColumnsRoundTrip((List<SortingColumn>)ImmutableList.of((Object)new SortingColumn("a", SortingColumn.Order.ASCENDING), (Object)new SortingColumn("b", SortingColumn.Order.DESCENDING)));
        this.verifyPreferredOrderingColumnsRoundTrip((List<SortingColumn>)ImmutableList.of((Object)new SortingColumn("a", SortingColumn.Order.ASCENDING), (Object)new SortingColumn("b", SortingColumn.Order.ASCENDING)));
        this.verifyPreferredOrderingColumnsRoundTrip((List<SortingColumn>)ImmutableList.of((Object)new SortingColumn("a", SortingColumn.Order.DESCENDING), (Object)new SortingColumn("b", SortingColumn.Order.ASCENDING)));
        this.verifyPreferredOrderingColumnsRoundTrip((List<SortingColumn>)ImmutableList.of((Object)new SortingColumn("a", SortingColumn.Order.DESCENDING), (Object)new SortingColumn("b", SortingColumn.Order.DESCENDING)));
        this.verifyPreferredOrderingColumnsRoundTrip((List<SortingColumn>)ImmutableList.of((Object)new SortingColumn("ASC", SortingColumn.Order.ASCENDING)));
        this.verifyPreferredOrderingColumnsRoundTrip((List<SortingColumn>)ImmutableList.of((Object)new SortingColumn("DESC", SortingColumn.Order.DESCENDING)));
    }

    private void verifyPreferredOrderingColumnsRoundTrip(List<SortingColumn> sortingColumns) {
        List decoded = HiveMetadata.decodePreferredOrderingColumnsFromStorage((Storage)Storage.builder().setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT).setLocation("test").setParameters((Map)ImmutableMap.of((Object)"preferred_ordering_columns", (Object)HiveMetadata.encodePreferredOrderingColumns(sortingColumns))).build());
        Assert.assertEquals(sortingColumns, (Collection)decoded);
    }

    private class TestColumnConverter
    implements ColumnConverter {
        TestColumnConverter() {
        }

        public Column toColumn(FieldSchema fieldSchema) {
            throw new UnsupportedOperationException();
        }

        public FieldSchema fromColumn(Column column) {
            throw new UnsupportedOperationException();
        }

        public Optional<String> getTypeMetadata(HiveType hiveType, TypeSignature typeSignature) {
            throw new UnsupportedOperationException();
        }

        public TypeSignature getTypeSignature(HiveType hiveType, Optional<String> typeMetadata) {
            if (typeMetadata == null) {
                throw new AssertionError((Object)"typeMetadata is null");
            }
            return hiveType.getTypeSignature();
        }
    }
}

