/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.hive.HiveMetadataUpdateHandle;
import com.facebook.presto.spi.SchemaTableName;
import java.util.Optional;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveMetadataUpdateHandle {
    public static final UUID TEST_REQUEST_ID = UUID.randomUUID();
    public static final String TEST_SCHEMA_NAME = "schema";
    public static final String TEST_TABLE_NAME = "table";
    public static final String TEST_PARTITION_NAME = "partition_name";
    public static final SchemaTableName TEST_SCHEMA_TABLE_NAME = new SchemaTableName("schema", "table");
    public static final HiveMetadataUpdateHandle TEST_HIVE_METADATA_UPDATE_REQUEST = new HiveMetadataUpdateHandle(TEST_REQUEST_ID, TEST_SCHEMA_TABLE_NAME, Optional.of("partition_name"), Optional.empty());
    private final JsonCodec<HiveMetadataUpdateHandle> codec = JsonCodec.jsonCodec(HiveMetadataUpdateHandle.class);

    @Test
    public void testHiveMetadataUpdateRequest() {
        this.testRoundTrip(TEST_HIVE_METADATA_UPDATE_REQUEST);
    }

    @Test
    public void testHiveMetadataUpdateResult() {
        HiveMetadataUpdateHandle request = TEST_HIVE_METADATA_UPDATE_REQUEST;
        HiveMetadataUpdateHandle expectedHiveMetadataUpdateResult = new HiveMetadataUpdateHandle(request.getRequestId(), request.getSchemaTableName(), request.getPartitionName(), Optional.of("fileName"));
        this.testRoundTrip(expectedHiveMetadataUpdateResult);
    }

    private void testRoundTrip(HiveMetadataUpdateHandle expected) {
        String json = this.codec.toJson((Object)expected);
        HiveMetadataUpdateHandle actual = (HiveMetadataUpdateHandle)this.codec.fromJson(json);
        Assert.assertEquals((Object)actual.getRequestId(), (Object)expected.getRequestId());
        Assert.assertEquals((Object)actual.getSchemaTableName(), (Object)expected.getSchemaTableName());
        Assert.assertEquals((Object)actual.getPartitionName(), (Object)expected.getPartitionName());
        Assert.assertEquals((Object)actual.getMetadataUpdate(), (Object)expected.getMetadataUpdate());
    }
}

