/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionResult;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.TestingSemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestHivePartitionManager {
    private static final String SCHEMA_NAME = "schema";
    private static final String TABLE_NAME = "table";
    private static final String USER_NAME = "user";
    private static final String LOCATION = "somewhere/over/the/rainbow";
    private static final Column PARTITION_COLUMN = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
    private static final Column BUCKET_COLUMN = new Column("c1", HiveType.HIVE_INT, Optional.empty(), Optional.empty());
    private static final Table TABLE = new Table("schema", "table", "user", PrestoTableType.MANAGED_TABLE, new Storage(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC), "somewhere/over/the/rainbow", Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)BUCKET_COLUMN.getName()), 100, (List)ImmutableList.of(), BucketFunctionType.HIVE_COMPATIBLE, Optional.empty())), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (List)ImmutableList.of((Object)BUCKET_COLUMN), (List)ImmutableList.of((Object)PARTITION_COLUMN), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty());
    private static final List<String> PARTITIONS = ImmutableList.of((Object)"ds=2019-07-23", (Object)"ds=2019-08-23");
    private HivePartitionManager hivePartitionManager = new HivePartitionManager((TypeManager)new TestingTypeManager(), new HiveClientConfig());
    private final TestingSemiTransactionalHiveMetastore metastore = TestingSemiTransactionalHiveMetastore.create();

    @BeforeClass
    public void setUp() {
        this.metastore.addTable(SCHEMA_NAME, TABLE_NAME, TABLE, PARTITIONS);
    }

    @Test
    public void testUsesBucketingIfSmallEnough() {
        HiveTableHandle tableHandle = new HiveTableHandle(SCHEMA_NAME, TABLE_NAME);
        HivePartitionResult result = this.hivePartitionManager.getPartitions((SemiTransactionalHiveMetastore)this.metastore, (ConnectorTableHandle)tableHandle, Constraint.alwaysTrue(), (ConnectorSession)new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig(), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties()));
        Assert.assertTrue((boolean)result.getBucketHandle().isPresent(), (String)"bucketHandle is not present");
        Assert.assertFalse((boolean)result.getBucketFilter().isPresent(), (String)"bucketFilter is present");
    }

    @Test
    public void testIgnoresBucketingWhenTooManyBuckets() {
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setMaxBucketsForGroupedExecution(100), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        HivePartitionResult result = this.hivePartitionManager.getPartitions((SemiTransactionalHiveMetastore)this.metastore, (ConnectorTableHandle)new HiveTableHandle(SCHEMA_NAME, TABLE_NAME), Constraint.alwaysTrue(), (ConnectorSession)session);
        Assert.assertFalse((boolean)result.getBucketHandle().isPresent(), (String)"bucketHandle is present");
        Assert.assertFalse((boolean)result.getBucketFilter().isPresent(), (String)"bucketFilter is present");
    }

    @Test
    public void testUsesBucketingWithPartitionFilters() {
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setMaxBucketsForGroupedExecution(100), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        HiveTableHandle tableHandle = new HiveTableHandle(SCHEMA_NAME, TABLE_NAME);
        HivePartitionResult result = this.hivePartitionManager.getPartitions((SemiTransactionalHiveMetastore)this.metastore, (ConnectorTableHandle)tableHandle, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new HiveColumnHandle(PARTITION_COLUMN.getName(), PARTITION_COLUMN.getType(), TypeSignature.parseTypeSignature((String)"varchar"), -13, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty(), Optional.empty()), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2019-07-23"))))), (ConnectorSession)session);
        Assert.assertTrue((boolean)result.getBucketHandle().isPresent(), (String)"bucketHandle is not present");
        Assert.assertFalse((boolean)result.getBucketFilter().isPresent(), (String)"bucketFilter is present");
    }

    @Test
    public void testUsesBucketingWithBucketFilters() {
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setMaxBucketsForGroupedExecution(100), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        HiveTableHandle tableHandle = new HiveTableHandle(SCHEMA_NAME, TABLE_NAME);
        HivePartitionResult result = this.hivePartitionManager.getPartitions((SemiTransactionalHiveMetastore)this.metastore, (ConnectorTableHandle)tableHandle, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new HiveColumnHandle(BUCKET_COLUMN.getName(), BUCKET_COLUMN.getType(), TypeSignature.parseTypeSignature((String)"varchar"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)))), (ConnectorSession)session);
        Assert.assertTrue((boolean)result.getBucketHandle().isPresent(), (String)"bucketHandle is not present");
        Assert.assertTrue((boolean)result.getBucketFilter().isPresent(), (String)"bucketFilter is present");
    }

    @Test
    public void testUsesBucketingWithBucketColumn() {
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setMaxBucketsForGroupedExecution(1), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        HiveTableHandle tableHandle = new HiveTableHandle(SCHEMA_NAME, TABLE_NAME);
        HivePartitionResult result = this.hivePartitionManager.getPartitions((SemiTransactionalHiveMetastore)this.metastore, (ConnectorTableHandle)tableHandle, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)HiveColumnHandle.bucketColumnHandle(), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)))), (ConnectorSession)session);
        Assert.assertTrue((boolean)result.getBucketHandle().isPresent(), (String)"bucketHandle is not present");
        Assert.assertTrue((boolean)result.getBucketFilter().isPresent(), (String)"bucketFilter is present");
    }

    @Test
    public void testIgnoresBucketingWhenConfigured() {
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setIgnoreTableBucketing(true), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        HivePartitionResult result = this.hivePartitionManager.getPartitions((SemiTransactionalHiveMetastore)this.metastore, (ConnectorTableHandle)new HiveTableHandle(SCHEMA_NAME, TABLE_NAME), Constraint.alwaysTrue(), (ConnectorSession)session);
        Assert.assertFalse((boolean)result.getBucketHandle().isPresent(), (String)"bucketHandle is present");
        Assert.assertFalse((boolean)result.getBucketFilter().isPresent(), (String)"bucketFilter is present");
    }
}

