/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.QueryAssertions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.tpch.TpchTable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHiveRoles
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createQueryRunner(new TpchTable[0]);
    }

    @AfterMethod
    public void afterMethod() {
        for (String role : this.listRoles()) {
            this.executeFromAdmin("DROP ROLE " + role);
        }
    }

    @Test
    public void testCreateRole() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        Assert.assertEquals(this.listRoles(), (Set)ImmutableSet.of((Object)"role1"));
        Assert.assertEquals(this.listRoles(), (Set)ImmutableSet.of((Object)"role1"));
    }

    @Test
    public void testCreateDuplicateRole() throws Exception {
        this.executeFromAdmin("CREATE ROLE duplicate_role");
        this.assertQueryFails(this.createAdminSession(), "CREATE ROLE duplicate_role", ".*?Role 'duplicate_role' already exists");
    }

    @Test
    public void testCreateRoleWithAdminOption() throws Exception {
        this.assertQueryFails(this.createAdminSession(), "CREATE ROLE role1 WITH ADMIN admin", ".*?Hive Connector does not support WITH ADMIN statement");
    }

    @Test
    public void testCreateReservedRole() throws Exception {
        this.assertQueryFails(this.createAdminSession(), "CREATE ROLE all", "Role name cannot be one of the reserved roles: \\[all, default, none\\]");
        this.assertQueryFails(this.createAdminSession(), "CREATE ROLE default", "Role name cannot be one of the reserved roles: \\[all, default, none\\]");
        this.assertQueryFails(this.createAdminSession(), "CREATE ROLE none", "Role name cannot be one of the reserved roles: \\[all, default, none\\]");
    }

    @Test
    public void testCreateRoleByNonAdminUser() throws Exception {
        this.assertQueryFails(this.createUserSession("non_admin_user"), "CREATE ROLE role1", "Access Denied: Cannot create role role1");
    }

    @Test
    public void testDropRole() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        Assert.assertEquals(this.listRoles(), (Set)ImmutableSet.of((Object)"role1"));
        this.executeFromAdmin("DROP ROLE role1");
        Assert.assertEquals(this.listRoles(), (Set)ImmutableSet.of());
    }

    @Test
    public void testDropNonExistentRole() throws Exception {
        this.assertQueryFails(this.createAdminSession(), "DROP ROLE non_existent_role", ".*?Role 'non_existent_role' does not exist");
    }

    @Test
    public void testDropRoleByNonAdminUser() throws Exception {
        this.assertQueryFails(this.createUserSession("non_admin_user"), "DROP ROLE role1", "Access Denied: Cannot drop role role1");
    }

    @Test
    public void testListRolesByNonAdminUser() throws Exception {
        this.assertQueryFails(this.createUserSession("non_admin_user"), "SELECT * FROM hive.information_schema.roles", "Access Denied: Cannot select from table information_schema.roles");
    }

    @Test
    public void testPublicRoleIsGrantedToAnyone() throws Exception {
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("some_user"), (MaterializedResult)this.applicableRoles("some_user", "USER", "public", "NO"));
    }

    @Test
    public void testAdminRoleIsGrantedToAdmin() throws Exception {
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("admin"), (MaterializedResult)this.applicableRoles("admin", "USER", "admin", "YES"));
    }

    @Test
    public void testGrantRoleToUser() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("GRANT role1 TO USER user");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO"));
    }

    @Test
    public void testGrantRoleToRole() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO"));
    }

    @Test
    public void testGrantRoleWithAdminOption() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("GRANT role1 TO USER user WITH ADMIN OPTION");
        this.executeFromAdmin("GRANT role2 TO ROLE role1 WITH ADMIN OPTION");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "YES", "role1", "ROLE", "role2", "YES"));
    }

    @Test
    public void testGrantRoleMultipleTimes() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        this.executeFromAdmin("GRANT role1 TO USER user WITH ADMIN OPTION");
        this.executeFromAdmin("GRANT role1 TO USER user WITH ADMIN OPTION");
        this.executeFromAdmin("GRANT role2 TO ROLE role1 WITH ADMIN OPTION");
        this.executeFromAdmin("GRANT role2 TO ROLE role1 WITH ADMIN OPTION");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "YES", "role1", "ROLE", "role2", "YES"));
    }

    @Test
    public void testGrantNonExistingRole() throws Exception {
        this.assertQueryFails("GRANT grant_revoke_role_existing_1 TO USER grant_revoke_existing_user_1", ".*?Role 'grant_revoke_role_existing_1' does not exist");
        this.executeFromAdmin("CREATE ROLE grant_revoke_role_existing_1");
        this.assertQueryFails("GRANT grant_revoke_role_existing_1 TO ROLE grant_revoke_role_existing_2", ".*?Role 'grant_revoke_role_existing_2' does not exist");
    }

    @Test
    public void testRevokeRoleFromUser() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("GRANT role1 TO USER user");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO"));
        this.executeFromAdmin("REVOKE role1 FROM USER user");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO"));
    }

    @Test
    public void testRevokeRoleFromRole() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO"));
        this.executeFromAdmin("REVOKE role2 FROM ROLE role1");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO", "user", "USER", "role1", "NO"));
    }

    @Test
    public void testDropGrantedRole() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("GRANT role1 TO USER user");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO"));
        this.executeFromAdmin("DROP ROLE role1");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO"));
    }

    @Test
    public void testRevokeTransitiveRoleFromUser() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("CREATE ROLE role3");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        this.executeFromAdmin("GRANT role3 TO ROLE role2");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO", "role2", "ROLE", "role3", "NO"));
        this.executeFromAdmin("REVOKE role1 FROM USER user");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO"));
    }

    @Test
    public void testRevokeTransitiveRoleFromRole() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("CREATE ROLE role3");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        this.executeFromAdmin("GRANT role3 TO ROLE role2");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO", "role2", "ROLE", "role3", "NO"));
        this.executeFromAdmin("REVOKE role2 FROM ROLE role1");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO", "user", "USER", "role1", "NO"));
    }

    @Test
    public void testDropTransitiveRole() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("CREATE ROLE role3");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        this.executeFromAdmin("GRANT role3 TO ROLE role2");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO", "role2", "ROLE", "role3", "NO"));
        this.executeFromAdmin("DROP ROLE role2");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO", "user", "USER", "role1", "NO"));
    }

    @Test
    public void testRevokeAdminOption() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("GRANT role1 TO USER user WITH ADMIN OPTION");
        this.executeFromAdmin("GRANT role2 TO ROLE role1 WITH ADMIN OPTION");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "YES", "role1", "ROLE", "role2", "YES"));
        this.executeFromAdmin("REVOKE ADMIN OPTION FOR role1 FROM USER user");
        this.executeFromAdmin("REVOKE ADMIN OPTION FOR role2 FROM ROLE role1");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO"));
    }

    @Test
    public void testRevokeRoleMultipleTimes() throws Exception {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("GRANT role1 TO USER user WITH ADMIN OPTION");
        this.executeFromAdmin("GRANT role2 TO ROLE role1 WITH ADMIN OPTION");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "YES", "role1", "ROLE", "role2", "YES"));
        this.executeFromAdmin("REVOKE ADMIN OPTION FOR role1 FROM USER user");
        this.executeFromAdmin("REVOKE ADMIN OPTION FOR role1 FROM USER user");
        this.executeFromAdmin("REVOKE ADMIN OPTION FOR role2 FROM ROLE role1");
        this.executeFromAdmin("REVOKE ADMIN OPTION FOR role2 FROM ROLE role1");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO"));
        this.executeFromAdmin("REVOKE role1 FROM USER user");
        this.executeFromAdmin("REVOKE role1 FROM USER user");
        this.executeFromAdmin("REVOKE role2 FROM ROLE role1");
        this.executeFromAdmin("REVOKE role2 FROM ROLE role1");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO"));
    }

    @Test
    public void testRevokeNonExistingRole() throws Exception {
        this.assertQueryFails(this.createAdminSession(), "REVOKE grant_revoke_role_existing_1 FROM USER grant_revoke_existing_user_1", ".*?Role 'grant_revoke_role_existing_1' does not exist");
        this.executeFromAdmin("CREATE ROLE grant_revoke_role_existing_1");
        this.assertQueryFails(this.createAdminSession(), "REVOKE grant_revoke_role_existing_1 FROM ROLE grant_revoke_role_existing_2", ".*?Role 'grant_revoke_role_existing_2' does not exist");
    }

    @Test
    public void testSetRole() throws Exception {
        this.executeFromAdmin("CREATE ROLE set_role_1");
        this.executeFromAdmin("CREATE ROLE set_role_2");
        this.executeFromAdmin("CREATE ROLE set_role_3");
        this.executeFromAdmin("CREATE ROLE set_role_4");
        this.executeFromAdmin("GRANT set_role_1 TO USER set_user_1");
        this.executeFromAdmin("GRANT set_role_2 TO ROLE set_role_1");
        this.executeFromAdmin("GRANT set_role_3 TO ROLE set_role_2");
        Session unsetRole = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(new Identity("set_user_1", Optional.empty())).build();
        Session setRoleAll = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(new Identity("set_user_1", Optional.empty(), (Map)ImmutableMap.of((Object)"hive", (Object)new SelectedRole(SelectedRole.Type.ALL, Optional.empty())), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty())).build();
        Session setRoleNone = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(new Identity("set_user_1", Optional.empty(), (Map)ImmutableMap.of((Object)"hive", (Object)new SelectedRole(SelectedRole.Type.NONE, Optional.empty())), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty())).build();
        Session setRole1 = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(new Identity("set_user_1", Optional.empty(), (Map)ImmutableMap.of((Object)"hive", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("set_role_1"))), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty())).build();
        Session setRole2 = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(new Identity("set_user_1", Optional.empty(), (Map)ImmutableMap.of((Object)"hive", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("set_role_2"))), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty())).build();
        Session setRole3 = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(new Identity("set_user_1", Optional.empty(), (Map)ImmutableMap.of((Object)"hive", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("set_role_3"))), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty())).build();
        Session setRole4 = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(new Identity("set_user_1", Optional.empty(), (Map)ImmutableMap.of((Object)"hive", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("set_role_4"))), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty())).build();
        MaterializedResult actual = this.getQueryRunner().execute(unsetRole, "SELECT * FROM hive.information_schema.applicable_roles");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)unsetRole, (Type[])new Type[]{VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType()}).row(new Object[]{"set_user_1", "USER", "public", "NO"}).row(new Object[]{"set_user_1", "USER", "set_role_1", "NO"}).row(new Object[]{"set_role_1", "ROLE", "set_role_2", "NO"}).row(new Object[]{"set_role_2", "ROLE", "set_role_3", "NO"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(unsetRole, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)unsetRole, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_1"}).row(new Object[]{"set_role_2"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRoleAll, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRoleAll, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_1"}).row(new Object[]{"set_role_2"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRoleNone, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRoleNone, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRole1, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRole1, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_1"}).row(new Object[]{"set_role_2"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRole2, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRole2, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_2"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRole3, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRole3, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        this.assertQueryFails(setRole4, "SELECT * FROM hive.information_schema.enabled_roles", ".*?Cannot set role set_role_4");
        this.executeFromAdmin("DROP ROLE set_role_1");
        this.executeFromAdmin("DROP ROLE set_role_2");
        this.executeFromAdmin("DROP ROLE set_role_3");
        this.executeFromAdmin("DROP ROLE set_role_4");
    }

    private Set<String> listRoles() {
        return this.executeFromAdmin("SELECT * FROM hive.information_schema.roles").getMaterializedRows().stream().map(row -> row.getField(0).toString()).collect(Collectors.toSet());
    }

    private MaterializedResult listApplicableRoles(String user) {
        return this.executeFromUser(user, "SELECT * FROM hive.information_schema.applicable_roles");
    }

    private MaterializedResult applicableRoles(String ... values) {
        ImmutableList types = ImmutableList.of((Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType());
        int rowLength = types.size();
        Preconditions.checkArgument((values.length % rowLength == 0 ? 1 : 0) != 0);
        MaterializedResult.Builder result = MaterializedResult.resultBuilder((Session)this.getQueryRunner().getDefaultSession(), (Iterable)types);
        Object[] row = null;
        for (int i = 0; i < values.length; ++i) {
            if (i % rowLength == 0) {
                if (row != null) {
                    result.row(row);
                }
                row = new Object[rowLength];
            }
            Preconditions.checkState((row != null ? 1 : 0) != 0);
            row[i % rowLength] = values[i];
        }
        if (row != null) {
            result.row(row);
        }
        return result.build();
    }

    private MaterializedResult executeFromAdmin(String sql) {
        return this.getQueryRunner().execute(this.createAdminSession(), sql);
    }

    private MaterializedResult executeFromUser(String user, String sql) {
        return this.getQueryRunner().execute(this.createUserSession(user), sql);
    }

    private Session createAdminSession() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(new Identity("admin", Optional.empty(), (Map)ImmutableMap.of((Object)"hive", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty())).build();
    }

    private Session createUserSession(String user) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(new Identity(user, Optional.empty())).build();
    }
}

