/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.testing.TestingConnectorSession;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveSessionProperties {
    @Test
    public void testEmptyNodeSelectionStrategyConfig() {
        TestingConnectorSession connectorSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig(), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        Assert.assertEquals((Object)HiveSessionProperties.getNodeSelectionStrategy((ConnectorSession)connectorSession), (Object)NodeSelectionStrategy.NO_PREFERENCE);
    }

    @Test
    public void testEmptyConfigNodeSelectionStrategyConfig() {
        TestingConnectorSession connectorSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setNodeSelectionStrategy(NodeSelectionStrategy.valueOf((String)"NO_PREFERENCE")), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        Assert.assertEquals((Object)HiveSessionProperties.getNodeSelectionStrategy((ConnectorSession)connectorSession), (Object)NodeSelectionStrategy.NO_PREFERENCE);
    }

    @Test
    public void testNodeSelectionStrategyConfig() {
        TestingConnectorSession connectorSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setNodeSelectionStrategy(NodeSelectionStrategy.HARD_AFFINITY), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        Assert.assertEquals((Object)HiveSessionProperties.getNodeSelectionStrategy((ConnectorSession)connectorSession), (Object)NodeSelectionStrategy.HARD_AFFINITY);
    }

    @Test
    public void testCacheEnabledConfig() {
        TestingConnectorSession connectorSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig(), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig().setCachingEnabled(true)).getSessionProperties());
        Assert.assertTrue((boolean)HiveSessionProperties.isCacheEnabled((ConnectorSession)connectorSession));
    }
}

