/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.block.BlockJsonSerde;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.CacheQuotaRequirement;
import com.facebook.presto.hive.DwrfEncryptionMetadata;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.EncryptionMetadata;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveHandleResolver;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.TableToPartitionMapping;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.type.TypeDeserializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveSplit {
    @Test
    public void testJsonRoundTrip() throws Exception {
        ImmutableList partitionKeys = ImmutableList.of((Object)new HivePartitionKey("a", Optional.of("apple")), (Object)new HivePartitionKey("b", Optional.of("42")));
        ImmutableList addresses = ImmutableList.of((Object)HostAddress.fromParts((String)"127.0.0.1", (int)44), (Object)HostAddress.fromParts((String)"127.0.0.1", (int)45));
        ImmutableMap customSplitInfo = ImmutableMap.of((Object)"key", (Object)"value");
        ImmutableSet redundantColumnDomains = ImmutableSet.of((Object)new HiveColumnHandle("test_column", HiveType.HIVE_LONG, HiveType.HIVE_LONG.getTypeSignature(), 5, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), (List)ImmutableList.of(), Optional.empty()));
        HiveFileSplit fileSplit = new HiveFileSplit("path", 42L, 87L, 88L, Instant.now().toEpochMilli(), Optional.empty(), (Map)customSplitInfo);
        HiveSplit expected = new HiveSplit(fileSplit, "db", "table", "partitionId", new Storage(StorageFormat.create((String)"serde", (String)"input", (String)"output"), "location", Optional.empty(), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (List)partitionKeys, (List)addresses, OptionalInt.empty(), OptionalInt.empty(), NodeSelectionStrategy.NO_PREFERENCE, 10, TableToPartitionMapping.mapColumnsByIndex((Map)ImmutableMap.of((Object)1, (Object)new Column("name", HiveType.HIVE_STRING, Optional.empty(), Optional.empty()))), Optional.of(new HiveSplit.BucketConversion(32, 16, (List)ImmutableList.of((Object)new HiveColumnHandle("col", HiveType.HIVE_LONG, BigintType.BIGINT.getTypeSignature(), 5, HiveColumnHandle.ColumnType.REGULAR, Optional.of("comment"), Optional.empty())))), false, CacheQuotaRequirement.NO_CACHE_REQUIREMENT, Optional.of(EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forPerField((Map)ImmutableMap.of((Object)"field1", (Object)"test1".getBytes()), (Map)ImmutableMap.of(), (String)"test_algo", (String)"test_provider"))), (Set)redundantColumnDomains, SplitWeight.fromProportion((double)2.0));
        JsonCodec<HiveSplit> codec = this.getJsonCodec();
        String json = codec.toJson((Object)expected);
        HiveSplit actual = (HiveSplit)codec.fromJson(json);
        Assert.assertEquals((String)actual.getDatabase(), (String)expected.getDatabase());
        Assert.assertEquals((String)actual.getTable(), (String)expected.getTable());
        Assert.assertEquals((String)actual.getPartitionName(), (String)expected.getPartitionName());
        Assert.assertEquals((Object)actual.getFileSplit(), (Object)expected.getFileSplit());
        Assert.assertEquals((Object)actual.getStorage(), (Object)expected.getStorage());
        Assert.assertEquals((Collection)actual.getPartitionKeys(), (Collection)expected.getPartitionKeys());
        Assert.assertEquals((Collection)actual.getAddresses(), (Collection)expected.getAddresses());
        Assert.assertEquals((int)actual.getPartitionDataColumnCount(), (int)expected.getPartitionDataColumnCount());
        Assert.assertEquals((Map)actual.getTableToPartitionMapping().getPartitionSchemaDifference(), (Map)expected.getTableToPartitionMapping().getPartitionSchemaDifference());
        Assert.assertEquals((Object)actual.getTableToPartitionMapping().getTableToPartitionColumns(), (Object)expected.getTableToPartitionMapping().getTableToPartitionColumns());
        Assert.assertEquals((Object)actual.getBucketConversion(), (Object)expected.getBucketConversion());
        Assert.assertEquals((Object)actual.getNodeSelectionStrategy(), (Object)expected.getNodeSelectionStrategy());
        Assert.assertEquals((boolean)actual.isS3SelectPushdownEnabled(), (boolean)expected.isS3SelectPushdownEnabled());
        Assert.assertEquals((Object)actual.getCacheQuotaRequirement(), (Object)expected.getCacheQuotaRequirement());
        Assert.assertEquals((Object)actual.getEncryptionInformation(), (Object)expected.getEncryptionInformation());
        Assert.assertEquals((Object)actual.getSplitWeight(), (Object)expected.getSplitWeight());
    }

    private JsonCodec<HiveSplit> getJsonCodec() throws Exception {
        Module module = binder -> {
            binder.install((Module)new JsonModule());
            binder.install((Module)new HandleJsonModule());
            ConfigBinder.configBinder((Binder)binder).bindConfig(FeaturesConfig.class);
            FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
            binder.bind(TypeManager.class).toInstance((Object)functionAndTypeManager);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
            Multibinder.newSetBinder((Binder)binder, Type.class);
            binder.bind(BlockEncodingSerde.class).to(BlockEncodingManager.class).in(Scopes.SINGLETON);
            Multibinder.newSetBinder((Binder)binder, BlockEncoding.class);
            JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Block.class).to(BlockJsonSerde.Serializer.class);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Block.class).to(BlockJsonSerde.Deserializer.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(HiveSplit.class);
        };
        Bootstrap app = new Bootstrap((Iterable)ImmutableList.of((Object)module));
        Injector injector = app.doNotInitializeLogging().quiet().initialize();
        HandleResolver handleResolver = (HandleResolver)injector.getInstance(HandleResolver.class);
        handleResolver.addConnectorName("hive", (ConnectorHandleResolver)new HiveHandleResolver());
        return (JsonCodec)injector.getInstance((Key)new Key<JsonCodec<HiveSplit>>(){});
    }
}

