/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.PartitionMutator;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePartitionMutator;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.BridgingHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.MockHiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastoreStats;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.constraints.PrimaryKeyConstraint;
import com.facebook.presto.spi.constraints.UniqueConstraint;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHiveTableConstraints {
    private MockHiveMetastoreClient mockClient;
    private SemiTransactionalHiveMetastore metastore;
    private ThriftHiveMetastoreStats stats;

    @BeforeMethod
    public void setUp() {
        HiveClientConfig config = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        this.mockClient = new MockHiveMetastoreClient();
        MockHiveCluster mockHiveCluster = new MockHiveCluster(this.mockClient);
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s")));
        HivePartitionMutator hivePartitionMutator = new HivePartitionMutator();
        HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(config, metastoreClientConfig), (Set)ImmutableSet.of(), config);
        HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, metastoreClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        ThriftHiveMetastore thriftHiveMetastore = new ThriftHiveMetastore((HiveCluster)mockHiveCluster, metastoreClientConfig, hdfsEnvironment);
        this.metastore = new SemiTransactionalHiveMetastore(hdfsEnvironment, (ExtendedHiveMetastore)new BridgingHiveMetastore((HiveMetastore)thriftHiveMetastore, (PartitionMutator)hivePartitionMutator), executor, false, false, true, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        this.stats = thriftHiveMetastore.getStats();
    }

    @Test
    public void testTableConstraints() {
        ImmutableList expectedConstraints = ImmutableList.of((Object)new PrimaryKeyConstraint("", (Set)ImmutableSet.of((Object)"c1"), true, true), (Object)new UniqueConstraint("", (Set)ImmutableSet.of((Object)"c2"), true, true));
        List tableConstraints = this.metastore.getTableConstraints(HiveQueryRunner.METASTORE_CONTEXT, "testdb", "testtbl_constraints");
        Assert.assertEquals((Collection)tableConstraints, (Collection)expectedConstraints);
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setMaxBucketsForGroupedExecution(100), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        this.metastore.dropTable(new HdfsContext((ConnectorSession)session, "testdb", "testtbl_constraints", "/some/path", false), "testdb", "testtbl_constraints");
        tableConstraints = this.metastore.getTableConstraints(HiveQueryRunner.METASTORE_CONTEXT, "testdb", "testtbl_constraints");
        Assert.assertEquals((Collection)tableConstraints, (Collection)ImmutableList.of());
    }

    public static class MockHiveCluster
    implements HiveCluster {
        private final MockHiveMetastoreClient client;

        public MockHiveCluster(MockHiveMetastoreClient client) {
            this.client = client;
        }

        public HiveMetastoreClient createMetastoreClient(Optional<String> token) {
            return this.client;
        }

        public MockHiveMetastoreClient createPartitionVersionSupportedMetastoreClient() {
            return this.client;
        }
    }
}

