/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveTypeTranslator {
    private final TypeTranslator typeTranslator;
    private final Map<String, HiveType> typeTranslationMap;

    public TestHiveTypeTranslator() {
        this((TypeTranslator)new HiveTypeTranslator(), (Map<String, HiveType>)ImmutableMap.of());
    }

    protected TestHiveTypeTranslator(TypeTranslator typeTranslator, Map<String, HiveType> overwriteTranslation) {
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
        ImmutableMap hiveTypeTranslationMap = ImmutableMap.builder().put((Object)"bigint", (Object)HiveType.HIVE_LONG).put((Object)"integer", (Object)HiveType.HIVE_INT).put((Object)"smallint", (Object)HiveType.HIVE_SHORT).put((Object)"tinyint", (Object)HiveType.HIVE_BYTE).put((Object)"double", (Object)HiveType.HIVE_DOUBLE).put((Object)"varchar(3)", (Object)HiveType.valueOf((String)"varchar(3)")).put((Object)"varchar", (Object)HiveType.HIVE_STRING).put((Object)"date", (Object)HiveType.HIVE_DATE).put((Object)"timestamp", (Object)HiveType.HIVE_TIMESTAMP).put((Object)"decimal(5,3)", (Object)HiveType.valueOf((String)"decimal(5,3)")).put((Object)"varbinary", (Object)HiveType.HIVE_BINARY).put((Object)"array(timestamp)", (Object)HiveType.valueOf((String)"array<timestamp>")).put((Object)"map(boolean,varbinary)", (Object)HiveType.valueOf((String)"map<boolean,binary>")).put((Object)"row(col0 integer,col1 varbinary)", (Object)HiveType.valueOf((String)"struct<col0:int,col1:binary>")).build();
        this.typeTranslationMap = new HashMap<String, HiveType>();
        this.typeTranslationMap.putAll((Map<String, HiveType>)hiveTypeTranslationMap);
        this.typeTranslationMap.putAll(overwriteTranslation);
    }

    @Test
    public void testTypeTranslator() {
        for (Map.Entry<String, HiveType> entry : this.typeTranslationMap.entrySet()) {
            this.assertTypeTranslation(entry.getKey(), entry.getValue());
        }
        this.assertInvalidTypeTranslation("row(integer,varbinary)", StandardErrorCode.NOT_SUPPORTED.toErrorCode(), "Anonymous row type is not supported in Hive. Please give each field a name: row(integer,varbinary)");
    }

    private void assertTypeTranslation(String typeName, HiveType hiveType) {
        Type type = HiveTestUtils.FUNCTION_AND_TYPE_MANAGER.getType(TypeSignature.parseTypeSignature((String)typeName));
        Assert.assertEquals((Object)HiveType.toHiveType((TypeTranslator)this.typeTranslator, (Type)type), (Object)hiveType);
    }

    private void assertInvalidTypeTranslation(String typeName, ErrorCode errorCode, String message) {
        Type type = HiveTestUtils.FUNCTION_AND_TYPE_MANAGER.getType(TypeSignature.parseTypeSignature((String)typeName));
        try {
            HiveType.toHiveType((TypeTranslator)this.typeTranslator, (Type)type);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)errorCode);
                Assertions.assertContains((String)e.getMessage(), (String)message);
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }
}

