/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveWriterFactory;
import java.util.OptionalInt;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveWriterFactory {
    @Test
    public void testComputeBucketedFileName() {
        String name = HiveWriterFactory.computeBucketedFileName((String)"20180102_030405_00641_x1y2z", (int)1234);
        Assert.assertEquals((String)name, (String)"001234_0_20180102_030405_00641_x1y2z");
        Assert.assertEquals((int)Utilities.getBucketIdFromFile((String)name), (int)1234);
    }

    @Test
    public void testGetBucketNumber() {
        Assert.assertEquals((Object)HiveWriterFactory.getBucketNumber((String)"0234_0"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)HiveWriterFactory.getBucketNumber((String)"000234_0"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)HiveWriterFactory.getBucketNumber((String)"0234_99"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)HiveWriterFactory.getBucketNumber((String)"0234_0.txt"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)HiveWriterFactory.getBucketNumber((String)"0234_0_copy_1"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)HiveWriterFactory.getBucketNumber((String)"20190526_072952_00009_fn7s5_bucket-00234"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)HiveWriterFactory.getBucketNumber((String)"20190526_072952_00009_fn7s5_bucket-00234.txt"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)HiveWriterFactory.getBucketNumber((String)"20190526_235847_87654_fn7s5_bucket-56789"), (Object)OptionalInt.of(56789));
        Assert.assertEquals((Object)HiveWriterFactory.getBucketNumber((String)"234_99"), (Object)OptionalInt.empty());
        Assert.assertEquals((Object)HiveWriterFactory.getBucketNumber((String)"0234.txt"), (Object)OptionalInt.empty());
        Assert.assertEquals((Object)HiveWriterFactory.getBucketNumber((String)"0234.txt"), (Object)OptionalInt.empty());
    }
}

