/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.CopyOnFirstWriteConfiguration;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveDirectoryContext;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HudiDirectoryLister;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.NestedDirectoryPolicy;
import com.facebook.presto.hive.cache.HiveCachingHdfsConfiguration;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HadoopExtendedFileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.TableNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHudiDirectoryLister {
    private Configuration getHadoopConfWithCopyOnFirstWriteDisabled() {
        Configuration hadoopConf = new Configuration();
        hadoopConf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        hadoopConf.set("fs.file.impl", LocalFileSystem.class.getName());
        return new HiveCachingHdfsConfiguration.CachingJobConf((factoryConfig, factoryUri) -> {
            LocalFileSystem localFileSystem = new LocalFileSystem();
            try {
                localFileSystem.initialize(URI.create("file:///"), hadoopConf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new HadoopExtendedFileSystem((FileSystem)localFileSystem);
        }, hadoopConf);
    }

    private Configuration getHadoopConfWithCopyOnFirstWriteEnabled() {
        Configuration hadoopConf = new Configuration();
        hadoopConf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        hadoopConf.set("fs.file.impl", LocalFileSystem.class.getName());
        CopyOnFirstWriteConfiguration configuration = new CopyOnFirstWriteConfiguration(hadoopConf);
        return new HiveCachingHdfsConfiguration.CachingJobConf((factoryConfig, factoryUri) -> {
            LocalFileSystem localFileSystem = new LocalFileSystem();
            try {
                localFileSystem.initialize(URI.create("file:///"), hadoopConf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new HadoopExtendedFileSystem((FileSystem)localFileSystem);
        }, (Configuration)configuration);
    }

    private Table getMockTable() {
        return new Table("schema", "hudi_non_part_cow", "user", PrestoTableType.EXTERNAL_TABLE, new Storage(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.PARQUET), TestHudiDirectoryLister.getTableBasePath("hudi_non_part_cow"), Optional.of(new HiveBucketProperty((List)ImmutableList.of(), 1, (List)ImmutableList.of(), BucketFunctionType.HIVE_COMPATIBLE, Optional.empty())), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (List)ImmutableList.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryListerForHudiTable() throws IOException {
        Table mockTable = this.getMockTable();
        Configuration hadoopConf = this.getHadoopConfWithCopyOnFirstWriteDisabled();
        try {
            HudiDirectoryLister directoryLister = new HudiDirectoryLister(hadoopConf, HiveTestUtils.SESSION, mockTable);
            HoodieTableMetaClient metaClient = directoryLister.getMetaClient();
            Assert.assertEquals((String)metaClient.getBasePath(), (String)mockTable.getStorage().getLocation());
            Path path = new Path(mockTable.getStorage().getLocation());
            ExtendedFileSystem fs = (ExtendedFileSystem)path.getFileSystem(hadoopConf);
            Iterator fileInfoIterator = directoryLister.list(fs, mockTable, path, Optional.empty(), new NamenodeStats(), new HiveDirectoryContext(NestedDirectoryPolicy.IGNORED, false, new ConnectorIdentity("test", Optional.empty(), Optional.empty()), (Map)ImmutableMap.of()));
            Assert.assertTrue((boolean)fileInfoIterator.hasNext());
            HiveFileInfo fileInfo = (HiveFileInfo)fileInfoIterator.next();
            Assert.assertEquals((String)fileInfo.getPath().getName(), (String)"d0875d00-483d-4e8b-bbbe-c520366c47a0-0_0-6-11_20211217110514527.parquet");
        }
        finally {
            hadoopConf = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryListerForHudiTableWithCopyOnFirstWriteEnabled() throws IOException {
        Table mockTable = this.getMockTable();
        Configuration hadoopConf = this.getHadoopConfWithCopyOnFirstWriteEnabled();
        try {
            HudiDirectoryLister directoryLister = new HudiDirectoryLister(hadoopConf, HiveTestUtils.SESSION, mockTable);
            HoodieTableMetaClient metaClient = directoryLister.getMetaClient();
            Assert.assertEquals((String)metaClient.getBasePath(), (String)mockTable.getStorage().getLocation());
            Path path = new Path(mockTable.getStorage().getLocation());
            ExtendedFileSystem fs = (ExtendedFileSystem)path.getFileSystem(hadoopConf);
            Iterator fileInfoIterator = directoryLister.list(fs, mockTable, path, Optional.empty(), new NamenodeStats(), new HiveDirectoryContext(NestedDirectoryPolicy.IGNORED, false, new ConnectorIdentity("test", Optional.empty(), Optional.empty()), (Map)ImmutableMap.of()));
            Assert.assertTrue((boolean)fileInfoIterator.hasNext());
            HiveFileInfo fileInfo = (HiveFileInfo)fileInfoIterator.next();
            Assert.assertEquals((String)fileInfo.getPath().getName(), (String)"d0875d00-483d-4e8b-bbbe-c520366c47a0-0_0-6-11_20211217110514527.parquet");
        }
        finally {
            hadoopConf = null;
        }
    }

    @Test
    public void testDirectoryListerForNonHudiTable() {
        Table mockTable = new Table("schema", "non_hudi_table", "user", PrestoTableType.EXTERNAL_TABLE, new Storage(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.PARQUET), TestHudiDirectoryLister.getTableBasePath("non_hudi_table"), Optional.of(new HiveBucketProperty((List)ImmutableList.of(), 1, (List)ImmutableList.of(), BucketFunctionType.HIVE_COMPATIBLE, Optional.empty())), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (List)ImmutableList.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty());
        Assert.assertThrows(TableNotFoundException.class, () -> new HudiDirectoryLister(this.getHadoopConfWithCopyOnFirstWriteDisabled(), HiveTestUtils.SESSION, mockTable));
    }

    private static String getTableBasePath(String tableName) {
        return TestHudiDirectoryLister.class.getClassLoader().getResource(tableName).toString();
    }
}

