/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.SortedRangeSet;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.IonSqlQueryBuilder;
import com.facebook.presto.hive.s3select.S3SelectDataType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.util.DateTimeUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestIonSqlQueryBuilder {
    @Test
    public void testBuildSQL() {
        ImmutableList columns = ImmutableList.of((Object)new HiveColumnHandle("n_nationkey", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"integer"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("n_name", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 1, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("n_regionkey", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"integer"), 2, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder((TypeManager)FunctionAndTypeManager.createTestFunctionAndTypeManager(), S3SelectDataType.CSV);
        Assert.assertEquals((String)"SELECT s._1, s._2, s._3 FROM S3Object s", (String)queryBuilder.buildSql((List)columns, TupleDomain.all()));
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of(columns.get(2), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)3L))), (boolean)false)));
        Assert.assertEquals((String)"SELECT s._1, s._2, s._3 FROM S3Object s WHERE (case s._3 when '' then null else CAST(s._3 AS INT) end = 3)", (String)queryBuilder.buildSql((List)columns, tupleDomain));
        queryBuilder = new IonSqlQueryBuilder((TypeManager)FunctionAndTypeManager.createTestFunctionAndTypeManager(), S3SelectDataType.JSON);
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, TupleDomain.all()), (String)"SELECT s.n_nationkey, s.n_name, s.n_regionkey FROM S3Object s");
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, tupleDomain), (String)"SELECT s.n_nationkey, s.n_name, s.n_regionkey FROM S3Object s WHERE (case s.n_regionkey when '' then null else CAST(s.n_regionkey AS INT) end = 3)");
    }

    @Test
    public void testEmptyColumns() {
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder((TypeManager)FunctionAndTypeManager.createTestFunctionAndTypeManager(), S3SelectDataType.CSV);
        Assert.assertEquals((String)"SELECT ' ' FROM S3Object s", (String)queryBuilder.buildSql((List)ImmutableList.of(), TupleDomain.all()));
        queryBuilder = new IonSqlQueryBuilder((TypeManager)FunctionAndTypeManager.createTestFunctionAndTypeManager(), S3SelectDataType.JSON);
        Assert.assertEquals((String)queryBuilder.buildSql((List)ImmutableList.of(), TupleDomain.all()), (String)"SELECT ' ' FROM S3Object s");
    }

    @Test
    public void testDecimalColumns() {
        FunctionAndTypeManager typeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        ImmutableList columns = ImmutableList.of((Object)new HiveColumnHandle("quantity", HiveType.valueOf((String)"decimal(20,0)"), TypeSignature.parseTypeSignature((String)"decimal"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("extendedprice", HiveType.valueOf((String)"decimal(20,2)"), TypeSignature.parseTypeSignature((String)"decimal"), 1, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("discount", HiveType.valueOf((String)"decimal(10,2)"), TypeSignature.parseTypeSignature((String)"decimal"), 2, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
        DecimalType decimalType = DecimalType.createDecimalType((int)10, (int)2);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of(columns.get(0), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)DecimalType.createDecimalType((int)20, (int)0), (Object)HiveTestUtils.longDecimal("50")), (Range[])new Range[0]), (boolean)false), columns.get(1), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)HiveType.valueOf((String)"decimal(20,2)").getType((TypeManager)typeManager), (Object)HiveTestUtils.longDecimal("0.05")), (Range[])new Range[0]), (boolean)false), columns.get(2), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)decimalType, (Object)HiveTestUtils.shortDecimal("0.0"), (boolean)true, (Object)HiveTestUtils.shortDecimal("0.02"), (boolean)true), (Range[])new Range[0]), (boolean)false)));
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder((TypeManager)typeManager, S3SelectDataType.CSV);
        Assert.assertEquals((String)"SELECT s._1, s._2, s._3 FROM S3Object s WHERE ((case s._1 when '' then null else CAST(s._1 AS DECIMAL(20,0)) end < 50)) AND (case s._2 when '' then null else CAST(s._2 AS DECIMAL(20,2)) end = 0.05) AND ((case s._3 when '' then null else CAST(s._3 AS DECIMAL(10,2)) end >= 0.00 AND case s._3 when '' then null else CAST(s._3 AS DECIMAL(10,2)) end <= 0.02))", (String)queryBuilder.buildSql((List)columns, tupleDomain));
        queryBuilder = new IonSqlQueryBuilder((TypeManager)typeManager, S3SelectDataType.JSON);
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, tupleDomain), (String)"SELECT s.quantity, s.extendedprice, s.discount FROM S3Object s WHERE ((case s.quantity when '' then null else CAST(s.quantity AS DECIMAL(20,0)) end < 50)) AND (case s.extendedprice when '' then null else CAST(s.extendedprice AS DECIMAL(20,2)) end = 0.05) AND ((case s.discount when '' then null else CAST(s.discount AS DECIMAL(10,2)) end >= 0.00 AND case s.discount when '' then null else CAST(s.discount AS DECIMAL(10,2)) end <= 0.02))");
    }

    @Test
    public void testDateColumn() {
        ImmutableList columns = ImmutableList.of((Object)new HiveColumnHandle("t1", HiveType.HIVE_TIMESTAMP, TypeSignature.parseTypeSignature((String)"timestamp"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("t2", HiveType.HIVE_DATE, TypeSignature.parseTypeSignature((String)"date"), 1, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of(columns.get(1), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)DateType.DATE, (List)ImmutableList.of((Object)Range.equal((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2001-08-22")))), (boolean)false)));
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder((TypeManager)FunctionAndTypeManager.createTestFunctionAndTypeManager(), S3SelectDataType.CSV);
        Assert.assertEquals((String)"SELECT s._1, s._2 FROM S3Object s WHERE (case s._2 when '' then null else CAST(s._2 AS TIMESTAMP) end = `2001-08-22`)", (String)queryBuilder.buildSql((List)columns, tupleDomain));
        queryBuilder = new IonSqlQueryBuilder((TypeManager)FunctionAndTypeManager.createTestFunctionAndTypeManager(), S3SelectDataType.JSON);
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, tupleDomain), (String)"SELECT s.t1, s.t2 FROM S3Object s WHERE (case s.t2 when '' then null else CAST(s.t2 AS TIMESTAMP) end = `2001-08-22`)");
    }

    @Test
    public void testNotPushDoublePredicates() {
        ImmutableList columns = ImmutableList.of((Object)new HiveColumnHandle("quantity", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"integer"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("extendedprice", HiveType.HIVE_DOUBLE, TypeSignature.parseTypeSignature((String)"double"), 1, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()), (Object)new HiveColumnHandle("discount", HiveType.HIVE_DOUBLE, TypeSignature.parseTypeSignature((String)"double"), 2, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of(columns.get(0), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)50L), (Range[])new Range[0]), (boolean)false), columns.get(1), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)DoubleType.DOUBLE, (Object)0.05), (Range[])new Range[0]), (boolean)false), columns.get(2), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)true, (Object)0.02, (boolean)true), (Range[])new Range[0]), (boolean)false)));
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder((TypeManager)FunctionAndTypeManager.createTestFunctionAndTypeManager(), S3SelectDataType.CSV);
        Assert.assertEquals((String)"SELECT s._1, s._2, s._3 FROM S3Object s WHERE ((case s._1 when '' then null else CAST(s._1 AS INT) end < 50))", (String)queryBuilder.buildSql((List)columns, tupleDomain));
        queryBuilder = new IonSqlQueryBuilder((TypeManager)FunctionAndTypeManager.createTestFunctionAndTypeManager(), S3SelectDataType.JSON);
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, tupleDomain), (String)"SELECT s.quantity, s.extendedprice, s.discount FROM S3Object s WHERE ((case s.quantity when '' then null else CAST(s.quantity AS INT) end < 50))");
    }
}

