/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class TestJsonHiveHandles {
    private static final Map<String, Object> TABLE_HANDLE_AS_MAP = ImmutableMap.of((Object)"schemaName", (Object)"hive_schema", (Object)"tableName", (Object)"hive_table");
    private static final Map<String, Object> COLUMN_HANDLE_AS_MAP = ImmutableMap.builder().put((Object)"name", (Object)"column").put((Object)"hiveType", (Object)"float").put((Object)"typeSignature", (Object)"double").put((Object)"hiveColumnIndex", (Object)-1).put((Object)"columnType", (Object)HiveColumnHandle.ColumnType.PARTITION_KEY.toString()).put((Object)"comment", (Object)"comment").put((Object)"requiredSubfields", (Object)ImmutableList.of()).build();
    private final ObjectMapper objectMapper = new JsonObjectMapperProvider().get();

    @Test
    public void testTableHandleSerialize() throws Exception {
        HiveTableHandle tableHandle = new HiveTableHandle("hive_schema", "hive_table");
        Assert.assertTrue((boolean)this.objectMapper.canSerialize(HiveTableHandle.class));
        String json = this.objectMapper.writeValueAsString((Object)tableHandle);
        this.testJsonEquals(json, TABLE_HANDLE_AS_MAP);
    }

    @Test
    public void testTableHandleDeserialize() throws Exception {
        String json = this.objectMapper.writeValueAsString(TABLE_HANDLE_AS_MAP);
        HiveTableHandle tableHandle = (HiveTableHandle)this.objectMapper.readValue(json, HiveTableHandle.class);
        Assert.assertEquals((String)tableHandle.getSchemaName(), (String)"hive_schema");
        Assert.assertEquals((String)tableHandle.getTableName(), (String)"hive_table");
        Assert.assertEquals((Object)tableHandle.getSchemaTableName(), (Object)new SchemaTableName("hive_schema", "hive_table"));
    }

    @Test
    public void testColumnHandleSerialize() throws Exception {
        HiveColumnHandle columnHandle = new HiveColumnHandle("column", HiveType.HIVE_FLOAT, TypeSignature.parseTypeSignature((String)"double"), -1, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.of("comment"), Optional.empty());
        Assert.assertTrue((boolean)this.objectMapper.canSerialize(HiveColumnHandle.class));
        String json = this.objectMapper.writeValueAsString((Object)columnHandle);
        this.testJsonEquals(json, COLUMN_HANDLE_AS_MAP);
    }

    @Test
    public void testColumnHandleDeserialize() throws Exception {
        String json = this.objectMapper.writeValueAsString(COLUMN_HANDLE_AS_MAP);
        HiveColumnHandle columnHandle = (HiveColumnHandle)this.objectMapper.readValue(json, HiveColumnHandle.class);
        Assert.assertEquals((String)columnHandle.getName(), (String)"column");
        Assert.assertEquals((Object)columnHandle.getTypeSignature(), (Object)DoubleType.DOUBLE.getTypeSignature());
        Assert.assertEquals((Object)columnHandle.getHiveType(), (Object)HiveType.HIVE_FLOAT);
        Assert.assertEquals((int)columnHandle.getHiveColumnIndex(), (int)-1);
        Assert.assertEquals((boolean)columnHandle.isPartitionKey(), (boolean)true);
    }

    private void testJsonEquals(String json, Map<String, Object> expectedMap) throws Exception {
        Map jsonMap = (Map)this.objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Assertions.assertEqualsIgnoreOrder(jsonMap.entrySet(), expectedMap.entrySet());
    }
}

