/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveSplitManager;
import com.facebook.presto.hive.HiveType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMergeRequestedAndPredicateColumns {
    private static final HiveType STRUCT_TYPE = HiveType.valueOf((String)"struct<a:string,b:string>");
    private static final HiveColumnHandle VARCHAR_COL = new HiveColumnHandle("varchar_col", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    private static final HiveColumnHandle BIGINT_COL = new HiveColumnHandle("bigint_col", HiveType.HIVE_LONG, TypeSignature.parseTypeSignature((String)"bigint"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    private static final HiveColumnHandle STRUCT_WITHOUT_SUBFIELD = new HiveColumnHandle("struct_col", STRUCT_TYPE, STRUCT_TYPE.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    private static final HiveColumnHandle STRUCT_WITH_SUBFIELD_A = new HiveColumnHandle("struct_col", STRUCT_TYPE, STRUCT_TYPE.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), (List)ImmutableList.of((Object)new Subfield("struct_col.a")), Optional.empty());
    private static final HiveColumnHandle STRUCT_WITH_SUBFIELD_B = new HiveColumnHandle("struct_col", STRUCT_TYPE, STRUCT_TYPE.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), (List)ImmutableList.of((Object)new Subfield("struct_col.b")), Optional.empty());
    private static final HiveColumnHandle STRUCT_WITH_SUBFIELD_AB = new HiveColumnHandle("struct_col", STRUCT_TYPE, STRUCT_TYPE.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), (List)ImmutableList.of((Object)new Subfield("struct_col.a"), (Object)new Subfield("struct_col.b")), Optional.empty());

    @Test
    public void testAbsentRequestedCols() {
        Optional result = HiveSplitManager.mergeRequestedAndPredicateColumns(Optional.empty(), (Set)ImmutableSet.of((Object)STRUCT_WITH_SUBFIELD_A));
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testEmptyRequestedCols() {
        Optional result = HiveSplitManager.mergeRequestedAndPredicateColumns(Optional.of(ImmutableSet.of()), (Set)ImmutableSet.of((Object)STRUCT_WITH_SUBFIELD_A));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((int)((Set)result.get()).size(), (int)1);
        Assert.assertEquals((Object)ImmutableList.copyOf((Collection)((Collection)result.get())).get(0), (Object)STRUCT_WITH_SUBFIELD_A);
    }

    @Test
    public void testEmptyPredicateCols() {
        Optional result = HiveSplitManager.mergeRequestedAndPredicateColumns(Optional.of(ImmutableSet.of((Object)VARCHAR_COL, (Object)BIGINT_COL, (Object)STRUCT_WITHOUT_SUBFIELD)), (Set)ImmutableSet.of());
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((int)((Set)result.get()).size(), (int)3);
        Assert.assertEquals((Set)((Set)result.get()), (Set)ImmutableSet.of((Object)VARCHAR_COL, (Object)BIGINT_COL, (Object)STRUCT_WITHOUT_SUBFIELD));
    }

    @Test
    public void testBothPresent() {
        Optional result = HiveSplitManager.mergeRequestedAndPredicateColumns(Optional.of(ImmutableSet.of((Object)VARCHAR_COL, (Object)BIGINT_COL)), (Set)ImmutableSet.of((Object)BIGINT_COL, (Object)STRUCT_WITHOUT_SUBFIELD));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((int)((Set)result.get()).size(), (int)3);
        Assert.assertEquals((Set)((Set)result.get()), (Set)ImmutableSet.of((Object)VARCHAR_COL, (Object)BIGINT_COL, (Object)STRUCT_WITHOUT_SUBFIELD));
    }

    @Test
    public void testStructs() {
        Optional result = HiveSplitManager.mergeRequestedAndPredicateColumns(Optional.of(ImmutableSet.of((Object)STRUCT_WITHOUT_SUBFIELD)), (Set)ImmutableSet.of((Object)STRUCT_WITH_SUBFIELD_A));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((int)((Set)result.get()).size(), (int)1);
        Assert.assertEquals((Set)((Set)result.get()), (Set)ImmutableSet.of((Object)STRUCT_WITHOUT_SUBFIELD));
        result = HiveSplitManager.mergeRequestedAndPredicateColumns(Optional.of(ImmutableSet.of((Object)STRUCT_WITH_SUBFIELD_A)), (Set)ImmutableSet.of((Object)STRUCT_WITH_SUBFIELD_B));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((int)((Set)result.get()).size(), (int)1);
        Assert.assertEquals((Set)((Set)result.get()), (Set)ImmutableSet.of((Object)STRUCT_WITH_SUBFIELD_AB));
        result = HiveSplitManager.mergeRequestedAndPredicateColumns(Optional.of(ImmutableSet.of((Object)STRUCT_WITH_SUBFIELD_A)), (Set)ImmutableSet.of((Object)STRUCT_WITH_SUBFIELD_AB));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((int)((Set)result.get()).size(), (int)1);
        Assert.assertEquals((Set)((Set)result.get()), (Set)ImmutableSet.of((Object)STRUCT_WITH_SUBFIELD_AB));
    }
}

