/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.facebook.presto.orc.writer.StreamLayoutFactory;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcFileWriterConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((OrcFileWriterConfig)ConfigAssertions.recordDefaults(OrcFileWriterConfig.class)).setStripeMinSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setStripeMaxSize(new DataSize(64.0, DataSize.Unit.MEGABYTE)).setStripeMaxRowCount(10000000).setRowGroupMaxRowCount(10000).setDictionaryMaxMemory(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setStringStatisticsLimit(new DataSize(64.0, DataSize.Unit.BYTE)).setMaxCompressionBufferSize(new DataSize(256.0, DataSize.Unit.KILOBYTE)).setStreamLayoutType(OrcFileWriterConfig.StreamLayoutType.BY_COLUMN_SIZE).setDwrfStripeCacheEnabled(true).setDwrfStripeCacheMaxSize(new DataSize(8.0, DataSize.Unit.MEGABYTE)).setDwrfStripeCacheMode(DwrfStripeCacheMode.INDEX_AND_FOOTER).setCompressionLevel(Integer.MIN_VALUE).setIntegerDictionaryEncodingEnabled(false).setStringDictionaryEncodingEnabled(true).setStringDictionarySortingEnabled(true).setFlatMapWriterEnabled(false).setAddHostnameToFileMetadataEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.orc.writer.stripe-min-size", (Object)"13MB").put((Object)"hive.orc.writer.stripe-max-size", (Object)"27MB").put((Object)"hive.orc.writer.stripe-max-rows", (Object)"44").put((Object)"hive.orc.writer.row-group-max-rows", (Object)"11").put((Object)"hive.orc.writer.dictionary-max-memory", (Object)"13MB").put((Object)"hive.orc.writer.string-statistics-limit", (Object)"17MB").put((Object)"hive.orc.writer.max-compression-buffer-size", (Object)"19MB").put((Object)"hive.orc.writer.stream-layout-type", (Object)"BY_STREAM_SIZE").put((Object)"hive.orc.writer.dwrf-stripe-cache-enabled", (Object)"false").put((Object)"hive.orc.writer.dwrf-stripe-cache-max-size", (Object)"10MB").put((Object)"hive.orc.writer.dwrf-stripe-cache-mode", (Object)"FOOTER").put((Object)"hive.orc.writer.compression-level", (Object)"5").put((Object)"hive.orc.writer.integer-dictionary-encoding-enabled", (Object)"true").put((Object)"hive.orc.writer.string-dictionary-encoding-enabled", (Object)"false").put((Object)"hive.orc.writer.string-dictionary-sorting-enabled", (Object)"false").put((Object)"hive.orc.writer.flat-map-writer-enabled", (Object)"true").put((Object)"hive.orc.writer.add-hostname-to-file-metadata-enabled", (Object)"false").build();
        OrcFileWriterConfig expected = new OrcFileWriterConfig().setStripeMinSize(new DataSize(13.0, DataSize.Unit.MEGABYTE)).setStripeMaxSize(new DataSize(27.0, DataSize.Unit.MEGABYTE)).setStripeMaxRowCount(44).setRowGroupMaxRowCount(11).setDictionaryMaxMemory(new DataSize(13.0, DataSize.Unit.MEGABYTE)).setStringStatisticsLimit(new DataSize(17.0, DataSize.Unit.MEGABYTE)).setMaxCompressionBufferSize(new DataSize(19.0, DataSize.Unit.MEGABYTE)).setStreamLayoutType(OrcFileWriterConfig.StreamLayoutType.BY_STREAM_SIZE).setDwrfStripeCacheEnabled(false).setDwrfStripeCacheMaxSize(new DataSize(10.0, DataSize.Unit.MEGABYTE)).setDwrfStripeCacheMode(DwrfStripeCacheMode.FOOTER).setCompressionLevel(5).setIntegerDictionaryEncodingEnabled(true).setStringDictionaryEncodingEnabled(false).setStringDictionarySortingEnabled(false).setFlatMapWriterEnabled(true).setAddHostnameToFileMetadataEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testWithNoOptionsSet() {
        OrcFileWriterConfig config = new OrcFileWriterConfig();
        config.toOrcWriterOptionsBuilder().build();
    }

    @Test
    public void testOrcWriterOptionsBuilder() {
        DataSize stripeMinSize = new DataSize(10.0, DataSize.Unit.MEGABYTE);
        DataSize stripeMaxSize = new DataSize(50.0, DataSize.Unit.MEGABYTE);
        int stripeMaxRowCount = 1000000;
        int rowGroupMaxRowCount = 15000;
        DataSize dictionaryMaxMemory = new DataSize(20.0, DataSize.Unit.MEGABYTE);
        DataSize stringStatisticsLimit = new DataSize(32.0, DataSize.Unit.BYTE);
        DataSize maxCompressionBufferSize = new DataSize(512.0, DataSize.Unit.KILOBYTE);
        OrcFileWriterConfig.StreamLayoutType streamLayoutType = OrcFileWriterConfig.StreamLayoutType.BY_STREAM_SIZE;
        DataSize dwrfStripeCacheMaxSize = new DataSize(4.0, DataSize.Unit.MEGABYTE);
        DwrfStripeCacheMode dwrfStripeCacheMode = DwrfStripeCacheMode.INDEX;
        int compressionLevel = 5;
        boolean flatMapWriterEnabled = true;
        OrcFileWriterConfig config = new OrcFileWriterConfig().setStripeMinSize(stripeMinSize).setStripeMaxSize(stripeMaxSize).setStripeMaxRowCount(stripeMaxRowCount).setRowGroupMaxRowCount(rowGroupMaxRowCount).setDictionaryMaxMemory(dictionaryMaxMemory).setStringStatisticsLimit(stringStatisticsLimit).setMaxCompressionBufferSize(maxCompressionBufferSize).setStreamLayoutType(streamLayoutType).setDwrfStripeCacheEnabled(false).setDwrfStripeCacheMaxSize(dwrfStripeCacheMaxSize).setDwrfStripeCacheMode(dwrfStripeCacheMode).setCompressionLevel(5).setFlatMapWriterEnabled(flatMapWriterEnabled);
        Assert.assertEquals((Object)stripeMinSize, (Object)config.getStripeMinSize());
        Assert.assertEquals((Object)stripeMaxSize, (Object)config.getStripeMaxSize());
        Assert.assertEquals((int)stripeMaxRowCount, (int)config.getStripeMaxRowCount());
        Assert.assertEquals((int)rowGroupMaxRowCount, (int)config.getRowGroupMaxRowCount());
        Assert.assertEquals((Object)dictionaryMaxMemory, (Object)config.getDictionaryMaxMemory());
        Assert.assertEquals((Object)stringStatisticsLimit, (Object)config.getStringStatisticsLimit());
        Assert.assertEquals((Object)maxCompressionBufferSize, (Object)config.getMaxCompressionBufferSize());
        Assert.assertEquals((Object)streamLayoutType, (Object)config.getStreamLayoutType());
        Assert.assertFalse((boolean)config.isDwrfStripeCacheEnabled());
        Assert.assertEquals((Object)dwrfStripeCacheMaxSize, (Object)config.getDwrfStripeCacheMaxSize());
        Assert.assertEquals((Object)dwrfStripeCacheMode, (Object)config.getDwrfStripeCacheMode());
        Assert.assertEquals((int)compressionLevel, (int)config.getCompressionLevel());
        Assert.assertEquals((boolean)flatMapWriterEnabled, (boolean)config.isFlatMapWriterEnabled());
        Assert.assertNotSame((Object)config.toOrcWriterOptionsBuilder(), (Object)config.toOrcWriterOptionsBuilder());
        OrcWriterOptions options = config.toOrcWriterOptionsBuilder().build();
        Assert.assertEquals((int)Math.toIntExact(stripeMinSize.toBytes()), (int)options.getFlushPolicy().getStripeMinBytes());
        Assert.assertEquals((int)Math.toIntExact(stripeMaxSize.toBytes()), (int)options.getFlushPolicy().getStripeMaxBytes());
        Assert.assertEquals((int)stripeMaxRowCount, (int)options.getFlushPolicy().getStripeMaxRowCount());
        Assert.assertEquals((int)rowGroupMaxRowCount, (int)options.getRowGroupMaxRowCount());
        Assert.assertEquals((Object)dictionaryMaxMemory, (Object)options.getDictionaryMaxMemory());
        Assert.assertEquals((Object)stringStatisticsLimit, (Object)options.getMaxStringStatisticsLimit());
        Assert.assertEquals((Object)maxCompressionBufferSize, (Object)options.getMaxCompressionBufferSize());
        Assert.assertTrue((boolean)(options.getStreamLayoutFactory() instanceof StreamLayoutFactory.StreamSizeLayoutFactory));
        Assert.assertEquals(Optional.empty(), (Object)options.getDwrfStripeCacheOptions());
        Assert.assertEquals((Object)OptionalInt.of(compressionLevel), (Object)options.getCompressionLevel());
    }

    @Test
    public void testStreamLayoutOption() {
        OrcFileWriterConfig config = new OrcFileWriterConfig();
        config.setStreamLayoutType(OrcFileWriterConfig.StreamLayoutType.BY_STREAM_SIZE);
        OrcWriterOptions options = config.toOrcWriterOptionsBuilder().build();
        Assert.assertTrue((boolean)(options.getStreamLayoutFactory() instanceof StreamLayoutFactory.StreamSizeLayoutFactory));
        config.setStreamLayoutType(OrcFileWriterConfig.StreamLayoutType.BY_COLUMN_SIZE);
        options = config.toOrcWriterOptionsBuilder().build();
        Assert.assertTrue((boolean)(options.getStreamLayoutFactory() instanceof StreamLayoutFactory.ColumnSizeLayoutFactory));
    }

    @Test
    public void testDefaultCompressionLevel() {
        OrcFileWriterConfig config = new OrcFileWriterConfig();
        OrcWriterOptions options = config.toOrcWriterOptionsBuilder().build();
        Assert.assertEquals((Object)OptionalInt.empty(), (Object)options.getCompressionLevel());
    }

    @Test
    public void testAddHostnameToFileMetadata() {
        OrcFileWriterConfig config = new OrcFileWriterConfig();
        config.setAddHostnameToFileMetadataEnabled(false);
        Assert.assertFalse((boolean)config.isAddHostnameToFileMetadataEnabled());
        config.setAddHostnameToFileMetadataEnabled(true);
        Assert.assertTrue((boolean)config.isAddHostnameToFileMetadataEnabled());
    }
}

