/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestDistributedQueries;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.tpch.TpchTable;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParquetDistributedQueries
extends AbstractTestDistributedQueries {
    protected QueryRunner createQueryRunner() throws Exception {
        ImmutableMap parquetProperties = ImmutableMap.builder().put((Object)"hive.storage-format", (Object)"PARQUET").put((Object)"hive.parquet.use-column-names", (Object)"true").put((Object)"hive.compression-codec", (Object)"GZIP").put((Object)"hive.enable-parquet-dereference-pushdown", (Object)"true").put((Object)"hive.partial_aggregation_pushdown_enabled", (Object)"true").put((Object)"hive.partial_aggregation_pushdown_for_variable_length_datatypes_enabled", (Object)"true").build();
        return HiveQueryRunner.createQueryRunner(TpchTable.getTables(), (Map<String, String>)ImmutableMap.of((Object)"experimental.pushdown-subfields-enabled", (Object)"true", (Object)"experimental.pushdown-dereference-enabled", (Object)"true"), "sql-standard", (Map<String, String>)parquetProperties, Optional.empty());
    }

    @Test
    public void testSubfieldPruning() {
        this.getQueryRunner().execute("CREATE TABLE test_subfield_pruning AS SELECT orderkey, linenumber, shipdate,    CAST(ROW(orderkey, linenumber, ROW(day(shipdate), month(shipdate), year(shipdate)))        AS ROW(orderkey BIGINT, linenumber INTEGER, shipdate ROW(ship_day TINYINT, ship_month TINYINT, ship_year INTEGER))) AS info FROM lineitem");
        try {
            this.assertQuery("SELECT info.orderkey, info.shipdate.ship_month FROM test_subfield_pruning", "SELECT orderkey, month(shipdate) FROM lineitem");
            this.assertQuery("SELECT orderkey FROM test_subfield_pruning WHERE info.shipdate.ship_month % 2 = 0", "SELECT orderkey FROM lineitem WHERE month(shipdate) % 2 = 0");
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE test_subfield_pruning");
        }
    }

    @Test
    public void testSubfieldWithSchemaChanges() {
        this.getQueryRunner().execute("CREATE TABLE test_subfield_multilevel_pruning AS SELECT    1 as orderkey,   CAST(ROW('N', ROW(5, 7)) AS ROW(returnflag CHAR(1), shipdate ROW(ship_day INTEGER, ship_month INTEGER))) as nestedColumnLevelUpdates,   CAST(ROW('N', ROW(5, 7)) AS ROW(returnflag CHAR(1), shipdate ROW(ship_day INTEGER, ship_month INTEGER))) as colLevelUpdates");
        this.getQueryRunner().execute("ALTER TABLE test_subfield_multilevel_pruning DROP COLUMN nestedColumnLevelUpdates");
        this.getQueryRunner().execute("ALTER TABLE test_subfield_multilevel_pruning ADD COLUMN nestedColumnLevelUpdates ROW(returnflag CHAR(1), shipdate ROW(ship_day INTEGER, ship_month INTEGER, ship_year INTEGER))");
        this.getQueryRunner().execute("ALTER TABLE test_subfield_multilevel_pruning DROP COLUMN colLevelUpdates");
        this.getQueryRunner().execute("ALTER TABLE test_subfield_multilevel_pruning ADD COLUMN colLevelUpdates2 ROW(returnflag CHAR(1), shipdate ROW(ship_day INTEGER, ship_month INTEGER, ship_year INTEGER))");
        this.getQueryRunner().execute("INSERT INTO test_subfield_multilevel_pruning SELECT 2, cast(row('Y', ROW(5, 7, 2020)) as ROW(returnflag CHAR(1), shipdate ROW(ship_day INTEGER, ship_month INTEGER, ship_year INTEGER))),cast(row('Y', ROW(5, 7, 2020)) as ROW(returnflag CHAR(1), shipdate ROW(ship_day INTEGER, ship_month INTEGER, ship_year INTEGER)))");
        try {
            this.assertQuery("SELECT orderkey, nestedColumnLevelUpdates.shipdate.ship_day, nestedColumnLevelUpdates.shipdate.ship_month, nestedColumnLevelUpdates.shipdate.ship_year FROM test_subfield_multilevel_pruning", "SELECT * from (VALUES(1, 5, 7, null), (2, 5, 7, 2020))");
            this.assertQuery("SELECT orderkey, colLevelUpdates2.shipdate.ship_day, colLevelUpdates2.shipdate.ship_month, colLevelUpdates2.shipdate.ship_year FROM test_subfield_multilevel_pruning", "SELECT * from (VALUES (1, null, null, null), (2, 5, 7, 2020))");
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE test_subfield_multilevel_pruning");
        }
    }

    protected boolean supportsNotNullColumns() {
        return false;
    }

    public void testDelete() {
    }

    public void testRenameColumn() {
    }

    @Test
    public void testExplainOfCreateTableAs() {
        String query = "CREATE TABLE copy_orders AS SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("EXPLAIN ", query, ExplainType.Type.LOGICAL));
    }
}

