/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import org.testng.annotations.Test;

public class TestParquetFileWriterConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ParquetFileWriterConfig)ConfigAssertions.recordDefaults(ParquetFileWriterConfig.class)).setParquetOptimizedWriterEnabled(false).setBlockSize(new DataSize(1.34217728E8, DataSize.Unit.BYTE)).setPageSize(new DataSize(1048576.0, DataSize.Unit.BYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.parquet.optimized-writer.enabled", (Object)"true").put((Object)"hive.parquet.writer.block-size", (Object)"234MB").put((Object)"hive.parquet.writer.page-size", (Object)"11MB").build();
        ParquetFileWriterConfig expected = new ParquetFileWriterConfig().setParquetOptimizedWriterEnabled(true).setBlockSize(new DataSize(234.0, DataSize.Unit.MEGABYTE)).setPageSize(new DataSize(11.0, DataSize.Unit.MEGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

